/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.paymentcollection.AutoSelectLanguageEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.SelectLanguageEvent;
import com.stripe.jvmcore.hardware.emv.TlvMap;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\nH\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\bH\u0002J\u001c\u0010\u0011\u001a\u00020\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/stripe/core/paymentcollection/LanguageSelectionHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "applicationRequiresLanguageSelection", "", "application", "", "candidateLanguagesForApplication", "", "applicationTlv", "generateAutoSelectLanguageEvent", "", "candidates", "generateLanguageSelectionEvent", "language", "onEnter", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
public final class LanguageSelectionHandler
extends PaymentCollectionStateHandler {
    public LanguageSelectionHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.LANGUAGE_SELECTION, coroutineScope, null, 4, null);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block4: {
            Object object;
            PaymentCollectionData data;
            block6: {
                block5: {
                    super.onEnter(current, from);
                    PaymentCollectionData paymentCollectionData = current;
                    if (paymentCollectionData == null) break block4;
                    data = paymentCollectionData;
                    boolean bl = false;
                    object = data.getSelectedApplicationIndex();
                    if (object == null) break block5;
                    int index = ((Number)object).intValue();
                    boolean bl2 = false;
                    String string = (String)CollectionsKt.getOrNull(data.getApplicationList(), (int)index);
                    object = string;
                    if (string != null) break block6;
                }
                LanguageSelectionHandler $this$onEnter_u24lambda_u242_u24lambda_u241 = this;
                boolean bl = false;
                PaymentCollectionStatesKt.access$getLOGGER$p().e("Attempt to select language without prior application selection.", new Pair[0]);
                return;
            }
            Object selectedApplicationTlvBlob = object;
            if (!this.applicationRequiresLanguageSelection((String)selectedApplicationTlvBlob)) {
                this.transitionTo(PaymentCollectionState.PROCESSING, "Language selection not required.");
                return;
            }
            List<String> candidates = this.candidateLanguagesForApplication((String)selectedApplicationTlvBlob);
            this.generateAutoSelectLanguageEvent(candidates);
            this.onPaymentCollectionDataUpdate(data, data);
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        String string = paymentCollectionData.getSelectedLanguage();
        if (string != null) {
            String selectedLanguage = string;
            boolean bl = false;
            this.generateLanguageSelectionEvent(selectedLanguage);
            this.transitionTo(PaymentCollectionState.PROCESSING, "Language selected.");
            return;
        }
        if (this.checkForPrematureTransactionCompletionAndTransitionIfNeeded(paymentCollectionData)) {
            return;
        }
    }

    private final void generateAutoSelectLanguageEvent(List<String> candidates) {
        this.yieldEvent(new AutoSelectLanguageEvent(candidates));
    }

    private final void generateLanguageSelectionEvent(String language) {
        this.yieldEvent(new SelectLanguageEvent(language));
    }

    private final List<String> candidateLanguagesForApplication(String applicationTlv) {
        Object object;
        block5: {
            block4: {
                object = TlvMap.Companion.toTlvMap(applicationTlv);
                if (object == null) break block4;
                TlvMap tlvMap = object;
                boolean bl = false;
                List list = tlvMap.getLanguagePreferences();
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                object = list;
                if (list != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final boolean applicationRequiresLanguageSelection(String application) {
        return !((Collection)this.candidateLanguagesForApplication(application)).isEmpty();
    }
}

