/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.paymentcollection.MagStripePinStatus;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.StopReaderEvent;
import com.stripe.core.paymentcollection.metrics.PinEntryFailureReason;
import com.stripe.core.paymentcollection.metrics.Result;
import com.stripe.core.paymentcollection.metrics.StageEventLogger;
import com.stripe.jvmcore.hardware.emv.CancellationPhase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/stripe/core/paymentcollection/MagStripePinEntryHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "onEnter", "", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onExit", "to", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
public final class MagStripePinEntryHandler
extends PaymentCollectionStateHandler {
    public MagStripePinEntryHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.MAGSTRIPE_PIN_ENTRY, coroutineScope, null, 4, null);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block0: {
            super.onEnter(current, from);
            this.generateStartPinEntryEvent();
            this.getStageEventLogger().openPinEntryLog();
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.onPaymentCollectionDataUpdate(it, null);
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        PaymentCollectionData paymentCollectionData2 = old;
        if (!Intrinsics.areEqual((Object)paymentCollectionData.getMagStripePinStatus(), (Object)(paymentCollectionData2 != null ? paymentCollectionData2.getMagStripePinStatus() : null))) {
            PaymentCollectionStatesKt.access$getLOGGER$p().d("MagStripePinStatus changed to: " + paymentCollectionData.getMagStripePinStatus(), new Pair[0]);
            MagStripePinStatus magStripePinStatus = paymentCollectionData.getMagStripePinStatus();
            if (Intrinsics.areEqual((Object)magStripePinStatus, (Object)MagStripePinStatus.Collected.INSTANCE)) {
                StageEventLogger.closePinEntryLog$default(this.getStageEventLogger(), Result.SUCCESS, paymentCollectionData, null, 4, null);
                this.transitionTo(PaymentCollectionState.ONLINE_AUTHORIZATION_MAG_STRIPE, "MagStripe PIN entered.");
                return;
            }
            if (Intrinsics.areEqual((Object)magStripePinStatus, (Object)MagStripePinStatus.Bypassed.INSTANCE)) {
                StageEventLogger.closePinEntryLog$default(this.getStageEventLogger(), Result.FAILURE, paymentCollectionData, null, 4, null);
                this.transitionTo(PaymentCollectionState.ONLINE_AUTHORIZATION_MAG_STRIPE, "MagStripe PIN bypassed.");
                return;
            }
            if (magStripePinStatus instanceof MagStripePinStatus.Failed) {
                StageEventLogger.closePinEntryLog$default(this.getStageEventLogger(), Result.FAILURE, paymentCollectionData, null, 4, null);
                this.clearContactCardStateAndPrepareNextCollection();
                this.transitionTo(PaymentCollectionState.COLLECTION, "MagStripe PIN failed, recollect payment.");
                return;
            }
            if (Intrinsics.areEqual((Object)magStripePinStatus, (Object)MagStripePinStatus.NotNeeded.INSTANCE)) {
                PaymentCollectionStatesKt.access$getLOGGER$p().e("MagStripePinStatus NotNeeded in MagStripe PIN state.", new Pair[0]);
            } else if (Intrinsics.areEqual((Object)magStripePinStatus, (Object)MagStripePinStatus.ToCollect.INSTANCE)) {
                // empty if block
            }
        }
        this.generateUserInteractionEvent(paymentCollectionData.getAmount(), paymentCollectionData.getPinAsterisks(), paymentCollectionData.getSelectedLanguage(), paymentCollectionData.getPinEntryRetryReason());
    }

    @Override
    public void onExit(@NotNull PaymentCollectionState to) {
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        super.onExit(to);
        if (to == PaymentCollectionState.CANCEL) {
            this.yieldEvent(new StopReaderEvent(CancellationPhase.PIN));
            StageEventLogger stageEventLogger = this.getStageEventLogger();
            Object d2 = this.getData();
            Intrinsics.checkNotNull(d2);
            stageEventLogger.closePinEntryLog(Result.FAILURE, (PaymentCollectionData)d2, PinEntryFailureReason.MERCHANT_CANCELLED);
        }
    }
}

