/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.ManualEntryFailureModel;
import com.stripe.core.paymentcollection.CancelReason;
import com.stripe.core.paymentcollection.ManualEntryAuthorizationRequestEvent;
import com.stripe.core.paymentcollection.ManualEntryCollectionResultEvent;
import com.stripe.core.paymentcollection.ManualEntryEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.TippingState;
import com.stripe.core.paymentcollection.manualentry.ManualEntryCollectionResult;
import com.stripe.core.paymentcollection.manualentry.ManualEntryFailureReason;
import com.stripe.core.paymentcollection.manualentry.ManualEntryStateMachine;
import com.stripe.core.statemachine.StateMachine;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.restclient.IntegrationType;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0011\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/stripe/core/paymentcollection/ManualEntryHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "manualEntryStateMachine", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryStateMachine;", "(Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/core/paymentcollection/manualentry/ManualEntryStateMachine;)V", "onEnter", "", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onExit", "to", "onPaymentCollectionDataUpdate", "new", "old", "sendManualEntryCollectionResult", "result", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryCollectionResult;", "sendManualEntryFailureUiEvent", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "transactionType", "Lcom/stripe/core/hardware/paymentcollection/TransactionType;", "paymentcollection_release"})
public final class ManualEntryHandler
extends PaymentCollectionStateHandler {
    @NotNull
    private final ManualEntryStateMachine manualEntryStateMachine;

    public ManualEntryHandler(@NotNull CoroutineScope coroutineScope, @NotNull ManualEntryStateMachine manualEntryStateMachine) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)manualEntryStateMachine, (String)"manualEntryStateMachine");
        super(PaymentCollectionState.MANUAL_ENTRY, coroutineScope, null, 4, null);
        this.manualEntryStateMachine = manualEntryStateMachine;
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block1: {
            super.onEnter(current, from);
            PaymentCollectionStatesKt.access$getLOGGER$p().i("ManualEntryHandler.onEnter", new Pair[0]);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.manualEntryStateMachine.reset();
            Amount amount = it.getAmount();
            com.stripe.core.hardware.paymentcollection.TransactionType transactionType = it.getTransactionType();
            TransactionType transactionType2 = it.getEmvTransactionType();
            IntegrationType integrationType = it.getIntegrationType();
            if (integrationType == null) {
                integrationType = IntegrationType.LOCAL_POS;
            }
            this.manualEntryStateMachine.startTransaction(amount, transactionType, transactionType2, integrationType, (Function1<? super ManualEntryCollectionResult, Unit>)((Function1)new Function1<ManualEntryCollectionResult, Unit>(this){
                final /* synthetic */ ManualEntryHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull ManualEntryCollectionResult result2) {
                    Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                    ManualEntryHandler.access$sendManualEntryCollectionResult(this.this$0, result2);
                }
            }));
        }
    }

    private final void sendManualEntryCollectionResult(ManualEntryCollectionResult result2) {
        this.yieldEvent(new ManualEntryCollectionResultEvent(result2));
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        ManualEntryCollectionResult result2 = paymentCollectionData.getManualEntryCollectionResult();
        if (result2 instanceof ManualEntryCollectionResult.Failure) {
            PaymentCollectionStatesKt.access$getLOGGER$p().i("MOTO collection failed: " + result2, new Pair[0]);
            switch (WhenMappings.$EnumSwitchMapping$0[((ManualEntryCollectionResult.Failure)result2).getReason().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.sendManualEntryFailureUiEvent(paymentCollectionData.getAmount(), paymentCollectionData.getTransactionType());
                    StateMachine.StateHandler.transitionTo$default(this, (Object)PaymentCollectionState.FINISHED, null, 2, null);
                    break;
                }
                case 5: {
                    StateMachine.StateHandler.transitionTo$default(this, (Object)PaymentCollectionState.TIMEOUT, null, 2, null);
                }
            }
        } else if (result2 instanceof ManualEntryCollectionResult.Success) {
            PaymentCollectionStatesKt.access$getLOGGER$p().i("MOTO collection success: " + result2, new Pair[0]);
            this.yieldEvent(new ManualEntryAuthorizationRequestEvent(((ManualEntryCollectionResult.Success)result2).getData(), TippingState.Ineligible.INSTANCE));
            StateMachine.StateHandler.transitionTo$default(this, (Object)PaymentCollectionState.COLLECTION_COMPLETE, null, 2, null);
        } else if (result2 == null) {
            // empty if block
        }
    }

    private final void sendManualEntryFailureUiEvent(Amount amount, com.stripe.core.hardware.paymentcollection.TransactionType transactionType) {
        this.yieldEvent(new ManualEntryEvent(new ManualEntryFailureModel(amount, transactionType)));
    }

    @Override
    public void onExit(@NotNull PaymentCollectionState to) {
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        super.onExit(to);
        if (to == PaymentCollectionState.CANCEL) {
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            CancelReason cancelReason = paymentCollectionData != null ? paymentCollectionData.getCancelReason() : null;
            switch (cancelReason == null ? -1 : WhenMappings.$EnumSwitchMapping$1[cancelReason.ordinal()]) {
                case 1: {
                    this.manualEntryStateMachine.notifyHardwareCancel();
                    break;
                }
                case 2: {
                    this.manualEntryStateMachine.notifyMerchantCancel();
                    break;
                }
                case -1: {
                    PaymentCollectionStatesKt.access$getLOGGER$p().w("Manual entry cancelled without a reason.", new Pair[0]);
                }
            }
        }
    }

    public static final /* synthetic */ void access$sendManualEntryCollectionResult(ManualEntryHandler $this, ManualEntryCollectionResult result2) {
        $this.sendManualEntryCollectionResult(result2);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ManualEntryFailureReason.values().length];
            try {
                nArray[ManualEntryFailureReason.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryFailureReason.INVALID_ENCRYPTED_DATA_RESULT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryFailureReason.DEVICE_FAILURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryFailureReason.EARLY_TRANSACTION_RESULT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryFailureReason.TIMEOUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryFailureReason.MERCHANT_CANCELLED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryFailureReason.USER_CANCELLED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CancelReason.values().length];
            try {
                nArray[CancelReason.HARDWARE_CANCELLED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CancelReason.MERCHANT_CANCELLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

