/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.PinEntryStatus;
import com.stripe.core.hardware.paymentcollection.TransactionType;
import com.stripe.core.paymentcollection.AuthorizePaymentEvent;
import com.stripe.core.paymentcollection.EmvSecondGenACResponse;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.SCARequirement;
import com.stripe.core.paymentcollection.SecondGenACResponseEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\t2\b\u0010\u0011\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/stripe/core/paymentcollection/OnlineAuthorizationHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "autoSetQuickEmvAuthResponse", "", "generateAuthResponseEvent", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "generateSecondGenACResponseEvent", "onEnter", "current", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onPaymentCollectionDataUpdate", "new", "old", "Companion", "paymentcollection_release"})
public final class OnlineAuthorizationHandler
extends PaymentCollectionStateHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String ENTRY_MODE_CONTACT = "05";
    @NotNull
    public static final String ENTRY_MODE_CONTACTLESS = "07";

    public OnlineAuthorizationHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.ONLINE_AUTHORIZATION, coroutineScope, 60000L);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block2: {
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData != null) {
                PaymentCollectionData it = paymentCollectionData;
                boolean bl = false;
                this.sendOnlineAuthRequestEventIfNeeded(it);
                if (it.getShouldAutoRespondOnlineAuth()) {
                    this.autoSetQuickEmvAuthResponse();
                }
            }
            PaymentCollectionData paymentCollectionData2 = (PaymentCollectionData)this.getData();
            if (paymentCollectionData2 == null) break block2;
            PaymentCollectionData it = paymentCollectionData2;
            boolean bl = false;
            this.onPaymentCollectionDataUpdate(it, it);
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        boolean isAuthFinished;
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        boolean hasOnlineAuthorizationRequestData = paymentCollectionData.getOnlineAuthorizationData() != null;
        boolean shouldSendOnlineAuthorizationResponse = paymentCollectionData.getOnlineAuthorizationResponse() != null && !paymentCollectionData.getOnlineAuthorizationResponseSentToKernel();
        boolean isFinalTlvCollected = paymentCollectionData.getFinalTlvResponse() != null;
        boolean isHardwareTransactionResultCollected = paymentCollectionData.getHardwareTransactionResult() != null;
        boolean shouldAutoRespondOnlineAuth = paymentCollectionData.getShouldAutoRespondOnlineAuth();
        boolean bl = isAuthFinished = isHardwareTransactionResultCollected && (isFinalTlvCollected || shouldAutoRespondOnlineAuth);
        if (isAuthFinished) {
            if (!shouldAutoRespondOnlineAuth) {
                if (paymentCollectionData.getChargeAttempt() != null) {
                    this.transitionTo(PaymentCollectionState.COLLECTION_COMPLETE, "Received payment confirmation.");
                } else {
                    this.generateSecondGenACResponseEvent(paymentCollectionData);
                }
            } else {
                this.transitionTo(PaymentCollectionState.COLLECTION_COMPLETE, "Quick response submitted.");
            }
        } else if (shouldSendOnlineAuthorizationResponse) {
            this.generateAuthResponseEvent(paymentCollectionData);
        } else if (paymentCollectionData.getTransactionType() == TransactionType.STRONG_CUSTOMER_AUTHENTICATION && !hasOnlineAuthorizationRequestData) {
            if (paymentCollectionData.getScaRequirement() == SCARequirement.ONLINE_OR_OFFLINE_PIN && paymentCollectionData.getPinEntryStatus() == PinEntryStatus.REQUESTED) {
                this.transitionTo(PaymentCollectionState.PIN_ENTRY, "Online SCA PIN entry requested.");
            } else {
                this.transitionTo(PaymentCollectionState.COLLECTION, "Offline SCA PIN entry requested.");
            }
        }
    }

    private final void generateSecondGenACResponseEvent(PaymentCollectionData data) {
        boolean bl = !data.isDeclined();
        String string = data.getFinalTlvResponse();
        Intrinsics.checkNotNull((Object)string);
        this.yieldEvent(new SecondGenACResponseEvent(new EmvSecondGenACResponse(bl, string)));
    }

    private final void generateAuthResponseEvent(PaymentCollectionData data) {
        String string = data.getOnlineAuthorizationResponse();
        if (string == null) {
            return;
        }
        AuthorizePaymentEvent event = new AuthorizePaymentEvent(string);
        this.updateDataWithoutCallback(PaymentCollectionData.copy$default(data, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, true, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -4194305, 1048575, null));
        this.yieldEvent(event);
    }

    private final void autoSetQuickEmvAuthResponse() {
        block0: {
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData updatedData = paymentCollectionData;
            boolean bl = false;
            this.updateDataWithoutCallback(PaymentCollectionData.copy$default(updatedData, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, "8A023035", false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -2097153, 1048575, null));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/core/paymentcollection/OnlineAuthorizationHandler$Companion;", "", "()V", "ENTRY_MODE_CONTACT", "", "ENTRY_MODE_CONTACTLESS", "paymentcollection_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

