/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.paymentcollection.MagStripeAuthorizationRequestEvent;
import com.stripe.core.paymentcollection.MagStripeSecondGenACResponse;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.PresentProcessingEvent;
import com.stripe.core.paymentcollection.SecondGenACResponseEvent;
import com.stripe.core.paymentcollection.TippingState;
import com.stripe.core.statemachine.StateMachine;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.magstripe.MagStripePaymentCollectionAuthority;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadResult;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadSuccess;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001c\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/stripe/core/paymentcollection/OnlineAuthorizationMagStripeHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "generateMagStripeAuthRequestEvent", "", "result", "Lcom/stripe/jvmcore/hardware/magstripe/MagStripeReadSuccess;", "collectionAuthority", "Lcom/stripe/jvmcore/hardware/magstripe/MagStripePaymentCollectionAuthority;", "tipResult", "Lcom/stripe/core/paymentcollection/TippingState$EndState;", "generatePresentProcessingEvent", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "onEnter", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
public final class OnlineAuthorizationMagStripeHandler
extends PaymentCollectionStateHandler {
    public OnlineAuthorizationMagStripeHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.ONLINE_AUTHORIZATION_MAG_STRIPE, coroutineScope, null, 4, null);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block4: {
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block4;
            PaymentCollectionData data = paymentCollectionData;
            boolean bl = false;
            this.generatePresentProcessingEvent(data.getAmount());
            MagStripeReadResult result2 = data.getMagStripeReadResult();
            MagStripePaymentCollectionAuthority authority = data.getMagStripePaymentCollectionAuthority();
            if (result2 instanceof MagStripeReadSuccess && authority != null) {
                this.getDiscreteEventLogger().logAllowingMagStripe(data);
                if (data.getTippingState() instanceof TippingState.EndState) {
                    this.getOnlineAuthStateLogger().updateOnlineAuthState(OnlineAuthState.ReadyToStartConfirmation.INSTANCE, data);
                    this.generateMagStripeAuthRequestEvent((MagStripeReadSuccess)result2, authority, (TippingState.EndState)data.getTippingState());
                }
            } else {
                PaymentCollectionStatesKt.access$getLOGGER$p().e("Entered Mag Stripe Authorization without card data", new Pair[0]);
            }
            if (data.getShouldAutoRespondOnlineAuth()) {
                StateMachine.StateHandler.transitionTo$default(this, (Object)PaymentCollectionState.COLLECTION_COMPLETE, null, 2, null);
            }
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        if (paymentCollectionData.getOnlineAuthorizationResponse() != null) {
            this.yieldEvent(new SecondGenACResponseEvent(MagStripeSecondGenACResponse.INSTANCE));
            StateMachine.StateHandler.transitionTo$default(this, (Object)PaymentCollectionState.COLLECTION_COMPLETE, null, 2, null);
        }
    }

    private final void generateMagStripeAuthRequestEvent(MagStripeReadSuccess result2, MagStripePaymentCollectionAuthority collectionAuthority, TippingState.EndState tipResult) {
        this.yieldEvent(new MagStripeAuthorizationRequestEvent(result2, collectionAuthority, tipResult));
    }

    private final void generatePresentProcessingEvent(Amount amount) {
        this.yieldEvent(new PresentProcessingEvent(amount));
    }
}

