/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PresentProcessingEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/stripe/core/paymentcollection/OnlineConfirmationHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "onEnter", "", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onExit", "to", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
public final class OnlineConfirmationHandler
extends PaymentCollectionStateHandler {
    public OnlineConfirmationHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.ONLINE_CONFIRMATION, coroutineScope, 60000L);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block0: {
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.yieldEvent(new PresentProcessingEvent(it.getAmount()));
            this.onPaymentCollectionDataUpdate(it, it);
        }
    }

    @Override
    public void onExit(@NotNull PaymentCollectionState to) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
            super.onExit(to);
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            if (it.getChargeAttempt() == null) {
                this.getDiscreteEventLogger().logOnlineConfirmResult(it);
            }
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        if (paymentCollectionData.getChargeAttempt() != null) {
            this.transitionTo(PaymentCollectionState.COLLECTION_COMPLETE, "Received payment confirmation.");
        }
    }
}

