/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import androidx.annotation.VisibleForTesting;
import com.stripe.core.featureflag.dagger.ApplicationSelectionInQuickChipEnabled;
import com.stripe.core.featureflag.dagger.EnableMagStripePin;
import com.stripe.core.hardware.paymentcollection.ContactCardSlotState;
import com.stripe.core.hardware.paymentcollection.Disposition;
import com.stripe.core.hardware.paymentcollection.PaymentCollector;
import com.stripe.core.hardware.paymentcollection.PaymentEventReceiver;
import com.stripe.core.hardware.paymentcollection.PinEntryStatus;
import com.stripe.core.hardware.paymentcollection.TippingSelectionResult;
import com.stripe.core.hardware.tipping.InvalidTipConfig;
import com.stripe.core.hardware.tipping.TipConfigValidationResult;
import com.stripe.core.hardware.tipping.TipConfigValidationResultKt;
import com.stripe.core.hardware.tipping.TipSelectionResult;
import com.stripe.core.paymentcollection.AcknowledgeInterfaceResetEvent;
import com.stripe.core.paymentcollection.AuthorizePaymentEvent;
import com.stripe.core.paymentcollection.AutoSelectApplicationEvent;
import com.stripe.core.paymentcollection.AutoSelectLanguageEvent;
import com.stripe.core.paymentcollection.AutomationEvent;
import com.stripe.core.paymentcollection.CancelHardwareTippingCollectionEvent;
import com.stripe.core.paymentcollection.Cancelled;
import com.stripe.core.paymentcollection.CardStateUpdateEvent;
import com.stripe.core.paymentcollection.ChipCardInitializationFailed;
import com.stripe.core.paymentcollection.ClearMagStripeStateEvent;
import com.stripe.core.paymentcollection.CollectionCancelledEvent;
import com.stripe.core.paymentcollection.CollectionCompleteEvent;
import com.stripe.core.paymentcollection.ConfigureReaderEvent;
import com.stripe.core.paymentcollection.ContactCardUpdateEvent;
import com.stripe.core.paymentcollection.DisplayCartEvent;
import com.stripe.core.paymentcollection.DisplayRecoverableErrorEvent;
import com.stripe.core.paymentcollection.EarlyTransactionAbortReason;
import com.stripe.core.paymentcollection.EmptyCandidateListEncounteredEvent;
import com.stripe.core.paymentcollection.EmvResult;
import com.stripe.core.paymentcollection.EmvSecondGenACResponse;
import com.stripe.core.paymentcollection.Failed;
import com.stripe.core.paymentcollection.HardwareEvent;
import com.stripe.core.paymentcollection.HardwareListenerEvent;
import com.stripe.core.paymentcollection.HardwareTippingCollectionEvent;
import com.stripe.core.paymentcollection.HardwareTippingCollectionResultEvent;
import com.stripe.core.paymentcollection.HardwareTransactionCancelledEvent;
import com.stripe.core.paymentcollection.IntermediateErrorEvent;
import com.stripe.core.paymentcollection.MagStripeAuthorizationRequestEvent;
import com.stripe.core.paymentcollection.MagStripeReadEvent;
import com.stripe.core.paymentcollection.MagStripeSecondGenACResponse;
import com.stripe.core.paymentcollection.ManualEntryAuthorizationRequestEvent;
import com.stripe.core.paymentcollection.ManualEntryCollectionResultEvent;
import com.stripe.core.paymentcollection.ManualEntryEvent;
import com.stripe.core.paymentcollection.ManualEntryResult;
import com.stripe.core.paymentcollection.MsrResult;
import com.stripe.core.paymentcollection.NetworkEvent;
import com.stripe.core.paymentcollection.OnlineAuthorizationRequestEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionEvent;
import com.stripe.core.paymentcollection.PaymentCollectionEventDelegate;
import com.stripe.core.paymentcollection.PaymentCollectionListener;
import com.stripe.core.paymentcollection.PaymentCollectionResult;
import com.stripe.core.paymentcollection.PaymentCollectionStateMachine;
import com.stripe.core.paymentcollection.PinEntryStatusChangeEvent;
import com.stripe.core.paymentcollection.PresentAccountTypeSelectionEvent;
import com.stripe.core.paymentcollection.PresentApplicationSelectionEvent;
import com.stripe.core.paymentcollection.PresentPaymentMethodEvent;
import com.stripe.core.paymentcollection.PresentPinEntryEvent;
import com.stripe.core.paymentcollection.PresentProcessingEvent;
import com.stripe.core.paymentcollection.PresentRemoveCardEvent;
import com.stripe.core.paymentcollection.ReaderFinalConfirmationTlvCollectedEvent;
import com.stripe.core.paymentcollection.ReaderTypeChangedEvent;
import com.stripe.core.paymentcollection.ReadingCardEvent;
import com.stripe.core.paymentcollection.RequestOnlineAuthorisationEvent;
import com.stripe.core.paymentcollection.RequestPinEntryEvent;
import com.stripe.core.paymentcollection.RequestSelectAccountEvent;
import com.stripe.core.paymentcollection.RequestSelectApplicationEvent;
import com.stripe.core.paymentcollection.ResetPaymentInterfacesEvent;
import com.stripe.core.paymentcollection.SCARequirement;
import com.stripe.core.paymentcollection.SecondGenACResponse;
import com.stripe.core.paymentcollection.SecondGenACResponseEvent;
import com.stripe.core.paymentcollection.SelectAccountTypeEvent;
import com.stripe.core.paymentcollection.SelectApplicationEvent;
import com.stripe.core.paymentcollection.SelectLanguageEvent;
import com.stripe.core.paymentcollection.SendFinalConfirmEvent;
import com.stripe.core.paymentcollection.SetPinEntryAsteriskCountEvent;
import com.stripe.core.paymentcollection.SetPinPadResultEvent;
import com.stripe.core.paymentcollection.ShowThankYouEvent;
import com.stripe.core.paymentcollection.StartPinEntryEvent;
import com.stripe.core.paymentcollection.StartPollingForCardStatusEvent;
import com.stripe.core.paymentcollection.StopReaderEvent;
import com.stripe.core.paymentcollection.Timeout;
import com.stripe.core.paymentcollection.TimeoutEvent;
import com.stripe.core.paymentcollection.TippingSelectionEvent;
import com.stripe.core.paymentcollection.TippingState;
import com.stripe.core.paymentcollection.TransactionCompletedEvent;
import com.stripe.core.paymentcollection.UserInteractionEvent;
import com.stripe.core.paymentcollection.WaitForCardPresentEvent;
import com.stripe.core.paymentcollection.manualentry.ManualEntryResultModel;
import com.stripe.core.paymentcollection.metrics.EventLoggers;
import com.stripe.core.statemachine.StateMachine;
import com.stripe.core.transaction.SettingsRepository;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.jvmcore.cart.Cart;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.dagger.PaymentCollection;
import com.stripe.jvmcore.dagger.SupportedLanguageList;
import com.stripe.jvmcore.device.MainlandDeviceType;
import com.stripe.jvmcore.device.PlatformDeviceInfo;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.AccountType;
import com.stripe.jvmcore.hardware.emv.InterfaceType;
import com.stripe.jvmcore.hardware.emv.IntermediateTransactionError;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.magstripe.MagStripePaymentCollectionAuthority;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadResult;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadSuccess;
import com.stripe.jvmcore.hardware.status.AudioAlertType;
import com.stripe.jvmcore.hardware.status.ReaderDisplayMessage;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import com.stripe.jvmcore.paymentcollection.OnlineAuthStateListener;
import com.stripe.jvmcore.restclient.IntegrationType;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.jvmcore.transaction.PaymentCollectionDeviceCapability;
import com.stripe.proto.terminal.terminal.pub.message.config.TippingConfigPb;
import com.stripe.stripeterminal.external.models.DeviceType;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00b9\u00012\u00020\u00012\u00020\u00022\u00020\u0003:\u0004\u00b9\u0001\u00ba\u0001Bq\b\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0001\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u000e\b\u0001\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u0012\u000e\b\u0001\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0002\u0010\u0019J\u0006\u0010(\u001a\u00020)J|\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\n\b\u0002\u00103\u001a\u0004\u0018\u0001042\n\b\u0002\u00105\u001a\u0004\u0018\u00010.2\b\b\u0002\u00106\u001a\u00020\u00172\b\b\u0002\u00107\u001a\u00020\u00172\b\b\u0002\u00108\u001a\u00020\u00172\n\b\u0002\u00109\u001a\u0004\u0018\u00010.2\b\b\u0002\u0010:\u001a\u00020\u00172\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<J\u0016\u0010=\u001a\u00020)2\u0006\u0010>\u001a\u00020?2\u0006\u00101\u001a\u000202J\b\u0010@\u001a\u00020AH\u0002J\b\u0010B\u001a\u00020\fH\u0002J\r\u0010C\u001a\u00020DH\u0001\u00a2\u0006\u0002\bEJ\u0012\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u0010H\u001a\u00020I2\u0006\u0010-\u001a\u00020.2\u0006\u0010J\u001a\u00020KH\u0002J8\u0010L\u001a\u00020K2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\b\u0002\u00106\u001a\u00020\u00172\b\b\u0002\u00107\u001a\u00020\u00172\n\b\u0002\u00109\u001a\u0004\u0018\u00010.H\u0002J\u0010\u0010M\u001a\u00020)2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u00020A2\u0006\u0010Q\u001a\u00020RH\u0002J\u0010\u0010S\u001a\u00020)2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020)2\u0006\u0010W\u001a\u00020XH\u0002J\u0010\u0010Y\u001a\u00020A2\u0006\u0010Q\u001a\u00020ZH\u0002J\u0014\u0010[\u001a\b\u0012\u0004\u0012\u00020\\0+2\u0006\u0010]\u001a\u00020\fJ\u0010\u0010^\u001a\u00020)2\u0006\u0010_\u001a\u00020`H\u0002J\u0010\u0010a\u001a\u00020A2\u0006\u0010b\u001a\u00020cH\u0016J\b\u0010d\u001a\u00020AH\u0016J\u0010\u0010e\u001a\u00020A2\u0006\u0010f\u001a\u00020gH\u0016J\u0010\u0010h\u001a\u00020A2\u0006\u0010i\u001a\u00020jH\u0016J\b\u0010k\u001a\u00020AH\u0016J\u0010\u0010l\u001a\u00020A2\u0006\u0010Q\u001a\u00020mH\u0016J\b\u0010n\u001a\u00020AH\u0016J\u0010\u0010o\u001a\u00020A2\u0006\u0010p\u001a\u00020qH\u0016J\u0010\u0010r\u001a\u00020A2\u0006\u0010s\u001a\u00020tH\u0016J\u0010\u0010u\u001a\u00020A2\u0006\u0010v\u001a\u00020wH\u0016J$\u0010x\u001a\u00020A2\u0006\u0010y\u001a\u00020z2\b\u0010{\u001a\u0004\u0018\u00010\f2\b\u0010|\u001a\u0004\u0018\u00010\fH\u0016J\u0017\u0010}\u001a\u00020A2\r\u0010~\u001a\t\u0012\u0005\u0012\u00030\u0080\u00010\u007fH\u0016J\t\u0010\u0081\u0001\u001a\u00020AH\u0016J\t\u0010\u0082\u0001\u001a\u00020AH\u0016J\u0012\u0010\u0083\u0001\u001a\u00020A2\u0007\u0010\u0084\u0001\u001a\u00020\fH\u0016J\u0013\u0010\u0085\u0001\u001a\u00020A2\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0016J\t\u0010\u0088\u0001\u001a\u00020AH\u0016J\u0018\u0010\u0089\u0001\u001a\u00020A2\r\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\t\u0010\u008b\u0001\u001a\u00020AH\u0016J\u0012\u0010\u008c\u0001\u001a\u00020A2\u0007\u0010\u008d\u0001\u001a\u00020\fH\u0016J\u0013\u0010\u008e\u0001\u001a\u00020A2\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001H\u0016J\u0012\u0010\u0091\u0001\u001a\u00020A2\u0007\u0010\u0092\u0001\u001a\u00020\u0017H\u0016J\t\u0010\u0093\u0001\u001a\u00020AH\u0016J\u0013\u0010\u0094\u0001\u001a\u00020A2\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0016J<\u0010\u0097\u0001\u001a\t\u0012\u0004\u0012\u00020,0\u0098\u00012\u0006\u0010-\u001a\u00020.2\b\u00105\u001a\u0004\u0018\u00010.2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u0099\u0001J\t\u0010\u009a\u0001\u001a\u00020AH\u0002J&\u0010\u009b\u0001\u001a\u00020A2\b\u0010\u009c\u0001\u001a\u00030\u009d\u00012\u0007\u0010\u009e\u0001\u001a\u00020\f2\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001H\u0002J\u001d\u0010\u00a1\u0001\u001a\u00020A2\b\u0010\u00a2\u0001\u001a\u00030\u00a3\u00012\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001H\u0002J'\u0010\u00a4\u0001\u001a\u00020A2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u00012\b\u0010\u00a7\u0001\u001a\u00030\u00a8\u00012\b\u0010\u009f\u0001\u001a\u00030\u00a0\u0001H\u0002J\u0012\u0010\u00a9\u0001\u001a\u00020A2\u0007\u0010]\u001a\u00030\u00aa\u0001H\u0002J\t\u0010\u00ab\u0001\u001a\u00020AH\u0002J\u0013\u0010\u00ac\u0001\u001a\u00020A2\b\u0010\u00ad\u0001\u001a\u00030\u00ae\u0001H\u0007J\u0011\u0010\u00af\u0001\u001a\u00020)2\u0006\u0010]\u001a\u00020\fH\u0002J\u009d\u0001\u0010\u00b0\u0001\u001a\t\u0012\u0004\u0012\u00020,0\u0098\u00012\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\b\u00105\u001a\u0004\u0018\u00010.2\b\b\u0002\u00106\u001a\u00020\u00172\b\b\u0002\u00107\u001a\u00020\u00172\b\b\u0002\u00108\u001a\u00020\u00172\n\b\u0002\u00109\u001a\u0004\u0018\u00010.2\b\b\u0002\u0010:\u001a\u00020\u00172\n\b\u0002\u0010;\u001a\u0004\u0018\u00010<2\t\b\u0002\u0010\u00b1\u0001\u001a\u00020\u00172\t\b\u0002\u0010\u00b2\u0001\u001a\u00020\u00172\t\b\u0002\u0010\u00b3\u0001\u001a\u00020\u0017H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0003\u0010\u00b4\u0001J\u0013\u0010\u00b5\u0001\u001a\u00020)2\n\u0010\u00b6\u0001\u001a\u0005\u0018\u00010\u00b7\u0001J\t\u0010\u00b8\u0001\u001a\u00020AH\u0016R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b \u0010!*\u0004\b\u001e\u0010\u001fR\u0014\u0010\"\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010&\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u00bb\u0001"}, d2={"Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator;", "Lcom/stripe/core/hardware/paymentcollection/PaymentEventReceiver;", "Lcom/stripe/core/paymentcollection/PaymentCollectionEventDelegate;", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthStateListener;", "paymentCollector", "Lcom/stripe/core/hardware/paymentcollection/PaymentCollector;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "settingsRepository", "Lcom/stripe/core/transaction/SettingsRepository;", "supportedLanguages", "", "", "eventLoggers", "Lcom/stripe/core/paymentcollection/metrics/EventLoggers;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "paymentCollectionContextFactory", "Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator$PaymentCollectionContext$Factory;", "platformDeviceInfo", "Lcom/stripe/jvmcore/device/PlatformDeviceInfo;", "applicationSelectionInQuickChipEnabled", "Ljavax/inject/Provider;", "", "enablesMagStripePin", "(Lcom/stripe/core/hardware/paymentcollection/PaymentCollector;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/core/transaction/SettingsRepository;Ljava/util/List;Lcom/stripe/core/paymentcollection/metrics/EventLoggers;Lcom/stripe/core/transaction/TransactionRepository;Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator$PaymentCollectionContext$Factory;Lcom/stripe/jvmcore/device/PlatformDeviceInfo;Ljavax/inject/Provider;Ljavax/inject/Provider;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "deviceCapability", "Lcom/stripe/jvmcore/transaction/PaymentCollectionDeviceCapability;", "getDeviceCapability$delegate", "(Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator;)Ljava/lang/Object;", "getDeviceCapability", "()Lcom/stripe/jvmcore/transaction/PaymentCollectionDeviceCapability;", "emvTransactionType", "Lcom/stripe/jvmcore/hardware/emv/TransactionType;", "getEmvTransactionType", "()Lcom/stripe/jvmcore/hardware/emv/TransactionType;", "paymentCollectionContext", "Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator$PaymentCollectionContext;", "cancelPaymentMethodCollection", "Lkotlinx/coroutines/Job;", "collectPaymentMethod", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/core/paymentcollection/PaymentCollectionResult;", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "transactionType", "Lcom/stripe/core/hardware/paymentcollection/TransactionType;", "paymentCollectionListener", "Lcom/stripe/core/paymentcollection/PaymentCollectionListener;", "scaRequirement", "Lcom/stripe/core/paymentcollection/SCARequirement;", "tippingAmount", "skipTipping", "manualEntry", "isOffline", "tipEligibleAmount", "isDeferredAuthorizationCountry", "domesticDebitPriority", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$DomesticDebitPriority;", "displayCart", "cart", "Lcom/stripe/jvmcore/cart/Cart;", "disposeCurrentTransaction", "", "getAccountBlob", "getDeviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "getDeviceType$paymentcollection_release", "getLocalizedTippingConfigs", "Lcom/stripe/proto/terminal/terminal/pub/message/config/TippingConfigPb$LocalizedTippingConfig;", "getTippingConfig", "Lcom/stripe/core/hardware/tipping/TipConfigValidationResult;", "tippingState", "Lcom/stripe/core/paymentcollection/TippingState;", "getTippingState", "handleAutomationEvent", "automationEvent", "Lcom/stripe/core/paymentcollection/AutomationEvent;", "handleCollectionCompletion", "event", "Lcom/stripe/core/paymentcollection/CollectionCompleteEvent;", "handleHardwareEvent", "hardwareEvent", "Lcom/stripe/core/paymentcollection/HardwareEvent;", "handleHardwareListenerEvent", "hardwareListenerEvent", "Lcom/stripe/core/paymentcollection/HardwareListenerEvent;", "handleNetworkEvent", "Lcom/stripe/core/paymentcollection/NetworkEvent;", "handleOnlineAuthResponse", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "response", "handleUserInteractionEvent", "userInteractionEvent", "Lcom/stripe/core/paymentcollection/UserInteractionEvent;", "onCardSwiped", "readResult", "Lcom/stripe/jvmcore/hardware/magstripe/MagStripeReadResult;", "onChipCardInitializationFailed", "onContactCardStateUpdate", "slotState", "Lcom/stripe/core/hardware/paymentcollection/ContactCardSlotState;", "onDisplayAdditionalMessage", "message", "Lcom/stripe/jvmcore/hardware/status/ReaderDisplayMessage;", "onEmptyCandidateList", "onHandlePaymentCollectionEvent", "Lcom/stripe/core/paymentcollection/PaymentCollectionEvent;", "onHardwareTransactionCanceled", "onIntermediateTransactionError", "error", "Lcom/stripe/jvmcore/hardware/emv/IntermediateTransactionError;", "onKernelTippingSelectionResult", "tipSelectionResult", "Lcom/stripe/core/hardware/tipping/TipSelectionResult;", "onOnlineAuthStateChanged", "state", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthState;", "onPinEntryStatusChange", "pinEntryStatus", "Lcom/stripe/core/hardware/paymentcollection/PinEntryStatus;", "epb", "epbKsn", "onReaderTypesChanged", "readerTypes", "Ljava/util/EnumSet;", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$ReaderType;", "onReadingCard", "onRequestFinalConfirm", "onRequestOnlineAuthorisation", "authorisationData", "onRequestProduceAudioTone", "audioAlertType", "Lcom/stripe/jvmcore/hardware/status/AudioAlertType;", "onRequestSelectAccountType", "onRequestSelectApplication", "appList", "onResetPaymentInterfaces", "onReturnFinalTlvBlob", "tlv", "onReturnTransactionResult", "transactionResult", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult$Result;", "onSetPinPadButtonsResult", "isSuccess", "onShowThankYou", "onUpdatePinEntryAsteriskCount", "count", "", "resumeExistingPaymentCollection", "Lkotlinx/coroutines/CompletableDeferred;", "(Lcom/stripe/jvmcore/currency/Amount;Lcom/stripe/jvmcore/currency/Amount;Lcom/stripe/core/paymentcollection/PaymentCollectionListener;Lcom/stripe/core/paymentcollection/SCARequirement;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sendCancelResult", "sendEmvResult", "interfaceType", "Lcom/stripe/jvmcore/hardware/emv/InterfaceType;", "emvBlob", "tipResult", "Lcom/stripe/core/paymentcollection/TippingState$EndState;", "sendManualEntryResult", "data", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryResultModel;", "sendMsrResult", "result", "Lcom/stripe/jvmcore/hardware/magstripe/MagStripeReadSuccess;", "collectionAuthority", "Lcom/stripe/jvmcore/hardware/magstripe/MagStripePaymentCollectionAuthority;", "sendSecondGenACResponse", "Lcom/stripe/core/paymentcollection/SecondGenACResponse;", "sendTimeoutResult", "setSelectedAccountType", "accountType", "Lcom/stripe/jvmcore/hardware/emv/AccountType;", "startHandleOnlineAuthResponse", "startPaymentCollection", "isApplicationSelectionInQuickChipEnabled", "promptPinEntryForServiceCode", "forceMagstripePin", "(Lcom/stripe/jvmcore/currency/Amount;Lcom/stripe/core/hardware/paymentcollection/TransactionType;Lcom/stripe/core/paymentcollection/PaymentCollectionListener;Lcom/stripe/jvmcore/currency/Amount;ZZZLcom/stripe/jvmcore/currency/Amount;ZLcom/stripe/jvmcore/hardware/ReaderConfiguration$DomesticDebitPriority;ZZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateChargeAttempt", "chargeAttempt", "Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "waitForCardPresent", "Companion", "PaymentCollectionContext", "paymentcollection_release"})
@ExperimentalCoroutinesApi
@SourceDebugExtension(value={"SMAP\nPaymentCollectionCoordinator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentCollectionCoordinator.kt\ncom/stripe/core/paymentcollection/PaymentCollectionCoordinator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,992:1\n1282#2,2:993\n*S KotlinDebug\n*F\n+ 1 PaymentCollectionCoordinator.kt\ncom/stripe/core/paymentcollection/PaymentCollectionCoordinator\n*L\n412#1:993,2\n*E\n"})
public final class PaymentCollectionCoordinator
implements PaymentEventReceiver,
PaymentCollectionEventDelegate,
OnlineAuthStateListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PaymentCollector paymentCollector;
    @NotNull
    private final SettingsRepository settingsRepository;
    @NotNull
    private final List<String> supportedLanguages;
    @NotNull
    private final EventLoggers eventLoggers;
    @NotNull
    private final TransactionRepository transactionRepository;
    @NotNull
    private final PaymentCollectionContext.Factory paymentCollectionContextFactory;
    @NotNull
    private final PlatformDeviceInfo platformDeviceInfo;
    @NotNull
    private final Provider<Boolean> applicationSelectionInQuickChipEnabled;
    @NotNull
    private final Provider<Boolean> enablesMagStripePin;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private PaymentCollectionContext paymentCollectionContext;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(PaymentCollectionCoordinator.class);

    @Inject
    public PaymentCollectionCoordinator(@NotNull PaymentCollector paymentCollector, @PaymentCollection @NotNull CoroutineDispatcher coroutineDispatcher, @NotNull SettingsRepository settingsRepository, @SupportedLanguageList @NotNull List<String> supportedLanguages, @NotNull EventLoggers eventLoggers, @NotNull TransactionRepository transactionRepository, @NotNull PaymentCollectionContext.Factory paymentCollectionContextFactory, @NotNull PlatformDeviceInfo platformDeviceInfo, @ApplicationSelectionInQuickChipEnabled @NotNull Provider<Boolean> applicationSelectionInQuickChipEnabled, @EnableMagStripePin @NotNull Provider<Boolean> enablesMagStripePin) {
        Intrinsics.checkNotNullParameter((Object)paymentCollector, (String)"paymentCollector");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        Intrinsics.checkNotNullParameter(supportedLanguages, (String)"supportedLanguages");
        Intrinsics.checkNotNullParameter((Object)eventLoggers, (String)"eventLoggers");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        Intrinsics.checkNotNullParameter((Object)paymentCollectionContextFactory, (String)"paymentCollectionContextFactory");
        Intrinsics.checkNotNullParameter((Object)platformDeviceInfo, (String)"platformDeviceInfo");
        Intrinsics.checkNotNullParameter(applicationSelectionInQuickChipEnabled, (String)"applicationSelectionInQuickChipEnabled");
        Intrinsics.checkNotNullParameter(enablesMagStripePin, (String)"enablesMagStripePin");
        this.paymentCollector = paymentCollector;
        this.settingsRepository = settingsRepository;
        this.supportedLanguages = supportedLanguages;
        this.eventLoggers = eventLoggers;
        this.transactionRepository = transactionRepository;
        this.paymentCollectionContextFactory = paymentCollectionContextFactory;
        this.platformDeviceInfo = platformDeviceInfo;
        this.applicationSelectionInQuickChipEnabled = applicationSelectionInQuickChipEnabled;
        this.enablesMagStripePin = enablesMagStripePin;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)coroutineDispatcher));
    }

    private final PaymentCollectionDeviceCapability getDeviceCapability() {
        return this.transactionRepository.getDevicePaymentCapability();
    }

    private static Object getDeviceCapability$delegate(PaymentCollectionCoordinator paymentCollectionCoordinator) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)paymentCollectionCoordinator.transactionRepository, TransactionRepository.class, "devicePaymentCapability", "getDevicePaymentCapability()Lcom/stripe/jvmcore/transaction/PaymentCollectionDeviceCapability;", 0)));
    }

    @NotNull
    public final Deferred<PaymentCollectionResult> collectPaymentMethod(@NotNull Amount amount, @NotNull com.stripe.core.hardware.paymentcollection.TransactionType transactionType, @NotNull PaymentCollectionListener paymentCollectionListener, @Nullable SCARequirement scaRequirement, @Nullable Amount tippingAmount, boolean skipTipping, boolean manualEntry, boolean isOffline, @Nullable Amount tipEligibleAmount, boolean isDeferredAuthorizationCountry, @Nullable ReaderConfiguration.DomesticDebitPriority domesticDebitPriority) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)"transactionType");
        Intrinsics.checkNotNullParameter((Object)paymentCollectionListener, (String)"paymentCollectionListener");
        return (Deferred)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CompletableDeferred<PaymentCollectionResult>>, Object>(transactionType, this, amount, tippingAmount, paymentCollectionListener, scaRequirement, skipTipping, manualEntry, isOffline, tipEligibleAmount, isDeferredAuthorizationCountry, domesticDebitPriority, null){
            int label;
            final /* synthetic */ com.stripe.core.hardware.paymentcollection.TransactionType $transactionType;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            final /* synthetic */ Amount $amount;
            final /* synthetic */ Amount $tippingAmount;
            final /* synthetic */ PaymentCollectionListener $paymentCollectionListener;
            final /* synthetic */ SCARequirement $scaRequirement;
            final /* synthetic */ boolean $skipTipping;
            final /* synthetic */ boolean $manualEntry;
            final /* synthetic */ boolean $isOffline;
            final /* synthetic */ Amount $tipEligibleAmount;
            final /* synthetic */ boolean $isDeferredAuthorizationCountry;
            final /* synthetic */ ReaderConfiguration.DomesticDebitPriority $domesticDebitPriority;
            {
                this.$transactionType = $transactionType;
                this.this$0 = $receiver;
                this.$amount = $amount;
                this.$tippingAmount = $tippingAmount;
                this.$paymentCollectionListener = $paymentCollectionListener;
                this.$scaRequirement = $scaRequirement;
                this.$skipTipping = $skipTipping;
                this.$manualEntry = $manualEntry;
                this.$isOffline = $isOffline;
                this.$tipEligibleAmount = $tipEligibleAmount;
                this.$isDeferredAuthorizationCountry = $isDeferredAuthorizationCountry;
                this.$domesticDebitPriority = $domesticDebitPriority;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        if (this.$transactionType != com.stripe.core.hardware.paymentcollection.TransactionType.STRONG_CUSTOMER_AUTHENTICATION) break;
                        v0 = this.$scaRequirement;
                        if (v0 == null) {
                            v0 = SCARequirement.GENERIC;
                        }
                        this.label = 1;
                        v1 = PaymentCollectionCoordinator.access$resumeExistingPaymentCollection(this.this$0, this.$amount, this.$tippingAmount, this.$paymentCollectionListener, v0, (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl17
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl17:
                        // 2 sources

                        v2 = (CompletableDeferred)v1;
                        ** GOTO lbl33
                    }
                }
                v3 = PaymentCollectionCoordinator.access$getApplicationSelectionInQuickChipEnabled$p(this.this$0).get();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"applicationSelectionInQuickChipEnabled.get()");
                v4 = (Boolean)v3;
                v5 = PaymentCollectionCoordinator.access$getEnablesMagStripePin$p(this.this$0).get();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"enablesMagStripePin.get()");
                this.label = 2;
                v6 = PaymentCollectionCoordinator.access$startPaymentCollection(this.this$0, this.$amount, this.$transactionType, this.$paymentCollectionListener, this.$tippingAmount, this.$skipTipping, this.$manualEntry, this.$isOffline, this.$tipEligibleAmount, this.$isDeferredAuthorizationCountry, this.$domesticDebitPriority, v4, (Boolean)v5, PaymentCollectionCoordinator.access$getSettingsRepository$p((PaymentCollectionCoordinator)this.this$0).getMagstripeConfig().force_pin_entry, (Continuation)this);
                if (v6 == var2_2) {
                    return var2_2;
                }
                ** GOTO lbl32
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl32:
                        // 2 sources

                        v2 = (CompletableDeferred)v6;
lbl33:
                        // 2 sources

                        return v2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CompletableDeferred<PaymentCollectionResult>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ Deferred collectPaymentMethod$default(PaymentCollectionCoordinator paymentCollectionCoordinator, Amount amount, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, PaymentCollectionListener paymentCollectionListener, SCARequirement sCARequirement, Amount amount2, boolean bl, boolean bl2, boolean bl3, Amount amount3, boolean bl4, ReaderConfiguration.DomesticDebitPriority domesticDebitPriority, int n2, Object object) {
        if ((n2 & 8) != 0) {
            sCARequirement = null;
        }
        if ((n2 & 0x10) != 0) {
            amount2 = null;
        }
        if ((n2 & 0x20) != 0) {
            bl = false;
        }
        if ((n2 & 0x40) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x80) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x100) != 0) {
            amount3 = null;
        }
        if ((n2 & 0x200) != 0) {
            bl4 = false;
        }
        if ((n2 & 0x400) != 0) {
            domesticDebitPriority = null;
        }
        return paymentCollectionCoordinator.collectPaymentMethod(amount, transactionType, paymentCollectionListener, sCARequirement, amount2, bl, bl2, bl3, amount3, bl4, domesticDebitPriority);
    }

    private final TippingState getTippingState(Amount amount, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, boolean skipTipping, boolean manualEntry, Amount tipEligibleAmount) {
        if (manualEntry) {
            return TippingState.Ineligible.INSTANCE;
        }
        Amount amount2 = tipEligibleAmount;
        if (amount2 != null) {
            Amount it = amount2;
            boolean bl = false;
            this.eventLoggers.getTippingLogger().logTipEligible(this.transactionRepository.getIntegrationType(), tipEligibleAmount.getValue());
        }
        Amount amount3 = tipEligibleAmount;
        boolean bl = amount3 != null ? amount3.getValue() == 0L : false;
        if (bl || skipTipping) {
            if (skipTipping) {
                this.eventLoggers.getTippingLogger().logSkipTipping(this.transactionRepository.getIntegrationType());
            }
            return TippingState.Ineligible.INSTANCE;
        }
        if (transactionType != com.stripe.core.hardware.paymentcollection.TransactionType.CHARGE) {
            LOGGER.i("Not starting the tipping flow because TransactionType is not CHARGE. Current TransactionType: " + transactionType.name(), new Pair[0]);
            return TippingState.Ineligible.INSTANCE;
        }
        if (this.getLocalizedTippingConfigs(amount) == null) {
            return TippingState.Ineligible.INSTANCE;
        }
        LOGGER.i("Starting tipping flow with currency: " + amount.getCurrencyCode(), new Pair[0]);
        return TippingState.SelectionNeeded.INSTANCE;
    }

    static /* synthetic */ TippingState getTippingState$default(PaymentCollectionCoordinator paymentCollectionCoordinator, Amount amount, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, boolean bl, boolean bl2, Amount amount2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            amount2 = null;
        }
        return paymentCollectionCoordinator.getTippingState(amount, transactionType, bl, bl2, amount2);
    }

    private final TippingConfigPb.LocalizedTippingConfig getLocalizedTippingConfigs(Amount amount) {
        Map<String, TippingConfigPb.LocalizedTippingConfig> localizedTippingConfigs = this.settingsRepository.getTippingConfig().localized_tipping_config;
        if (localizedTippingConfigs.isEmpty()) {
            LOGGER.i("Not starting the tipping flow because there is no tipping config", new Pair[0]);
            return null;
        }
        TippingConfigPb.LocalizedTippingConfig localizedTippingConfig = localizedTippingConfigs.get(amount.getCurrencyCode());
        if (localizedTippingConfig == null) {
            String tippingCurrencies = CollectionsKt.joinToString$default((Iterable)localizedTippingConfigs.keySet(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            this.eventLoggers.getTippingLogger().logCurrencyMismatch(tippingCurrencies, amount.getCurrencyCode(), this.transactionRepository.getIntegrationType());
        }
        return localizedTippingConfig;
    }

    private final TipConfigValidationResult getTippingConfig(Amount amount, TippingState tippingState) {
        if (Intrinsics.areEqual((Object)tippingState, (Object)TippingState.Ineligible.INSTANCE)) {
            return new InvalidTipConfig(InvalidTipConfig.Reason.NULL_TIP_CONFIG);
        }
        TippingConfigPb.LocalizedTippingConfig localizedTippingConfig = this.getLocalizedTippingConfigs(amount);
        if (localizedTippingConfig == null) {
            return new InvalidTipConfig(InvalidTipConfig.Reason.NULL_TIP_CONFIG);
        }
        TippingConfigPb.LocalizedTippingConfig localConfig = localizedTippingConfig;
        return TipConfigValidationResultKt.generateValidatedConfig(localConfig, amount);
    }

    @NotNull
    public final Job displayCart(@NotNull Cart cart, @NotNull PaymentCollectionListener paymentCollectionListener) {
        Intrinsics.checkNotNullParameter((Object)cart, (String)"cart");
        Intrinsics.checkNotNullParameter((Object)paymentCollectionListener, (String)"paymentCollectionListener");
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, paymentCollectionListener, cart, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            final /* synthetic */ PaymentCollectionListener $paymentCollectionListener;
            final /* synthetic */ Cart $cart;
            {
                this.this$0 = $receiver;
                this.$paymentCollectionListener = $paymentCollectionListener;
                this.$cart = $cart;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0) == null) {
                            PaymentCollectionCoordinator.access$setPaymentCollectionContext$p(this.this$0, PaymentCollectionCoordinator.access$getPaymentCollectionContextFactory$p(this.this$0).create(this.$paymentCollectionListener, this.$cart.getBalance(), com.stripe.core.hardware.paymentcollection.TransactionType.CHARGE));
                        }
                        TippingState tippingState = PaymentCollectionCoordinator.getTippingState$default(this.this$0, this.$cart.getBalance(), com.stripe.core.hardware.paymentcollection.TransactionType.CHARGE, false, false, null, 28, null);
                        TipConfigValidationResult tippingConfig = PaymentCollectionCoordinator.access$getTippingConfig(this.this$0, this.$cart.getBalance(), tippingState);
                        Object object2 = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        if (object2 != null && (object2 = ((PaymentCollectionContext)object2).getPaymentCollectionStateMachine()) != null) {
                            void var3_3;
                            void var2_2;
                            TransactionType transactionType = PaymentCollectionCoordinator.access$getEmvTransactionType(this.this$0);
                            IntegrationType integrationType = PaymentCollectionCoordinator.access$getTransactionRepository$p(this.this$0).getIntegrationType();
                            PaymentCollectionDeviceCapability paymentCollectionDeviceCapability = PaymentCollectionCoordinator.access$getDeviceCapability(this.this$0);
                            DeviceType deviceType = this.this$0.getDeviceType$paymentcollection_release();
                            Object object3 = PaymentCollectionCoordinator.access$getApplicationSelectionInQuickChipEnabled$p(this.this$0).get();
                            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"applicationSelectionInQuickChipEnabled.get()");
                            boolean bl = (Boolean)object3;
                            Object object4 = PaymentCollectionCoordinator.access$getEnablesMagStripePin$p(this.this$0).get();
                            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"enablesMagStripePin.get()");
                            Boxing.boxBoolean((boolean)((PaymentCollectionStateMachine)object2).displayCart(transactionType, (TippingState)var2_2, (TipConfigValidationResult)var3_3, this.$cart, integrationType, paymentCollectionDeviceCapability, deviceType, bl, (Boolean)object4, PaymentCollectionCoordinator.access$getSettingsRepository$p((PaymentCollectionCoordinator)this.this$0).getMagstripeConfig().force_pin_entry));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Job cancelPaymentMethodCollection() {
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PaymentCollectionContext paymentCollectionContext = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        if (paymentCollectionContext != null) {
                            PaymentCollectionContext paymentCollectionContext2;
                            PaymentCollectionContext $this$invokeSuspend_u24lambda_u240 = paymentCollectionContext2 = paymentCollectionContext;
                            boolean bl = false;
                            $this$invokeSuspend_u24lambda_u240.getPaymentCollectionStateMachine().onMerchantTransactionCanceled();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final Deferred<TransactionResult> handleOnlineAuthResponse(@NotNull String response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        PaymentCollectionContext paymentCollectionContext = this.paymentCollectionContext;
        if (paymentCollectionContext != null) {
            CompletableDeferred completableDeferred;
            PaymentCollectionContext context = paymentCollectionContext;
            boolean bl = false;
            CompletableDeferred it = completableDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            boolean bl2 = false;
            context.setSecondGenACResult((CompletableDeferred<TransactionResult>)it);
            this.startHandleOnlineAuthResponse(response);
            return (Deferred)completableDeferred;
        }
        PaymentCollectionCoordinator $this$handleOnlineAuthResponse_u24lambda_u243 = this;
        boolean bl = false;
        return (Deferred)CompletableDeferredKt.CompletableDeferred((Object)new TransactionResult(TransactionResult.Result.TERMINATED, null));
    }

    @NotNull
    public final Job updateChargeAttempt(@Nullable ChargeAttempt chargeAttempt) {
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, chargeAttempt, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            final /* synthetic */ ChargeAttempt $chargeAttempt;
            {
                this.this$0 = $receiver;
                this.$chargeAttempt = $chargeAttempt;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PaymentCollectionContext paymentCollectionContext = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        if (paymentCollectionContext != null) {
                            PaymentCollectionContext paymentCollectionContext2 = paymentCollectionContext;
                            ChargeAttempt chargeAttempt = this.$chargeAttempt;
                            PaymentCollectionContext $this$invokeSuspend_u24lambda_u241 = paymentCollectionContext2;
                            boolean bl = false;
                            $this$invokeSuspend_u24lambda_u241.getPaymentCollectionStateMachine().updateChargeAttempt(chargeAttempt);
                            ChargeAttempt chargeAttempt2 = chargeAttempt;
                            if (chargeAttempt2 != null) {
                                ChargeAttempt it = chargeAttempt2;
                                boolean bl2 = false;
                                $this$invokeSuspend_u24lambda_u241.getPaymentCollectionListener().onChargeSummary(it);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Override
    public void onOnlineAuthStateChanged(@NotNull OnlineAuthState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, state, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            final /* synthetic */ OnlineAuthState $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PaymentCollectionContext paymentCollectionContext = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        if (paymentCollectionContext != null) {
                            PaymentCollectionContext paymentCollectionContext2 = paymentCollectionContext;
                            OnlineAuthState onlineAuthState = this.$state;
                            PaymentCollectionContext $this$invokeSuspend_u24lambda_u240 = paymentCollectionContext2;
                            boolean bl = false;
                            $this$invokeSuspend_u24lambda_u240.getPaymentCollectionStateMachine().onOnlineAuthStateChanged(onlineAuthState);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Job startHandleOnlineAuthResponse(String response) {
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, response, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            final /* synthetic */ String $response;
            {
                this.this$0 = $receiver;
                this.$response = $response;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PaymentCollectionContext paymentCollectionContext = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        if (paymentCollectionContext != null) {
                            PaymentCollectionContext paymentCollectionContext2 = paymentCollectionContext;
                            String string = this.$response;
                            PaymentCollectionContext $this$invokeSuspend_u24lambda_u240 = paymentCollectionContext2;
                            boolean bl = false;
                            $this$invokeSuspend_u24lambda_u240.getPaymentCollectionStateMachine().setOnlineAuthResponse(string);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object startPaymentCollection(Amount amount, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, PaymentCollectionListener paymentCollectionListener, Amount tippingAmount, boolean skipTipping, boolean manualEntry, boolean isOffline, Amount tipEligibleAmount, boolean isDeferredAuthorizationCountry, ReaderConfiguration.DomesticDebitPriority domesticDebitPriority, boolean isApplicationSelectionInQuickChipEnabled, boolean promptPinEntryForServiceCode, boolean forceMagstripePin, Continuation<? super CompletableDeferred<PaymentCollectionResult>> $completion) {
        return BuildersKt.withContext((CoroutineContext)this.coroutineScope.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CompletableDeferred<PaymentCollectionResult>>, Object>(this, amount, transactionType, skipTipping, manualEntry, tipEligibleAmount, paymentCollectionListener, tippingAmount, isOffline, isDeferredAuthorizationCountry, domesticDebitPriority, isApplicationSelectionInQuickChipEnabled, promptPinEntryForServiceCode, forceMagstripePin, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            final /* synthetic */ Amount $amount;
            final /* synthetic */ com.stripe.core.hardware.paymentcollection.TransactionType $transactionType;
            final /* synthetic */ boolean $skipTipping;
            final /* synthetic */ boolean $manualEntry;
            final /* synthetic */ Amount $tipEligibleAmount;
            final /* synthetic */ PaymentCollectionListener $paymentCollectionListener;
            final /* synthetic */ Amount $tippingAmount;
            final /* synthetic */ boolean $isOffline;
            final /* synthetic */ boolean $isDeferredAuthorizationCountry;
            final /* synthetic */ ReaderConfiguration.DomesticDebitPriority $domesticDebitPriority;
            final /* synthetic */ boolean $isApplicationSelectionInQuickChipEnabled;
            final /* synthetic */ boolean $promptPinEntryForServiceCode;
            final /* synthetic */ boolean $forceMagstripePin;
            {
                this.this$0 = $receiver;
                this.$amount = $amount;
                this.$transactionType = $transactionType;
                this.$skipTipping = $skipTipping;
                this.$manualEntry = $manualEntry;
                this.$tipEligibleAmount = $tipEligibleAmount;
                this.$paymentCollectionListener = $paymentCollectionListener;
                this.$tippingAmount = $tippingAmount;
                this.$isOffline = $isOffline;
                this.$isDeferredAuthorizationCountry = $isDeferredAuthorizationCountry;
                this.$domesticDebitPriority = $domesticDebitPriority;
                this.$isApplicationSelectionInQuickChipEnabled = $isApplicationSelectionInQuickChipEnabled;
                this.$promptPinEntryForServiceCode = $promptPinEntryForServiceCode;
                this.$forceMagstripePin = $forceMagstripePin;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean useExistingStateMachine;
                        ResultKt.throwOnFailure((Object)object);
                        TippingState tippingState = PaymentCollectionCoordinator.access$getTippingState(this.this$0, this.$amount, this.$transactionType, this.$skipTipping, this.$manualEntry, this.$tipEligibleAmount);
                        TipConfigValidationResult tippingConfig = PaymentCollectionCoordinator.access$getTippingConfig(this.this$0, this.$amount, tippingState);
                        DeviceType deviceType = this.this$0.getDeviceType$paymentcollection_release();
                        Object object2 = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        boolean bl = object2 != null && (object2 = ((PaymentCollectionContext)object2).getPaymentCollectionStateMachine()) != null ? ((PaymentCollectionStateMachine)object2).canStartCollection() : (useExistingStateMachine = false);
                        if (!useExistingStateMachine) {
                            PaymentCollectionCoordinator.access$disposeCurrentTransaction(this.this$0);
                            PaymentCollectionCoordinator.access$setPaymentCollectionContext$p(this.this$0, PaymentCollectionCoordinator.access$getPaymentCollectionContextFactory$p(this.this$0).create(this.$paymentCollectionListener, this.$amount, this.$transactionType));
                        }
                        PaymentCollectionContext paymentCollectionContext = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        if (paymentCollectionContext != null) {
                            void var3_3;
                            void var2_2;
                            PaymentCollectionContext paymentCollectionContext2 = paymentCollectionContext;
                            com.stripe.core.hardware.paymentcollection.TransactionType transactionType = this.$transactionType;
                            Amount amount = this.$amount;
                            PaymentCollectionCoordinator paymentCollectionCoordinator = this.this$0;
                            Amount amount2 = this.$tippingAmount;
                            boolean bl2 = this.$manualEntry;
                            boolean bl3 = this.$isOffline;
                            Amount amount3 = this.$tipEligibleAmount;
                            boolean bl4 = this.$isDeferredAuthorizationCountry;
                            ReaderConfiguration.DomesticDebitPriority domesticDebitPriority = this.$domesticDebitPriority;
                            boolean bl5 = this.$isApplicationSelectionInQuickChipEnabled;
                            boolean bl6 = this.$promptPinEntryForServiceCode;
                            boolean bl7 = this.$forceMagstripePin;
                            PaymentCollectionContext it = paymentCollectionContext2;
                            boolean bl8 = false;
                            if (it.getPaymentCollectionStateMachine().collectPayment(transactionType, amount, PaymentCollectionCoordinator.access$getEmvTransactionType(paymentCollectionCoordinator), (TippingState)var2_2, (TipConfigValidationResult)var3_3, amount2, PaymentCollectionCoordinator.access$getTransactionRepository$p(paymentCollectionCoordinator).getIntegrationType(), bl2, PaymentCollectionCoordinator.access$getDeviceCapability(paymentCollectionCoordinator), deviceType, bl3, amount3, bl4, domesticDebitPriority, bl5, bl6, bl7, PaymentCollectionCoordinator.access$getTransactionRepository$p(paymentCollectionCoordinator).getDomesticDebitAids())) {
                                // empty if block
                            }
                        }
                        PaymentCollectionContext paymentCollectionContext3 = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        Intrinsics.checkNotNull((Object)paymentCollectionContext3);
                        return paymentCollectionContext3.getCollectionResult();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CompletableDeferred<PaymentCollectionResult>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    static /* synthetic */ Object startPaymentCollection$default(PaymentCollectionCoordinator paymentCollectionCoordinator, Amount amount, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, PaymentCollectionListener paymentCollectionListener, Amount amount2, boolean bl, boolean bl2, boolean bl3, Amount amount3, boolean bl4, ReaderConfiguration.DomesticDebitPriority domesticDebitPriority, boolean bl5, boolean bl6, boolean bl7, Continuation continuation, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            bl = false;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x40) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x80) != 0) {
            amount3 = null;
        }
        if ((n2 & 0x100) != 0) {
            bl4 = false;
        }
        if ((n2 & 0x200) != 0) {
            domesticDebitPriority = null;
        }
        if ((n2 & 0x400) != 0) {
            bl5 = false;
        }
        if ((n2 & 0x800) != 0) {
            bl6 = false;
        }
        if ((n2 & 0x1000) != 0) {
            bl7 = false;
        }
        return paymentCollectionCoordinator.startPaymentCollection(amount, transactionType, paymentCollectionListener, amount2, bl, bl2, bl3, amount3, bl4, domesticDebitPriority, bl5, bl6, bl7, (Continuation<? super CompletableDeferred<PaymentCollectionResult>>)continuation);
    }

    private final void disposeCurrentTransaction() {
        block0: {
            Object object = this.paymentCollectionContext;
            if (object == null || (object = ((PaymentCollectionContext)object).getPaymentCollectionStateMachine()) == null) break block0;
            ((PaymentCollectionStateMachine)object).dispose();
        }
    }

    private final Object resumeExistingPaymentCollection(Amount amount, Amount tippingAmount, PaymentCollectionListener paymentCollectionListener, SCARequirement scaRequirement, Continuation<? super CompletableDeferred<PaymentCollectionResult>> $completion) {
        return BuildersKt.withContext((CoroutineContext)this.coroutineScope.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super CompletableDeferred<PaymentCollectionResult>>, Object>(this, amount, paymentCollectionListener, tippingAmount, scaRequirement, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            final /* synthetic */ Amount $amount;
            final /* synthetic */ PaymentCollectionListener $paymentCollectionListener;
            final /* synthetic */ Amount $tippingAmount;
            final /* synthetic */ SCARequirement $scaRequirement;
            {
                this.this$0 = $receiver;
                this.$amount = $amount;
                this.$paymentCollectionListener = $paymentCollectionListener;
                this.$tippingAmount = $tippingAmount;
                this.$scaRequirement = $scaRequirement;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        v1 = v0 != null && (v0 = v0.getPaymentCollectionStateMachine()) != null ? v0.canResumeCollectionForSca() : (canResumeExistingPayment = false);
                        if (!canResumeExistingPayment) ** GOTO lbl22
                        v2 = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        PaymentCollectionCoordinator.access$setPaymentCollectionContext$p(this.this$0, v2 != null ? PaymentCollectionContext.copy$default(v2, null, null, null, null, 15, null) : null);
                        v3 = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        if (v3 != null) {
                            var3_4 = v3;
                            var4_5 = this.$scaRequirement;
                            it = var3_4;
                            $i$a$-takeIf-PaymentCollectionCoordinator$resumeExistingPaymentCollection$2$1 = false;
                            if (it.getPaymentCollectionStateMachine().resumePaymentForSCA(var4_5)) {
                                // empty if block
                            }
                        }
                        v4 = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        Intrinsics.checkNotNull((Object)v4);
                        v5 = v4.getCollectionResult();
                        ** GOTO lbl31
lbl22:
                        // 1 sources

                        this.label = 1;
                        v6 = PaymentCollectionCoordinator.startPaymentCollection$default(this.this$0, this.$amount, com.stripe.core.hardware.paymentcollection.TransactionType.STRONG_CUSTOMER_AUTHENTICATION, this.$paymentCollectionListener, this.$tippingAmount, false, false, false, null, false, null, false, false, false, (Continuation)this, 8176, null);
                        if (v6 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl30
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v6 = $result;
lbl30:
                        // 2 sources

                        v5 = (CompletableDeferred<PaymentCollectionResult>)v6;
lbl31:
                        // 2 sources

                        return v5;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super CompletableDeferred<PaymentCollectionResult>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final TransactionType getEmvTransactionType() {
        return this.settingsRepository.getSettings().getEmvTransactionType();
    }

    @VisibleForTesting
    @NotNull
    public final DeviceType getDeviceType$paymentcollection_release() {
        DeviceType deviceType;
        block2: {
            DeviceType[] $this$firstOrNull$iv = DeviceType.values();
            boolean $i$f$firstOrNull = false;
            int n2 = $this$firstOrNull$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                DeviceType element$iv;
                DeviceType it = element$iv = $this$firstOrNull$iv[i2];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)new MainlandDeviceType(it.getDeviceName()), (Object)this.platformDeviceInfo.getMainlandDeviceType())) continue;
                deviceType = element$iv;
                break block2;
            }
            deviceType = null;
        }
        if (deviceType == null) {
            PaymentCollectionCoordinator it = this;
            boolean bl = false;
            LOGGER.w("Failed to retrieve device type.", new Pair[0]);
            return DeviceType.UNKNOWN;
        }
        return deviceType;
    }

    @Override
    public void onHandlePaymentCollectionEvent(@NotNull PaymentCollectionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LOGGER.i("onHandlePaymentCollectionEvent " + event, new Pair[0]);
        PaymentCollectionEvent paymentCollectionEvent = event;
        if (paymentCollectionEvent instanceof UserInteractionEvent) {
            this.handleUserInteractionEvent((UserInteractionEvent)event);
        } else if (paymentCollectionEvent instanceof HardwareEvent) {
            this.handleHardwareEvent((HardwareEvent)event);
        } else if (paymentCollectionEvent instanceof AutomationEvent) {
            this.handleAutomationEvent((AutomationEvent)event);
        } else if (paymentCollectionEvent instanceof HardwareListenerEvent) {
            this.handleHardwareListenerEvent((HardwareListenerEvent)event);
        } else if (paymentCollectionEvent instanceof NetworkEvent) {
            this.handleNetworkEvent((NetworkEvent)event);
        }
    }

    private final void handleNetworkEvent(NetworkEvent event) {
        NetworkEvent networkEvent = event;
        if (networkEvent instanceof OnlineAuthorizationRequestEvent) {
            this.sendEmvResult(((OnlineAuthorizationRequestEvent)event).getInterfaceType(), ((OnlineAuthorizationRequestEvent)event).getTlv(), ((OnlineAuthorizationRequestEvent)event).getTipResult());
        } else if (networkEvent instanceof MagStripeAuthorizationRequestEvent) {
            this.sendMsrResult(((MagStripeAuthorizationRequestEvent)event).getReadResult(), ((MagStripeAuthorizationRequestEvent)event).getCollectionAuthority(), ((MagStripeAuthorizationRequestEvent)event).getTipResult());
        } else if (networkEvent instanceof SecondGenACResponseEvent) {
            this.sendSecondGenACResponse(((SecondGenACResponseEvent)event).getResponse());
        } else if (networkEvent instanceof ManualEntryAuthorizationRequestEvent) {
            this.sendManualEntryResult(((ManualEntryAuthorizationRequestEvent)event).getData(), ((ManualEntryAuthorizationRequestEvent)event).getTipResult());
        }
    }

    private final void sendManualEntryResult(ManualEntryResultModel data, TippingState.EndState tipResult) {
        block0: {
            CompletableDeferred<PaymentCollectionResult> completableDeferred = this.paymentCollectionContext;
            if (completableDeferred == null || (completableDeferred = completableDeferred.getCollectionResult()) == null) break block0;
            completableDeferred.complete((Object)new ManualEntryResult(data, tipResult));
        }
    }

    private final void sendSecondGenACResponse(SecondGenACResponse response) {
        CompletableDeferred<TransactionResult> completableDeferred = this.paymentCollectionContext;
        if (completableDeferred != null && (completableDeferred = completableDeferred.getSecondGenACResult()) != null) {
            boolean bl;
            CompletableDeferred<TransactionResult> callback2 = completableDeferred;
            boolean bl2 = false;
            SecondGenACResponse secondGenACResponse = response;
            if (secondGenACResponse instanceof EmvSecondGenACResponse) {
                TransactionResult.Result result2 = ((EmvSecondGenACResponse)response).isApproved() ? TransactionResult.Result.APPROVED : TransactionResult.Result.DECLINED;
                bl = callback2.complete((Object)new TransactionResult(result2, ((EmvSecondGenACResponse)response).getTlv()));
            } else if (secondGenACResponse instanceof MagStripeSecondGenACResponse) {
                bl = callback2.complete((Object)new TransactionResult(TransactionResult.Result.APPROVED, null));
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void sendEmvResult(InterfaceType interfaceType, String emvBlob, TippingState.EndState tipResult) {
        block0: {
            CompletableDeferred<PaymentCollectionResult> completableDeferred = this.paymentCollectionContext;
            if (completableDeferred == null || (completableDeferred = completableDeferred.getCollectionResult()) == null) break block0;
            completableDeferred.complete((Object)new EmvResult(emvBlob, interfaceType, tipResult));
        }
    }

    private final void sendMsrResult(MagStripeReadSuccess result2, MagStripePaymentCollectionAuthority collectionAuthority, TippingState.EndState tipResult) {
        block0: {
            CompletableDeferred<PaymentCollectionResult> completableDeferred = this.paymentCollectionContext;
            if (completableDeferred == null || (completableDeferred = completableDeferred.getCollectionResult()) == null) break block0;
            completableDeferred.complete((Object)new MsrResult(result2, collectionAuthority, tipResult));
        }
    }

    private final void sendCancelResult() {
        block0: {
            CompletableDeferred<PaymentCollectionResult> completableDeferred = this.paymentCollectionContext;
            if (completableDeferred == null || (completableDeferred = completableDeferred.getCollectionResult()) == null) break block0;
            completableDeferred.complete((Object)Cancelled.INSTANCE);
        }
    }

    private final void sendTimeoutResult() {
        block0: {
            CompletableDeferred<PaymentCollectionResult> completableDeferred = this.paymentCollectionContext;
            if (completableDeferred == null || (completableDeferred = completableDeferred.getCollectionResult()) == null) break block0;
            completableDeferred.complete((Object)Timeout.INSTANCE);
        }
    }

    private final Job handleAutomationEvent(AutomationEvent automationEvent) {
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, automationEvent, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            final /* synthetic */ AutomationEvent $automationEvent;
            {
                this.this$0 = $receiver;
                this.$automationEvent = $automationEvent;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PaymentCollectionContext paymentCollectionContext = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        if (paymentCollectionContext != null) {
                            PaymentCollectionContext paymentCollectionContext2 = paymentCollectionContext;
                            AutomationEvent automationEvent = this.$automationEvent;
                            PaymentCollectionCoordinator paymentCollectionCoordinator = this.this$0;
                            PaymentCollectionContext it = paymentCollectionContext2;
                            boolean bl = false;
                            AutomationEvent automationEvent2 = automationEvent;
                            if (automationEvent2 instanceof AutoSelectApplicationEvent) {
                                it.getPaymentCollectionStateMachine().setSelectedApplicationIndex(((AutoSelectApplicationEvent)automationEvent).getIndex());
                            } else if (automationEvent2 instanceof AutoSelectLanguageEvent) {
                                List<String> preferredLanguages = ((AutoSelectLanguageEvent)automationEvent).getOptions();
                                List supportedPreferredLanguages = CollectionsKt.toList((Iterable)CollectionsKt.intersect((Iterable)preferredLanguages, (Iterable)PaymentCollectionCoordinator.access$getSupportedLanguages$p(paymentCollectionCoordinator)));
                                String string = (String)CollectionsKt.firstOrNull((List)supportedPreferredLanguages);
                                if (string == null) {
                                    string = (String)CollectionsKt.first(preferredLanguages);
                                }
                                String language = string;
                                it.getPaymentCollectionStateMachine().setSelectedLanguage(language);
                            } else if (automationEvent2 instanceof ClearMagStripeStateEvent) {
                                it.getPaymentCollectionStateMachine().clearMagStripeReadState();
                            } else if (automationEvent2 instanceof AcknowledgeInterfaceResetEvent) {
                                it.getPaymentCollectionStateMachine().setInterfaceResetRequired(false);
                            } else if (automationEvent2 instanceof ManualEntryCollectionResultEvent) {
                                it.getPaymentCollectionStateMachine().setManualEntryCollectionResult(((ManualEntryCollectionResultEvent)automationEvent).getResult());
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Job handleHardwareEvent(HardwareEvent hardwareEvent) {
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, hardwareEvent, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            final /* synthetic */ HardwareEvent $hardwareEvent;
            {
                this.this$0 = $receiver;
                this.$hardwareEvent = $hardwareEvent;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                block27: {
                    HardwareEvent hardwareEvent;
                    HardwareEvent hardwareEvent2;
                    PaymentCollectionCoordinator paymentCollectionCoordinator;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            Object object3;
                            ResultKt.throwOnFailure((Object)object);
                            PaymentCollectionContext paymentCollectionContext = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                            if (paymentCollectionContext != null) {
                                PaymentCollectionContext paymentCollectionContext2 = paymentCollectionContext;
                                paymentCollectionCoordinator = this.this$0;
                                hardwareEvent2 = this.$hardwareEvent;
                                PaymentCollectionContext it = paymentCollectionContext2;
                                boolean bl = false;
                                PaymentCollectionCoordinator.access$getEventLoggers$p(paymentCollectionCoordinator).getStageEventLogger().onHardwareEvent(hardwareEvent2, (PaymentCollectionData)it.getPaymentCollectionStateMachine().getData());
                                hardwareEvent = hardwareEvent2;
                                if (!(hardwareEvent instanceof ConfigureReaderEvent)) break;
                                this.label = 1;
                                object3 = PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).startReader(((ConfigureReaderEvent)hardwareEvent2).getConfiguration(), (Continuation<? super Unit>)this);
                                if (object3 == object2) {
                                    return object2;
                                }
                            }
                            break block27;
                        }
                        case 1: {
                            void $result;
                            boolean bl = false;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            break block27;
                        }
                    }
                    if (hardwareEvent instanceof SelectApplicationEvent) {
                        PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).selectApplication(((SelectApplicationEvent)hardwareEvent2).getIndex());
                    } else if (hardwareEvent instanceof SelectLanguageEvent) {
                        PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).selectLanguage(((SelectLanguageEvent)hardwareEvent2).getLanguage());
                    } else if (hardwareEvent instanceof SelectAccountTypeEvent) {
                        PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).selectAccountType(((SelectAccountTypeEvent)hardwareEvent2).getAccountType());
                    } else if (hardwareEvent instanceof StartPinEntryEvent) {
                        PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).setPinEntryButtons();
                    } else if (hardwareEvent instanceof StartPollingForCardStatusEvent) {
                        PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).checkCardUntilRemoved(((StartPollingForCardStatusEvent)hardwareEvent2).getReaderType());
                    } else if (hardwareEvent instanceof AuthorizePaymentEvent) {
                        PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).handleAuthorisationResponseData(((AuthorizePaymentEvent)hardwareEvent2).getTlv());
                    } else if (hardwareEvent instanceof SendFinalConfirmEvent) {
                        PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).handleFinalConfirmationRequest(((SendFinalConfirmEvent)hardwareEvent2).getConfirm());
                    } else if (hardwareEvent instanceof HardwareTippingCollectionEvent) {
                        PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).collectTipAmount(((HardwareTippingCollectionEvent)hardwareEvent2).getConfig());
                    } else if (hardwareEvent instanceof CancelHardwareTippingCollectionEvent) {
                        PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).cancelCollectTipAmount();
                    } else if (hardwareEvent instanceof StopReaderEvent) {
                        PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).stopReader(((StopReaderEvent)hardwareEvent2).getPhase());
                    } else if (Intrinsics.areEqual((Object)hardwareEvent, (Object)RequestPinEntryEvent.INSTANCE)) {
                        PaymentCollectionCoordinator.access$getPaymentCollector$p(paymentCollectionCoordinator).startPinEntry();
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Job handleHardwareListenerEvent(HardwareListenerEvent hardwareListenerEvent) {
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, hardwareListenerEvent, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            final /* synthetic */ HardwareListenerEvent $hardwareListenerEvent;
            {
                this.this$0 = $receiver;
                this.$hardwareListenerEvent = $hardwareListenerEvent;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PaymentCollectionContext paymentCollectionContext = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        if (paymentCollectionContext != null) {
                            PaymentCollectionContext paymentCollectionContext2 = paymentCollectionContext;
                            PaymentCollectionCoordinator paymentCollectionCoordinator = this.this$0;
                            HardwareListenerEvent hardwareListenerEvent = this.$hardwareListenerEvent;
                            PaymentCollectionContext it = paymentCollectionContext2;
                            boolean bl = false;
                            PaymentCollectionCoordinator.access$getEventLoggers$p(paymentCollectionCoordinator).getStageEventLogger().onHardwareListenerEvent(hardwareListenerEvent, (PaymentCollectionData)it.getPaymentCollectionStateMachine().getData());
                            HardwareListenerEvent hardwareListenerEvent2 = hardwareListenerEvent;
                            if (hardwareListenerEvent2 instanceof ResetPaymentInterfacesEvent) {
                                it.getPaymentCollectionStateMachine().setInterfaceResetRequired(true);
                            } else if (hardwareListenerEvent2 instanceof ChipCardInitializationFailed) {
                                it.getPaymentCollectionStateMachine().setEarlyTransactionAbortReason(EarlyTransactionAbortReason.CHIP_CARD_INITIALIZATION_FAILED);
                            } else if (hardwareListenerEvent2 instanceof EmptyCandidateListEncounteredEvent) {
                                it.getPaymentCollectionStateMachine().setEarlyTransactionAbortReason(EarlyTransactionAbortReason.EMPTY_CANDIDATE_LIST);
                            } else if (hardwareListenerEvent2 instanceof RequestSelectApplicationEvent) {
                                it.getPaymentCollectionStateMachine().setApplicationList(((RequestSelectApplicationEvent)hardwareListenerEvent).getApplications());
                            } else if (hardwareListenerEvent2 instanceof MagStripeReadEvent) {
                                it.getPaymentCollectionStateMachine().setMagStripeReadResult(((MagStripeReadEvent)hardwareListenerEvent).getResult());
                            } else if (hardwareListenerEvent2 instanceof ContactCardUpdateEvent) {
                                it.getPaymentCollectionStateMachine().setCardSlotState(((ContactCardUpdateEvent)hardwareListenerEvent).getUpdatedCardState());
                            } else if (hardwareListenerEvent2 instanceof SetPinEntryAsteriskCountEvent) {
                                it.getPaymentCollectionStateMachine().setPinEntryAsterisks(((SetPinEntryAsteriskCountEvent)hardwareListenerEvent).getCount());
                            } else if (hardwareListenerEvent2 instanceof PinEntryStatusChangeEvent) {
                                it.getPaymentCollectionStateMachine().onPinEntryStatusChange(((PinEntryStatusChangeEvent)hardwareListenerEvent).getStatus(), ((PinEntryStatusChangeEvent)hardwareListenerEvent).getEpb(), ((PinEntryStatusChangeEvent)hardwareListenerEvent).getEpbKsn());
                            } else if (hardwareListenerEvent2 instanceof RequestOnlineAuthorisationEvent) {
                                it.getPaymentCollectionStateMachine().setOnlineAuthorizationData(((RequestOnlineAuthorisationEvent)hardwareListenerEvent).getAuthorizationData());
                            } else if (hardwareListenerEvent2 instanceof ReaderFinalConfirmationTlvCollectedEvent) {
                                it.getPaymentCollectionStateMachine().setFinalConfirmation(((ReaderFinalConfirmationTlvCollectedEvent)hardwareListenerEvent).getTlv());
                            } else if (hardwareListenerEvent2 instanceof TransactionCompletedEvent) {
                                it.getPaymentCollectionStateMachine().setHardwareTransactionResult(((TransactionCompletedEvent)hardwareListenerEvent).getResult());
                            } else if (hardwareListenerEvent2 instanceof IntermediateErrorEvent) {
                                it.getPaymentCollectionStateMachine().setIntermediateError(((IntermediateErrorEvent)hardwareListenerEvent).getError());
                            } else if (hardwareListenerEvent2 instanceof ReaderTypeChangedEvent) {
                                it.getPaymentCollectionStateMachine().setActiveReaderInterfaces(((ReaderTypeChangedEvent)hardwareListenerEvent).getTypes());
                            } else if (Intrinsics.areEqual((Object)hardwareListenerEvent2, (Object)ShowThankYouEvent.INSTANCE)) {
                                it.getPaymentCollectionStateMachine().setShowThankYouReceived(true);
                            } else if (Intrinsics.areEqual((Object)hardwareListenerEvent2, (Object)WaitForCardPresentEvent.INSTANCE)) {
                                PaymentCollectionCoordinator.access$getEventLoggers$p(paymentCollectionCoordinator).getStageEventLogger().openWaitForCardPresentLog();
                            } else if (Intrinsics.areEqual((Object)hardwareListenerEvent2, (Object)RequestSelectAccountEvent.INSTANCE)) {
                                PaymentCollectionCoordinator.access$getLOGGER$cp().i("onRequestSelectAccountType", new Pair[0]);
                                it.getPaymentCollectionStateMachine().onRequestAccountTypeSelection();
                            } else if (Intrinsics.areEqual((Object)hardwareListenerEvent2, (Object)ReadingCardEvent.INSTANCE)) {
                                it.getPaymentCollectionStateMachine().onDeviceKernelBusy();
                            } else if (!(hardwareListenerEvent2 instanceof SetPinPadResultEvent)) {
                                if (hardwareListenerEvent2 instanceof HardwareTippingCollectionResultEvent) {
                                    it.getPaymentCollectionStateMachine().setHardwareTippingSelectionResult(((HardwareTippingCollectionResultEvent)hardwareListenerEvent).getTipSelectionResult());
                                } else if (hardwareListenerEvent2 instanceof HardwareTransactionCancelledEvent) {
                                    it.getPaymentCollectionStateMachine().onHardwareTransactionCanceled();
                                }
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Job handleUserInteractionEvent(UserInteractionEvent userInteractionEvent) {
        return BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, userInteractionEvent, null){
            int label;
            final /* synthetic */ PaymentCollectionCoordinator this$0;
            final /* synthetic */ UserInteractionEvent $userInteractionEvent;
            {
                this.this$0 = $receiver;
                this.$userInteractionEvent = $userInteractionEvent;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        PaymentCollectionContext paymentCollectionContext = PaymentCollectionCoordinator.access$getPaymentCollectionContext$p(this.this$0);
                        if (paymentCollectionContext != null) {
                            PaymentCollectionContext paymentCollectionContext2 = paymentCollectionContext;
                            UserInteractionEvent userInteractionEvent = this.$userInteractionEvent;
                            PaymentCollectionCoordinator paymentCollectionCoordinator = this.this$0;
                            PaymentCollectionContext context = paymentCollectionContext2;
                            boolean bl = false;
                            UserInteractionEvent userInteractionEvent2 = userInteractionEvent;
                            if (userInteractionEvent2 instanceof TippingSelectionEvent) {
                                context.getPaymentCollectionListener().onRequestTippingSelection(((TippingSelectionEvent)userInteractionEvent).getModel(), (Function1<? super Disposition<TippingSelectionResult>, Unit>)((Function1)new Function1<Disposition<TippingSelectionResult>, Unit>(context, paymentCollectionCoordinator){
                                    final /* synthetic */ PaymentCollectionContext $context;
                                    final /* synthetic */ PaymentCollectionCoordinator this$0;
                                    {
                                        this.$context = $context;
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Disposition<TippingSelectionResult> it) {
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        Disposition<TippingSelectionResult> disposition = it;
                                        if (disposition instanceof Disposition.Completed) {
                                            this.$context.getPaymentCollectionStateMachine().setTippingSelectionResult((TippingSelectionResult)((Disposition.Completed)it).getResult());
                                        } else if (disposition instanceof Disposition.Canceled) {
                                            if (((Disposition.Canceled)it).getReason() == Disposition.Canceled.Reason.RESET) {
                                                this.$context.getPaymentCollectionStateMachine().resetTipSelection();
                                            } else {
                                                this.this$0.cancelPaymentMethodCollection();
                                            }
                                        }
                                    }
                                }));
                            } else if (userInteractionEvent2 instanceof ManualEntryEvent) {
                                context.getPaymentCollectionListener().onRequestManualEntry(((ManualEntryEvent)userInteractionEvent).getModel(), (Function1<? super Disposition<com.stripe.core.hardware.paymentcollection.ManualEntryResult>, Unit>)((Function1)new Function1<Disposition<com.stripe.core.hardware.paymentcollection.ManualEntryResult>, Unit>(context, paymentCollectionCoordinator){
                                    final /* synthetic */ PaymentCollectionContext $context;
                                    final /* synthetic */ PaymentCollectionCoordinator this$0;
                                    {
                                        this.$context = $context;
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Disposition<com.stripe.core.hardware.paymentcollection.ManualEntryResult> it) {
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        Disposition<com.stripe.core.hardware.paymentcollection.ManualEntryResult> disposition = it;
                                        if (disposition instanceof Disposition.Completed) {
                                            this.$context.getPaymentCollectionStateMachine().setManualEntryResult((com.stripe.core.hardware.paymentcollection.ManualEntryResult)((Disposition.Completed)it).getResult());
                                        } else if (disposition instanceof Disposition.Canceled) {
                                            this.this$0.cancelPaymentMethodCollection();
                                        }
                                    }
                                }));
                            } else if (userInteractionEvent2 instanceof PresentPaymentMethodEvent) {
                                context.getPaymentCollectionListener().onRequestPaymentMethodCollection(((PresentPaymentMethodEvent)userInteractionEvent).getModel(), (Function1<? super Disposition<Unit>, Unit>)((Function1)new Function1<Disposition<Unit>, Unit>(paymentCollectionCoordinator){
                                    final /* synthetic */ PaymentCollectionCoordinator this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Disposition<Unit> it) {
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        this.this$0.cancelPaymentMethodCollection();
                                    }
                                }));
                            } else if (userInteractionEvent2 instanceof DisplayRecoverableErrorEvent) {
                                context.getPaymentCollectionListener().onRequestDisplayRecoverableError(((DisplayRecoverableErrorEvent)userInteractionEvent).getModel(), (Function1<? super Disposition<Unit>, Unit>)((Function1)new Function1<Disposition<Unit>, Unit>(context, paymentCollectionCoordinator){
                                    final /* synthetic */ PaymentCollectionContext $context;
                                    final /* synthetic */ PaymentCollectionCoordinator this$0;
                                    {
                                        this.$context = $context;
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Disposition<Unit> it) {
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        Disposition<Unit> disposition = it;
                                        if (disposition instanceof Disposition.Completed) {
                                            this.$context.getPaymentCollectionStateMachine().setUserRetryRequested();
                                        } else if (disposition instanceof Disposition.Canceled) {
                                            this.this$0.cancelPaymentMethodCollection();
                                        }
                                    }
                                }));
                            } else if (userInteractionEvent2 instanceof PresentRemoveCardEvent) {
                                context.getPaymentCollectionListener().onRequestCardRemoval(((PresentRemoveCardEvent)userInteractionEvent).getModel(), (Function1<? super Disposition<Unit>, Unit>)((Function1)new Function1<Disposition<Unit>, Unit>(paymentCollectionCoordinator){
                                    final /* synthetic */ PaymentCollectionCoordinator this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Disposition<Unit> it) {
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        this.this$0.cancelPaymentMethodCollection();
                                    }
                                }));
                            } else if (userInteractionEvent2 instanceof CollectionCompleteEvent) {
                                PaymentCollectionCoordinator.access$handleCollectionCompletion(paymentCollectionCoordinator, (CollectionCompleteEvent)userInteractionEvent);
                            } else if (userInteractionEvent2 instanceof PresentApplicationSelectionEvent) {
                                context.getPaymentCollectionListener().onRequestApplicationSelection(((PresentApplicationSelectionEvent)userInteractionEvent).getModel(), (Function1<? super Disposition<Integer>, Unit>)((Function1)new Function1<Disposition<Integer>, Unit>(context, paymentCollectionCoordinator){
                                    final /* synthetic */ PaymentCollectionContext $context;
                                    final /* synthetic */ PaymentCollectionCoordinator this$0;
                                    {
                                        this.$context = $context;
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Disposition<Integer> it) {
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        Disposition<Integer> disposition = it;
                                        if (disposition instanceof Disposition.Completed) {
                                            this.$context.getPaymentCollectionStateMachine().setSelectedApplicationIndex(((Number)((Disposition.Completed)it).getResult()).intValue());
                                        } else if (disposition instanceof Disposition.Canceled) {
                                            this.this$0.cancelPaymentMethodCollection();
                                        }
                                    }
                                }));
                            } else if (userInteractionEvent2 instanceof PresentAccountTypeSelectionEvent) {
                                context.getPaymentCollectionListener().onRequestAccountTypeSelection(((PresentAccountTypeSelectionEvent)userInteractionEvent).getModel(), (Function1<? super Disposition<AccountType>, Unit>)((Function1)new Function1<Disposition<AccountType>, Unit>(paymentCollectionCoordinator){
                                    final /* synthetic */ PaymentCollectionCoordinator this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Disposition<AccountType> it) {
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        Disposition<AccountType> disposition = it;
                                        if (disposition instanceof Disposition.Completed) {
                                            this.this$0.setSelectedAccountType((AccountType)((Object)((Disposition.Completed)it).getResult()));
                                        } else if (disposition instanceof Disposition.Canceled) {
                                            this.this$0.cancelPaymentMethodCollection();
                                        }
                                    }
                                }));
                            } else if (userInteractionEvent2 instanceof PresentPinEntryEvent) {
                                context.getPaymentCollectionListener().onRequestPinEntry(((PresentPinEntryEvent)userInteractionEvent).getModel(), (Function1<? super Disposition<Unit>, Unit>)((Function1)new Function1<Disposition<Unit>, Unit>(paymentCollectionCoordinator){
                                    final /* synthetic */ PaymentCollectionCoordinator this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Disposition<Unit> it) {
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        Disposition<Unit> disposition = it;
                                        if (!(disposition instanceof Disposition.Completed) && disposition instanceof Disposition.Canceled) {
                                            this.this$0.cancelPaymentMethodCollection();
                                        }
                                    }
                                }));
                            } else if (userInteractionEvent2 instanceof PresentProcessingEvent) {
                                context.getPaymentCollectionListener().onProcessing();
                            } else if (userInteractionEvent2 instanceof CardStateUpdateEvent) {
                                context.getPaymentCollectionListener().onCardStateUpdate(((CardStateUpdateEvent)userInteractionEvent).getCardState());
                            } else if (userInteractionEvent2 instanceof CollectionCancelledEvent) {
                                context.getPaymentCollectionListener().onCancelled();
                                PaymentCollectionCoordinator.access$sendCancelResult(paymentCollectionCoordinator);
                            } else if (userInteractionEvent2 instanceof DisplayCartEvent) {
                                context.getPaymentCollectionListener().onRequestDisplayCart(((DisplayCartEvent)userInteractionEvent).getModel(), (Function1<? super Disposition<Unit>, Unit>)((Function1)new Function1<Disposition<Unit>, Unit>(paymentCollectionCoordinator){
                                    final /* synthetic */ PaymentCollectionCoordinator this$0;
                                    {
                                        this.this$0 = $receiver;
                                        super(1);
                                    }

                                    public final void invoke(@NotNull Disposition<Unit> it) {
                                        Intrinsics.checkNotNullParameter(it, (String)"it");
                                        this.this$0.cancelPaymentMethodCollection();
                                    }
                                }));
                            } else if (userInteractionEvent2 instanceof TimeoutEvent) {
                                PaymentCollectionCoordinator.access$sendTimeoutResult(paymentCollectionCoordinator);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @VisibleForTesting
    public final void setSelectedAccountType(@NotNull AccountType accountType) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)accountType), (String)"accountType");
            Object object = this.paymentCollectionContext;
            if (object == null || (object = ((PaymentCollectionContext)object).getPaymentCollectionStateMachine()) == null) break block0;
            ((PaymentCollectionStateMachine)object).setSelectedAccountType(accountType);
        }
    }

    private final void handleCollectionCompletion(CollectionCompleteEvent event) {
        block3: {
            PaymentCollectionContext paymentCollectionContext = this.paymentCollectionContext;
            if (paymentCollectionContext == null) break block3;
            PaymentCollectionContext it = paymentCollectionContext;
            boolean bl = false;
            it.getPaymentCollectionListener().onCollectionComplete(event.getModel());
            CompletableDeferred<PaymentCollectionResult> pendingResult = it.getCollectionResult();
            boolean bl2 = false;
            if (pendingResult.isActive()) {
                pendingResult.complete((Object)Failed.INSTANCE);
            }
            CompletableDeferred<TransactionResult> completableDeferred = it.getSecondGenACResult();
            if (completableDeferred != null) {
                CompletableDeferred<TransactionResult> pendingResult2 = completableDeferred;
                boolean bl3 = false;
                if (pendingResult2.isActive()) {
                    pendingResult2.complete((Object)new TransactionResult(TransactionResult.Result.TERMINATED, null));
                }
            }
            this.paymentCollectionContext = null;
        }
    }

    @Override
    public void onResetPaymentInterfaces() {
        this.onHandlePaymentCollectionEvent(ResetPaymentInterfacesEvent.INSTANCE);
    }

    @Override
    public void onChipCardInitializationFailed() {
        this.onHandlePaymentCollectionEvent(ChipCardInitializationFailed.INSTANCE);
    }

    @Override
    public void onCardSwiped(@NotNull MagStripeReadResult readResult) {
        Intrinsics.checkNotNullParameter((Object)readResult, (String)"readResult");
        this.onHandlePaymentCollectionEvent(new MagStripeReadEvent(readResult));
    }

    @Override
    public void onContactCardStateUpdate(@NotNull ContactCardSlotState slotState) {
        Intrinsics.checkNotNullParameter((Object)((Object)slotState), (String)"slotState");
        this.onHandlePaymentCollectionEvent(new ContactCardUpdateEvent(slotState));
    }

    @Override
    public void onEmptyCandidateList() {
        this.onHandlePaymentCollectionEvent(EmptyCandidateListEncounteredEvent.INSTANCE);
    }

    @Override
    public void onRequestSelectApplication(@NotNull List<String> appList) {
        Intrinsics.checkNotNullParameter(appList, (String)"appList");
        this.onHandlePaymentCollectionEvent(new RequestSelectApplicationEvent(appList));
    }

    @Override
    public void onRequestSelectAccountType() {
        this.onHandlePaymentCollectionEvent(RequestSelectAccountEvent.INSTANCE);
    }

    @Override
    public void onPinEntryStatusChange(@NotNull PinEntryStatus pinEntryStatus, @Nullable String epb, @Nullable String epbKsn) {
        Intrinsics.checkNotNullParameter((Object)((Object)pinEntryStatus), (String)"pinEntryStatus");
        LOGGER.i("onPinEntryStatusChange " + (Object)((Object)pinEntryStatus), new Pair[0]);
        this.onHandlePaymentCollectionEvent(new PinEntryStatusChangeEvent(pinEntryStatus, epb, epbKsn));
    }

    @Override
    public void onUpdatePinEntryAsteriskCount(int count) {
        this.onHandlePaymentCollectionEvent(new SetPinEntryAsteriskCountEvent(count));
    }

    @Override
    public void onRequestFinalConfirm() {
        boolean confirm;
        Object object = this.paymentCollectionContext;
        boolean bl = confirm = !(object != null && (object = ((PaymentCollectionContext)object).getPaymentCollectionStateMachine()) != null && (object = (PaymentCollectionData)((StateMachine)object).getData()) != null ? ((PaymentCollectionData)object).isCancelled() : false);
        if (!confirm) {
            LOGGER.d("sending final confirm false since payment was cancelled", new Pair[0]);
        }
        this.onHandlePaymentCollectionEvent(new SendFinalConfirmEvent(confirm));
    }

    @Override
    public void onRequestOnlineAuthorisation(@NotNull String authorisationData) {
        Intrinsics.checkNotNullParameter((Object)authorisationData, (String)"authorisationData");
        String accountBlob = this.getAccountBlob();
        String authBlob = authorisationData + accountBlob;
        this.onHandlePaymentCollectionEvent(new RequestOnlineAuthorisationEvent(authBlob));
    }

    @Override
    public void onIntermediateTransactionError(@NotNull IntermediateTransactionError error) {
        Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
        this.onHandlePaymentCollectionEvent(new IntermediateErrorEvent(error));
    }

    @Override
    public void onReturnTransactionResult(@NotNull TransactionResult.Result transactionResult2) {
        Intrinsics.checkNotNullParameter((Object)((Object)transactionResult2), (String)"transactionResult");
        this.onHandlePaymentCollectionEvent(new TransactionCompletedEvent(transactionResult2));
    }

    @Override
    public void onReturnFinalTlvBlob(@NotNull String tlv) {
        Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
        String accountBlob = this.getAccountBlob();
        String finalTlvBlob = tlv + accountBlob;
        this.onHandlePaymentCollectionEvent(new ReaderFinalConfirmationTlvCollectedEvent(finalTlvBlob));
    }

    @Override
    public void onReaderTypesChanged(@NotNull EnumSet<ReaderConfiguration.ReaderType> readerTypes) {
        Intrinsics.checkNotNullParameter(readerTypes, (String)"readerTypes");
        this.onHandlePaymentCollectionEvent(new ReaderTypeChangedEvent(readerTypes));
    }

    @Override
    public void waitForCardPresent() {
        this.onHandlePaymentCollectionEvent(WaitForCardPresentEvent.INSTANCE);
    }

    @Override
    public void onReadingCard() {
        this.onHandlePaymentCollectionEvent(ReadingCardEvent.INSTANCE);
    }

    @Override
    public void onSetPinPadButtonsResult(boolean isSuccess) {
        this.onHandlePaymentCollectionEvent(new SetPinPadResultEvent(isSuccess));
    }

    @Override
    public void onKernelTippingSelectionResult(@NotNull TipSelectionResult tipSelectionResult) {
        Intrinsics.checkNotNullParameter((Object)tipSelectionResult, (String)"tipSelectionResult");
        this.onHandlePaymentCollectionEvent(new HardwareTippingCollectionResultEvent(tipSelectionResult));
    }

    @Override
    public void onRequestProduceAudioTone(@NotNull AudioAlertType audioAlertType) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)audioAlertType), (String)"audioAlertType");
            Object object = this.paymentCollectionContext;
            if (object == null || (object = ((PaymentCollectionContext)object).getPaymentCollectionListener()) == null) break block0;
            object.onRequestProduceAudioTone(audioAlertType);
        }
    }

    @Override
    public void onHardwareTransactionCanceled() {
        this.onHandlePaymentCollectionEvent(HardwareTransactionCancelledEvent.INSTANCE);
    }

    @Override
    public void onDisplayAdditionalMessage(@NotNull ReaderDisplayMessage message) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)message), (String)"message");
            Object object = this.paymentCollectionContext;
            if (object == null || (object = ((PaymentCollectionContext)object).getPaymentCollectionListener()) == null) break block0;
            object.onAdditionalReaderDisplayMessage(message);
        }
    }

    @Override
    public void onShowThankYou() {
        this.onHandlePaymentCollectionEvent(ShowThankYouEvent.INSTANCE);
    }

    private final String getAccountBlob() {
        String string;
        AccountType accountType;
        PaymentCollectionData paymentCollectionData;
        PaymentCollectionStateMachine paymentCollectionStateMachine;
        PaymentCollectionContext paymentCollectionContext = this.paymentCollectionContext;
        return paymentCollectionContext != null && (paymentCollectionStateMachine = paymentCollectionContext.getPaymentCollectionStateMachine()) != null && (paymentCollectionData = (PaymentCollectionData)paymentCollectionStateMachine.getData()) != null && (accountType = paymentCollectionData.getSelectedAccount()) != null && (string = accountType.toTlvBlob()) != null ? string : "";
    }

    public static final /* synthetic */ Object access$resumeExistingPaymentCollection(PaymentCollectionCoordinator $this, Amount amount, Amount tippingAmount, PaymentCollectionListener paymentCollectionListener, SCARequirement scaRequirement, Continuation $completion) {
        return $this.resumeExistingPaymentCollection(amount, tippingAmount, paymentCollectionListener, scaRequirement, (Continuation<? super CompletableDeferred<PaymentCollectionResult>>)$completion);
    }

    public static final /* synthetic */ Object access$startPaymentCollection(PaymentCollectionCoordinator $this, Amount amount, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, PaymentCollectionListener paymentCollectionListener, Amount tippingAmount, boolean skipTipping, boolean manualEntry, boolean isOffline, Amount tipEligibleAmount, boolean isDeferredAuthorizationCountry, ReaderConfiguration.DomesticDebitPriority domesticDebitPriority, boolean isApplicationSelectionInQuickChipEnabled, boolean promptPinEntryForServiceCode, boolean forceMagstripePin, Continuation $completion) {
        return $this.startPaymentCollection(amount, transactionType, paymentCollectionListener, tippingAmount, skipTipping, manualEntry, isOffline, tipEligibleAmount, isDeferredAuthorizationCountry, domesticDebitPriority, isApplicationSelectionInQuickChipEnabled, promptPinEntryForServiceCode, forceMagstripePin, (Continuation<? super CompletableDeferred<PaymentCollectionResult>>)$completion);
    }

    public static final /* synthetic */ Provider access$getApplicationSelectionInQuickChipEnabled$p(PaymentCollectionCoordinator $this) {
        return $this.applicationSelectionInQuickChipEnabled;
    }

    public static final /* synthetic */ Provider access$getEnablesMagStripePin$p(PaymentCollectionCoordinator $this) {
        return $this.enablesMagStripePin;
    }

    public static final /* synthetic */ SettingsRepository access$getSettingsRepository$p(PaymentCollectionCoordinator $this) {
        return $this.settingsRepository;
    }

    public static final /* synthetic */ PaymentCollectionContext access$getPaymentCollectionContext$p(PaymentCollectionCoordinator $this) {
        return $this.paymentCollectionContext;
    }

    public static final /* synthetic */ void access$setPaymentCollectionContext$p(PaymentCollectionCoordinator $this, PaymentCollectionContext paymentCollectionContext) {
        $this.paymentCollectionContext = paymentCollectionContext;
    }

    public static final /* synthetic */ PaymentCollectionContext.Factory access$getPaymentCollectionContextFactory$p(PaymentCollectionCoordinator $this) {
        return $this.paymentCollectionContextFactory;
    }

    public static final /* synthetic */ TipConfigValidationResult access$getTippingConfig(PaymentCollectionCoordinator $this, Amount amount, TippingState tippingState) {
        return $this.getTippingConfig(amount, tippingState);
    }

    public static final /* synthetic */ TransactionType access$getEmvTransactionType(PaymentCollectionCoordinator $this) {
        return $this.getEmvTransactionType();
    }

    public static final /* synthetic */ TransactionRepository access$getTransactionRepository$p(PaymentCollectionCoordinator $this) {
        return $this.transactionRepository;
    }

    public static final /* synthetic */ PaymentCollectionDeviceCapability access$getDeviceCapability(PaymentCollectionCoordinator $this) {
        return $this.getDeviceCapability();
    }

    public static final /* synthetic */ TippingState access$getTippingState(PaymentCollectionCoordinator $this, Amount amount, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, boolean skipTipping, boolean manualEntry, Amount tipEligibleAmount) {
        return $this.getTippingState(amount, transactionType, skipTipping, manualEntry, tipEligibleAmount);
    }

    public static final /* synthetic */ void access$disposeCurrentTransaction(PaymentCollectionCoordinator $this) {
        $this.disposeCurrentTransaction();
    }

    public static final /* synthetic */ List access$getSupportedLanguages$p(PaymentCollectionCoordinator $this) {
        return $this.supportedLanguages;
    }

    public static final /* synthetic */ EventLoggers access$getEventLoggers$p(PaymentCollectionCoordinator $this) {
        return $this.eventLoggers;
    }

    public static final /* synthetic */ PaymentCollector access$getPaymentCollector$p(PaymentCollectionCoordinator $this) {
        return $this.paymentCollector;
    }

    public static final /* synthetic */ Log access$getLOGGER$cp() {
        return LOGGER;
    }

    public static final /* synthetic */ void access$handleCollectionCompletion(PaymentCollectionCoordinator $this, CollectionCompleteEvent event) {
        $this.handleCollectionCompletion(event);
    }

    public static final /* synthetic */ void access$sendCancelResult(PaymentCollectionCoordinator $this) {
        $this.sendCancelResult();
    }

    public static final /* synthetic */ void access$sendTimeoutResult(PaymentCollectionCoordinator $this) {
        $this.sendTimeoutResult();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "paymentcollection_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001:\u0001)B-\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J1\u0010!\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u00052\b\b\u0003\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator$PaymentCollectionContext;", "", "paymentCollectionListener", "Lcom/stripe/core/paymentcollection/PaymentCollectionListener;", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "transactionType", "Lcom/stripe/core/hardware/paymentcollection/TransactionType;", "paymentCollectionStateMachine", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateMachine;", "(Lcom/stripe/core/paymentcollection/PaymentCollectionListener;Lcom/stripe/jvmcore/currency/Amount;Lcom/stripe/core/hardware/paymentcollection/TransactionType;Lcom/stripe/core/paymentcollection/PaymentCollectionStateMachine;)V", "getAmount", "()Lcom/stripe/jvmcore/currency/Amount;", "collectionResult", "Lkotlinx/coroutines/CompletableDeferred;", "Lcom/stripe/core/paymentcollection/PaymentCollectionResult;", "getCollectionResult", "()Lkotlinx/coroutines/CompletableDeferred;", "getPaymentCollectionListener", "()Lcom/stripe/core/paymentcollection/PaymentCollectionListener;", "getPaymentCollectionStateMachine", "()Lcom/stripe/core/paymentcollection/PaymentCollectionStateMachine;", "secondGenACResult", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "getSecondGenACResult", "setSecondGenACResult", "(Lkotlinx/coroutines/CompletableDeferred;)V", "getTransactionType", "()Lcom/stripe/core/hardware/paymentcollection/TransactionType;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Factory", "paymentcollection_release"})
    public static final class PaymentCollectionContext {
        @NotNull
        private final PaymentCollectionListener paymentCollectionListener;
        @NotNull
        private final Amount amount;
        @NotNull
        private final com.stripe.core.hardware.paymentcollection.TransactionType transactionType;
        @NotNull
        private final PaymentCollectionStateMachine paymentCollectionStateMachine;
        @NotNull
        private final CompletableDeferred<PaymentCollectionResult> collectionResult;
        @Nullable
        private CompletableDeferred<TransactionResult> secondGenACResult;

        @AssistedInject
        public PaymentCollectionContext(@Assisted @NotNull PaymentCollectionListener paymentCollectionListener, @Assisted @NotNull Amount amount, @Assisted @NotNull com.stripe.core.hardware.paymentcollection.TransactionType transactionType, @NotNull PaymentCollectionStateMachine paymentCollectionStateMachine) {
            Intrinsics.checkNotNullParameter((Object)paymentCollectionListener, (String)"paymentCollectionListener");
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)"transactionType");
            Intrinsics.checkNotNullParameter((Object)paymentCollectionStateMachine, (String)"paymentCollectionStateMachine");
            this.paymentCollectionListener = paymentCollectionListener;
            this.amount = amount;
            this.transactionType = transactionType;
            this.paymentCollectionStateMachine = paymentCollectionStateMachine;
            this.collectionResult = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        }

        @NotNull
        public final PaymentCollectionListener getPaymentCollectionListener() {
            return this.paymentCollectionListener;
        }

        @NotNull
        public final Amount getAmount() {
            return this.amount;
        }

        @NotNull
        public final com.stripe.core.hardware.paymentcollection.TransactionType getTransactionType() {
            return this.transactionType;
        }

        @NotNull
        public final PaymentCollectionStateMachine getPaymentCollectionStateMachine() {
            return this.paymentCollectionStateMachine;
        }

        @NotNull
        public final CompletableDeferred<PaymentCollectionResult> getCollectionResult() {
            return this.collectionResult;
        }

        @Nullable
        public final CompletableDeferred<TransactionResult> getSecondGenACResult() {
            return this.secondGenACResult;
        }

        public final void setSecondGenACResult(@Nullable CompletableDeferred<TransactionResult> completableDeferred) {
            this.secondGenACResult = completableDeferred;
        }

        @NotNull
        public final PaymentCollectionListener component1() {
            return this.paymentCollectionListener;
        }

        @NotNull
        public final Amount component2() {
            return this.amount;
        }

        @NotNull
        public final com.stripe.core.hardware.paymentcollection.TransactionType component3() {
            return this.transactionType;
        }

        @NotNull
        public final PaymentCollectionStateMachine component4() {
            return this.paymentCollectionStateMachine;
        }

        @NotNull
        public final PaymentCollectionContext copy(@Assisted @NotNull PaymentCollectionListener paymentCollectionListener, @Assisted @NotNull Amount amount, @Assisted @NotNull com.stripe.core.hardware.paymentcollection.TransactionType transactionType, @NotNull PaymentCollectionStateMachine paymentCollectionStateMachine) {
            Intrinsics.checkNotNullParameter((Object)paymentCollectionListener, (String)"paymentCollectionListener");
            Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
            Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)"transactionType");
            Intrinsics.checkNotNullParameter((Object)paymentCollectionStateMachine, (String)"paymentCollectionStateMachine");
            return new PaymentCollectionContext(paymentCollectionListener, amount, transactionType, paymentCollectionStateMachine);
        }

        public static /* synthetic */ PaymentCollectionContext copy$default(PaymentCollectionContext paymentCollectionContext, PaymentCollectionListener paymentCollectionListener, Amount amount, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, PaymentCollectionStateMachine paymentCollectionStateMachine, int n2, Object object) {
            if ((n2 & 1) != 0) {
                paymentCollectionListener = paymentCollectionContext.paymentCollectionListener;
            }
            if ((n2 & 2) != 0) {
                amount = paymentCollectionContext.amount;
            }
            if ((n2 & 4) != 0) {
                transactionType = paymentCollectionContext.transactionType;
            }
            if ((n2 & 8) != 0) {
                paymentCollectionStateMachine = paymentCollectionContext.paymentCollectionStateMachine;
            }
            return paymentCollectionContext.copy(paymentCollectionListener, amount, transactionType, paymentCollectionStateMachine);
        }

        @NotNull
        public String toString() {
            return "PaymentCollectionContext(paymentCollectionListener=" + this.paymentCollectionListener + ", amount=" + this.amount + ", transactionType=" + (Object)((Object)this.transactionType) + ", paymentCollectionStateMachine=" + this.paymentCollectionStateMachine + ')';
        }

        public int hashCode() {
            int result2 = this.paymentCollectionListener.hashCode();
            result2 = result2 * 31 + this.amount.hashCode();
            result2 = result2 * 31 + this.transactionType.hashCode();
            result2 = result2 * 31 + this.paymentCollectionStateMachine.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PaymentCollectionContext)) {
                return false;
            }
            PaymentCollectionContext paymentCollectionContext = (PaymentCollectionContext)other;
            if (!Intrinsics.areEqual((Object)this.paymentCollectionListener, (Object)paymentCollectionContext.paymentCollectionListener)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.amount, (Object)paymentCollectionContext.amount)) {
                return false;
            }
            if (this.transactionType != paymentCollectionContext.transactionType) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.paymentCollectionStateMachine, (Object)paymentCollectionContext.paymentCollectionStateMachine);
        }

        @AssistedFactory
        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bg\u0018\u00002\u00020\u0001J \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator$PaymentCollectionContext$Factory;", "", "create", "Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator$PaymentCollectionContext;", "paymentCollectionListener", "Lcom/stripe/core/paymentcollection/PaymentCollectionListener;", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "transactionType", "Lcom/stripe/core/hardware/paymentcollection/TransactionType;", "paymentcollection_release"})
        public static interface Factory {
            @NotNull
            public PaymentCollectionContext create(@NotNull PaymentCollectionListener var1, @NotNull Amount var2, @NotNull com.stripe.core.hardware.paymentcollection.TransactionType var3);
        }
    }
}

