/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import androidx.annotation.CallSuper;
import com.stripe.core.hardware.paymentcollection.DisplayCartModel;
import com.stripe.core.hardware.paymentcollection.PinEntryModel;
import com.stripe.core.hardware.paymentcollection.PinEntryRetryReason;
import com.stripe.core.hardware.paymentcollection.PinEntryStatus;
import com.stripe.core.paymentcollection.AccountSelectionStatus;
import com.stripe.core.paymentcollection.CancelReason;
import com.stripe.core.paymentcollection.CardStateUpdateEvent;
import com.stripe.core.paymentcollection.DisplayCartEvent;
import com.stripe.core.paymentcollection.HardwareTransactionCancelledEvent;
import com.stripe.core.paymentcollection.OnlineAuthorizationRequestEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionEvent;
import com.stripe.core.paymentcollection.PaymentCollectionEventDelegate;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.PresentPinEntryEvent;
import com.stripe.core.paymentcollection.StartPinEntryEvent;
import com.stripe.core.paymentcollection.StartPollingForCardStatusEvent;
import com.stripe.core.paymentcollection.StopReaderEvent;
import com.stripe.core.paymentcollection.TippingState;
import com.stripe.core.paymentcollection.metrics.DiscreteEventLogger;
import com.stripe.core.paymentcollection.metrics.EndToEndEventLogger;
import com.stripe.core.paymentcollection.metrics.EventLoggers;
import com.stripe.core.paymentcollection.metrics.OnlineAuthStateLogger;
import com.stripe.core.paymentcollection.metrics.StageEventLogger;
import com.stripe.core.paymentcollection.metrics.TippingLogger;
import com.stripe.core.statemachine.StateMachine;
import com.stripe.jvmcore.cart.Cart;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.CancellationPhase;
import com.stripe.jvmcore.hardware.emv.CheckForCardBehavior;
import com.stripe.jvmcore.hardware.emv.InterfaceType;
import com.stripe.jvmcore.hardware.emv.IntermediateTransactionError;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B!\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\b\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0004J\b\u0010*\u001a\u00020&H\u0004J\u0017\u0010+\u001a\u0004\u0018\u00010&2\u0006\u0010)\u001a\u00020\u0003H\u0004\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020&H\u0004J\u000f\u0010.\u001a\u0004\u0018\u00010&H\u0004\u00a2\u0006\u0002\u0010/J\b\u00100\u001a\u00020&H\u0004J,\u00101\u001a\u00020&2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u000109H\u0004J\u001c\u0010:\u001a\u00020&2\b\u0010;\u001a\u0004\u0018\u00010\u00032\b\u0010<\u001a\u0004\u0018\u00010\u0002H\u0017J\u0010\u0010=\u001a\u00020&2\u0006\u0010>\u001a\u00020\u0002H\u0017J\u001a\u0010?\u001a\u00020&2\u0006\u0010@\u001a\u00020\u00032\b\u0010A\u001a\u0004\u0018\u00010\u0003H\u0017J\u0010\u0010B\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010C\u001a\u00020&2\u0006\u0010@\u001a\u00020\u00032\b\u0010A\u001a\u0004\u0018\u00010\u0003J\u0010\u0010D\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0003H\u0004J\u0015\u0010E\u001a\u00020&2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bFJ\u0015\u0010G\u001a\u00020&2\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bHJ\u0010\u0010I\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0003H\u0004J\b\u0010J\u001a\u00020&H\u0002J\u0010\u0010K\u001a\u00020&2\u0006\u0010L\u001a\u00020MH\u0004R\u0014\u0010\n\u001a\u00020\u000b8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0014\u0010!\u001a\u00020\"8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006N"}, d2={"Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "Lcom/stripe/core/statemachine/StateMachine$StateHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "state", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "timeout", "", "(Lcom/stripe/core/paymentcollection/PaymentCollectionState;Lkotlinx/coroutines/CoroutineScope;Ljava/lang/Long;)V", "collectionEventLogger", "Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;", "getCollectionEventLogger", "()Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;", "discreteEventLogger", "Lcom/stripe/core/paymentcollection/metrics/DiscreteEventLogger;", "getDiscreteEventLogger", "()Lcom/stripe/core/paymentcollection/metrics/DiscreteEventLogger;", "eventDelegate", "Lcom/stripe/core/paymentcollection/PaymentCollectionEventDelegate;", "eventLoggers", "Lcom/stripe/core/paymentcollection/metrics/EventLoggers;", "job", "Lkotlinx/coroutines/Job;", "onlineAuthStateLogger", "Lcom/stripe/core/paymentcollection/metrics/OnlineAuthStateLogger;", "getOnlineAuthStateLogger", "()Lcom/stripe/core/paymentcollection/metrics/OnlineAuthStateLogger;", "stageEventLogger", "Lcom/stripe/core/paymentcollection/metrics/StageEventLogger;", "getStageEventLogger", "()Lcom/stripe/core/paymentcollection/metrics/StageEventLogger;", "Ljava/lang/Long;", "tippingLogger", "Lcom/stripe/core/paymentcollection/metrics/TippingLogger;", "getTippingLogger", "()Lcom/stripe/core/paymentcollection/metrics/TippingLogger;", "cancelTimeoutJob", "", "checkForPrematureTransactionCompletionAndTransitionIfNeeded", "", "data", "clearContactCardStateAndPrepareNextCollection", "generateDisplayCartEvent", "(Lcom/stripe/core/paymentcollection/PaymentCollectionData;)Lkotlin/Unit;", "generateStartPinEntryEvent", "generateStartPollingForCardStatusEvent", "()Lkotlin/Unit;", "generateStopReaderEvent", "generateUserInteractionEvent", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "numberOfAsterisks", "", "language", "", "pinEntryRetryReason", "Lcom/stripe/core/hardware/paymentcollection/PinEntryRetryReason;", "onEnter", "current", "from", "onExit", "to", "onPaymentCollectionDataUpdate", "new", "old", "onPaymentCollectionTimeout", "onUpdate", "sendOnlineAuthRequestEventIfNeeded", "setEventDelegate", "setEventDelegate$paymentcollection_release", "setEventLoggers", "setEventLoggers$paymentcollection_release", "startCollectionIfNeeded", "startTimeoutCountdown", "yieldEvent", "paymentCollectionEvent", "Lcom/stripe/core/paymentcollection/PaymentCollectionEvent;", "paymentcollection_release"})
public abstract class PaymentCollectionStateHandler
extends StateMachine.StateHandler<PaymentCollectionState, PaymentCollectionData> {
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private final Long timeout;
    private PaymentCollectionEventDelegate eventDelegate;
    private EventLoggers eventLoggers;
    @Nullable
    private Job job;

    public PaymentCollectionStateHandler(@NotNull PaymentCollectionState state, @NotNull CoroutineScope coroutineScope, @Nullable Long timeout) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(state);
        this.coroutineScope = coroutineScope;
        this.timeout = timeout;
    }

    public /* synthetic */ PaymentCollectionStateHandler(PaymentCollectionState paymentCollectionState, CoroutineScope coroutineScope, Long l2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            l2 = null;
        }
        this(paymentCollectionState, coroutineScope, l2);
    }

    @NotNull
    protected final EndToEndEventLogger getCollectionEventLogger() {
        EventLoggers eventLoggers = this.eventLoggers;
        if (eventLoggers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventLoggers");
            eventLoggers = null;
        }
        return eventLoggers.getEndToEndEventLogger();
    }

    @NotNull
    protected final StageEventLogger getStageEventLogger() {
        EventLoggers eventLoggers = this.eventLoggers;
        if (eventLoggers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventLoggers");
            eventLoggers = null;
        }
        return eventLoggers.getStageEventLogger();
    }

    @NotNull
    protected final TippingLogger getTippingLogger() {
        EventLoggers eventLoggers = this.eventLoggers;
        if (eventLoggers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventLoggers");
            eventLoggers = null;
        }
        return eventLoggers.getTippingLogger();
    }

    @NotNull
    protected final DiscreteEventLogger getDiscreteEventLogger() {
        EventLoggers eventLoggers = this.eventLoggers;
        if (eventLoggers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventLoggers");
            eventLoggers = null;
        }
        return eventLoggers.getDiscreteEventLogger();
    }

    @NotNull
    protected final OnlineAuthStateLogger getOnlineAuthStateLogger() {
        EventLoggers eventLoggers = this.eventLoggers;
        if (eventLoggers == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventLoggers");
            eventLoggers = null;
        }
        return eventLoggers.getOnlineAuthStateLogger();
    }

    public final void setEventDelegate$paymentcollection_release(@NotNull PaymentCollectionEventDelegate eventDelegate) {
        Intrinsics.checkNotNullParameter((Object)eventDelegate, (String)"eventDelegate");
        this.eventDelegate = eventDelegate;
    }

    public final void setEventLoggers$paymentcollection_release(@NotNull EventLoggers eventLoggers) {
        Intrinsics.checkNotNullParameter((Object)eventLoggers, (String)"eventLoggers");
        this.eventLoggers = eventLoggers;
    }

    protected final void yieldEvent(@NotNull PaymentCollectionEvent paymentCollectionEvent) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionEvent, (String)"paymentCollectionEvent");
        PaymentCollectionEventDelegate paymentCollectionEventDelegate = this.eventDelegate;
        if (paymentCollectionEventDelegate == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"eventDelegate");
            paymentCollectionEventDelegate = null;
        }
        paymentCollectionEventDelegate.onHandlePaymentCollectionEvent(paymentCollectionEvent);
    }

    @Override
    public final void onUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        PaymentCollectionData paymentCollectionData2 = old;
        if (!(paymentCollectionData2 != null ? paymentCollectionData2.isCancelled() : false) && paymentCollectionData.isCancelled()) {
            CancelReason cancelReason = paymentCollectionData.getCancelReason();
            this.transitionTo(PaymentCollectionState.CANCEL, cancelReason != null ? cancelReason.name() : null);
        } else {
            this.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        }
    }

    @Override
    @CallSuper
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        super.onEnter(current, from);
        this.startTimeoutCountdown();
    }

    @Override
    @CallSuper
    public void onExit(@NotNull PaymentCollectionState to) {
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        super.onExit(to);
        this.cancelTimeoutJob();
    }

    private final void onPaymentCollectionTimeout(long timeout) {
        PaymentCollectionStatesKt.access$getLOGGER$p().d("Payment collection timed-out after " + timeout + "ms", new Pair[0]);
        StateMachine.StateHandler.transitionTo$default(this, (Object)PaymentCollectionState.TIMEOUT, null, 2, null);
    }

    @CallSuper
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        PaymentCollectionData paymentCollectionData2 = old;
        if (paymentCollectionData.getCardSlotState() != (paymentCollectionData2 != null ? paymentCollectionData2.getCardSlotState() : null)) {
            this.yieldEvent(new CardStateUpdateEvent(paymentCollectionData.getCardSlotState()));
        }
    }

    protected final boolean checkForPrematureTransactionCompletionAndTransitionIfNeeded(@NotNull PaymentCollectionData data) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.isDeclined()) {
            this.transitionTo(PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN, "Declined.");
            return true;
        }
        TransactionResult.Result result2 = data.getHardwareTransactionResult();
        switch (result2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[result2.ordinal()]) {
            case 1: {
                DiscreteEventLogger discreteEventLogger = this.getDiscreteEventLogger();
                Object d2 = this.getData();
                Intrinsics.checkNotNull(d2);
                discreteEventLogger.logPrematureCardRemoval((PaymentCollectionData)d2);
                this.transitionTo(PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN, "Card removed prematurely.");
                bl = true;
                break;
            }
            case 2: {
                if (data.getDeviceCapability().getRetryUponTerminate()) {
                    this.transitionTo(PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN, "Terminated.");
                } else {
                    this.yieldEvent(HardwareTransactionCancelledEvent.INSTANCE);
                }
                bl = true;
                break;
            }
            case 3: {
                this.transitionTo(PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN, "Card blocked.");
                bl = true;
                break;
            }
            case 4: {
                this.transitionTo(PaymentCollectionState.FINISHED, "Device failure.");
                bl = true;
                break;
            }
            case 5: {
                this.transitionTo(PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN, "Previous card still inserted.");
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    protected final Unit generateDisplayCartEvent(@NotNull PaymentCollectionData data) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cart cart = data.getCartToDisplay();
        if (cart != null) {
            Cart it = cart;
            boolean bl = false;
            this.yieldEvent(new DisplayCartEvent(new DisplayCartModel(it, data.getEmvTransactionType(), data.getOnlineAuthorizationData() != null)));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    protected final boolean startCollectionIfNeeded(@NotNull PaymentCollectionData data) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Pair pair = !data.getConfirmedCollection() && !data.isPreDipEnabled() ? new Pair((Object)PaymentCollectionState.DISPLAY_CART_PRE_COLLECTION, (Object)"Display cart.") : (data.getTippingState() instanceof TippingState.SelectionNeeded && data.getConfirmedCollection() ? new Pair((Object)PaymentCollectionState.TIPPING_SELECTION, (Object)"Tipping required.") : new Pair((Object)PaymentCollectionState.COLLECTION, (Object)"Tipping and manual entry not required."));
        PaymentCollectionState targetState = (PaymentCollectionState)((Object)pair.component1());
        String reason = (String)pair.component2();
        if (targetState != this.getState()) {
            this.transitionTo(targetState, reason);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void startTimeoutCountdown() {
        block0: {
            Long l2 = this.timeout;
            if (l2 == null) break block0;
            long timeout = ((Number)l2).longValue();
            boolean bl = false;
            this.cancelTimeoutJob();
            this.job = BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(timeout, this, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ long $timeout;
                final /* synthetic */ PaymentCollectionStateHandler this$0;
                {
                    this.$timeout = $timeout;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            $this$launch = (CoroutineScope)this.L$0;
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = DelayKt.delay((long)this.$timeout, (Continuation)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl16
                        }
                        case 1: {
                            $this$launch = (CoroutineScope)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl16:
                            // 2 sources

                            if (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                                PaymentCollectionStateHandler.access$onPaymentCollectionTimeout(this.this$0, this.$timeout);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    protected final void generateUserInteractionEvent(@NotNull Amount amount, int numberOfAsterisks, @Nullable String language, @Nullable PinEntryRetryReason pinEntryRetryReason) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        PinEntryModel model2 = new PinEntryModel(amount, numberOfAsterisks, language, pinEntryRetryReason);
        this.yieldEvent(new PresentPinEntryEvent(model2));
    }

    protected final void generateStartPinEntryEvent() {
        this.yieldEvent(StartPinEntryEvent.INSTANCE);
    }

    protected final void sendOnlineAuthRequestEventIfNeeded(@NotNull PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (data.getOnlineAuthorizationData() != null && data.getTippingState() instanceof TippingState.EndState && !data.getOnlineAuthorizationRequested()) {
            this.updateDataWithoutCallback(PaymentCollectionData.copy$default(data, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, true, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -1048577, 1048575, null));
            this.getOnlineAuthStateLogger().updateOnlineAuthState(OnlineAuthState.ReadyToStartConfirmation.INSTANCE, data);
            InterfaceType interfaceType = PaymentCollectionStatesKt.interfaceTypeFromTlv(data.getOnlineAuthorizationData());
            Intrinsics.checkNotNull((Object)((Object)interfaceType));
            this.yieldEvent(new OnlineAuthorizationRequestEvent(interfaceType, data.getOnlineAuthorizationData(), (TippingState.EndState)data.getTippingState()));
        }
    }

    private final void cancelTimeoutJob() {
        block0: {
            Job job = this.job;
            if (job == null) break block0;
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
    }

    @Nullable
    protected final Unit generateStartPollingForCardStatusEvent() {
        Unit unit;
        PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
        if (paymentCollectionData != null) {
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            if (it.getDeviceCapability().getCheckForCardBehavior() == CheckForCardBehavior.POLL_FOR_CARD_REMOVAL) {
                this.yieldEvent(new StartPollingForCardStatusEvent(ReaderConfiguration.Companion.getINSERT()));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    protected final void generateStopReaderEvent() {
        CancellationPhase cancellationPhase;
        PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
        PaymentCollectionState paymentCollectionState = paymentCollectionData != null ? paymentCollectionData.getStateWhenCancelled() : null;
        switch (paymentCollectionState == null ? -1 : WhenMappings.$EnumSwitchMapping$1[paymentCollectionState.ordinal()]) {
            case 1: {
                cancellationPhase = CancellationPhase.APPLICATION_SELECTION;
                break;
            }
            case 2: {
                cancellationPhase = CancellationPhase.ACCOUNT_TYPE_SELECTION;
                break;
            }
            case 3: {
                cancellationPhase = CancellationPhase.PIN;
                break;
            }
            case 4: {
                cancellationPhase = CancellationPhase.AUTH;
                break;
            }
            default: {
                cancellationPhase = CancellationPhase.COLLECTION;
            }
        }
        CancellationPhase phase = cancellationPhase;
        this.yieldEvent(new StopReaderEvent(phase));
    }

    protected final void clearContactCardStateAndPrepareNextCollection() {
        block3: {
            TransactionResult.Result result2;
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block3;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            if (it.getHardwareTransactionResult() == TransactionResult.Result.TERMINATED && it.getIntermediateTransactionError() == IntermediateTransactionError.TOO_MANY_TAPS) {
                result2 = TransactionResult.Result.MOBILE_WALLET_TOO_MANY_TAPS;
            } else {
                result2 = it.getHardwareTransactionResult();
                if (result2 == null) {
                    result2 = it.getLastCollectionResult();
                }
            }
            TransactionResult.Result lastCollectionResult = result2;
            List list = CollectionsKt.emptyList();
            AccountSelectionStatus.NotRequested notRequested = AccountSelectionStatus.NotRequested.INSTANCE;
            PinEntryStatus pinEntryStatus = PinEntryStatus.NOT_REQUESTED;
            this.updateDataWithoutCallback(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, list, null, null, notRequested, pinEntryStatus, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, lastCollectionResult, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, 234881983, 1040110, null));
        }
    }

    public static final /* synthetic */ void access$onPaymentCollectionTimeout(PaymentCollectionStateHandler $this, long timeout) {
        $this.onPaymentCollectionTimeout(timeout);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TransactionResult.Result.values().length];
            try {
                nArray[TransactionResult.Result.ICC_CARD_REMOVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.TERMINATED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CARD_BLOCKED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.DEVICE_FAILURE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CARD_STILL_INSERTED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PaymentCollectionState.values().length];
            try {
                nArray[PaymentCollectionState.APPLICATION_SELECTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.ACCOUNT_SELECTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.PIN_ENTRY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.ONLINE_AUTHORIZATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

