/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.neovisionaries.i18n.CurrencyCode;
import com.stripe.core.hardware.paymentcollection.ContactCardSlotState;
import com.stripe.core.hardware.paymentcollection.ManualEntryResult;
import com.stripe.core.hardware.paymentcollection.PinEntryRetryReason;
import com.stripe.core.hardware.paymentcollection.PinEntryStatus;
import com.stripe.core.hardware.paymentcollection.TippingSelectionResult;
import com.stripe.core.hardware.paymentcollection.TippingSelectionType;
import com.stripe.core.hardware.tipping.BbposSdkTipSelectionType;
import com.stripe.core.hardware.tipping.Custom;
import com.stripe.core.hardware.tipping.FixedAmount;
import com.stripe.core.hardware.tipping.FixedAmountTips;
import com.stripe.core.hardware.tipping.NoTipSelected;
import com.stripe.core.hardware.tipping.Percentage;
import com.stripe.core.hardware.tipping.PercentageTips;
import com.stripe.core.hardware.tipping.TipConfigValidationResult;
import com.stripe.core.hardware.tipping.TipSelected;
import com.stripe.core.hardware.tipping.TipSelectionFailure;
import com.stripe.core.hardware.tipping.TipSelectionResult;
import com.stripe.core.hardware.tipping.Unknown;
import com.stripe.core.paymentcollection.AccountSelectionHandler;
import com.stripe.core.paymentcollection.AccountSelectionStatus;
import com.stripe.core.paymentcollection.ApplicationSelectionHandler;
import com.stripe.core.paymentcollection.CancelHandler;
import com.stripe.core.paymentcollection.CancelReason;
import com.stripe.core.paymentcollection.CollectionCompleteHandler;
import com.stripe.core.paymentcollection.CollectionHandler;
import com.stripe.core.paymentcollection.DisplayCartPostCollectionHandler;
import com.stripe.core.paymentcollection.DisplayCartPreCollectionHandler;
import com.stripe.core.paymentcollection.EarlyTransactionAbortReason;
import com.stripe.core.paymentcollection.EmptyHandler;
import com.stripe.core.paymentcollection.FinishedHandler;
import com.stripe.core.paymentcollection.LanguageSelectionHandler;
import com.stripe.core.paymentcollection.MagStripePinEntryHandler;
import com.stripe.core.paymentcollection.ManualEntryHandler;
import com.stripe.core.paymentcollection.OnlineAuthorizationHandler;
import com.stripe.core.paymentcollection.OnlineAuthorizationMagStripeHandler;
import com.stripe.core.paymentcollection.OnlineConfirmationHandler;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionEventDelegate;
import com.stripe.core.paymentcollection.PaymentCollectionScreenInputStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.PinEntryHandler;
import com.stripe.core.paymentcollection.PrepareToCollectAgainHandler;
import com.stripe.core.paymentcollection.ProcessingHandler;
import com.stripe.core.paymentcollection.RecoverableErrorSummaryHandler;
import com.stripe.core.paymentcollection.RemoveCardHandler;
import com.stripe.core.paymentcollection.SCARequirement;
import com.stripe.core.paymentcollection.TimeoutHandler;
import com.stripe.core.paymentcollection.TippingHandler;
import com.stripe.core.paymentcollection.TippingState;
import com.stripe.core.paymentcollection.manualentry.ManualEntryCollectionResult;
import com.stripe.core.paymentcollection.manualentry.ManualEntryStateMachine;
import com.stripe.core.paymentcollection.metrics.DisplayCartResult;
import com.stripe.core.paymentcollection.metrics.EventLoggers;
import com.stripe.core.paymentcollection.metrics.PendingPosCommand;
import com.stripe.core.statemachine.StateMachine;
import com.stripe.jvmcore.cart.Cart;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.dagger.PaymentCollection;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.AccountType;
import com.stripe.jvmcore.hardware.emv.IntermediateTransactionError;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadResult;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadSuccess;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import com.stripe.jvmcore.restclient.IntegrationType;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.jvmcore.transaction.PaymentCollectionDeviceCapability;
import com.stripe.jvmcore.transaction.PaymentCollectionDeviceCapabilityKt;
import com.stripe.stripeterminal.external.models.DeviceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u0094\u00012\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u0094\u0001B3\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u0012\b\b\u0001\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0015\u001a\u00020\u000bJ\u0006\u0010\u0016\u001a\u00020\u000bJ\u0006\u0010\u0017\u001a\u00020\u0013J\u00be\u0001\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010&\u001a\u00020\u000b2\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\u000b2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u001c2\b\b\u0002\u0010-\u001a\u00020\u000b2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010/2\b\b\u0002\u00100\u001a\u00020\u000b2\b\b\u0002\u00101\u001a\u00020\u000b2\b\b\u0002\u00102\u001a\u00020\u000b2\u000e\b\u0002\u00103\u001a\b\u0012\u0004\u0012\u00020504J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\"2\u0006\u00109\u001a\u00020:H\u0002Jd\u0010;\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010<\u001a\u00020=2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%2\b\b\u0002\u0010'\u001a\u00020(2\b\b\u0002\u0010)\u001a\u00020*2\b\b\u0002\u00100\u001a\u00020\u000b2\b\b\u0002\u00101\u001a\u00020\u000b2\b\b\u0002\u00102\u001a\u00020\u000bJ\u0006\u0010>\u001a\u00020\u0013J<\u0010?\u001a\b\u0012\u0004\u0012\u00020A0@2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(2\b\b\u0002\u0010&\u001a\u00020\u000b2\b\b\u0002\u0010+\u001a\u00020\u000b2\b\b\u0002\u0010)\u001a\u00020*H\u0002J4\u0010B\u001a\b\u0012\u0004\u0012\u00020A0@2\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010&\u001a\u00020\u000b2\b\b\u0002\u0010+\u001a\u00020\u000b2\b\b\u0002\u0010)\u001a\u00020*H\u0002J\u0006\u0010C\u001a\u00020\u000bJ\u0006\u0010D\u001a\u00020\u0013J\u0006\u0010E\u001a\u00020\u0013J\u0006\u0010F\u001a\u00020\u0013J\u000e\u0010G\u001a\u00020\u00132\u0006\u0010H\u001a\u00020IJ&\u0010J\u001a\u00020\u00132\u0006\u0010K\u001a\u00020L2\n\b\u0002\u0010M\u001a\u0004\u0018\u0001052\n\b\u0002\u0010N\u001a\u0004\u0018\u000105J\u0006\u0010O\u001a\u00020\u0013J.\u0010\u0011\u001a\u00020\u00132\u0006\u0010P\u001a\u00020\u00022\b\u0010Q\u001a\u0004\u0018\u00010\u00022\b\u0010R\u001a\u0004\u0018\u00010\u00032\b\u0010S\u001a\u0004\u0018\u000105H\u0014J\u0014\u0010T\u001a\u0004\u0018\u00010U2\b\u0010V\u001a\u0004\u0018\u00010LH\u0002J\b\u0010W\u001a\u00020\u0013H\u0002J\u0006\u0010X\u001a\u00020\u0013J\u000e\u0010Y\u001a\u00020\u000b2\u0006\u0010Z\u001a\u00020[J\u0014\u0010\\\u001a\u00020\u00132\f\u0010]\u001a\b\u0012\u0004\u0012\u00020A0@J\u0014\u0010^\u001a\u00020\u00132\f\u0010_\u001a\b\u0012\u0004\u0012\u00020504J\u000e\u0010`\u001a\u00020\u00132\u0006\u0010a\u001a\u00020bJ\u000e\u0010c\u001a\u00020\u00132\u0006\u0010S\u001a\u00020dJ\u000e\u0010e\u001a\u00020\u00132\u0006\u0010f\u001a\u000205J\u000e\u0010g\u001a\u00020\u00132\u0006\u0010h\u001a\u00020iJ\u000e\u0010j\u001a\u00020\u00132\u0006\u0010k\u001a\u00020lJ\b\u0010m\u001a\u00020\u0013H\u0002J\u000e\u0010n\u001a\u00020\u00132\u0006\u0010o\u001a\u00020\u000bJ\u000e\u0010p\u001a\u00020\u00132\u0006\u0010q\u001a\u00020rJ\u000e\u0010s\u001a\u00020\u00132\u0006\u0010t\u001a\u00020uJ\u000e\u0010v\u001a\u00020\u00132\u0006\u0010k\u001a\u00020wJ\u000e\u0010x\u001a\u00020\u00132\u0006\u0010y\u001a\u00020zJ\"\u0010{\u001a\u00020\u00132\u001a\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012j\u0004\u0018\u0001`\u0014J\u000e\u0010|\u001a\u00020\u00132\u0006\u0010}\u001a\u000205J\u000e\u0010~\u001a\u00020\u00132\u0006\u0010\u007f\u001a\u000205J\u0011\u0010\u0080\u0001\u001a\u00020\u00132\b\u0010\u0081\u0001\u001a\u00030\u0082\u0001J\u0011\u0010\u0083\u0001\u001a\u00020\u00132\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001J\u0011\u0010\u0086\u0001\u001a\u00020\u00132\b\u0010\u0087\u0001\u001a\u00030\u0082\u0001J\u0010\u0010\u0088\u0001\u001a\u00020\u00132\u0007\u0010\u0089\u0001\u001a\u000205J\u0010\u0010\u008a\u0001\u001a\u00020\u00132\u0007\u0010\u008b\u0001\u001a\u00020\u000bJ\u0010\u0010\u008c\u0001\u001a\u00020\u00132\u0007\u0010k\u001a\u00030\u008d\u0001J\u0007\u0010\u008e\u0001\u001a\u00020\u0013J\u0012\u0010\u008f\u0001\u001a\u00020\u00132\u0007\u0010S\u001a\u00030\u0090\u0001H\u0002J\u0013\u0010\u0091\u0001\u001a\u00020\u00132\n\u0010\u0092\u0001\u001a\u0005\u0018\u00010\u0093\u0001R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012j\u0004\u0018\u0001`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0095\u0001"}, d2={"Lcom/stripe/core/paymentcollection/PaymentCollectionStateMachine;", "Lcom/stripe/core/statemachine/StateMachine;", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "eventDelegate", "Lcom/stripe/core/paymentcollection/PaymentCollectionEventDelegate;", "eventLoggers", "Lcom/stripe/core/paymentcollection/metrics/EventLoggers;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "motoTransactionsEnabled", "", "manualEntryStateMachine", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryStateMachine;", "(Lcom/stripe/core/paymentcollection/PaymentCollectionEventDelegate;Lcom/stripe/core/paymentcollection/metrics/EventLoggers;Lkotlinx/coroutines/CoroutineDispatcher;ZLcom/stripe/core/paymentcollection/manualentry/ManualEntryStateMachine;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "onStateChanging", "Lkotlin/Function1;", "", "Lcom/stripe/core/paymentcollection/OnStateChanging;", "canResumeCollectionForSca", "canStartCollection", "clearMagStripeReadState", "collectPayment", "transactionType", "Lcom/stripe/core/hardware/paymentcollection/TransactionType;", "baseAmount", "Lcom/stripe/jvmcore/currency/Amount;", "emvTransactionType", "Lcom/stripe/jvmcore/hardware/emv/TransactionType;", "tippingState", "Lcom/stripe/core/paymentcollection/TippingState;", "tippingConfig", "Lcom/stripe/core/hardware/tipping/TipConfigValidationResult;", "tippingAmount", "integrationType", "Lcom/stripe/jvmcore/restclient/IntegrationType;", "manualEntry", "deviceCapability", "Lcom/stripe/jvmcore/transaction/PaymentCollectionDeviceCapability;", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "isOffline", "tipEligibleAmount", "isDeferredAuthorizationCountry", "domesticDebitPriority", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$DomesticDebitPriority;", "isApplicationSelectionInQuickChipEnabled", "enableMagStripePin", "forceMagstripePin", "domesticDebitAids", "", "", "determineTipSelectionType", "Lcom/stripe/core/hardware/paymentcollection/TippingSelectionType;", "config", "bbposSdkTipSelectionType", "Lcom/stripe/core/hardware/tipping/BbposSdkTipSelectionType;", "displayCart", "cart", "Lcom/stripe/jvmcore/cart/Cart;", "dispose", "getDesiredReaderInterfaces", "Ljava/util/EnumSet;", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$ReaderType;", "interfacesSupportedByTransaction", "isFinished", "onDeviceKernelBusy", "onHardwareTransactionCanceled", "onMerchantTransactionCanceled", "onOnlineAuthStateChanged", "state", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthState;", "onPinEntryStatusChange", "status", "Lcom/stripe/core/hardware/paymentcollection/PinEntryStatus;", "epb", "epbKsn", "onRequestAccountTypeSelection", "to", "from", "data", "reason", "pinEntryStatusToFailureReasonForViewModel", "Lcom/stripe/core/hardware/paymentcollection/PinEntryRetryReason;", "pinEntryStatus", "registerHandlers", "resetTipSelection", "resumePaymentForSCA", "scaRequirement", "Lcom/stripe/core/paymentcollection/SCARequirement;", "setActiveReaderInterfaces", "activeReaderInterfaces", "setApplicationList", "applicationList", "setCardSlotState", "cardSlotState", "Lcom/stripe/core/hardware/paymentcollection/ContactCardSlotState;", "setEarlyTransactionAbortReason", "Lcom/stripe/core/paymentcollection/EarlyTransactionAbortReason;", "setFinalConfirmation", "tlv", "setHardwareTippingSelectionResult", "hardwareResult", "Lcom/stripe/core/hardware/tipping/TipSelectionResult;", "setHardwareTransactionResult", "result", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult$Result;", "setInitialState", "setInterfaceResetRequired", "isRequired", "setIntermediateError", "error", "Lcom/stripe/jvmcore/hardware/emv/IntermediateTransactionError;", "setMagStripeReadResult", "magStripeReadResult", "Lcom/stripe/jvmcore/hardware/magstripe/MagStripeReadResult;", "setManualEntryCollectionResult", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryCollectionResult;", "setManualEntryResult", "manualEntryResult", "Lcom/stripe/core/hardware/paymentcollection/ManualEntryResult;", "setOnStateChanging", "setOnlineAuthResponse", "response", "setOnlineAuthorizationData", "onlineAuthorizationData", "setPinEntryAsterisks", "count", "", "setSelectedAccountType", "selectedAccountType", "Lcom/stripe/jvmcore/hardware/emv/AccountType;", "setSelectedApplicationIndex", "selectedApplicationIndex", "setSelectedLanguage", "selectedLanguage", "setShowThankYouReceived", "showThankYouReceived", "setTippingSelectionResult", "Lcom/stripe/core/hardware/paymentcollection/TippingSelectionResult;", "setUserRetryRequested", "startCancellation", "Lcom/stripe/core/paymentcollection/CancelReason;", "updateChargeAttempt", "chargeAttempt", "Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "Companion", "paymentcollection_release"})
@SourceDebugExtension(value={"SMAP\nPaymentCollectionStateMachine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentCollectionStateMachine.kt\ncom/stripe/core/paymentcollection/PaymentCollectionStateMachine\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1100:1\n13579#2,2:1101\n766#3:1103\n857#3,2:1104\n1#4:1106\n*S KotlinDebug\n*F\n+ 1 PaymentCollectionStateMachine.kt\ncom/stripe/core/paymentcollection/PaymentCollectionStateMachine\n*L\n134#1:1101,2\n459#1:1103\n459#1:1104,2\n*E\n"})
public final class PaymentCollectionStateMachine
extends StateMachine<PaymentCollectionState, PaymentCollectionData> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final PaymentCollectionEventDelegate eventDelegate;
    @NotNull
    private final EventLoggers eventLoggers;
    private final boolean motoTransactionsEnabled;
    @NotNull
    private final ManualEntryStateMachine manualEntryStateMachine;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private Function1<? super PaymentCollectionState, Unit> onStateChanging;
    @NotNull
    private static final String TAG = "PaymentCollectionStateMachine";
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(PaymentCollectionStateMachine.class);
    @NotNull
    private static final Set<DeviceType> WISEPAD_3_DEVICES;

    @Inject
    public PaymentCollectionStateMachine(@NotNull PaymentCollectionEventDelegate eventDelegate, @NotNull EventLoggers eventLoggers, @PaymentCollection @NotNull CoroutineDispatcher coroutineDispatcher, @Named(value="enable_moto_transactions") boolean motoTransactionsEnabled, @NotNull ManualEntryStateMachine manualEntryStateMachine) {
        Intrinsics.checkNotNullParameter((Object)eventDelegate, (String)"eventDelegate");
        Intrinsics.checkNotNullParameter((Object)eventLoggers, (String)"eventLoggers");
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        Intrinsics.checkNotNullParameter((Object)manualEntryStateMachine, (String)"manualEntryStateMachine");
        this.eventDelegate = eventDelegate;
        this.eventLoggers = eventLoggers;
        this.motoTransactionsEnabled = motoTransactionsEnabled;
        this.manualEntryStateMachine = manualEntryStateMachine;
        this.coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)coroutineDispatcher));
        this.registerHandlers();
        this.setInitialState();
    }

    private final void registerHandlers() {
        PaymentCollectionState[] $this$forEach$iv = PaymentCollectionState.values();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PaymentCollectionStateHandler paymentCollectionStateHandler;
            PaymentCollectionState element$iv;
            PaymentCollectionState it = element$iv = $this$forEach$iv[i2];
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    paymentCollectionStateHandler = new EmptyHandler(this.coroutineScope);
                    break;
                }
                case 2: {
                    paymentCollectionStateHandler = new DisplayCartPreCollectionHandler(this.coroutineScope);
                    break;
                }
                case 3: {
                    paymentCollectionStateHandler = new DisplayCartPostCollectionHandler(this.coroutineScope);
                    break;
                }
                case 4: {
                    paymentCollectionStateHandler = new TippingHandler(this.coroutineScope);
                    break;
                }
                case 5: {
                    paymentCollectionStateHandler = new CollectionHandler(this.coroutineScope);
                    break;
                }
                case 6: {
                    paymentCollectionStateHandler = new ManualEntryHandler(this.coroutineScope, this.manualEntryStateMachine);
                    break;
                }
                case 7: {
                    paymentCollectionStateHandler = new ProcessingHandler(this.coroutineScope);
                    break;
                }
                case 8: {
                    paymentCollectionStateHandler = new ApplicationSelectionHandler(this.coroutineScope);
                    break;
                }
                case 9: {
                    paymentCollectionStateHandler = new LanguageSelectionHandler(this.coroutineScope);
                    break;
                }
                case 10: {
                    paymentCollectionStateHandler = new AccountSelectionHandler(this.coroutineScope);
                    break;
                }
                case 11: {
                    paymentCollectionStateHandler = new PinEntryHandler(this.coroutineScope);
                    break;
                }
                case 12: {
                    paymentCollectionStateHandler = new MagStripePinEntryHandler(this.coroutineScope);
                    break;
                }
                case 13: {
                    paymentCollectionStateHandler = new PrepareToCollectAgainHandler(this.coroutineScope);
                    break;
                }
                case 14: {
                    paymentCollectionStateHandler = new RecoverableErrorSummaryHandler(this.coroutineScope);
                    break;
                }
                case 15: {
                    paymentCollectionStateHandler = new OnlineAuthorizationHandler(this.coroutineScope);
                    break;
                }
                case 16: {
                    paymentCollectionStateHandler = new OnlineAuthorizationMagStripeHandler(this.coroutineScope);
                    break;
                }
                case 17: {
                    paymentCollectionStateHandler = new RemoveCardHandler(this.coroutineScope);
                    break;
                }
                case 18: {
                    paymentCollectionStateHandler = new OnlineConfirmationHandler(this.coroutineScope);
                    break;
                }
                case 19: {
                    paymentCollectionStateHandler = new CollectionCompleteHandler(this.coroutineScope);
                    break;
                }
                case 20: {
                    paymentCollectionStateHandler = new CancelHandler(this.coroutineScope);
                    break;
                }
                case 21: {
                    paymentCollectionStateHandler = new FinishedHandler(this.coroutineScope);
                    break;
                }
                case 22: {
                    paymentCollectionStateHandler = new TimeoutHandler(this.coroutineScope);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            PaymentCollectionStateHandler $this$registerHandlers_u24lambda_u241_u24lambda_u240 = paymentCollectionStateHandler;
            boolean bl2 = false;
            $this$registerHandlers_u24lambda_u241_u24lambda_u240.setEventDelegate$paymentcollection_release(this.eventDelegate);
            $this$registerHandlers_u24lambda_u241_u24lambda_u240.setEventLoggers$paymentcollection_release(this.eventLoggers);
            $this$registerHandlers_u24lambda_u241_u24lambda_u240.register(this);
        }
    }

    private final void setInitialState() {
        StateMachine.transitionTo$default(this, (Object)PaymentCollectionState.EMPTY, null, 2, null);
    }

    public final void setOnStateChanging(@Nullable Function1<? super PaymentCollectionState, Unit> onStateChanging) {
        this.onStateChanging = onStateChanging;
    }

    @Override
    protected void onStateChanging(@NotNull PaymentCollectionState to, @Nullable PaymentCollectionState from, @Nullable PaymentCollectionData data, @Nullable String reason) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
            PaymentCollectionState paymentCollectionState = from;
            LOGGER.i("onStateChanged: " + (paymentCollectionState != null ? paymentCollectionState.name() : null) + " -> " + to.name() + ": " + reason, new Pair[0]);
            Function1<? super PaymentCollectionState, Unit> function1 = this.onStateChanging;
            if (function1 == null) break block0;
            function1.invoke((Object)to);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canStartCollection() {
        PaymentCollectionState[] paymentCollectionStateArray = new PaymentCollectionState[]{PaymentCollectionState.EMPTY, PaymentCollectionState.TIPPING_SELECTION, PaymentCollectionState.MANUAL_ENTRY};
        if (CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])paymentCollectionStateArray), this.getState())) return true;
        PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
        if (paymentCollectionData == null) return false;
        if (paymentCollectionData.getConfirmedCollection()) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canResumeCollectionForSca() {
        if (this.getState() != PaymentCollectionState.ONLINE_AUTHORIZATION) return false;
        PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
        if (!((paymentCollectionData != null ? paymentCollectionData.getChargeAttempt() : null) instanceof ChargeAttempt.ExtendedAttempt)) return false;
        PaymentCollectionData paymentCollectionData2 = (PaymentCollectionData)this.getData();
        if (paymentCollectionData2 == null) return false;
        String string = paymentCollectionData2.getOnlineAuthorizationData();
        if (string == null) return false;
        PaymentCollectionData paymentCollectionData3 = (PaymentCollectionData)this.getData();
        if (paymentCollectionData3 == null) return false;
        String string2 = paymentCollectionData3.getOnlineAuthorizationResponse();
        if (string2 == null) return false;
        return true;
    }

    public final boolean displayCart(@NotNull TransactionType emvTransactionType, @NotNull TippingState tippingState, @NotNull TipConfigValidationResult tippingConfig, @NotNull Cart cart, @Nullable IntegrationType integrationType, @NotNull PaymentCollectionDeviceCapability deviceCapability, @NotNull DeviceType deviceType, boolean isApplicationSelectionInQuickChipEnabled, boolean enableMagStripePin, boolean forceMagstripePin) {
        Intrinsics.checkNotNullParameter((Object)((Object)emvTransactionType), (String)"emvTransactionType");
        Intrinsics.checkNotNullParameter((Object)tippingState, (String)"tippingState");
        Intrinsics.checkNotNullParameter((Object)tippingConfig, (String)"tippingConfig");
        Intrinsics.checkNotNullParameter((Object)cart, (String)"cart");
        Intrinsics.checkNotNullParameter((Object)deviceCapability, (String)"deviceCapability");
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        if (!this.canStartCollection()) {
            LOGGER.i("Attempt to begin payment from invalid state " + this.getState(), new Pair[0]);
            return false;
        }
        PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
        if (paymentCollectionData != null) {
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.eventLoggers.getStageEventLogger().closeDisplayCartLog(it, DisplayCartResult.CART_UPDATED);
        }
        this.eventLoggers.getStageEventLogger().openDisplayCartLog();
        com.stripe.core.hardware.paymentcollection.TransactionType transactionType = com.stripe.core.hardware.paymentcollection.TransactionType.CHARGE;
        EnumSet desiredReaderInterfaces = PaymentCollectionStateMachine.getDesiredReaderInterfaces$default(this, transactionType, deviceCapability, false, false, deviceType, 12, null);
        Amount amount = cart.getBalance();
        PaymentCollectionData paymentCollectionData2 = (PaymentCollectionData)this.getData();
        if (paymentCollectionData2 == null || (paymentCollectionData2 = PaymentCollectionData.copy$default(paymentCollectionData2, transactionType, amount, amount, emvTransactionType, false, 0, null, enableMagStripePin, forceMagstripePin, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, tippingState, tippingConfig, null, null, null, null, false, null, null, false, desiredReaderInterfaces, null, cart, false, false, null, null, integrationType, deviceCapability, deviceType, null, false, false, null, null, isApplicationSelectionInQuickChipEnabled, false, -100663696, 779143, null)) == null) {
            paymentCollectionData2 = new PaymentCollectionData(transactionType, amount, amount, emvTransactionType, false, 0, null, enableMagStripePin, forceMagstripePin, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, tippingState, tippingConfig, null, null, null, null, false, null, null, false, desiredReaderInterfaces, null, cart, false, false, null, null, integrationType, deviceCapability, deviceType, null, false, false, null, null, isApplicationSelectionInQuickChipEnabled, false, -100663696, 779143, null);
        }
        this.updateData(paymentCollectionData2);
        return true;
    }

    public static /* synthetic */ boolean displayCart$default(PaymentCollectionStateMachine paymentCollectionStateMachine, TransactionType transactionType, TippingState tippingState, TipConfigValidationResult tipConfigValidationResult, Cart cart, IntegrationType integrationType, PaymentCollectionDeviceCapability paymentCollectionDeviceCapability, DeviceType deviceType, boolean bl, boolean bl2, boolean bl3, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            integrationType = null;
        }
        if ((n2 & 0x20) != 0) {
            paymentCollectionDeviceCapability = PaymentCollectionDeviceCapabilityKt.getDEFAULT_PAYMENT_COLLECTION_CAPABILITY();
        }
        if ((n2 & 0x40) != 0) {
            deviceType = DeviceType.UNKNOWN;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        if ((n2 & 0x100) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x200) != 0) {
            bl3 = false;
        }
        return paymentCollectionStateMachine.displayCart(transactionType, tippingState, tipConfigValidationResult, cart, integrationType, paymentCollectionDeviceCapability, deviceType, bl, bl2, bl3);
    }

    public final boolean collectPayment(@NotNull com.stripe.core.hardware.paymentcollection.TransactionType transactionType, @NotNull Amount baseAmount, @NotNull TransactionType emvTransactionType, @NotNull TippingState tippingState, @NotNull TipConfigValidationResult tippingConfig, @Nullable Amount tippingAmount, @Nullable IntegrationType integrationType, boolean manualEntry, @NotNull PaymentCollectionDeviceCapability deviceCapability, @NotNull DeviceType deviceType, boolean isOffline, @Nullable Amount tipEligibleAmount, boolean isDeferredAuthorizationCountry, @Nullable ReaderConfiguration.DomesticDebitPriority domesticDebitPriority, boolean isApplicationSelectionInQuickChipEnabled, boolean enableMagStripePin, boolean forceMagstripePin, @NotNull List<String> domesticDebitAids) {
        Amount totalAmount;
        Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)"transactionType");
        Intrinsics.checkNotNullParameter((Object)baseAmount, (String)"baseAmount");
        Intrinsics.checkNotNullParameter((Object)((Object)emvTransactionType), (String)"emvTransactionType");
        Intrinsics.checkNotNullParameter((Object)tippingState, (String)"tippingState");
        Intrinsics.checkNotNullParameter((Object)tippingConfig, (String)"tippingConfig");
        Intrinsics.checkNotNullParameter((Object)deviceCapability, (String)"deviceCapability");
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Intrinsics.checkNotNullParameter(domesticDebitAids, (String)"domesticDebitAids");
        if (!this.canStartCollection()) {
            LOGGER.i("Attempt to begin payment from invalid state " + this.getState(), new Pair[0]);
            return false;
        }
        EnumSet<ReaderConfiguration.ReaderType> desiredReaderInterfaces = this.getDesiredReaderInterfaces(transactionType, deviceCapability, manualEntry, isOffline, deviceType);
        PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
        if (paymentCollectionData != null) {
            PaymentCollectionData data = paymentCollectionData;
            boolean bl = false;
            if (!data.getConfirmedCollection()) {
                PaymentCollectionState paymentCollectionState = (PaymentCollectionState)((Object)this.getState());
                if (paymentCollectionState != null) {
                    PaymentCollectionState it = paymentCollectionState;
                    boolean bl2 = false;
                    this.eventLoggers.getStageEventLogger().closeDisplayCartLog(data, DisplayCartResult.STARTED_COLLECTION);
                }
            }
        }
        Amount amount = tippingAmount;
        Amount amount2 = totalAmount = (amount != null ? amount.getCurrency() : null) != baseAmount.getCurrency() ? baseAmount : new Amount(tippingAmount.getValue() + baseAmount.getValue(), baseAmount.getCurrency());
        if (manualEntry && !this.motoTransactionsEnabled) {
            LOGGER.e("MOTO transactions are not enabled for the registered account", new Pair[0]);
            return false;
        }
        boolean shouldStartManualEntry = manualEntry && this.motoTransactionsEnabled;
        PaymentCollectionData paymentCollectionData2 = (PaymentCollectionData)this.getData();
        if (paymentCollectionData2 == null || (paymentCollectionData2 = PaymentCollectionData.copy$default(paymentCollectionData2, transactionType, baseAmount, totalAmount, emvTransactionType, false, 0, null, enableMagStripePin, forceMagstripePin, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, tippingState, tippingConfig, tipEligibleAmount, null, null, null, false, null, null, false, desiredReaderInterfaces, null, null, true, shouldStartManualEntry, null, null, integrationType, deviceCapability, deviceType, null, isOffline, isDeferredAuthorizationCountry, domesticDebitAids, domesticDebitPriority, isApplicationSelectionInQuickChipEnabled, false, -234881424, 533287, null)) == null) {
            paymentCollectionData2 = new PaymentCollectionData(transactionType, baseAmount, totalAmount, emvTransactionType, false, 0, null, enableMagStripePin, forceMagstripePin, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, tippingState, tippingConfig, tipEligibleAmount, null, null, null, false, null, null, false, desiredReaderInterfaces, null, null, false, shouldStartManualEntry, null, null, integrationType, deviceCapability, deviceType, null, isOffline, isDeferredAuthorizationCountry, domesticDebitAids, domesticDebitPriority, isApplicationSelectionInQuickChipEnabled, false, -234881424, 533351, null);
        }
        this.updateData(paymentCollectionData2);
        return true;
    }

    public static /* synthetic */ boolean collectPayment$default(PaymentCollectionStateMachine paymentCollectionStateMachine, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, Amount amount, TransactionType transactionType2, TippingState tippingState, TipConfigValidationResult tipConfigValidationResult, Amount amount2, IntegrationType integrationType, boolean bl, PaymentCollectionDeviceCapability paymentCollectionDeviceCapability, DeviceType deviceType, boolean bl2, Amount amount3, boolean bl3, ReaderConfiguration.DomesticDebitPriority domesticDebitPriority, boolean bl4, boolean bl5, boolean bl6, List list, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            amount2 = null;
        }
        if ((n2 & 0x40) != 0) {
            integrationType = null;
        }
        if ((n2 & 0x80) != 0) {
            bl = false;
        }
        if ((n2 & 0x100) != 0) {
            paymentCollectionDeviceCapability = PaymentCollectionDeviceCapabilityKt.getDEFAULT_PAYMENT_COLLECTION_CAPABILITY();
        }
        if ((n2 & 0x200) != 0) {
            deviceType = DeviceType.UNKNOWN;
        }
        if ((n2 & 0x400) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x800) != 0) {
            amount3 = null;
        }
        if ((n2 & 0x1000) != 0) {
            bl3 = false;
        }
        if ((n2 & 0x2000) != 0) {
            domesticDebitPriority = null;
        }
        if ((n2 & 0x4000) != 0) {
            bl4 = false;
        }
        if ((n2 & 0x8000) != 0) {
            bl5 = false;
        }
        if ((n2 & 0x10000) != 0) {
            bl6 = false;
        }
        if ((n2 & 0x20000) != 0) {
            list = CollectionsKt.emptyList();
        }
        return paymentCollectionStateMachine.collectPayment(transactionType, amount, transactionType2, tippingState, tipConfigValidationResult, amount2, integrationType, bl, paymentCollectionDeviceCapability, deviceType, bl2, amount3, bl3, domesticDebitPriority, bl4, bl5, bl6, list);
    }

    public final boolean resumePaymentForSCA(@NotNull SCARequirement scaRequirement) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)scaRequirement), (String)"scaRequirement");
            if (!this.canResumeCollectionForSca()) {
                LOGGER.i("Attempt to resume payment from invalid state " + this.getState(), new Pair[0]);
                return false;
            }
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, com.stripe.core.hardware.paymentcollection.TransactionType.STRONG_CUSTOMER_AUTHENTICATION, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, scaRequirement, null, null, null, null, null, false, false, null, null, false, false, -24641538, 1048319, null));
            this.eventLoggers.getStageEventLogger().closeWaitForPosCommandLog((PaymentCollectionData)this.getData(), PendingPosCommand.RESUME_PAYMENT);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final EnumSet<ReaderConfiguration.ReaderType> getDesiredReaderInterfaces(com.stripe.core.hardware.paymentcollection.TransactionType transactionType, PaymentCollectionDeviceCapability deviceCapability, boolean manualEntry, boolean isOffline, DeviceType deviceType) {
        void $this$filterTo$iv$iv;
        EnumSet<ReaderConfiguration.ReaderType> interfacesByTransaction = this.interfacesSupportedByTransaction(transactionType, manualEntry, isOffline, deviceType);
        Iterable $this$filter$iv = interfacesByTransaction;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ReaderConfiguration.ReaderType it = (ReaderConfiguration.ReaderType)((Object)element$iv$iv);
            boolean bl = false;
            if (!deviceCapability.getSupportedInterface().contains((Object)it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        EnumSet<ReaderConfiguration.ReaderType> enumSet = EnumSet.copyOf((Collection)((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"copyOf(\n            inte\u2026)\n            }\n        )");
        return enumSet;
    }

    static /* synthetic */ EnumSet getDesiredReaderInterfaces$default(PaymentCollectionStateMachine paymentCollectionStateMachine, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, PaymentCollectionDeviceCapability paymentCollectionDeviceCapability, boolean bl, boolean bl2, DeviceType deviceType, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            deviceType = DeviceType.UNKNOWN;
        }
        return paymentCollectionStateMachine.getDesiredReaderInterfaces(transactionType, paymentCollectionDeviceCapability, bl, bl2, deviceType);
    }

    private final EnumSet<ReaderConfiguration.ReaderType> interfacesSupportedByTransaction(com.stripe.core.hardware.paymentcollection.TransactionType transactionType, boolean manualEntry, boolean isOffline, DeviceType deviceType) {
        EnumSet<Enum> enumSet;
        if (manualEntry) {
            EnumSet<Enum> enumSet2 = EnumSet.of((Enum)ReaderConfiguration.ReaderType.MANUAL_ENTRY);
            Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"of(ReaderConfiguration.ReaderType.MANUAL_ENTRY)");
            return enumSet2;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[transactionType.ordinal()]) {
            case 1: {
                enumSet = EnumSet.of((Enum)ReaderConfiguration.ReaderType.ICC, (Enum)ReaderConfiguration.ReaderType.MAGSTRIPE);
                break;
            }
            case 2: {
                enumSet = EnumSet.of((Enum)ReaderConfiguration.ReaderType.MAGSTRIPE, (Enum)ReaderConfiguration.ReaderType.ICC, (Enum)ReaderConfiguration.ReaderType.NFC);
                break;
            }
            case 3: {
                enumSet = EnumSet.of((Enum)ReaderConfiguration.ReaderType.ICC, (Enum)ReaderConfiguration.ReaderType.NFC);
                break;
            }
            case 4: {
                enumSet = EnumSet.of((Enum)ReaderConfiguration.ReaderType.MAGSTRIPE, (Enum)ReaderConfiguration.ReaderType.ICC);
                break;
            }
            case 5: {
                enumSet = EnumSet.of((Enum)ReaderConfiguration.ReaderType.MAGSTRIPE, (Enum)ReaderConfiguration.ReaderType.ICC, (Enum)ReaderConfiguration.ReaderType.NFC);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        EnumSet<Enum> interfaces = enumSet;
        boolean bl = false;
        EnumSet<Enum> it = interfaces;
        boolean bl2 = false;
        EnumSet<Enum> trimmedInterfaces = EnumSet.copyOf(it);
        if (isOffline) {
            trimmedInterfaces.remove((Object)ReaderConfiguration.ReaderType.MAGSTRIPE);
        }
        Intrinsics.checkNotNullExpressionValue(trimmedInterfaces, (String)"trimmedInterfaces");
        return trimmedInterfaces;
    }

    static /* synthetic */ EnumSet interfacesSupportedByTransaction$default(PaymentCollectionStateMachine paymentCollectionStateMachine, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, boolean bl, boolean bl2, DeviceType deviceType, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            bl2 = false;
        }
        if ((n2 & 8) != 0) {
            deviceType = DeviceType.UNKNOWN;
        }
        return paymentCollectionStateMachine.interfacesSupportedByTransaction(transactionType, bl, bl2, deviceType);
    }

    public final void setTippingSelectionResult(@NotNull TippingSelectionResult result2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            Amount tip = result2.getAmount();
            if (tip.getCurrency() != it.getAmount().getCurrency()) {
                throw new IllegalStateException(("Tip currency (" + tip.getCurrency() + ") not the same as transaction " + it.getAmount().getCurrency()).toString());
            }
            this.updateData(PaymentCollectionData.copy$default(it, null, null, new Amount(it.getBaseAmount().getValue() + tip.getValue(), it.getAmount().getCurrency()), null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, new TippingState.Completed(result2), null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -33554437, 1048575, null));
        }
    }

    public final void resetTipSelection() {
        block1: {
            if (this.getState() != PaymentCollectionState.COLLECTION) {
                LOGGER.w("Attempt to return to tip selection from an invalid state " + this.getState(), new Pair[0]);
                return;
            }
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.eventLoggers.getTippingLogger().logReselectTipping(it);
            this.updateData(PaymentCollectionData.copy$default(it, null, null, it.getBaseAmount(), null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, TippingState.SelectionNeeded.INSTANCE, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -33554437, 1048575, null));
        }
    }

    public final void setInterfaceResetRequired(boolean isRequired) {
        block0: {
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, isRequired, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -17, 1048575, null));
        }
    }

    public final void setCardSlotState(@NotNull ContactCardSlotState cardSlotState) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)cardSlotState), (String)"cardSlotState");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            boolean bl = paymentCollectionData != null ? paymentCollectionData.getShouldStartManualEntry() : false;
            if (bl && cardSlotState != ContactCardSlotState.EMPTY) {
                return;
            }
            PaymentCollectionData paymentCollectionData2 = (PaymentCollectionData)this.getData();
            if (paymentCollectionData2 == null) break block1;
            PaymentCollectionData it = paymentCollectionData2;
            boolean bl2 = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, cardSlotState, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -513, 1048575, null));
        }
    }

    public final void clearMagStripeReadState() {
        block1: {
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData data = paymentCollectionData;
            boolean bl = false;
            if (data.getMagStripeReadResult() != null) {
                this.updateData(PaymentCollectionData.copy$default(data, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -65, 1048575, null));
            }
        }
    }

    public final void setMagStripeReadResult(@NotNull MagStripeReadResult magStripeReadResult) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)magStripeReadResult, (String)"magStripeReadResult");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, magStripeReadResult, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -65, 1048575, null));
        }
    }

    public final void setApplicationList(@NotNull List<String> applicationList) {
        block0: {
            Intrinsics.checkNotNullParameter(applicationList, (String)"applicationList");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, applicationList, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -3073, 1048575, null));
        }
    }

    public final void onRequestAccountTypeSelection() {
        block0: {
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, AccountSelectionStatus.Requested.INSTANCE, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -8193, 1048575, null));
        }
    }

    public final void setSelectedApplicationIndex(int selectedApplicationIndex) {
        block0: {
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, selectedApplicationIndex, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -2049, 1048575, null));
        }
    }

    public final void setSelectedLanguage(@NotNull String selectedLanguage) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)selectedLanguage, (String)"selectedLanguage");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, selectedLanguage, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -4097, 1048575, null));
        }
    }

    public final void setSelectedAccountType(@NotNull AccountType selectedAccountType) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)selectedAccountType), (String)"selectedAccountType");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, new AccountSelectionStatus.AccountSelected(selectedAccountType), null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -8193, 1048575, null));
        }
    }

    public final void setShowThankYouReceived(boolean showThankYouReceived) {
        block0: {
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, showThankYouReceived, -1, 524287, null));
        }
    }

    public final void onPinEntryStatusChange(@NotNull PinEntryStatus status, @Nullable String epb, @Nullable String epbKsn) {
        block7: {
            PinEntryRetryReason pinEntryRetryReason;
            EarlyTransactionAbortReason earlyTransactionAbortReason;
            EarlyTransactionAbortReason earlyTransactionAbortReason2;
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (status == (paymentCollectionData != null ? paymentCollectionData.getPinEntryStatus() : null)) {
                return;
            }
            switch (WhenMappings.$EnumSwitchMapping$2[status.ordinal()]) {
                case 1: {
                    earlyTransactionAbortReason2 = EarlyTransactionAbortReason.PIN_ENTRY_CANCELED;
                    break;
                }
                case 2: {
                    earlyTransactionAbortReason2 = EarlyTransactionAbortReason.PIN_ENTRY_TIMED_OUT;
                    break;
                }
                default: {
                    earlyTransactionAbortReason2 = null;
                }
            }
            EarlyTransactionAbortReason earlyAbortReason = earlyTransactionAbortReason2;
            PinEntryRetryReason pinEntryRetryReason2 = this.pinEntryStatusToFailureReasonForViewModel(status);
            PaymentCollectionData paymentCollectionData2 = (PaymentCollectionData)this.getData();
            if (paymentCollectionData2 == null) break block7;
            PaymentCollectionData it = paymentCollectionData2;
            boolean bl = false;
            MagStripeReadResult magStripeReadResult = status == PinEntryStatus.ENTERED && it.getMagStripeReadResult() instanceof MagStripeReadSuccess ? (MagStripeReadResult)MagStripeReadSuccess.copy$default((MagStripeReadSuccess)it.getMagStripeReadResult(), null, null, null, null, null, epb, epbKsn, 31, null) : it.getMagStripeReadResult();
            EarlyTransactionAbortReason earlyTransactionAbortReason3 = earlyAbortReason;
            if (earlyTransactionAbortReason3 == null) {
                earlyTransactionAbortReason3 = earlyTransactionAbortReason = it.getEarlyTransactionAbortReason();
            }
            if ((pinEntryRetryReason = pinEntryRetryReason2) == null) {
                pinEntryRetryReason = it.getPinEntryRetryReason();
            }
            PinEntryRetryReason pinEntryRetryReason3 = pinEntryRetryReason;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, magStripeReadResult, false, false, null, null, null, null, null, status, pinEntryRetryReason3, 0, false, earlyTransactionAbortReason, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -376897, 1048575, null));
        }
    }

    public static /* synthetic */ void onPinEntryStatusChange$default(PaymentCollectionStateMachine paymentCollectionStateMachine, PinEntryStatus pinEntryStatus, String string, String string2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = null;
        }
        if ((n2 & 4) != 0) {
            string2 = null;
        }
        paymentCollectionStateMachine.onPinEntryStatusChange(pinEntryStatus, string, string2);
    }

    private final PinEntryRetryReason pinEntryStatusToFailureReasonForViewModel(PinEntryStatus pinEntryStatus) {
        PinEntryRetryReason pinEntryRetryReason;
        PinEntryStatus pinEntryStatus2 = pinEntryStatus;
        switch (pinEntryStatus2 == null ? -1 : WhenMappings.$EnumSwitchMapping$2[pinEntryStatus2.ordinal()]) {
            case 3: {
                pinEntryRetryReason = PinEntryRetryReason.WRONG_PIN_LENGTH;
                break;
            }
            case 4: {
                pinEntryRetryReason = PinEntryRetryReason.INCORRECT_PIN;
                break;
            }
            default: {
                pinEntryRetryReason = null;
            }
        }
        return pinEntryRetryReason;
    }

    public final void setPinEntryAsterisks(int count) {
        block0: {
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, count, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -65537, 1048575, null));
        }
    }

    public final void setEarlyTransactionAbortReason(@NotNull EarlyTransactionAbortReason reason) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, reason, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -262145, 1048575, null));
        }
    }

    public final void setOnlineAuthorizationData(@NotNull String onlineAuthorizationData) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)onlineAuthorizationData, (String)"onlineAuthorizationData");
            if (PaymentCollectionStatesKt.interfaceTypeFromTlv(onlineAuthorizationData) == null) {
                LOGGER.w("Ignore invalid onlineAuthorizationData " + onlineAuthorizationData, new Pair[0]);
                return;
            }
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, onlineAuthorizationData, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -524289, 1048575, null));
        }
    }

    public final void setFinalConfirmation(@NotNull String tlv) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)tlv, (String)"tlv");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            if (it.getOnlineAuthorizationData() != null) {
                this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, tlv, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -8388609, 1048575, null));
            }
        }
    }

    public final void setOnlineAuthResponse(@NotNull String response) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, response, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -2097153, 1048575, null));
        }
    }

    public final void updateChargeAttempt(@Nullable ChargeAttempt chargeAttempt) {
        block1: {
            LOGGER.d("updateChargeAttempt " + chargeAttempt, new Pair[0]);
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            PaymentCollectionData newData = PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, chargeAttempt, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -16777217, 1048575, null);
            this.updateData(newData);
            ChargeAttempt chargeAttempt2 = chargeAttempt;
            if (chargeAttempt2 != null) {
                ChargeAttempt it2 = chargeAttempt2;
                boolean bl2 = false;
                this.eventLoggers.getDiscreteEventLogger().logOnlineConfirmResult(newData);
            }
        }
    }

    public final void setHardwareTransactionResult(@NotNull TransactionResult.Result result2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, result2, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -268435457, 1048575, null));
        }
    }

    public final void setIntermediateError(@NotNull IntermediateTransactionError error) {
        block4: {
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)((Object)error), (String)"error");
                    if (error != IntermediateTransactionError.CONTACTLESS_LIMIT_EXCEEDED) break block2;
                    PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
                    if ((paymentCollectionData != null ? paymentCollectionData.getTransactionType() : null) == com.stripe.core.hardware.paymentcollection.TransactionType.SETUP) break block3;
                    PaymentCollectionData paymentCollectionData2 = (PaymentCollectionData)this.getData();
                    if ((paymentCollectionData2 != null ? paymentCollectionData2.getTransactionType() : null) != com.stripe.core.hardware.paymentcollection.TransactionType.REUSABLE_CARD) break block2;
                }
                return;
            }
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block4;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, error, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -536870913, 1048575, null));
        }
    }

    public final void setActiveReaderInterfaces(@NotNull EnumSet<ReaderConfiguration.ReaderType> activeReaderInterfaces) {
        block1: {
            Intrinsics.checkNotNullParameter(activeReaderInterfaces, (String)"activeReaderInterfaces");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            if (!Intrinsics.areEqual(activeReaderInterfaces, it.getActiveReaderInterfacesForDisplay())) {
                this.eventLoggers.getDiscreteEventLogger().logReaderInterfaceChanged(activeReaderInterfaces);
                this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, activeReaderInterfaces, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -1, 1048559, null));
            }
        }
    }

    public final boolean isFinished() {
        return this.getState() == PaymentCollectionState.FINISHED;
    }

    public final void onOnlineAuthStateChanged(@NotNull OnlineAuthState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.eventLoggers.getOnlineAuthStateLogger().updateOnlineAuthState(state, (PaymentCollectionData)this.getData());
    }

    public final void setManualEntryResult(@NotNull ManualEntryResult manualEntryResult) {
        Intrinsics.checkNotNullParameter((Object)manualEntryResult, (String)"manualEntryResult");
        this.manualEntryStateMachine.setManualEntryResult(manualEntryResult);
    }

    public final void setUserRetryRequested() {
        block0: {
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, true, null, null, false, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, Integer.MAX_VALUE, 1048575, null));
        }
    }

    public final void onDeviceKernelBusy() {
        block1: {
            StateMachine.StateHandler stateHandler = this.getStateHandler();
            if (stateHandler == null) break block1;
            StateMachine.StateHandler handler2 = stateHandler;
            boolean bl = false;
            PaymentCollectionData data = (PaymentCollectionData)this.getData();
            Object object = data;
            boolean bl2 = object != null && (object = ((PaymentCollectionData)object).getDeviceCapability()) != null ? !((PaymentCollectionDeviceCapability)object).getDirectlyControlsScreenInput() : false;
            if (bl2 && handler2 instanceof PaymentCollectionScreenInputStateHandler) {
                ((PaymentCollectionScreenInputStateHandler)handler2).onImplicitSelection(data);
            }
        }
    }

    public final void setHardwareTippingSelectionResult(@NotNull TipSelectionResult hardwareResult) {
        block6: {
            TippingSelectionResult tippingSelectionResult;
            Intrinsics.checkNotNullParameter((Object)hardwareResult, (String)"hardwareResult");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block6;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            CurrencyCode currency = it.getAmount().getCurrency();
            TipSelectionResult tipSelectionResult = hardwareResult;
            if (Intrinsics.areEqual((Object)tipSelectionResult, (Object)NoTipSelected.INSTANCE)) {
                tippingSelectionResult = new TippingSelectionResult(new Amount(0L, currency), TippingSelectionType.NO_TIP, null, 4, null);
            } else if (tipSelectionResult instanceof TipSelected) {
                TippingSelectionType tipSelectionType = this.determineTipSelectionType(it.getTippingConfig(), ((TipSelected)hardwareResult).getBbposSdkTipSelectionType());
                tippingSelectionResult = new TippingSelectionResult(new Amount(((TipSelected)hardwareResult).getTipsAmount(), currency), tipSelectionType, null, 4, null);
            } else if (tipSelectionResult instanceof TipSelectionFailure) {
                tippingSelectionResult = new TippingSelectionResult(new Amount(0L, currency), TippingSelectionType.NO_TIP, ((TipSelectionFailure)hardwareResult).getTippingSelectionFailureReason());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            TippingSelectionResult tippingSelectionResult2 = tippingSelectionResult;
            this.setTippingSelectionResult(tippingSelectionResult2);
        }
    }

    private final TippingSelectionType determineTipSelectionType(TipConfigValidationResult config, BbposSdkTipSelectionType bbposSdkTipSelectionType) {
        TippingSelectionType tippingSelectionType;
        Object object = config;
        boolean isSmartTip = object instanceof FixedAmountTips ? ((FixedAmountTips)config).isSmartTip() : (object instanceof PercentageTips ? ((PercentageTips)config).isSmartTip() : false);
        object = bbposSdkTipSelectionType;
        if (Intrinsics.areEqual((Object)object, (Object)FixedAmount.INSTANCE)) {
            tippingSelectionType = isSmartTip ? TippingSelectionType.SELECTED_FIXED_SMART_TIP : TippingSelectionType.SELECTED_FIXED;
        } else if (Intrinsics.areEqual((Object)object, (Object)Percentage.INSTANCE)) {
            tippingSelectionType = isSmartTip ? TippingSelectionType.SELECTED_PERCENTAGE_SMART_TIP : TippingSelectionType.SELECTED_PERCENTAGE;
        } else if (Intrinsics.areEqual((Object)object, (Object)Unknown.INSTANCE)) {
            tippingSelectionType = TippingSelectionType.NO_TIP_SELECTION_TYPE_FROM_BBPOS;
        } else if (Intrinsics.areEqual((Object)object, (Object)Custom.INSTANCE)) {
            tippingSelectionType = TippingSelectionType.CUSTOMIZED;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return tippingSelectionType;
    }

    public final void setManualEntryCollectionResult(@NotNull ManualEntryCollectionResult result2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.updateData(PaymentCollectionData.copy$default(it, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, false, null, null, null, false, false, null, null, null, null, null, result2, false, false, null, null, false, false, -1, 1040383, null));
        }
    }

    public final void onHardwareTransactionCanceled() {
        if (this.getState() == PaymentCollectionState.TIPPING_SELECTION) {
            return;
        }
        PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
        if (paymentCollectionData == null) {
            return;
        }
        PaymentCollectionData data = paymentCollectionData;
        if (data.isCancelled()) {
            this.updateData(PaymentCollectionData.copy$default(data, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, null, null, true, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -1, 1048571, null));
        } else {
            this.startCancellation(CancelReason.HARDWARE_CANCELLED);
        }
    }

    public final void onMerchantTransactionCanceled() {
        this.startCancellation(CancelReason.MERCHANT_CANCELLED);
    }

    private final void startCancellation(CancelReason reason) {
        PaymentCollectionState paymentCollectionState = (PaymentCollectionState)((Object)this.getState());
        if (paymentCollectionState == null) {
            return;
        }
        PaymentCollectionState state = paymentCollectionState;
        PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
        if (paymentCollectionData == null) {
            return;
        }
        PaymentCollectionData data = paymentCollectionData;
        if (data.isCancelled()) {
            return;
        }
        this.updateData(PaymentCollectionData.copy$default(data, null, null, null, null, false, 0, null, false, false, null, null, null, null, null, null, null, 0, false, null, null, false, null, false, null, null, null, null, null, null, null, null, false, state, reason, reason == CancelReason.HARDWARE_CANCELLED, null, null, null, false, false, null, null, null, null, null, null, false, false, null, null, false, false, -1, 1048568, null));
    }

    public final void dispose() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
    }

    static {
        Object[] objectArray = new DeviceType[]{DeviceType.WISEPAD_3S, DeviceType.WISEPAD_3};
        WISEPAD_3_DEVICES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/stripe/core/paymentcollection/PaymentCollectionStateMachine$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "TAG", "", "WISEPAD_3_DEVICES", "", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "paymentcollection_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[PaymentCollectionState.values().length];
            try {
                nArray[PaymentCollectionState.EMPTY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.DISPLAY_CART_PRE_COLLECTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.DISPLAY_CART_POST_COLLECTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.TIPPING_SELECTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.COLLECTION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.MANUAL_ENTRY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.PROCESSING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.APPLICATION_SELECTION.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.LANGUAGE_SELECTION.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.ACCOUNT_SELECTION.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.PIN_ENTRY.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.MAGSTRIPE_PIN_ENTRY.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.RECOVERABLE_ERROR_SUMMARY.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.ONLINE_AUTHORIZATION.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.ONLINE_AUTHORIZATION_MAG_STRIPE.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.REMOVE_CARD.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.ONLINE_CONFIRMATION.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.COLLECTION_COMPLETE.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.CANCEL.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.FINISHED.ordinal()] = 21;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentCollectionState.TIMEOUT.ordinal()] = 22;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[com.stripe.core.hardware.paymentcollection.TransactionType.values().length];
            try {
                nArray[com.stripe.core.hardware.paymentcollection.TransactionType.STRONG_CUSTOMER_AUTHENTICATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.stripe.core.hardware.paymentcollection.TransactionType.CHARGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.stripe.core.hardware.paymentcollection.TransactionType.REFUND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.stripe.core.hardware.paymentcollection.TransactionType.REUSABLE_CARD.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.stripe.core.hardware.paymentcollection.TransactionType.SETUP.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PinEntryStatus.values().length];
            try {
                nArray[PinEntryStatus.CANCEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.TIMEOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.WRONG_PIN_LENGTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.INCORRECT_PIN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

