/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.PinEntryStatus;
import com.stripe.core.paymentcollection.HardwareTransactionCancelledEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.metrics.PinEntryFailureReason;
import com.stripe.core.paymentcollection.metrics.Result;
import com.stripe.core.paymentcollection.metrics.StageEventLogger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/stripe/core/paymentcollection/PinEntryHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "onEnter", "", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onExit", "to", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
public final class PinEntryHandler
extends PaymentCollectionStateHandler {
    public PinEntryHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.PIN_ENTRY, coroutineScope, null, 4, null);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block0: {
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.onPaymentCollectionDataUpdate(it, null);
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        PaymentCollectionData paymentCollectionData2 = old;
        if (paymentCollectionData.getPinEntryStatus() != (paymentCollectionData2 != null ? paymentCollectionData2.getPinEntryStatus() : null)) {
            switch (WhenMappings.$EnumSwitchMapping$0[paymentCollectionData.getPinEntryStatus().ordinal()]) {
                case 1: {
                    this.transitionTo(PaymentCollectionState.PROCESSING, "PIN verified.");
                    StageEventLogger.closePinEntryLog$default(this.getStageEventLogger(), Result.SUCCESS, paymentCollectionData, null, 4, null);
                    return;
                }
                case 2: {
                    this.generateStartPinEntryEvent();
                    this.getStageEventLogger().openPinEntryLog();
                    break;
                }
                case 3: {
                    this.getStageEventLogger().closePinEntryLog(Result.FAILURE, paymentCollectionData, PinEntryFailureReason.CUSTOMER_CANCELLED);
                    if (!paymentCollectionData.getDeviceCapability().getRetryUponPinCancel()) {
                        this.yieldEvent(HardwareTransactionCancelledEvent.INSTANCE);
                    } else {
                        this.transitionTo(PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN, "PIN entry canceled.");
                    }
                    return;
                }
                case 4: 
                case 5: {
                    StageEventLogger.closePinEntryLog$default(this.getStageEventLogger(), Result.FAILURE, paymentCollectionData, null, 4, null);
                    this.transitionTo(PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN, "PIN entry aborted.");
                    return;
                }
                case 6: 
                case 7: 
                case 8: {
                    StageEventLogger.closePinEntryLog$default(this.getStageEventLogger(), Result.FAILURE, paymentCollectionData, null, 4, null);
                }
            }
        }
        if (paymentCollectionData.getOnlineAuthorizationData() != null && paymentCollectionData.getPinEntryStatus() != PinEntryStatus.REQUESTED) {
            this.transitionTo(PaymentCollectionState.PROCESSING, "PIN entered.");
            StageEventLogger.closePinEntryLog$default(this.getStageEventLogger(), Result.SUCCESS, paymentCollectionData, null, 4, null);
            return;
        }
        if (paymentCollectionData.isDeclined()) {
            this.transitionTo(PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN, "Transaction declined. Prepare to collect again.");
            return;
        }
        this.generateUserInteractionEvent(paymentCollectionData.getAmount(), paymentCollectionData.getPinAsterisks(), paymentCollectionData.getSelectedLanguage(), paymentCollectionData.getPinEntryRetryReason());
    }

    @Override
    public void onExit(@NotNull PaymentCollectionState to) {
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        super.onExit(to);
        if (to == PaymentCollectionState.CANCEL) {
            StageEventLogger stageEventLogger = this.getStageEventLogger();
            Object d2 = this.getData();
            Intrinsics.checkNotNull(d2);
            stageEventLogger.closePinEntryLog(Result.FAILURE, (PaymentCollectionData)d2, PinEntryFailureReason.MERCHANT_CANCELLED);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PinEntryStatus.values().length];
            try {
                nArray[PinEntryStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.REQUESTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.CANCEL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.ICC_REMOVED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.TIMEOUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.BYPASS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.WRONG_PIN_LENGTH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.INCORRECT_PIN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.NOT_REQUESTED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.ENTERED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

