/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.ContactCardSlotState;
import com.stripe.core.hardware.paymentcollection.RecoverableError;
import com.stripe.core.hardware.paymentcollection.RemoveCardModel;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PresentProcessingEvent;
import com.stripe.core.paymentcollection.PresentRemoveCardEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/stripe/core/paymentcollection/PrepareToCollectAgainHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "onEnter", "", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
public final class PrepareToCollectAgainHandler
extends PaymentCollectionStateHandler {
    public PrepareToCollectAgainHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN, coroutineScope, null, 4, null);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block0: {
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData data = paymentCollectionData;
            boolean bl = false;
            this.getCollectionEventLogger().end(data, (PaymentCollectionState)((Object)this.getState()));
            this.onPaymentCollectionDataUpdate(data, data);
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        boolean isReadyToRecollect;
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        boolean isCardRemoved = paymentCollectionData.getCardSlotState() == ContactCardSlotState.EMPTY;
        boolean isCardInsertedIncorrectly = paymentCollectionData.getCardSlotState() == ContactCardSlotState.CARD_INSERTED_INCORRECTLY;
        boolean isTransactionTerminated = paymentCollectionData.getHardwareTransactionResult() != null;
        boolean bl = isReadyToRecollect = isCardRemoved && isTransactionTerminated;
        if (isReadyToRecollect) {
            this.transitionTo(PaymentCollectionState.RECOVERABLE_ERROR_SUMMARY, "Transaction can be recovered.");
            return;
        }
        if (isTransactionTerminated && !isCardRemoved) {
            this.generateStartPollingForCardStatusEvent();
        }
        if (!isCardRemoved) {
            this.yieldEvent(new PresentRemoveCardEvent(new RemoveCardModel(paymentCollectionData.getAmount(), paymentCollectionData.getSelectedLanguage(), isCardInsertedIncorrectly ? RecoverableError.CHIP_CARD_INSERTED_INCORRECTLY : null)));
        } else {
            this.yieldEvent(new PresentProcessingEvent(paymentCollectionData.getAmount()));
        }
    }
}

