/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.PinEntryStatus;
import com.stripe.core.paymentcollection.AccountSelectionStatus;
import com.stripe.core.paymentcollection.EarlyTransactionAbortReason;
import com.stripe.core.paymentcollection.MagStripePinStatus;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PresentProcessingEvent;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u001a\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/stripe/core/paymentcollection/ProcessingHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "generatePresentProcessingEvent", "", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "onEnter", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
public final class ProcessingHandler
extends PaymentCollectionStateHandler {
    public ProcessingHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.PROCESSING, coroutineScope, 30000L);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block0: {
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData data = paymentCollectionData;
            boolean bl = false;
            this.generatePresentProcessingEvent(data.getAmount());
            this.onPaymentCollectionDataUpdate(data, data);
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        boolean readyForMagStripeAuth;
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        boolean hasEmptyCandidateList = paymentCollectionData.getEarlyTransactionAbortReason() == EarlyTransactionAbortReason.EMPTY_CANDIDATE_LIST || paymentCollectionData.getHardwareTransactionResult() == TransactionResult.Result.EMPTY_CANDIDATE_LIST;
        boolean hasSelectedApplication = paymentCollectionData.getSelectedApplicationIndex() != null;
        boolean hasApplicationsToSelect = !((Collection)paymentCollectionData.getApplicationList()).isEmpty();
        boolean accountSelectionNeeded = Intrinsics.areEqual((Object)paymentCollectionData.getAccountSelectionStatus(), (Object)AccountSelectionStatus.Requested.INSTANCE);
        boolean hasRequestedPin = paymentCollectionData.getPinEntryStatus() == PinEntryStatus.REQUESTED;
        boolean hasOnlineAuthorizationData = paymentCollectionData.getOnlineAuthorizationData() != null;
        boolean bl = readyForMagStripeAuth = paymentCollectionData.getMagStripePaymentCollectionAuthority() != null && !Intrinsics.areEqual((Object)paymentCollectionData.getMagStripePinStatus(), (Object)MagStripePinStatus.ToCollect.INSTANCE);
        if (hasEmptyCandidateList) {
            this.transitionTo(PaymentCollectionState.PREPARE_TO_COLLECT_AGAIN, "Empty candidate list.");
        } else if (hasApplicationsToSelect && !hasSelectedApplication) {
            this.transitionTo(PaymentCollectionState.APPLICATION_SELECTION, "Application selection requested.");
        } else if (accountSelectionNeeded) {
            this.transitionTo(PaymentCollectionState.ACCOUNT_SELECTION, "Account selection requested.");
        } else if (hasRequestedPin) {
            if (Intrinsics.areEqual((Object)paymentCollectionData.getMagStripePinStatus(), (Object)MagStripePinStatus.ToCollect.INSTANCE)) {
                this.transitionTo(PaymentCollectionState.MAGSTRIPE_PIN_ENTRY, "MagStripe Pin entry requested.");
            } else {
                this.transitionTo(PaymentCollectionState.PIN_ENTRY, "Pin entry requested.");
            }
        } else if (hasOnlineAuthorizationData) {
            this.transitionTo(PaymentCollectionState.ONLINE_AUTHORIZATION, "Online authorization data obtained.");
        } else if (readyForMagStripeAuth) {
            this.transitionTo(PaymentCollectionState.ONLINE_AUTHORIZATION_MAG_STRIPE, "MagStripe online auth ready.");
        } else if (this.checkForPrematureTransactionCompletionAndTransitionIfNeeded(paymentCollectionData)) {
            return;
        }
    }

    private final void generatePresentProcessingEvent(Amount amount) {
        this.yieldEvent(new PresentProcessingEvent(amount));
    }
}

