/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.RecoverableError;
import com.stripe.core.hardware.paymentcollection.RecoverableErrorModel;
import com.stripe.core.paymentcollection.DisplayRecoverableErrorEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/stripe/core/paymentcollection/RecoverableErrorSummaryHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "onEnter", "", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onExit", "to", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
public final class RecoverableErrorSummaryHandler
extends PaymentCollectionStateHandler {
    public RecoverableErrorSummaryHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.RECOVERABLE_ERROR_SUMMARY, coroutineScope, 30000L);
    }

    @Override
    public void onExit(@NotNull PaymentCollectionState to) {
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        super.onExit(to);
        if (to == PaymentCollectionState.COLLECTION) {
            this.clearContactCardStateAndPrepareNextCollection();
            this.getCollectionEventLogger().start();
        }
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        boolean isTerminatedWithoutIntermediateError;
        boolean bl;
        Object object;
        RecoverableError recoverableError;
        RecoverableError recoverableError2;
        boolean directlyControlsScreenInput;
        boolean bl2;
        PaymentCollectionData data;
        super.onEnter(current, from);
        PaymentCollectionData paymentCollectionData = current;
        if (paymentCollectionData != null) {
            data = paymentCollectionData;
            boolean bl3 = false;
            bl2 = data.getDeviceCapability().getDirectlyControlsScreenInput();
        } else {
            bl2 = directlyControlsScreenInput = false;
        }
        if (!directlyControlsScreenInput) {
            this.transitionTo(PaymentCollectionState.COLLECTION, "Ready to collect again - does not control input.");
            return;
        }
        PaymentCollectionData paymentCollectionData2 = current;
        if (paymentCollectionData2 != null) {
            data = paymentCollectionData2;
            boolean bl4 = false;
            recoverableError2 = data.getHardwareTransactionResult() != null ? RecoverableError.Companion.fromTransactionResult(data.getHardwareTransactionResult()) : null;
        } else {
            recoverableError2 = recoverableError = null;
        }
        boolean isInTechnicalFallback = recoverableError == RecoverableError.CARD_REMOVED_TOO_SOON && ((object = current) != null && (object = ((PaymentCollectionData)object).getApplicationList()) != null ? object.isEmpty() : false);
        PaymentCollectionData paymentCollectionData3 = current;
        if (paymentCollectionData3 != null) {
            boolean isEarlyTransactionAbortReasonUnspecified;
            PaymentCollectionData data2 = paymentCollectionData3;
            boolean bl5 = false;
            boolean isTerminated = data2.getHardwareTransactionResult() == TransactionResult.Result.TERMINATED;
            boolean isIntermediateTransactionErrorUnspecified = data2.getIntermediateTransactionError() == null;
            boolean bl6 = isEarlyTransactionAbortReasonUnspecified = data2.getEarlyTransactionAbortReason() == null;
            bl = isTerminated && isIntermediateTransactionErrorUnspecified && isEarlyTransactionAbortReasonUnspecified;
        } else {
            bl = isTerminatedWithoutIntermediateError = false;
        }
        if (isInTechnicalFallback) {
            this.transitionTo(PaymentCollectionState.COLLECTION, "Ready to collect again - technical fallback.");
        } else if (recoverableError != null) {
            this.yieldEvent(new DisplayRecoverableErrorEvent(new RecoverableErrorModel(recoverableError)));
        } else if (isTerminatedWithoutIntermediateError) {
            this.yieldEvent(new DisplayRecoverableErrorEvent(new RecoverableErrorModel(RecoverableError.DECLINED)));
        } else {
            this.transitionTo(PaymentCollectionState.COLLECTION, "Ready to collect again - no result.");
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
            super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
            PaymentCollectionData paymentCollectionData2 = (PaymentCollectionData)this.getData();
            if (paymentCollectionData2 == null) break block1;
            PaymentCollectionData updatedData = paymentCollectionData2;
            boolean bl = false;
            if (updatedData.getUserRetryRequested()) {
                this.transitionTo(PaymentCollectionState.COLLECTION, "Ready to collect again - retry requested.");
            }
        }
    }
}

