/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.ContactCardSlotState;
import com.stripe.core.hardware.paymentcollection.RemoveCardModel;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PresentRemoveCardEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0016J\u001a\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/stripe/core/paymentcollection/RemoveCardHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "onEnter", "", "current", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onExit", "to", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
@SourceDebugExtension(value={"SMAP\nPaymentCollectionStates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentCollectionStates.kt\ncom/stripe/core/paymentcollection/RemoveCardHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,2480:1\n1#2:2481\n*E\n"})
public final class RemoveCardHandler
extends PaymentCollectionStateHandler {
    public RemoveCardHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.REMOVE_CARD, coroutineScope, null, 4, null);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block0: {
            super.onEnter(current, from);
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.getStageEventLogger().openRemoveCardLog();
            this.generateStartPollingForCardStatusEvent();
            this.onPaymentCollectionDataUpdate(it, it);
        }
    }

    @Override
    public void onExit(@NotNull PaymentCollectionState to) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
            super.onExit(to);
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block0;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.getStageEventLogger().closeRemoveCardLog(it);
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        if (paymentCollectionData.getCardSlotState() == ContactCardSlotState.EMPTY) {
            this.transitionTo(PaymentCollectionState.COLLECTION_COMPLETE, "Card removed.");
        } else {
            this.yieldEvent(new PresentRemoveCardEvent(new RemoveCardModel(paymentCollectionData.getAmount(), paymentCollectionData.getSelectedLanguage(), null, 4, null)));
        }
    }
}

