/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.TippingSelectionModel;
import com.stripe.core.paymentcollection.CancelHardwareTippingCollectionEvent;
import com.stripe.core.paymentcollection.HardwareTippingCollectionEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.PaymentCollectionStateHandler;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.TippingSelectionEvent;
import com.stripe.core.paymentcollection.TippingState;
import com.stripe.jvmcore.currency.Amount;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J\u001a\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/stripe/core/paymentcollection/TippingHandler;", "Lcom/stripe/core/paymentcollection/PaymentCollectionStateHandler;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "generateCancelCollectTippingThroughKernelEvent", "", "generateCollectTippingThroughKernelEvent", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "generateUserInteractionEvent", "onEnter", "current", "from", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "onExit", "to", "onPaymentCollectionDataUpdate", "new", "old", "paymentcollection_release"})
public final class TippingHandler
extends PaymentCollectionStateHandler {
    public TippingHandler(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(PaymentCollectionState.TIPPING_SELECTION, coroutineScope, null, 4, null);
    }

    @Override
    public void onEnter(@Nullable PaymentCollectionData current, @Nullable PaymentCollectionState from) {
        block2: {
            super.onEnter(current, from);
            PaymentCollectionStatesKt.access$getLOGGER$p().i("TippingHandler.onEnter", new Pair[0]);
            this.getTippingLogger().openTippingSelectionLog();
            PaymentCollectionData paymentCollectionData = current;
            if (paymentCollectionData == null) break block2;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            if (it.getDeviceCapability().getDirectlyControlsScreenInput()) {
                this.generateUserInteractionEvent(it);
            } else {
                this.generateCollectTippingThroughKernelEvent(it);
            }
        }
    }

    @Override
    public void onExit(@NotNull PaymentCollectionState to) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
            super.onExit(to);
            PaymentCollectionData paymentCollectionData = (PaymentCollectionData)this.getData();
            if (paymentCollectionData == null) break block1;
            PaymentCollectionData it = paymentCollectionData;
            boolean bl = false;
            this.getTippingLogger().closeTippingSelectionLog(it);
            if (!it.getDeviceCapability().getDirectlyControlsScreenInput()) {
                this.generateCancelCollectTippingThroughKernelEvent();
            }
        }
    }

    @Override
    public void onPaymentCollectionDataUpdate(@NotNull PaymentCollectionData paymentCollectionData, @Nullable PaymentCollectionData old) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionData, (String)"new");
        PaymentCollectionStatesKt.access$getLOGGER$p().i("TippingHandler.onPaymentCollectionDataUpdate", new Pair[0]);
        super.onPaymentCollectionDataUpdate(paymentCollectionData, old);
        if (paymentCollectionData.getTippingState() instanceof TippingState.Completed) {
            this.transitionTo(PaymentCollectionState.COLLECTION, "Tipping completed.");
        }
    }

    private final void generateUserInteractionEvent(PaymentCollectionData data) {
        Amount amount = data.getAmount();
        Amount amount2 = data.getTipEligibleAmount();
        if (amount2 == null) {
            amount2 = data.getAmount();
        }
        TippingSelectionModel tipping = new TippingSelectionModel(amount, amount2);
        this.yieldEvent(new TippingSelectionEvent(tipping));
    }

    private final void generateCollectTippingThroughKernelEvent(PaymentCollectionData data) {
        this.yieldEvent(new HardwareTippingCollectionEvent(data.getTippingConfig()));
    }

    private final void generateCancelCollectTippingThroughKernelEvent() {
        this.yieldEvent(CancelHardwareTippingCollectionEvent.INSTANCE);
    }
}

