/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection;

import com.stripe.core.hardware.paymentcollection.PinEntryStatus;
import com.stripe.core.paymentcollection.metrics.PinEntryFailureReason;
import com.stripe.core.transaction.Summary;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.stripeterminal.external.models.DeviceType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001ad\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0000\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0017\u00a8\u0006\u0018"}, d2={"generateConfigureReaderEvent", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration;", "readerType", "Ljava/util/EnumSet;", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$ReaderType;", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "transactionType", "Lcom/stripe/core/hardware/paymentcollection/TransactionType;", "emvTransactionType", "Lcom/stripe/jvmcore/hardware/emv/TransactionType;", "isOffline", "", "isDeferredAuthorizationCountry", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "domesticDebitPriority", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$DomesticDebitPriority;", "domesticDebitAids", "", "", "toFailureReason", "Lcom/stripe/core/paymentcollection/metrics/PinEntryFailureReason;", "Lcom/stripe/core/hardware/paymentcollection/PinEntryStatus;", "paymentcollection_release"})
public final class UtilsKt {
    @NotNull
    public static final ReaderConfiguration generateConfigureReaderEvent(@NotNull EnumSet<ReaderConfiguration.ReaderType> readerType, @NotNull Amount amount, @NotNull com.stripe.core.hardware.paymentcollection.TransactionType transactionType, @NotNull TransactionType emvTransactionType, boolean isOffline, boolean isDeferredAuthorizationCountry, @NotNull DeviceType deviceType, @Nullable ReaderConfiguration.DomesticDebitPriority domesticDebitPriority, @NotNull List<String> domesticDebitAids) {
        ReaderConfiguration.TransactionType transactionType2;
        ReaderConfiguration.QuickChipOption quickChipOption;
        Intrinsics.checkNotNullParameter(readerType, (String)"readerType");
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)"transactionType");
        Intrinsics.checkNotNullParameter((Object)((Object)emvTransactionType), (String)"emvTransactionType");
        Intrinsics.checkNotNullParameter((Object)deviceType, (String)"deviceType");
        Intrinsics.checkNotNullParameter(domesticDebitAids, (String)"domesticDebitAids");
        switch (WhenMappings.$EnumSwitchMapping$0[transactionType.ordinal()]) {
            case 1: {
                quickChipOption = ReaderConfiguration.QuickChipOption.USE_QUICKCHIP;
                break;
            }
            case 2: 
            case 3: {
                quickChipOption = ReaderConfiguration.QuickChipOption.USE_CONFIG;
                break;
            }
            case 4: 
            case 5: {
                if (isDeferredAuthorizationCountry && isOffline) {
                    quickChipOption = ReaderConfiguration.QuickChipOption.USE_QUICKCHIP;
                    break;
                }
                quickChipOption = ReaderConfiguration.QuickChipOption.USE_CONFIG;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ReaderConfiguration.QuickChipOption quickChipMode = quickChipOption;
        Pair pair = isOffline ? Summary.Companion.disableOnlinePinSettings(deviceType) : TuplesKt.to(null, null);
        String terminalCapabilitiesOverride = (String)pair.component1();
        ReaderConfiguration.ContactlessOnlinePinOption contactlessOnlinePinOption = (ReaderConfiguration.ContactlessOnlinePinOption)((Object)pair.component2());
        switch (WhenMappings.$EnumSwitchMapping$0[transactionType.ordinal()]) {
            case 2: {
                transactionType2 = ReaderConfiguration.TransactionType.REFUND;
                break;
            }
            case 5: {
                transactionType2 = ReaderConfiguration.TransactionType.GOODS;
                break;
            }
            case 1: {
                transactionType2 = ReaderConfiguration.TransactionType.GOODS;
                break;
            }
            case 3: {
                transactionType2 = ReaderConfiguration.TransactionType.GOODS;
                break;
            }
            case 4: {
                transactionType2 = ReaderConfiguration.TransactionType.GOODS;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ReaderConfiguration.TransactionType transactionType3 = transactionType2;
        ReaderConfiguration.DomesticDebitPriority domesticDebitPriority2 = Summary.Companion.domesticDebitPriorityOverride(domesticDebitPriority, domesticDebitAids, isOffline);
        return new ReaderConfiguration(readerType, amount, transactionType3, emvTransactionType, quickChipMode, terminalCapabilitiesOverride, domesticDebitPriority2, contactlessOnlinePinOption);
    }

    public static /* synthetic */ ReaderConfiguration generateConfigureReaderEvent$default(EnumSet enumSet, Amount amount, com.stripe.core.hardware.paymentcollection.TransactionType transactionType, TransactionType transactionType2, boolean bl, boolean bl2, DeviceType deviceType, ReaderConfiguration.DomesticDebitPriority domesticDebitPriority, List list, int n2, Object object) {
        if ((n2 & 0x40) != 0) {
            deviceType = DeviceType.UNKNOWN;
        }
        if ((n2 & 0x80) != 0) {
            domesticDebitPriority = null;
        }
        if ((n2 & 0x100) != 0) {
            list = CollectionsKt.emptyList();
        }
        return UtilsKt.generateConfigureReaderEvent(enumSet, amount, transactionType, transactionType2, bl, bl2, deviceType, domesticDebitPriority, list);
    }

    @Nullable
    public static final PinEntryFailureReason toFailureReason(@NotNull PinEntryStatus $this$toFailureReason) {
        PinEntryFailureReason pinEntryFailureReason;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toFailureReason), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toFailureReason.ordinal()]) {
            case 1: {
                pinEntryFailureReason = PinEntryFailureReason.CUSTOMER_CANCELLED;
                break;
            }
            case 2: {
                pinEntryFailureReason = PinEntryFailureReason.TIMEOUT;
                break;
            }
            case 3: {
                pinEntryFailureReason = PinEntryFailureReason.BYPASSED;
                break;
            }
            case 4: {
                pinEntryFailureReason = PinEntryFailureReason.WRONG_PIN_LENGTH;
                break;
            }
            case 5: {
                pinEntryFailureReason = PinEntryFailureReason.INCORRECT_PIN;
                break;
            }
            case 6: {
                pinEntryFailureReason = PinEntryFailureReason.ICC_REMOVED;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                pinEntryFailureReason = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return pinEntryFailureReason;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[com.stripe.core.hardware.paymentcollection.TransactionType.values().length];
            try {
                nArray[com.stripe.core.hardware.paymentcollection.TransactionType.SETUP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.stripe.core.hardware.paymentcollection.TransactionType.REFUND.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.stripe.core.hardware.paymentcollection.TransactionType.REUSABLE_CARD.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.stripe.core.hardware.paymentcollection.TransactionType.STRONG_CUSTOMER_AUTHENTICATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.stripe.core.hardware.paymentcollection.TransactionType.CHARGE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PinEntryStatus.values().length];
            try {
                nArray[PinEntryStatus.CANCEL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.TIMEOUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.BYPASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.WRONG_PIN_LENGTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.INCORRECT_PIN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.ICC_REMOVED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.NOT_REQUESTED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.REQUESTED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.ENTERED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.SUCCESS.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

