/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.dagger;

import com.stripe.core.hardware.paymentcollection.ManualEntryEventReceiver;
import com.stripe.core.hardware.paymentcollection.PaymentEventReceiver;
import com.stripe.core.paymentcollection.PaymentCollectionCoordinator;
import com.stripe.core.paymentcollection.PaymentCollectionEventDelegate;
import com.stripe.core.paymentcollection.manualentry.ManualEntryStateMachine;
import com.stripe.core.paymentcollection.metrics.dagger.PaymentCollectionLoggerModule;
import com.stripe.jvmcore.dagger.PaymentCollection;
import dagger.Module;
import dagger.Provides;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;

@Module(includes={PaymentCollectionLoggerModule.class})
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/stripe/core/paymentcollection/dagger/PaymentCollectionModule;", "", "()V", "providePaymentCollectionDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "providePaymentCollectionEventDelegate", "Lcom/stripe/core/paymentcollection/PaymentCollectionEventDelegate;", "coordinator", "Lcom/stripe/core/paymentcollection/PaymentCollectionCoordinator;", "providePaymentEventReceiver", "Lcom/stripe/core/hardware/paymentcollection/PaymentEventReceiver;", "providesManualEntryEventReceiver", "Lcom/stripe/core/hardware/paymentcollection/ManualEntryEventReceiver;", "stateMachine", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryStateMachine;", "paymentcollection_release"})
public final class PaymentCollectionModule {
    @NotNull
    public static final PaymentCollectionModule INSTANCE = new PaymentCollectionModule();

    private PaymentCollectionModule() {
    }

    @Provides
    @Singleton
    @NotNull
    public final PaymentEventReceiver providePaymentEventReceiver(@NotNull PaymentCollectionCoordinator coordinator) {
        Intrinsics.checkNotNullParameter((Object)coordinator, (String)"coordinator");
        return coordinator;
    }

    @Provides
    @Singleton
    @NotNull
    public final PaymentCollectionEventDelegate providePaymentCollectionEventDelegate(@NotNull PaymentCollectionCoordinator coordinator) {
        Intrinsics.checkNotNullParameter((Object)coordinator, (String)"coordinator");
        return coordinator;
    }

    @Provides
    @Singleton
    @PaymentCollection
    @NotNull
    public final CoroutineDispatcher providePaymentCollectionDispatcher() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor()");
        return (CoroutineDispatcher)ExecutorsKt.from((ExecutorService)executorService);
    }

    @Provides
    @NotNull
    public final ManualEntryEventReceiver providesManualEntryEventReceiver(@NotNull ManualEntryStateMachine stateMachine) {
        Intrinsics.checkNotNullParameter((Object)stateMachine, (String)"stateMachine");
        return stateMachine;
    }
}

