/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.manualentry;

import com.stripe.core.hardware.paymentcollection.ExpiryDateModel;
import com.stripe.core.paymentcollection.ManualEntryEvent;
import com.stripe.core.paymentcollection.PaymentCollectionEventDelegate;
import com.stripe.core.paymentcollection.manualentry.ManualEntryData;
import com.stripe.core.paymentcollection.manualentry.ManualEntryHandler;
import com.stripe.core.paymentcollection.manualentry.ManualEntryState;
import com.stripe.core.paymentcollection.manualentry.ManualEntryStatesKt;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\bH\u0014J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/stripe/core/paymentcollection/manualentry/ExpiryDateEntryHandler;", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryHandler;", "eventDelegate", "Lcom/stripe/core/paymentcollection/PaymentCollectionEventDelegate;", "(Lcom/stripe/core/paymentcollection/PaymentCollectionEventDelegate;)V", "onEnter", "", "current", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryData;", "from", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryState;", "onProcessDataUpdate", "new", "old", "sendExpiryEntryUiEvent", "data", "paymentcollection_release"})
public final class ExpiryDateEntryHandler
extends ManualEntryHandler {
    @Inject
    public ExpiryDateEntryHandler(@NotNull PaymentCollectionEventDelegate eventDelegate) {
        Intrinsics.checkNotNullParameter((Object)eventDelegate, (String)"eventDelegate");
        super(ManualEntryState.EXPIRY_DATE_ENTRY, eventDelegate);
    }

    @Override
    public void onEnter(@Nullable ManualEntryData current, @Nullable ManualEntryState from) {
        block0: {
            super.onEnter(current, from);
            ManualEntryStatesKt.access$getLOGGER$p().i("ExpiryDateEntryHandler.onEnter", new Pair[0]);
            ManualEntryData manualEntryData = current;
            if (manualEntryData == null) break block0;
            ManualEntryData it = manualEntryData;
            boolean bl = false;
            this.sendExpiryEntryUiEvent(it);
            this.sendStartPinEvent();
        }
    }

    @Override
    protected void onProcessDataUpdate(@NotNull ManualEntryData manualEntryData, @Nullable ManualEntryData old) {
        Intrinsics.checkNotNullParameter((Object)manualEntryData, (String)"new");
        this.sendExpiryEntryUiEvent(manualEntryData);
    }

    private final void sendExpiryEntryUiEvent(ManualEntryData data) {
        this.getEventDelegate().onHandlePaymentCollectionEvent(new ManualEntryEvent(new ExpiryDateModel(data.getAmount(), data.getExpiryDateUnmaskedDigits(), data.getShowError(), data.getTransactionType())));
    }
}

