/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.manualentry;

import androidx.annotation.VisibleForTesting;
import com.stripe.core.hardware.paymentcollection.ManualEntryEventReceiver;
import com.stripe.core.hardware.paymentcollection.ManualEntryResult;
import com.stripe.core.hardware.paymentcollection.ManualEntryType;
import com.stripe.core.hardware.paymentcollection.ProcessPaymentFromManualEntryResult;
import com.stripe.core.hardware.paymentcollection.ZipCodeManualEntryResult;
import com.stripe.core.paymentcollection.manualentry.ConfigureReaderHandler;
import com.stripe.core.paymentcollection.manualentry.ConfirmDetailsHandler;
import com.stripe.core.paymentcollection.manualentry.CvvEntryHandler;
import com.stripe.core.paymentcollection.manualentry.EmptyHandler;
import com.stripe.core.paymentcollection.manualentry.ExpiryDateEntryHandler;
import com.stripe.core.paymentcollection.manualentry.FinishedHandler;
import com.stripe.core.paymentcollection.manualentry.ManualEntryCollectionResult;
import com.stripe.core.paymentcollection.manualentry.ManualEntryData;
import com.stripe.core.paymentcollection.manualentry.ManualEntryEncryptedData;
import com.stripe.core.paymentcollection.manualentry.ManualEntryFailureReason;
import com.stripe.core.paymentcollection.manualentry.ManualEntryHandler;
import com.stripe.core.paymentcollection.manualentry.ManualEntryLoggerInterface;
import com.stripe.core.paymentcollection.manualentry.ManualEntryState;
import com.stripe.core.paymentcollection.manualentry.ManualEntryStateMachineKt;
import com.stripe.core.paymentcollection.manualentry.PanEntryHandler;
import com.stripe.core.paymentcollection.manualentry.ZipCodeHandler;
import com.stripe.core.statemachine.StateMachine;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.restclient.IntegrationType;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004BO\b\u0007\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020!J\u0010\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0002J8\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020(H\u0016J\b\u0010.\u001a\u00020!H\u0016J\u001a\u0010/\u001a\u00020!2\b\u00100\u001a\u0004\u0018\u00010(2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020!2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020!2\u0006\u00107\u001a\u000208H\u0016J.\u00109\u001a\u00020!2\u0006\u0010:\u001a\u00020\u00022\b\u0010;\u001a\u0004\u0018\u00010\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010<\u001a\u0004\u0018\u00010(H\u0014J\b\u0010=\u001a\u00020!H\u0002J\u0006\u0010>\u001a\u00020!J\u000e\u0010?\u001a\u00020!2\u0006\u0010@\u001a\u00020AJ>\u0010B\u001a\u00020!2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0016\u0010K\u001a\u0012\u0012\u0004\u0012\u00020M\u0012\u0004\u0012\u00020!0Lj\u0002`NR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u00020\u00198FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u001cR\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006O"}, d2={"Lcom/stripe/core/paymentcollection/manualentry/ManualEntryStateMachine;", "Lcom/stripe/core/statemachine/StateMachine;", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryState;", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryData;", "Lcom/stripe/core/hardware/paymentcollection/ManualEntryEventReceiver;", "emptyHandler", "Lcom/stripe/core/paymentcollection/manualentry/EmptyHandler;", "configureReaderHandler", "Lcom/stripe/core/paymentcollection/manualentry/ConfigureReaderHandler;", "zipCodeHandler", "Lcom/stripe/core/paymentcollection/manualentry/ZipCodeHandler;", "confirmDetailsHandler", "Lcom/stripe/core/paymentcollection/manualentry/ConfirmDetailsHandler;", "panEntryHandler", "Lcom/stripe/core/paymentcollection/manualentry/PanEntryHandler;", "expiryDateEntryHandler", "Lcom/stripe/core/paymentcollection/manualentry/ExpiryDateEntryHandler;", "cvvEntryHandler", "Lcom/stripe/core/paymentcollection/manualentry/CvvEntryHandler;", "finishedHandler", "Lcom/stripe/core/paymentcollection/manualentry/FinishedHandler;", "manualEntryLogger", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryLoggerInterface;", "(Lcom/stripe/core/paymentcollection/manualentry/EmptyHandler;Lcom/stripe/core/paymentcollection/manualentry/ConfigureReaderHandler;Lcom/stripe/core/paymentcollection/manualentry/ZipCodeHandler;Lcom/stripe/core/paymentcollection/manualentry/ConfirmDetailsHandler;Lcom/stripe/core/paymentcollection/manualentry/PanEntryHandler;Lcom/stripe/core/paymentcollection/manualentry/ExpiryDateEntryHandler;Lcom/stripe/core/paymentcollection/manualentry/CvvEntryHandler;Lcom/stripe/core/paymentcollection/manualentry/FinishedHandler;Lcom/stripe/core/paymentcollection/manualentry/ManualEntryLoggerInterface;)V", "isActive", "", "isActive$annotations", "()V", "()Z", "isEncryptedDataValid", "data", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryEncryptedData;", "notifyHardwareCancel", "", "notifyMerchantCancel", "onCollectionFailed", "failureReason", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryFailureReason;", "onEncryptedDataCollected", "encPAN", "", "expiryDate", "encCVV", "maskedPan", "ksn", "posEntryMode", "onInvalidInput", "onRequestDisplayAsterisk", "unmaskedDigits", "numOfAsterisk", "", "onRequestManualEntry", "type", "Lcom/stripe/core/hardware/paymentcollection/ManualEntryType;", "onReturnTransactionResult", "transactionResult", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult$Result;", "onStateChanging", "to", "from", "reason", "registerHandlers", "reset", "setManualEntryResult", "manualEntryResult", "Lcom/stripe/core/hardware/paymentcollection/ManualEntryResult;", "startTransaction", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "transactionType", "Lcom/stripe/core/hardware/paymentcollection/TransactionType;", "emvTransactionType", "Lcom/stripe/jvmcore/hardware/emv/TransactionType;", "integrationType", "Lcom/stripe/jvmcore/restclient/IntegrationType;", "resultListener", "Lkotlin/Function1;", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryCollectionResult;", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryResultListener;", "paymentcollection_release"})
@SourceDebugExtension(value={"SMAP\nManualEntryStateMachine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManualEntryStateMachine.kt\ncom/stripe/core/paymentcollection/manualentry/ManualEntryStateMachine\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,340:1\n13579#2,2:341\n*S KotlinDebug\n*F\n+ 1 ManualEntryStateMachine.kt\ncom/stripe/core/paymentcollection/manualentry/ManualEntryStateMachine\n*L\n115#1:341,2\n*E\n"})
public final class ManualEntryStateMachine
extends StateMachine<ManualEntryState, ManualEntryData>
implements ManualEntryEventReceiver {
    @NotNull
    private final EmptyHandler emptyHandler;
    @NotNull
    private final ConfigureReaderHandler configureReaderHandler;
    @NotNull
    private final ZipCodeHandler zipCodeHandler;
    @NotNull
    private final ConfirmDetailsHandler confirmDetailsHandler;
    @NotNull
    private final PanEntryHandler panEntryHandler;
    @NotNull
    private final ExpiryDateEntryHandler expiryDateEntryHandler;
    @NotNull
    private final CvvEntryHandler cvvEntryHandler;
    @NotNull
    private final FinishedHandler finishedHandler;
    @NotNull
    private final ManualEntryLoggerInterface manualEntryLogger;

    @Inject
    public ManualEntryStateMachine(@NotNull EmptyHandler emptyHandler, @NotNull ConfigureReaderHandler configureReaderHandler, @NotNull ZipCodeHandler zipCodeHandler, @NotNull ConfirmDetailsHandler confirmDetailsHandler, @NotNull PanEntryHandler panEntryHandler, @NotNull ExpiryDateEntryHandler expiryDateEntryHandler, @NotNull CvvEntryHandler cvvEntryHandler, @NotNull FinishedHandler finishedHandler, @NotNull ManualEntryLoggerInterface manualEntryLogger) {
        Intrinsics.checkNotNullParameter((Object)emptyHandler, (String)"emptyHandler");
        Intrinsics.checkNotNullParameter((Object)configureReaderHandler, (String)"configureReaderHandler");
        Intrinsics.checkNotNullParameter((Object)zipCodeHandler, (String)"zipCodeHandler");
        Intrinsics.checkNotNullParameter((Object)confirmDetailsHandler, (String)"confirmDetailsHandler");
        Intrinsics.checkNotNullParameter((Object)panEntryHandler, (String)"panEntryHandler");
        Intrinsics.checkNotNullParameter((Object)expiryDateEntryHandler, (String)"expiryDateEntryHandler");
        Intrinsics.checkNotNullParameter((Object)cvvEntryHandler, (String)"cvvEntryHandler");
        Intrinsics.checkNotNullParameter((Object)finishedHandler, (String)"finishedHandler");
        Intrinsics.checkNotNullParameter((Object)manualEntryLogger, (String)"manualEntryLogger");
        this.emptyHandler = emptyHandler;
        this.configureReaderHandler = configureReaderHandler;
        this.zipCodeHandler = zipCodeHandler;
        this.confirmDetailsHandler = confirmDetailsHandler;
        this.panEntryHandler = panEntryHandler;
        this.expiryDateEntryHandler = expiryDateEntryHandler;
        this.cvvEntryHandler = cvvEntryHandler;
        this.finishedHandler = finishedHandler;
        this.manualEntryLogger = manualEntryLogger;
        ManualEntryStateMachineKt.access$getLOGGER$p().i("registerHandlers", new Pair[0]);
        this.registerHandlers();
        StateMachine.transitionTo$default(this, (Object)ManualEntryState.EMPTY, null, 2, null);
    }

    public final void reset() {
        StateMachine.transitionTo$default(this, (Object)ManualEntryState.FINISHED, null, 2, null);
    }

    public final void startTransaction(@NotNull Amount amount, @NotNull com.stripe.core.hardware.paymentcollection.TransactionType transactionType, @NotNull TransactionType emvTransactionType, @NotNull IntegrationType integrationType, @NotNull Function1<? super ManualEntryCollectionResult, Unit> resultListener) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)((Object)transactionType), (String)"transactionType");
        Intrinsics.checkNotNullParameter((Object)((Object)emvTransactionType), (String)"emvTransactionType");
        Intrinsics.checkNotNullParameter((Object)((Object)integrationType), (String)"integrationType");
        Intrinsics.checkNotNullParameter(resultListener, (String)"resultListener");
        if (this.isActive()) {
            return;
        }
        this.updateData(new ManualEntryData(amount, null, null, 0, 0, null, transactionType, emvTransactionType, integrationType, null, null, null, false, resultListener, false, 24126, null));
        StateMachine.transitionTo$default(this, (Object)ManualEntryState.CONFIGURE_READER, null, 2, null);
    }

    public final boolean isActive() {
        return this.getState() != ManualEntryState.EMPTY;
    }

    @VisibleForTesting
    public static /* synthetic */ void isActive$annotations() {
    }

    private final void registerHandlers() {
        ManualEntryState[] $this$forEach$iv = ManualEntryState.values();
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ManualEntryHandler manualEntryHandler;
            ManualEntryState element$iv;
            ManualEntryState it = element$iv = $this$forEach$iv[i2];
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.ordinal()]) {
                case 1: {
                    manualEntryHandler = this.emptyHandler;
                    break;
                }
                case 2: {
                    manualEntryHandler = this.configureReaderHandler;
                    break;
                }
                case 3: {
                    manualEntryHandler = this.zipCodeHandler;
                    break;
                }
                case 4: {
                    manualEntryHandler = this.confirmDetailsHandler;
                    break;
                }
                case 5: {
                    manualEntryHandler = this.panEntryHandler;
                    break;
                }
                case 6: {
                    manualEntryHandler = this.expiryDateEntryHandler;
                    break;
                }
                case 7: {
                    manualEntryHandler = this.cvvEntryHandler;
                    break;
                }
                case 8: {
                    manualEntryHandler = this.finishedHandler;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            manualEntryHandler.register(this);
        }
    }

    public final void setManualEntryResult(@NotNull ManualEntryResult manualEntryResult) {
        Intrinsics.checkNotNullParameter((Object)manualEntryResult, (String)"manualEntryResult");
        ManualEntryData manualEntryData = (ManualEntryData)this.getData();
        if (manualEntryData == null) {
            return;
        }
        ManualEntryData oldData = manualEntryData;
        ManualEntryResult manualEntryResult2 = manualEntryResult;
        if (manualEntryResult2 instanceof ZipCodeManualEntryResult) {
            ManualEntryData updatedData = ManualEntryData.copy$default(oldData, null, ((ZipCodeManualEntryResult)manualEntryResult).getZipCode(), null, 0, 0, null, null, null, null, null, null, null, false, null, false, 32765, null);
            this.updateData(updatedData);
        } else if (Intrinsics.areEqual((Object)manualEntryResult2, (Object)ProcessPaymentFromManualEntryResult.INSTANCE)) {
            this.updateData(ManualEntryData.copy$default(oldData, null, null, null, 0, 0, null, null, null, null, null, null, null, true, null, false, 28671, null));
        }
    }

    @Override
    public void onRequestDisplayAsterisk(@Nullable String unmaskedDigits, int numOfAsterisk) {
        if (!this.isActive()) {
            return;
        }
        ManualEntryState manualEntryState = (ManualEntryState)((Object)this.getState());
        switch (manualEntryState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[manualEntryState.ordinal()]) {
            case 5: {
                ManualEntryData manualEntryData = (ManualEntryData)this.getData();
                if (manualEntryData != null) {
                    ManualEntryData it = manualEntryData;
                    boolean bl = false;
                    this.updateData(ManualEntryData.copy$default(it, null, null, unmaskedDigits, numOfAsterisk, 0, null, null, null, null, null, null, null, false, null, false, 16371, null));
                }
                break;
            }
            case 6: {
                ManualEntryData manualEntryData = (ManualEntryData)this.getData();
                if (manualEntryData != null) {
                    ManualEntryData it = manualEntryData;
                    boolean bl = false;
                    this.updateData(ManualEntryData.copy$default(it, null, null, null, 0, 0, unmaskedDigits, null, null, null, null, null, null, false, null, false, 16351, null));
                }
                break;
            }
            case 7: {
                ManualEntryData manualEntryData = (ManualEntryData)this.getData();
                if (manualEntryData != null) {
                    ManualEntryData it = manualEntryData;
                    boolean bl = false;
                    this.updateData(ManualEntryData.copy$default(it, null, null, null, 0, numOfAsterisk, null, null, null, null, null, null, null, false, null, false, 16367, null));
                }
                break;
            }
        }
    }

    public final void notifyMerchantCancel() {
        this.onCollectionFailed(ManualEntryFailureReason.MERCHANT_CANCELLED);
    }

    public final void notifyHardwareCancel() {
        this.onCollectionFailed(ManualEntryFailureReason.USER_CANCELLED);
    }

    @Override
    public void onEncryptedDataCollected(@NotNull String encPAN, @NotNull String expiryDate, @NotNull String encCVV, @NotNull String maskedPan, @NotNull String ksn, @NotNull String posEntryMode) {
        Intrinsics.checkNotNullParameter((Object)encPAN, (String)"encPAN");
        Intrinsics.checkNotNullParameter((Object)expiryDate, (String)"expiryDate");
        Intrinsics.checkNotNullParameter((Object)encCVV, (String)"encCVV");
        Intrinsics.checkNotNullParameter((Object)maskedPan, (String)"maskedPan");
        Intrinsics.checkNotNullParameter((Object)ksn, (String)"ksn");
        Intrinsics.checkNotNullParameter((Object)posEntryMode, (String)"posEntryMode");
        if (!this.isActive()) {
            return;
        }
        ManualEntryData manualEntryData = (ManualEntryData)this.getData();
        if (manualEntryData == null) {
            return;
        }
        ManualEntryData data = manualEntryData;
        ManualEntryEncryptedData result2 = new ManualEntryEncryptedData(encPAN, expiryDate, encCVV, maskedPan, ksn, posEntryMode);
        boolean isValid = this.isEncryptedDataValid(result2);
        if (isValid) {
            this.updateData(ManualEntryData.copy$default(data, null, null, null, 0, 0, null, null, null, null, result2, null, null, false, null, false, 32255, null));
        } else {
            this.updateData(ManualEntryData.copy$default(data, null, null, null, 0, 0, null, null, null, null, result2, (ManualEntryState)((Object)this.getState()), ManualEntryFailureReason.INVALID_ENCRYPTED_DATA_RESULT, false, null, false, 29183, null));
        }
    }

    private final boolean isEncryptedDataValid(ManualEntryEncryptedData data) {
        boolean isValid;
        boolean bl = ((CharSequence)data.getEncCVV()).length() > 0 && ((CharSequence)data.getEncPAN()).length() > 0 && ((CharSequence)data.getExpiryDate()).length() > 0 && ((CharSequence)data.getKsn()).length() > 0 ? true : (isValid = false);
        if (!isValid) {
            ManualEntryStateMachineKt.access$getLOGGER$p().i("Invalid encrypted data result: " + data, new Pair[0]);
        }
        return isValid;
    }

    @Override
    public void onInvalidInput() {
        if (!this.isActive()) {
            return;
        }
        this.manualEntryLogger.onInvalidInput((ManualEntryData)this.getData());
        ManualEntryState manualEntryState = (ManualEntryState)((Object)this.getState());
        switch (manualEntryState == null ? -1 : WhenMappings.$EnumSwitchMapping$0[manualEntryState.ordinal()]) {
            case 5: 
            case 6: 
            case 7: {
                ManualEntryData manualEntryData = (ManualEntryData)this.getData();
                if (manualEntryData != null) {
                    ManualEntryData it = manualEntryData;
                    boolean bl = false;
                    this.updateData(ManualEntryData.copy$default(it, null, null, null, 0, 0, null, null, null, null, null, null, null, false, null, true, 16383, null));
                }
                break;
            }
        }
    }

    @Override
    public void onRequestManualEntry(@NotNull ManualEntryType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (!this.isActive()) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                StateMachine.transitionTo$default(this, (Object)ManualEntryState.PAN_ENTRY, null, 2, null);
                break;
            }
            case 2: {
                StateMachine.transitionTo$default(this, (Object)ManualEntryState.EXPIRY_DATE_ENTRY, null, 2, null);
                break;
            }
            case 3: {
                StateMachine.transitionTo$default(this, (Object)ManualEntryState.CVV_ENTRY, null, 2, null);
            }
        }
    }

    @Override
    public void onReturnTransactionResult(@NotNull TransactionResult.Result transactionResult2) {
        Intrinsics.checkNotNullParameter((Object)((Object)transactionResult2), (String)"transactionResult");
        if (!this.isActive()) {
            return;
        }
        ManualEntryData manualEntryData = (ManualEntryData)this.getData();
        if (manualEntryData == null) {
            return;
        }
        ManualEntryData data = manualEntryData;
        switch (WhenMappings.$EnumSwitchMapping$2[transactionResult2.ordinal()]) {
            case 1: {
                this.onCollectionFailed(ManualEntryFailureReason.TIMEOUT);
                break;
            }
            case 2: {
                this.onCollectionFailed(ManualEntryFailureReason.DEVICE_FAILURE);
                break;
            }
            default: {
                this.onCollectionFailed(ManualEntryFailureReason.EARLY_TRANSACTION_RESULT);
            }
        }
    }

    private final void onCollectionFailed(ManualEntryFailureReason failureReason) {
        if (!this.isActive()) {
            return;
        }
        ManualEntryState manualEntryState = (ManualEntryState)((Object)this.getState());
        if (manualEntryState == null) {
            return;
        }
        ManualEntryState state = manualEntryState;
        ManualEntryData manualEntryData = (ManualEntryData)this.getData();
        if (manualEntryData == null) {
            return;
        }
        ManualEntryData date = manualEntryData;
        this.updateData(ManualEntryData.copy$default(date, null, null, null, 0, 0, null, null, null, null, null, state, failureReason, false, null, false, 29695, null));
    }

    @Override
    protected void onStateChanging(@NotNull ManualEntryState to, @Nullable ManualEntryState from, @Nullable ManualEntryData data, @Nullable String reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)to), (String)"to");
        ManualEntryState manualEntryState = from;
        ManualEntryStateMachineKt.access$getLOGGER$p().i("onStateChanged: " + (manualEntryState != null ? manualEntryState.name() : null) + " -> " + to.name() + ": " + reason, new Pair[0]);
        this.manualEntryLogger.onExit(data);
        this.manualEntryLogger.onEnter(to);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ManualEntryState.values().length];
            try {
                nArray[ManualEntryState.EMPTY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryState.CONFIGURE_READER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryState.ZIP_CODE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryState.CONFIRM_DETAILS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryState.PAN_ENTRY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryState.EXPIRY_DATE_ENTRY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryState.CVV_ENTRY.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryState.FINISHED.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ManualEntryType.values().length];
            try {
                nArray[ManualEntryType.PAN_ENTRY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryType.EXPIRY_DATE_ENTRY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ManualEntryType.CVV_ENTRY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[TransactionResult.Result.values().length];
            try {
                nArray[TransactionResult.Result.TERMINATED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.DEVICE_FAILURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

