/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.metrics;

import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.metrics.DiscreteEventLogger;
import com.stripe.core.paymentcollection.metrics.OnlineConfirmationFailureReason;
import com.stripe.core.paymentcollection.metrics.PaymentMethodType;
import com.stripe.core.paymentcollection.metrics.Result;
import com.stripe.core.paymentcollection.metrics.UtilsKt;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.magstripe.MagStripePaymentCollectionAuthority;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.HealthLoggerBuilder;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.DiscreteScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.PaymentCollectionDomain;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0017*\u0004\u0018\u00010\u001aH\u0002R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u0006j\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/stripe/core/paymentcollection/metrics/DiscreteEventLogger;", "", "healthLoggerBuilder", "Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;", "(Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;)V", "logger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/DiscreteScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/DiscreteScope$Builder;", "Lcom/stripe/core/paymentcollection/metrics/DiscreteHealthLogger;", "logAllowingMagStripe", "", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "logOnlineConfirmResult", "logPrematureCardRemoval", "logReaderInterfaceChanged", "readerTypes", "Ljava/util/EnumSet;", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$ReaderType;", "toOnlineConfirmFailureReason", "Lkotlin/Pair;", "Lcom/stripe/core/paymentcollection/metrics/Result;", "Lcom/stripe/core/paymentcollection/metrics/OnlineConfirmationFailureReason;", "Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "Companion", "paymentcollection_release"})
@SourceDebugExtension(value={"SMAP\nDiscreteEventLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiscreteEventLogger.kt\ncom/stripe/core/paymentcollection/metrics/DiscreteEventLogger\n+ 2 Tags.kt\ncom/stripe/core/paymentcollection/metrics/TagsKt\n*L\n1#1,96:1\n412#2,11:97\n412#2,11:108\n412#2,11:119\n412#2,11:130\n*S KotlinDebug\n*F\n+ 1 DiscreteEventLogger.kt\ncom/stripe/core/paymentcollection/metrics/DiscreteEventLogger\n*L\n22#1:97,11\n58#1:108,11\n59#1:119,11\n60#1:130,11\n*E\n"})
public final class DiscreteEventLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HealthLogger<PaymentCollectionDomain, PaymentCollectionDomain.Builder, DiscreteScope, DiscreteScope.Builder> logger;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(DiscreteEventLogger.class);

    @Inject
    public DiscreteEventLogger(@NotNull HealthLoggerBuilder healthLoggerBuilder) {
        Intrinsics.checkNotNullParameter((Object)healthLoggerBuilder, (String)"healthLoggerBuilder");
        this.logger = UtilsKt.buildsDiscreteHealthLogger(healthLoggerBuilder);
    }

    /*
     * WARNING - void declaration
     */
    public final void logAllowingMagStripe(@NotNull PaymentCollectionData data) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Map $this$logAllowingMagStripe_u24lambda_u240 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        Map map3 = $this$logAllowingMagStripe_u24lambda_u240;
        Enum tag$iv = data.getMagStripePaymentCollectionAuthority();
        boolean $i$f$addEnumTag = false;
        if (tag$iv != null) {
            void $this$addEnumTag$iv;
            KClass kClass = Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class);
            String tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : MagStripePaymentCollectionAuthority.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, tag$iv.name());
        }
        Map tagMap = map2;
        HealthLogger.incrementCounter$default(this.logger, Outcome.Ok.INSTANCE, tagMap, null, logAllowingMagStripe.1.INSTANCE, 4, null);
        LOGGER.i(" magStripeAllowReason " + data + ".magStripePaymentCollectionAuthority", new Pair[0]);
    }

    public final void logPrematureCardRemoval(@NotNull PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        LOGGER.i("logPrematureCardRemoval", new Pair[0]);
        HealthLogger.incrementCounter$default(this.logger, null, null, null, logPrematureCardRemoval.1.INSTANCE, 7, null);
    }

    public final void logReaderInterfaceChanged(@NotNull EnumSet<ReaderConfiguration.ReaderType> readerTypes) {
        Intrinsics.checkNotNullParameter(readerTypes, (String)"readerTypes");
        String readerTypeString = CollectionsKt.joinToString$default((Iterable)readerTypes, (CharSequence)"_", null, null, (int)0, null, null, (int)62, null);
        LOGGER.i("logReaderInterfaceChanged readerTypes " + readerTypeString, new Pair[0]);
        Map tagMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"ReaderInterfaces", (Object)readerTypeString));
        HealthLogger.incrementCounter$default(this.logger, Outcome.Ok.INSTANCE, tagMap, null, logReaderInterfaceChanged.1.INSTANCE, 4, null);
    }

    public final void logOnlineConfirmResult(@NotNull PaymentCollectionData data) {
        String tagName$iv;
        KClass kClass;
        Map map2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        PaymentMethodType paymentMethodType = UtilsKt.getPaymentMethodType(data);
        com.stripe.core.hardware.paymentcollection.TransactionType transactionType = data.getTransactionType();
        Pair<Result, OnlineConfirmationFailureReason> pair = data.isTimedOut() ? new Pair<Result, OnlineConfirmationFailureReason>((Object)Result.FAILURE, (Object)OnlineConfirmationFailureReason.TIMEOUT) : (data.isCancelled() ? new Pair((Object)Result.FAILURE, (Object)OnlineConfirmationFailureReason.MERCHANT_CANCELLED) : this.toOnlineConfirmFailureReason(data.getChargeAttempt()));
        Result result2 = (Result)((Object)pair.component1());
        OnlineConfirmationFailureReason failureReason = (OnlineConfirmationFailureReason)((Object)pair.component2());
        Map $this$logOnlineConfirmResult_u24lambda_u241 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        Map $this$addEnumTag$iv = $this$logOnlineConfirmResult_u24lambda_u241;
        boolean $i$f$addEnumTag = false;
        if ((Enum)paymentMethodType != null) {
            kClass = Reflection.getOrCreateKotlinClass(PaymentMethodType.class);
            tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : PaymentMethodType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, ((Enum)paymentMethodType).name());
        }
        $this$addEnumTag$iv = $this$logOnlineConfirmResult_u24lambda_u241;
        $i$f$addEnumTag = false;
        if ((Enum)transactionType != null) {
            kClass = Reflection.getOrCreateKotlinClass(com.stripe.core.hardware.paymentcollection.TransactionType.class);
            tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : com.stripe.core.hardware.paymentcollection.TransactionType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, ((Enum)transactionType).name());
        }
        $this$addEnumTag$iv = $this$logOnlineConfirmResult_u24lambda_u241;
        $i$f$addEnumTag = false;
        if ((Enum)failureReason != null) {
            kClass = Reflection.getOrCreateKotlinClass(OnlineConfirmationFailureReason.class);
            tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : OnlineConfirmationFailureReason.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, ((Enum)failureReason).name());
        }
        Map tagMap = map2;
        LOGGER.i("logOnlineConfirmResult result " + (Object)((Object)result2) + " failureReason " + (Object)((Object)failureReason), new Pair[0]);
        HealthLogger.incrementCounter$default(this.logger, UtilsKt.toOutcome(result2), tagMap, null, logOnlineConfirmResult.1.INSTANCE, 4, null);
    }

    private final Pair<Result, OnlineConfirmationFailureReason> toOnlineConfirmFailureReason(ChargeAttempt $this$toOnlineConfirmFailureReason) {
        Pair pair;
        ChargeAttempt chargeAttempt = $this$toOnlineConfirmFailureReason;
        if (((chargeAttempt instanceof ChargeAttempt.CompletedAttempt.SuccessfulCharge ? true : chargeAttempt instanceof ChargeAttempt.CompletedAttempt.SuccessfulRefund) ? true : Intrinsics.areEqual((Object)chargeAttempt, (Object)ChargeAttempt.CompletedAttempt.SuccessfulReusableCard.INSTANCE)) ? true : Intrinsics.areEqual((Object)chargeAttempt, (Object)ChargeAttempt.CompletedAttempt.SuccessfulSetupIntent.INSTANCE)) {
            pair = new Pair((Object)Result.SUCCESS, null);
        } else if ((chargeAttempt instanceof ChargeAttempt.CompletedAttempt.DeclinedCharge ? true : chargeAttempt instanceof ChargeAttempt.CompletedAttempt.DeclinedRefund) ? true : chargeAttempt instanceof ChargeAttempt.CompletedAttempt.AlreadyRefunded) {
            pair = new Pair((Object)Result.FAILURE, (Object)OnlineConfirmationFailureReason.DECLINED);
        } else if ((Intrinsics.areEqual((Object)chargeAttempt, (Object)ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE) ? true : Intrinsics.areEqual((Object)chargeAttempt, (Object)ChargeAttempt.CompletedAttempt.UnknownRefundResult.INSTANCE)) ? true : Intrinsics.areEqual((Object)chargeAttempt, (Object)ChargeAttempt.CompletedAttempt.UnknownReusableCardResult.INSTANCE)) {
            pair = new Pair((Object)Result.FAILURE, (Object)OnlineConfirmationFailureReason.UNKNOWN_NETWORK_FAILURE);
        } else if (chargeAttempt instanceof ChargeAttempt.ExtendedAttempt) {
            pair = new Pair((Object)Result.FAILURE, (Object)OnlineConfirmationFailureReason.SCA_NEEDED);
        } else if (chargeAttempt == null) {
            pair = new Pair((Object)Result.FAILURE, (Object)OnlineConfirmationFailureReason.UNKNOWN);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/paymentcollection/metrics/DiscreteEventLogger$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "paymentcollection_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

