/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.metrics;

import androidx.annotation.VisibleForTesting;
import com.stripe.core.hardware.paymentcollection.PaymentCollectionResultType;
import com.stripe.core.paymentcollection.EarlyTransactionAbortReason;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.metrics.CollectionFailureReason;
import com.stripe.core.paymentcollection.metrics.EndToEndEventLogger;
import com.stripe.core.paymentcollection.metrics.LatencyCategory;
import com.stripe.core.paymentcollection.metrics.Result;
import com.stripe.core.paymentcollection.metrics.UtilsKt;
import com.stripe.jvmcore.hardware.emv.ApplicationId;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.magstripe.MagStripePaymentCollectionAuthority;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.HealthLoggerBuilder;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.time.Clock;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.EndToEndScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.PaymentCollectionDomain;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0001\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u0016H\u0002J,\u0010 \u001a\u00020\u00162\u0006\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%H\u0002J$\u0010'\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020&0%H\u0002J\u0006\u0010(\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR*\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\fj\u0002`\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006*"}, d2={"Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;", "", "healthLoggerBuilder", "Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;", "clock", "Lcom/stripe/jvmcore/time/Clock;", "(Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;Lcom/stripe/jvmcore/time/Clock;)V", "latencyPerCategory", "", "", "[Ljava/lang/Long;", "logger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/EndToEndScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/EndToEndScope$Builder;", "Lcom/stripe/core/paymentcollection/metrics/EndToEndHealthLogger;", "startTime", "Ljava/lang/Long;", "startTimePerCategory", "categoryEnd", "", "category", "Lcom/stripe/core/paymentcollection/metrics/LatencyCategory;", "categoryStart", "end", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "state", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "measureUnknownLatencyIfNeeded", "sendEndToEndEvent", "totalDuration", "result", "Lcom/stripe/core/paymentcollection/metrics/Result;", "tagMap", "", "", "sendPerCategoryMeasurementEvents", "start", "Companion", "paymentcollection_release"})
@SourceDebugExtension(value={"SMAP\nEndToEndEventLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndToEndEventLogger.kt\ncom/stripe/core/paymentcollection/metrics/EndToEndEventLogger\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Tags.kt\ncom/stripe/core/paymentcollection/metrics/TagsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,235:1\n12541#2,2:236\n412#3,11:238\n412#3,11:249\n412#3,11:261\n1#4:260\n*S KotlinDebug\n*F\n+ 1 EndToEndEventLogger.kt\ncom/stripe/core/paymentcollection/metrics/EndToEndEventLogger\n*L\n73#1:236,2\n92#1:238,11\n93#1:249,11\n133#1:261,11\n*E\n"})
public final class EndToEndEventLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Clock clock;
    @NotNull
    private final HealthLogger<PaymentCollectionDomain, PaymentCollectionDomain.Builder, EndToEndScope, EndToEndScope.Builder> logger;
    @Nullable
    private Long startTime;
    @NotNull
    private Long[] startTimePerCategory;
    @NotNull
    private final Long[] latencyPerCategory;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(EndToEndEventLogger.class);

    @Inject
    public EndToEndEventLogger(@NotNull HealthLoggerBuilder healthLoggerBuilder, @NotNull Clock clock) {
        int n2;
        Intrinsics.checkNotNullParameter((Object)healthLoggerBuilder, (String)"healthLoggerBuilder");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.clock = clock;
        this.logger = UtilsKt.buildsEndToEndHealthLogger(healthLoggerBuilder);
        int n3 = 0;
        int n4 = LatencyCategory.values().length;
        Long[] longArray = new Long[n4];
        EndToEndEventLogger endToEndEventLogger = this;
        while (n3 < n4) {
            n2 = n3++;
            longArray[n2] = -1L;
        }
        endToEndEventLogger.startTimePerCategory = longArray;
        n3 = 0;
        n4 = LatencyCategory.values().length;
        longArray = new Long[n4];
        endToEndEventLogger = this;
        while (n3 < n4) {
            n2 = n3++;
            longArray[n2] = 0L;
        }
        endToEndEventLogger.latencyPerCategory = longArray;
    }

    public final void start() {
        long curTime = this.clock.currentTimeMillis();
        ArraysKt.fill$default((Object[])this.latencyPerCategory, (Object)0L, (int)0, (int)0, (int)6, null);
        ArraysKt.fill$default((Object[])this.startTimePerCategory, (Object)-1L, (int)0, (int)0, (int)6, null);
        this.startTimePerCategory[LatencyCategory.UNKNOWN.ordinal()] = curTime;
        this.startTime = curTime;
    }

    public final void categoryStart(@NotNull LatencyCategory category) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        if (this.startTimePerCategory[category.ordinal()] != -1L) {
            return;
        }
        this.startTimePerCategory[category.ordinal()] = this.clock.currentTimeMillis();
        if (category != LatencyCategory.UNKNOWN) {
            this.measureUnknownLatencyIfNeeded();
        }
    }

    public final void categoryEnd(@NotNull LatencyCategory category) {
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        long startTime = this.startTimePerCategory[category.ordinal()];
        if (startTime == -1L) {
            return;
        }
        long latency = this.clock.currentTimeMillis() - startTime;
        Long[] longArray = this.latencyPerCategory;
        int n2 = category.ordinal();
        longArray[n2] = longArray[n2] + latency;
        this.startTimePerCategory[category.ordinal()] = -1L;
        if (category != LatencyCategory.UNKNOWN) {
            this.measureUnknownLatencyIfNeeded();
        }
    }

    private final void measureUnknownLatencyIfNeeded() {
        boolean isIdle;
        block3: {
            boolean bl;
            Long[] $this$all$iv = this.startTimePerCategory;
            boolean $i$f$all = false;
            for (Long element$iv : $this$all$iv) {
                long it = ((Number)element$iv).longValue();
                boolean bl2 = false;
                if (it == -1L) continue;
                bl = false;
                break block3;
            }
            bl = isIdle = true;
        }
        if (isIdle) {
            this.categoryStart(LatencyCategory.UNKNOWN);
        } else {
            this.categoryEnd(LatencyCategory.UNKNOWN);
        }
    }

    public final void end(@NotNull PaymentCollectionData data, @NotNull PaymentCollectionState state) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Long l2 = this.startTime;
        if (l2 != null) {
            PaymentCollectionState state2;
            HashMap hashMap;
            long it = ((Number)l2).longValue();
            boolean bl = false;
            Result result2 = EndToEndEventLogger.Companion.getResult(data, state);
            PaymentCollectionState stateWhenCancelled = EndToEndEventLogger.Companion.getStateWhenCancelled(data);
            PaymentCollectionState stateWhenTimedOut = EndToEndEventLogger.Companion.getStateWhenTimedOut(data);
            CollectionFailureReason failureReason = Companion.getCollectionFailureReason$paymentcollection_release(data, result2);
            HashMap $this$end_u24lambda_u244_u24lambda_u243 = hashMap = UtilsKt.generateCommonTags$default(data, null, 2, null);
            boolean bl2 = false;
            Map $this$addEnumTag$iv = $this$end_u24lambda_u244_u24lambda_u243;
            boolean $i$f$addEnumTag = false;
            if ((Enum)failureReason != null) {
                KClass kClass = Reflection.getOrCreateKotlinClass(CollectionFailureReason.class);
                String tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : CollectionFailureReason.class.getSimpleName());
                Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
                $this$addEnumTag$iv.put(tagName$iv, ((Enum)failureReason).name());
            }
            $this$addEnumTag$iv = $this$end_u24lambda_u244_u24lambda_u243;
            Enum tag$iv = UtilsKt.getApplicationId(data);
            boolean $i$f$addEnumTag2 = false;
            if (tag$iv != null) {
                KClass kClass = Reflection.getOrCreateKotlinClass(ApplicationId.class);
                String tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : ApplicationId.class.getSimpleName());
                Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
                $this$addEnumTag$iv.put(tagName$iv, tag$iv.name());
            }
            PaymentCollectionState paymentCollectionState = stateWhenCancelled;
            if (paymentCollectionState != null) {
                state2 = paymentCollectionState;
                boolean bl3 = false;
                ((Map)$this$end_u24lambda_u244_u24lambda_u243).put("stateWhenCancelled", state2.name());
            }
            PaymentCollectionState paymentCollectionState2 = stateWhenTimedOut;
            if (paymentCollectionState2 != null) {
                state2 = paymentCollectionState2;
                boolean bl4 = false;
                ((Map)$this$end_u24lambda_u244_u24lambda_u243).put("stateWhenTimedOut", state2.name());
            }
            HashMap tagMap = hashMap;
            long duration = this.clock.currentTimeMillis() - it;
            this.sendEndToEndEvent(duration, result2, tagMap);
            this.sendPerCategoryMeasurementEvents(result2, tagMap);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            EndToEndEventLogger $this$end_u24lambda_u245 = this;
            boolean bl = false;
            LOGGER.e("No open log to end.", new Pair[0]);
        }
        this.startTime = null;
    }

    private final void sendEndToEndEvent(long totalDuration, Result result2, Map<String, String> tagMap) {
        HealthLogger.recordTimer$default(this.logger, totalDuration, UtilsKt.toOutcome(result2), tagMap, null, sendEndToEndEvent.1.INSTANCE, 8, null);
        LOGGER.i("Payment collection metric ending in " + totalDuration + " ms: result " + (Object)((Object)result2) + ", tagMap " + tagMap, new Pair[0]);
    }

    private final void sendPerCategoryMeasurementEvents(Result result2, Map<String, String> tagMap) {
        for (LatencyCategory category : LatencyCategory.values()) {
            this.categoryEnd(category);
            long categoryLatency = this.latencyPerCategory[category.ordinal()];
            Map<String, String> $this$addEnumTag$iv = tagMap;
            boolean $i$f$addEnumTag = false;
            if ((Enum)category != null) {
                KClass kClass = Reflection.getOrCreateKotlinClass(LatencyCategory.class);
                String tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : LatencyCategory.class.getSimpleName());
                Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
                $this$addEnumTag$iv.put(tagName$iv, ((Enum)category).name());
            }
            HealthLogger.recordTimer$default(this.logger, categoryLatency, UtilsKt.toOutcome(result2), tagMap, null, sendPerCategoryMeasurementEvents.1.INSTANCE, 8, null);
            LOGGER.i("Category " + (Object)((Object)category) + " took " + categoryLatency + " ms.", new Pair[0]);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u000bJ\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\f\u0010\u0013\u001a\u00020\u0006*\u00020\u0014H\u0007J\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0006*\u00020\u0015H\u0002J\f\u0010\u0013\u001a\u0004\u0018\u00010\u0006*\u00020\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "getCollectionFailureReason", "Lcom/stripe/core/paymentcollection/metrics/CollectionFailureReason;", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "result", "Lcom/stripe/core/paymentcollection/metrics/Result;", "getCollectionFailureReason$paymentcollection_release", "getResult", "state", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "getStateWhenCancelled", "getStateWhenTimedOut", "getTransactionRequestType", "Lcom/stripe/core/hardware/paymentcollection/TransactionType;", "toCollectionFailureReason", "Lcom/stripe/core/paymentcollection/EarlyTransactionAbortReason;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult$Result;", "Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "paymentcollection_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Result getResult(PaymentCollectionData data, PaymentCollectionState state) {
            return state == PaymentCollectionState.FINISHED && data.getCollectionResultType() == PaymentCollectionResultType.SUCCESS ? Result.SUCCESS : Result.FAILURE;
        }

        private final com.stripe.core.hardware.paymentcollection.TransactionType getTransactionRequestType(PaymentCollectionData data) {
            return data.getTransactionType();
        }

        private final PaymentCollectionState getStateWhenCancelled(PaymentCollectionData data) {
            return data.getStateWhenCancelled();
        }

        private final PaymentCollectionState getStateWhenTimedOut(PaymentCollectionData data) {
            return data.getStateWhenTimedOut();
        }

        @Nullable
        public final CollectionFailureReason getCollectionFailureReason$paymentcollection_release(@NotNull PaymentCollectionData data, @NotNull Result result2) {
            CollectionFailureReason collectionFailureReason;
            CollectionFailureReason collectionFailureReason2;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
            if (result2 == Result.SUCCESS) {
                return null;
            }
            if (data.isCancelled()) {
                collectionFailureReason2 = CollectionFailureReason.MERCHANT_CANCELLED;
            } else if (data.isTimedOut()) {
                collectionFailureReason2 = CollectionFailureReason.TIMEOUT;
            } else if (data.getEarlyTransactionAbortReason() != null) {
                collectionFailureReason2 = this.toCollectionFailureReason(data.getEarlyTransactionAbortReason());
            } else {
                ChargeAttempt chargeAttempt = data.getChargeAttempt();
                collectionFailureReason2 = (chargeAttempt != null ? this.toCollectionFailureReason(chargeAttempt) : null) != null ? this.toCollectionFailureReason(data.getChargeAttempt()) : (collectionFailureReason = data.getHardwareTransactionResult() != null ? this.toCollectionFailureReason(data.getHardwareTransactionResult()) : CollectionFailureReason.UNKNOWN);
            }
            if (collectionFailureReason2 == null) {
                collectionFailureReason = CollectionFailureReason.UNKNOWN;
            }
            return collectionFailureReason;
        }

        @Nullable
        public final CollectionFailureReason toCollectionFailureReason(@NotNull ChargeAttempt $this$toCollectionFailureReason) {
            CollectionFailureReason collectionFailureReason;
            Intrinsics.checkNotNullParameter((Object)$this$toCollectionFailureReason, (String)"<this>");
            ChargeAttempt chargeAttempt = $this$toCollectionFailureReason;
            if ((chargeAttempt instanceof ChargeAttempt.CompletedAttempt.DeclinedCharge ? true : chargeAttempt instanceof ChargeAttempt.CompletedAttempt.DeclinedRefund) ? true : chargeAttempt instanceof ChargeAttempt.CompletedAttempt.AlreadyRefunded) {
                collectionFailureReason = CollectionFailureReason.ONLINE_CONFIRMATION_DECLINED;
            } else if ((Intrinsics.areEqual((Object)chargeAttempt, (Object)ChargeAttempt.CompletedAttempt.UnknownChargeResult.INSTANCE) ? true : Intrinsics.areEqual((Object)chargeAttempt, (Object)ChargeAttempt.CompletedAttempt.UnknownRefundResult.INSTANCE)) ? true : Intrinsics.areEqual((Object)chargeAttempt, (Object)ChargeAttempt.CompletedAttempt.UnknownReusableCardResult.INSTANCE)) {
                collectionFailureReason = CollectionFailureReason.ONLINE_CONFIRMATION_UNKNOWN;
            } else if (chargeAttempt instanceof ChargeAttempt.ExtendedAttempt) {
                collectionFailureReason = CollectionFailureReason.SCA_NEEDED;
            } else if (((chargeAttempt instanceof ChargeAttempt.CompletedAttempt.SuccessfulCharge ? true : chargeAttempt instanceof ChargeAttempt.CompletedAttempt.SuccessfulRefund) ? true : Intrinsics.areEqual((Object)chargeAttempt, (Object)ChargeAttempt.CompletedAttempt.SuccessfulReusableCard.INSTANCE)) ? true : Intrinsics.areEqual((Object)chargeAttempt, (Object)ChargeAttempt.CompletedAttempt.SuccessfulSetupIntent.INSTANCE)) {
                collectionFailureReason = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return collectionFailureReason;
        }

        @VisibleForTesting
        @NotNull
        public final CollectionFailureReason toCollectionFailureReason(@NotNull EarlyTransactionAbortReason $this$toCollectionFailureReason) {
            CollectionFailureReason collectionFailureReason;
            Intrinsics.checkNotNullParameter((Object)((Object)$this$toCollectionFailureReason), (String)"<this>");
            switch (WhenMappings.$EnumSwitchMapping$0[$this$toCollectionFailureReason.ordinal()]) {
                case 1: {
                    collectionFailureReason = CollectionFailureReason.CHIP_CARD_INITIALIZATION_FAILED;
                    break;
                }
                case 2: {
                    collectionFailureReason = CollectionFailureReason.EMPTY_CANDIDATE_LIST;
                    break;
                }
                case 3: {
                    collectionFailureReason = CollectionFailureReason.PIN_ENTRY_CANCELED;
                    break;
                }
                case 4: {
                    collectionFailureReason = CollectionFailureReason.PIN_ENTRY_TIMED_OUT;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return collectionFailureReason;
        }

        private final CollectionFailureReason toCollectionFailureReason(TransactionResult.Result $this$toCollectionFailureReason) {
            CollectionFailureReason collectionFailureReason;
            switch (WhenMappings.$EnumSwitchMapping$1[$this$toCollectionFailureReason.ordinal()]) {
                case 1: {
                    collectionFailureReason = null;
                    break;
                }
                case 2: {
                    collectionFailureReason = CollectionFailureReason.CONTACTLESS_LIMIT_EXCEEDED;
                    break;
                }
                case 3: {
                    collectionFailureReason = CollectionFailureReason.READER_DECLINED;
                    break;
                }
                case 4: {
                    collectionFailureReason = CollectionFailureReason.READER_TERMINATED;
                    break;
                }
                case 5: {
                    collectionFailureReason = CollectionFailureReason.MERCHANT_CANCELLED;
                    break;
                }
                case 6: {
                    collectionFailureReason = CollectionFailureReason.EMPTY_CANDIDATE_LIST;
                    break;
                }
                case 7: {
                    collectionFailureReason = CollectionFailureReason.CARD_BLOCKED;
                    break;
                }
                case 8: {
                    collectionFailureReason = CollectionFailureReason.DEVICE_FAILURE;
                    break;
                }
                case 9: {
                    collectionFailureReason = CollectionFailureReason.ICC_CARD_REMOVED;
                    break;
                }
                case 10: {
                    collectionFailureReason = CollectionFailureReason.CHECK_MOBILE_DEVICE;
                    break;
                }
                case 11: {
                    collectionFailureReason = CollectionFailureReason.INSERT_OR_SWIPE_REQUIRED;
                    break;
                }
                case 12: {
                    collectionFailureReason = CollectionFailureReason.MULTIPLE_CARDS_DETECTED;
                    break;
                }
                case 13: {
                    collectionFailureReason = CollectionFailureReason.MOBILE_WALLET_TOO_MANY_TAPS;
                    break;
                }
                case 14: {
                    collectionFailureReason = CollectionFailureReason.CARD_STILL_INSERTED;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return collectionFailureReason;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[EarlyTransactionAbortReason.values().length];
                try {
                    nArray[EarlyTransactionAbortReason.CHIP_CARD_INITIALIZATION_FAILED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EarlyTransactionAbortReason.EMPTY_CANDIDATE_LIST.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EarlyTransactionAbortReason.PIN_ENTRY_CANCELED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EarlyTransactionAbortReason.PIN_ENTRY_TIMED_OUT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[TransactionResult.Result.values().length];
                try {
                    nArray[TransactionResult.Result.APPROVED.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.CONTACTLESS_LIMIT_EXCEEDED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.DECLINED.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.TERMINATED.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.CANCELED.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.EMPTY_CANDIDATE_LIST.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.CARD_BLOCKED.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.DEVICE_FAILURE.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.ICC_CARD_REMOVED.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.CHECK_MOBILE_DEVICE.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.INSERT_OR_SWIPE_REQUIRED.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.MULTIPLE_CARDS_DETECTED.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.MOBILE_WALLET_TOO_MANY_TAPS.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TransactionResult.Result.CARD_STILL_INSERTED.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

