/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.metrics;

import com.stripe.core.hardware.paymentcollection.ContactCardSlotState;
import com.stripe.core.hardware.paymentcollection.PinEntryStatus;
import com.stripe.core.paymentcollection.AuthorizePaymentEvent;
import com.stripe.core.paymentcollection.CancelHardwareTippingCollectionEvent;
import com.stripe.core.paymentcollection.ChipCardInitializationFailed;
import com.stripe.core.paymentcollection.ConfigureReaderEvent;
import com.stripe.core.paymentcollection.ContactCardUpdateEvent;
import com.stripe.core.paymentcollection.EmptyCandidateListEncounteredEvent;
import com.stripe.core.paymentcollection.HardwareEvent;
import com.stripe.core.paymentcollection.HardwareListenerEvent;
import com.stripe.core.paymentcollection.HardwareTippingCollectionEvent;
import com.stripe.core.paymentcollection.HardwareTippingCollectionResultEvent;
import com.stripe.core.paymentcollection.HardwareTransactionCancelledEvent;
import com.stripe.core.paymentcollection.IntermediateErrorEvent;
import com.stripe.core.paymentcollection.MagStripeReadEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PinEntryStatusChangeEvent;
import com.stripe.core.paymentcollection.ReaderFinalConfirmationTlvCollectedEvent;
import com.stripe.core.paymentcollection.ReaderTypeChangedEvent;
import com.stripe.core.paymentcollection.ReadingCardEvent;
import com.stripe.core.paymentcollection.RequestOnlineAuthorisationEvent;
import com.stripe.core.paymentcollection.RequestPinEntryEvent;
import com.stripe.core.paymentcollection.RequestSelectAccountEvent;
import com.stripe.core.paymentcollection.RequestSelectApplicationEvent;
import com.stripe.core.paymentcollection.ResetPaymentInterfacesEvent;
import com.stripe.core.paymentcollection.SelectAccountTypeEvent;
import com.stripe.core.paymentcollection.SelectApplicationEvent;
import com.stripe.core.paymentcollection.SelectLanguageEvent;
import com.stripe.core.paymentcollection.SendFinalConfirmEvent;
import com.stripe.core.paymentcollection.SetPinEntryAsteriskCountEvent;
import com.stripe.core.paymentcollection.SetPinPadResultEvent;
import com.stripe.core.paymentcollection.ShowThankYouEvent;
import com.stripe.core.paymentcollection.StartPinEntryEvent;
import com.stripe.core.paymentcollection.StartPollingForCardStatusEvent;
import com.stripe.core.paymentcollection.StopReaderEvent;
import com.stripe.core.paymentcollection.TransactionCompletedEvent;
import com.stripe.core.paymentcollection.WaitForCardPresentEvent;
import com.stripe.core.paymentcollection.metrics.EndToEndEventLogger;
import com.stripe.core.paymentcollection.metrics.KernelProcessingEventLogger;
import com.stripe.core.paymentcollection.metrics.KernelProcessingFailureReason;
import com.stripe.core.paymentcollection.metrics.KernelProcessingStatus;
import com.stripe.core.paymentcollection.metrics.LatencyCategory;
import com.stripe.core.paymentcollection.metrics.Result;
import com.stripe.core.paymentcollection.metrics.StageEventLogHelper;
import com.stripe.core.paymentcollection.metrics.UtilsKt;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.magstripe.MagStripePaymentCollectionAuthority;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.PaymentCollectionDomain;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.StageScope;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001e2\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001j\u0002`\u0006:\u0001\u001eB1\u0012\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\bj\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0018\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00182\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\"\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\b\u0010\u001d\u001a\u00020\u0010H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/stripe/core/paymentcollection/metrics/KernelProcessingEventLogger;", "Lcom/stripe/core/paymentcollection/metrics/StageEventLogHelper;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/StageScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/StageScope$Builder;", "Lcom/stripe/core/paymentcollection/metrics/PaymentCollectionStageEventLogger;", "logger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/core/paymentcollection/metrics/StageLogger;", "endToEndEventLogger", "Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;", "(Lcom/stripe/jvmcore/logging/HealthLogger;Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;)V", "curStatus", "Lcom/stripe/core/paymentcollection/metrics/KernelProcessingStatus;", "closeLog", "", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "eventName", "", "getKernelStatus", "event", "Lcom/stripe/core/paymentcollection/HardwareEvent;", "Lcom/stripe/core/paymentcollection/HardwareListenerEvent;", "onHardwareEvent", "onHardwareListenerEvent", "onKernelStatusUpdate", "newStatus", "openLog", "Companion", "paymentcollection_release"})
public final class KernelProcessingEventLogger
extends StageEventLogHelper<PaymentCollectionDomain, PaymentCollectionDomain.Builder, StageScope, StageScope.Builder> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private KernelProcessingStatus curStatus;
    @NotNull
    private static final String KERNEL_PROCESSING_RESULT = "KernelProcessingResult";

    public KernelProcessingEventLogger(@NotNull HealthLogger<PaymentCollectionDomain, PaymentCollectionDomain.Builder, StageScope, StageScope.Builder> logger2, @NotNull EndToEndEventLogger endToEndEventLogger) {
        Intrinsics.checkNotNullParameter(logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)endToEndEventLogger, (String)"endToEndEventLogger");
        super(logger2, "KernelProcessing", endToEndEventLogger, LatencyCategory.KERNEL_PROCESSING);
        this.curStatus = KernelProcessingStatus.IDLE;
    }

    public final void onHardwareEvent(@NotNull HardwareEvent event, @Nullable PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        KernelProcessingStatus kernelProcessingStatus = this.getKernelStatus(event);
        String string = event.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.javaClass.simpleName");
        this.onKernelStatusUpdate(kernelProcessingStatus, string, data);
    }

    public final void onHardwareListenerEvent(@NotNull HardwareListenerEvent event, @Nullable PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        KernelProcessingStatus kernelProcessingStatus = this.getKernelStatus(event);
        String string = event.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.javaClass.simpleName");
        this.onKernelStatusUpdate(kernelProcessingStatus, string, data);
    }

    private final void onKernelStatusUpdate(KernelProcessingStatus newStatus, String eventName, PaymentCollectionData data) {
        StageEventLogHelper.Companion.getLOGGER().i("KernelProcessing newStatus " + (Object)((Object)newStatus) + " event " + eventName, new Pair[0]);
        if (newStatus == KernelProcessingStatus.UNKNOWN || newStatus == this.curStatus) {
            return;
        }
        this.curStatus = newStatus;
        if (newStatus == KernelProcessingStatus.BUSY) {
            this.openLog();
        } else {
            this.closeLog(data, eventName);
        }
    }

    private final void openLog() {
        StageEventLogHelper.openLogHelper$default(this, null, openLog.1.INSTANCE, 1, null);
    }

    private final void closeLog(PaymentCollectionData data, String eventName) {
        if (data == null) {
            return;
        }
        this.closeLogHelper(data, (Function1<Map<String, String>, Pair<Outcome, Map<String, String>>>)((Function1)new Function1<Map<String, String>, Pair<? extends Outcome, ? extends Map<String, String>>>(data, eventName){
            final /* synthetic */ PaymentCollectionData $data;
            final /* synthetic */ String $eventName;
            {
                this.$data = $data;
                this.$eventName = $eventName;
                super(1);
            }

            @NotNull
            public final Pair<Outcome, Map<String, String>> invoke(@NotNull Map<String, String> tagMap) {
                Intrinsics.checkNotNullParameter(tagMap, (String)"tagMap");
                Pair pair = this.$data.isCancelled() ? new Pair((Object)((Object)Result.FAILURE), (Object)((Object)KernelProcessingFailureReason.MERCHANT_CANCELLED)) : (this.$data.isTimedOut() ? new Pair((Object)((Object)Result.FAILURE), (Object)((Object)KernelProcessingFailureReason.TIMEOUT)) : new Pair((Object)((Object)Result.SUCCESS), null));
                Result result2 = (Result)((Object)pair.component1());
                KernelProcessingFailureReason failureReason = (KernelProcessingFailureReason)((Object)pair.component2());
                Map<String, String> map2 = tagMap;
                String string = this.$eventName;
                Map<String, String> $this$invoke_u24lambda_u240 = map2;
                boolean bl = false;
                Map<String, String> $this$addEnumTag$iv = $this$invoke_u24lambda_u240;
                boolean $i$f$addEnumTag = false;
                if ((Enum)failureReason != null) {
                    KClass kClass = Reflection.getOrCreateKotlinClass(KernelProcessingFailureReason.class);
                    String tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : KernelProcessingFailureReason.class.getSimpleName());
                    Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
                    $this$addEnumTag$iv.put(tagName$iv, ((Enum)failureReason).name());
                }
                $this$invoke_u24lambda_u240.put("KernelProcessingResult", string);
                return new Pair((Object)UtilsKt.toOutcome(result2), tagMap);
            }
        }));
    }

    private final KernelProcessingStatus getKernelStatus(HardwareEvent event) {
        KernelProcessingStatus kernelProcessingStatus;
        HardwareEvent hardwareEvent = event;
        if ((((((((hardwareEvent instanceof ConfigureReaderEvent ? true : hardwareEvent instanceof AuthorizePaymentEvent) ? true : hardwareEvent instanceof SelectAccountTypeEvent) ? true : hardwareEvent instanceof SelectApplicationEvent) ? true : hardwareEvent instanceof SelectLanguageEvent) ? true : Intrinsics.areEqual((Object)hardwareEvent, (Object)StartPinEntryEvent.INSTANCE)) ? true : hardwareEvent instanceof StopReaderEvent) ? true : Intrinsics.areEqual((Object)hardwareEvent, (Object)RequestPinEntryEvent.INSTANCE)) ? true : hardwareEvent instanceof SendFinalConfirmEvent) {
            kernelProcessingStatus = KernelProcessingStatus.BUSY;
        } else if ((hardwareEvent instanceof StartPollingForCardStatusEvent ? true : hardwareEvent instanceof HardwareTippingCollectionEvent) ? true : Intrinsics.areEqual((Object)hardwareEvent, (Object)CancelHardwareTippingCollectionEvent.INSTANCE)) {
            kernelProcessingStatus = KernelProcessingStatus.UNKNOWN;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return kernelProcessingStatus;
    }

    private final KernelProcessingStatus getKernelStatus(HardwareListenerEvent event) {
        KernelProcessingStatus kernelProcessingStatus;
        block20: {
            HardwareListenerEvent hardwareListenerEvent;
            block22: {
                block21: {
                    block19: {
                        hardwareListenerEvent = event;
                        if (!(Intrinsics.areEqual((Object)hardwareListenerEvent, (Object)EmptyCandidateListEncounteredEvent.INSTANCE) ? true : Intrinsics.areEqual((Object)hardwareListenerEvent, (Object)ChipCardInitializationFailed.INSTANCE))) break block19;
                        kernelProcessingStatus = KernelProcessingStatus.BUSY;
                        break block20;
                    }
                    if (!(hardwareListenerEvent instanceof ContactCardUpdateEvent)) break block21;
                    switch (WhenMappings.$EnumSwitchMapping$0[((ContactCardUpdateEvent)event).getUpdatedCardState().ordinal()]) {
                        case 1: 
                        case 2: {
                            kernelProcessingStatus = KernelProcessingStatus.IDLE;
                            break block20;
                        }
                        case 3: {
                            kernelProcessingStatus = KernelProcessingStatus.UNKNOWN;
                            break block20;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                if (!(hardwareListenerEvent instanceof PinEntryStatusChangeEvent)) break block22;
                switch (WhenMappings.$EnumSwitchMapping$1[((PinEntryStatusChangeEvent)event).getStatus().ordinal()]) {
                    case 1: {
                        kernelProcessingStatus = KernelProcessingStatus.UNKNOWN;
                        break block20;
                    }
                    case 2: {
                        kernelProcessingStatus = KernelProcessingStatus.IDLE;
                        break block20;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        kernelProcessingStatus = KernelProcessingStatus.BUSY;
                        break block20;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            if (((((((((hardwareListenerEvent instanceof TransactionCompletedEvent ? true : Intrinsics.areEqual((Object)hardwareListenerEvent, (Object)WaitForCardPresentEvent.INSTANCE)) ? true : Intrinsics.areEqual((Object)hardwareListenerEvent, (Object)RequestSelectAccountEvent.INSTANCE)) ? true : Intrinsics.areEqual((Object)hardwareListenerEvent, (Object)ShowThankYouEvent.INSTANCE)) ? true : hardwareListenerEvent instanceof SetPinEntryAsteriskCountEvent) ? true : hardwareListenerEvent instanceof RequestSelectApplicationEvent) ? true : hardwareListenerEvent instanceof ReaderFinalConfirmationTlvCollectedEvent) ? true : hardwareListenerEvent instanceof ReaderTypeChangedEvent) ? true : hardwareListenerEvent instanceof MagStripeReadEvent) ? true : hardwareListenerEvent instanceof RequestOnlineAuthorisationEvent) {
                kernelProcessingStatus = KernelProcessingStatus.IDLE;
            } else if (Intrinsics.areEqual((Object)hardwareListenerEvent, (Object)ResetPaymentInterfacesEvent.INSTANCE)) {
                kernelProcessingStatus = KernelProcessingStatus.UNKNOWN;
            } else if (Intrinsics.areEqual((Object)hardwareListenerEvent, (Object)ReadingCardEvent.INSTANCE)) {
                kernelProcessingStatus = KernelProcessingStatus.BUSY;
            } else if ((hardwareListenerEvent instanceof HardwareTippingCollectionResultEvent ? true : Intrinsics.areEqual((Object)hardwareListenerEvent, (Object)HardwareTransactionCancelledEvent.INSTANCE)) ? true : hardwareListenerEvent instanceof SetPinPadResultEvent) {
                kernelProcessingStatus = KernelProcessingStatus.IDLE;
            } else if (hardwareListenerEvent instanceof IntermediateErrorEvent) {
                kernelProcessingStatus = KernelProcessingStatus.IDLE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return kernelProcessingStatus;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/paymentcollection/metrics/KernelProcessingEventLogger$Companion;", "", "()V", "KERNEL_PROCESSING_RESULT", "", "paymentcollection_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ContactCardSlotState.values().length];
            try {
                nArray[ContactCardSlotState.EMPTY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContactCardSlotState.CARD_INSERTED_INCORRECTLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContactCardSlotState.CARD_INSERTED_CORRECTLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PinEntryStatus.values().length];
            try {
                nArray[PinEntryStatus.NOT_REQUESTED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.REQUESTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.SUCCESS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.CANCEL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.TIMEOUT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.BYPASS.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.WRONG_PIN_LENGTH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.INCORRECT_PIN.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.ENTERED.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PinEntryStatus.ICC_REMOVED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

