/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.metrics;

import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.metrics.EndToEndEventLogger;
import com.stripe.core.paymentcollection.metrics.LatencyCategory;
import com.stripe.core.paymentcollection.metrics.OnlineAuthFailureReason;
import com.stripe.core.paymentcollection.metrics.OnlineAuthLogger;
import com.stripe.core.paymentcollection.metrics.Result;
import com.stripe.core.paymentcollection.metrics.StageEventLogHelper;
import com.stripe.core.paymentcollection.metrics.UtilsKt;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.magstripe.MagStripePaymentCollectionAuthority;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import com.stripe.jvmcore.paymentcollection.OnlineAuthType;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.PaymentCollectionDomain;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.StageScope;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001j\u0002`\u0006B1\u0012\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\bj\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\u001f\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010 \u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/stripe/core/paymentcollection/metrics/OnlineAuthLogger;", "Lcom/stripe/core/paymentcollection/metrics/StageEventLogHelper;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/StageScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/StageScope$Builder;", "Lcom/stripe/core/paymentcollection/metrics/PaymentCollectionStageEventLogger;", "logger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/core/paymentcollection/metrics/StageLogger;", "endToEndEventLogger", "Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;", "(Lcom/stripe/jvmcore/logging/HealthLogger;Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;)V", "authType", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthType;", "getAuthType", "()Lcom/stripe/jvmcore/paymentcollection/OnlineAuthType;", "setAuthType", "(Lcom/stripe/jvmcore/paymentcollection/OnlineAuthType;)V", "closeLog", "", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "authState", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthState;", "getMetricReason", "Lcom/stripe/core/paymentcollection/metrics/OnlineAuthFailureReason;", "failureReason", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthFailureReason;", "getResult", "Lkotlin/Pair;", "Lcom/stripe/core/paymentcollection/metrics/Result;", "openLog", "paymentcollection_release"})
public final class OnlineAuthLogger
extends StageEventLogHelper<PaymentCollectionDomain, PaymentCollectionDomain.Builder, StageScope, StageScope.Builder> {
    @Nullable
    private OnlineAuthType authType;

    public OnlineAuthLogger(@NotNull HealthLogger<PaymentCollectionDomain, PaymentCollectionDomain.Builder, StageScope, StageScope.Builder> logger2, @NotNull EndToEndEventLogger endToEndEventLogger) {
        Intrinsics.checkNotNullParameter(logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)endToEndEventLogger, (String)"endToEndEventLogger");
        super(logger2, "OnlineAuth", endToEndEventLogger, LatencyCategory.NETWORK_PROCESSING);
    }

    @Nullable
    public final OnlineAuthType getAuthType() {
        return this.authType;
    }

    public final void setAuthType(@Nullable OnlineAuthType onlineAuthType) {
        this.authType = onlineAuthType;
    }

    public final void openLog(@NotNull OnlineAuthType authType) {
        Intrinsics.checkNotNullParameter((Object)((Object)authType), (String)"authType");
        this.authType = authType;
        StageEventLogHelper.openLogHelper$default(this, null, openLog.1.INSTANCE, 1, null);
    }

    public final void closeLog(@Nullable PaymentCollectionData data, @NotNull OnlineAuthState authState) {
        Intrinsics.checkNotNullParameter((Object)authState, (String)"authState");
        OnlineAuthType onlineAuthType = this.authType;
        if (onlineAuthType == null) {
            return;
        }
        OnlineAuthType authType = onlineAuthType;
        if (data == null) {
            return;
        }
        this.closeLogHelper(data, (Function1<Map<String, String>, Pair<Outcome, Map<String, String>>>)((Function1)new Function1<Map<String, String>, Pair<? extends Outcome, ? extends Map<String, String>>>(data, this, authState, authType){
            final /* synthetic */ PaymentCollectionData $data;
            final /* synthetic */ OnlineAuthLogger this$0;
            final /* synthetic */ OnlineAuthState $authState;
            final /* synthetic */ OnlineAuthType $authType;
            {
                this.$data = $data;
                this.this$0 = $receiver;
                this.$authState = $authState;
                this.$authType = $authType;
                super(1);
            }

            @NotNull
            public final Pair<Outcome, Map<String, String>> invoke(@NotNull Map<String, String> tagMap) {
                String tagName$iv;
                KClass kClass;
                Intrinsics.checkNotNullParameter(tagMap, (String)"tagMap");
                Pair pair = this.$data.isTimedOut() ? new Pair((Object)((Object)Result.FAILURE), (Object)((Object)OnlineAuthFailureReason.TIMEOUT)) : (this.$data.isCancelled() ? new Pair((Object)((Object)Result.FAILURE), (Object)((Object)OnlineAuthFailureReason.MERCHANT_CANCELLED)) : OnlineAuthLogger.access$getResult(this.this$0, this.$authState));
                Result result2 = (Result)((Object)pair.component1());
                OnlineAuthFailureReason failureReason = (OnlineAuthFailureReason)((Object)pair.component2());
                Map<String, String> map2 = tagMap;
                OnlineAuthType onlineAuthType = this.$authType;
                Map<String, String> $this$invoke_u24lambda_u240 = map2;
                boolean bl = false;
                Map<String, String> $this$addEnumTag$iv = $this$invoke_u24lambda_u240;
                boolean $i$f$addEnumTag = false;
                if ((Enum)failureReason != null) {
                    kClass = Reflection.getOrCreateKotlinClass(OnlineAuthFailureReason.class);
                    tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : OnlineAuthFailureReason.class.getSimpleName());
                    Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
                    $this$addEnumTag$iv.put(tagName$iv, ((Enum)failureReason).name());
                }
                $this$addEnumTag$iv = $this$invoke_u24lambda_u240;
                $i$f$addEnumTag = false;
                if ((Enum)onlineAuthType != null) {
                    kClass = Reflection.getOrCreateKotlinClass(OnlineAuthType.class);
                    tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : OnlineAuthType.class.getSimpleName());
                    Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
                    $this$addEnumTag$iv.put(tagName$iv, ((Enum)onlineAuthType).name());
                }
                return new Pair((Object)UtilsKt.toOutcome(result2), tagMap);
            }
        }));
    }

    private final Pair<Result, OnlineAuthFailureReason> getResult(OnlineAuthState authState) {
        Pair pair;
        OnlineAuthState onlineAuthState = authState;
        if (Intrinsics.areEqual((Object)onlineAuthState, (Object)OnlineAuthState.Cancelled.INSTANCE)) {
            pair = new Pair((Object)Result.FAILURE, (Object)OnlineAuthFailureReason.MERCHANT_CANCELLED);
        } else if (onlineAuthState instanceof OnlineAuthState.ConfirmationResponseReceived.Failed) {
            pair = new Pair((Object)Result.FAILURE, (Object)this.getMetricReason(((OnlineAuthState.ConfirmationResponseReceived.Failed)authState).getReason()));
        } else if (onlineAuthState instanceof OnlineAuthState.SecondGenAcResponseReceived.Failed) {
            pair = new Pair((Object)Result.FAILURE, (Object)this.getMetricReason(((OnlineAuthState.SecondGenAcResponseReceived.Failed)authState).getReason()));
        } else if ((Intrinsics.areEqual((Object)onlineAuthState, (Object)OnlineAuthState.ConfirmationStarted.INSTANCE) ? true : Intrinsics.areEqual((Object)onlineAuthState, (Object)OnlineAuthState.ReadyToStartConfirmation.INSTANCE)) ? true : Intrinsics.areEqual((Object)onlineAuthState, (Object)OnlineAuthState.SecondGenAcStarted.INSTANCE)) {
            pair = new Pair((Object)Result.FAILURE, (Object)OnlineAuthFailureReason.UNKNOWN);
        } else if ((onlineAuthState instanceof OnlineAuthState.ConfirmationResponseReceived.NeedSecondGenAc ? true : onlineAuthState instanceof OnlineAuthState.ConfirmationResponseReceived.Success) ? true : onlineAuthState instanceof OnlineAuthState.SecondGenAcResponseReceived.Success) {
            pair = new Pair((Object)Result.SUCCESS, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return pair;
    }

    private final OnlineAuthFailureReason getMetricReason(com.stripe.jvmcore.paymentcollection.OnlineAuthFailureReason failureReason) {
        OnlineAuthFailureReason onlineAuthFailureReason;
        switch (WhenMappings.$EnumSwitchMapping$0[failureReason.ordinal()]) {
            case 1: {
                onlineAuthFailureReason = OnlineAuthFailureReason.DECLINED;
                break;
            }
            case 2: {
                onlineAuthFailureReason = OnlineAuthFailureReason.SCA_NEEDED;
                break;
            }
            case 3: {
                onlineAuthFailureReason = OnlineAuthFailureReason.UNKNOWN_NETWORK_FAILURE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return onlineAuthFailureReason;
    }

    public static final /* synthetic */ Pair access$getResult(OnlineAuthLogger $this, OnlineAuthState authState) {
        return $this.getResult(authState);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[com.stripe.jvmcore.paymentcollection.OnlineAuthFailureReason.values().length];
            try {
                nArray[com.stripe.jvmcore.paymentcollection.OnlineAuthFailureReason.DECLINED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.stripe.jvmcore.paymentcollection.OnlineAuthFailureReason.SCA_NEEDED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[com.stripe.jvmcore.paymentcollection.OnlineAuthFailureReason.UNKNOWN_NETWORK_FAILURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

