/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.metrics;

import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.metrics.PendingPosCommand;
import com.stripe.core.paymentcollection.metrics.StageEventLogger;
import com.stripe.jvmcore.paymentcollection.OnlineAuthFailureReason;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import com.stripe.jvmcore.paymentcollection.OnlineAuthType;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/stripe/core/paymentcollection/metrics/OnlineAuthStateLogger;", "", "stageEventLogger", "Lcom/stripe/core/paymentcollection/metrics/StageEventLogger;", "(Lcom/stripe/core/paymentcollection/metrics/StageEventLogger;)V", "getStageEventLogger", "()Lcom/stripe/core/paymentcollection/metrics/StageEventLogger;", "updateOnlineAuthState", "", "state", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthState;", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "paymentcollection_release"})
public final class OnlineAuthStateLogger {
    @NotNull
    private final StageEventLogger stageEventLogger;

    @Inject
    public OnlineAuthStateLogger(@NotNull StageEventLogger stageEventLogger) {
        Intrinsics.checkNotNullParameter((Object)stageEventLogger, (String)"stageEventLogger");
        this.stageEventLogger = stageEventLogger;
    }

    @NotNull
    public final StageEventLogger getStageEventLogger() {
        return this.stageEventLogger;
    }

    public final void updateOnlineAuthState(@NotNull OnlineAuthState state, @Nullable PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        OnlineAuthType authType = state.getOnlineAuthType();
        OnlineAuthState onlineAuthState = state;
        if (Intrinsics.areEqual((Object)onlineAuthState, (Object)OnlineAuthState.ReadyToStartConfirmation.INSTANCE)) {
            this.stageEventLogger.openWaitForPosCommandLog(PendingPosCommand.PROCESS_PAYMENT);
        } else if (Intrinsics.areEqual((Object)onlineAuthState, (Object)OnlineAuthState.ConfirmationStarted.INSTANCE)) {
            this.stageEventLogger.closeWaitForPosCommandLog(data, PendingPosCommand.PROCESS_PAYMENT);
            this.stageEventLogger.openOnlineAuthenticationLog(authType);
        } else if (Intrinsics.areEqual((Object)onlineAuthState, (Object)OnlineAuthState.SecondGenAcStarted.INSTANCE)) {
            this.stageEventLogger.openOnlineAuthenticationLog(authType);
        } else if (((((Intrinsics.areEqual((Object)onlineAuthState, (Object)OnlineAuthState.Cancelled.INSTANCE) ? true : onlineAuthState instanceof OnlineAuthState.ConfirmationResponseReceived.NeedSecondGenAc) ? true : onlineAuthState instanceof OnlineAuthState.ConfirmationResponseReceived.Success) ? true : onlineAuthState instanceof OnlineAuthState.ConfirmationResponseReceived.Failed) ? true : onlineAuthState instanceof OnlineAuthState.SecondGenAcResponseReceived.Failed) ? true : onlineAuthState instanceof OnlineAuthState.SecondGenAcResponseReceived.Success) {
            if (state instanceof OnlineAuthState.ConfirmationResponseReceived.Failed && ((OnlineAuthState.ConfirmationResponseReceived.Failed)state).getReason() == OnlineAuthFailureReason.SCA_NEEDED || state instanceof OnlineAuthState.SecondGenAcResponseReceived.Failed && ((OnlineAuthState.SecondGenAcResponseReceived.Failed)state).getReason() == OnlineAuthFailureReason.SCA_NEEDED) {
                this.stageEventLogger.openWaitForPosCommandLog(PendingPosCommand.RESUME_PAYMENT);
            }
            this.stageEventLogger.closeOnlineAuthenticationLog(data, state);
        }
    }
}

