/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.metrics;

import androidx.annotation.CallSuper;
import com.squareup.wire.Message;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.manualentry.ManualEntryData;
import com.stripe.core.paymentcollection.metrics.EndToEndEventLogger;
import com.stripe.core.paymentcollection.metrics.LatencyCategory;
import com.stripe.core.paymentcollection.metrics.StageEventLogger;
import com.stripe.core.paymentcollection.metrics.UtilsKt;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.PendingTimer;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.proto.terminal.clientlogger.pub.message.health.metrictype.Timer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 ,*\u0014\b\u0000\u0010\u0001*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004*\u0014\b\u0002\u0010\u0005*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u0002*\u0014\b\u0003\u0010\u0006*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00060\u00042\u00020\u0007:\u0001,BA\u0012\u001e\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0016\u001a\u00020\u0017H\u0017JW\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2E\u0010\u001b\u001aA\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001d0!0\u001cH\u0004JW\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020#2E\u0010\u001b\u001aA\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b( \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001d0!0\u001cH\u0004JM\u0010$\u001a\u00020\u00172\u0014\b\u0002\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0&2-\u0010'\u001a)\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00170(j\u000e\u0012\u0004\u0012\u00028\u0003\u0012\u0004\u0012\u00020)`*\u00a2\u0006\u0002\b+H\u0004R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/stripe/core/paymentcollection/metrics/StageEventLogHelper;", "D", "Lcom/squareup/wire/Message;", "DB", "Lcom/squareup/wire/Message$Builder;", "S", "SB", "", "logger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "eventName", "", "endToEndEventLogger", "Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;", "latencyCategory", "Lcom/stripe/core/paymentcollection/metrics/LatencyCategory;", "(Lcom/stripe/jvmcore/logging/HealthLogger;Ljava/lang/String;Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;Lcom/stripe/core/paymentcollection/metrics/LatencyCategory;)V", "isOpen", "", "()Z", "openLog", "Lcom/stripe/jvmcore/logging/PendingTimer;", "cleanUp", "", "closeLogHelper", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "outcomeAndTags", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "tagMap", "Lkotlin/Pair;", "Lcom/stripe/jvmcore/loggingmodels/Outcome;", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryData;", "openLogHelper", "tags", "", "timerSetter", "Lkotlin/Function2;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/metrictype/Timer;", "Lcom/stripe/jvmcore/logging/EventSetter;", "Lkotlin/ExtensionFunctionType;", "Companion", "paymentcollection_release"})
@SourceDebugExtension(value={"SMAP\nStageEventLogHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StageEventLogHelper.kt\ncom/stripe/core/paymentcollection/metrics/StageEventLogHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public abstract class StageEventLogHelper<D extends Message<D, DB>, DB extends Message.Builder<D, DB>, S extends Message<S, SB>, SB extends Message.Builder<S, SB>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HealthLogger<D, DB, S, SB> logger;
    @NotNull
    private final String eventName;
    @NotNull
    private final EndToEndEventLogger endToEndEventLogger;
    @Nullable
    private final LatencyCategory latencyCategory;
    @Nullable
    private PendingTimer openLog;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(StageEventLogger.class);

    public StageEventLogHelper(@NotNull HealthLogger<D, DB, S, SB> logger2, @NotNull String eventName, @NotNull EndToEndEventLogger endToEndEventLogger, @Nullable LatencyCategory latencyCategory) {
        Intrinsics.checkNotNullParameter(logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
        Intrinsics.checkNotNullParameter((Object)endToEndEventLogger, (String)"endToEndEventLogger");
        this.logger = logger2;
        this.eventName = eventName;
        this.endToEndEventLogger = endToEndEventLogger;
        this.latencyCategory = latencyCategory;
    }

    public /* synthetic */ StageEventLogHelper(HealthLogger healthLogger2, String string, EndToEndEventLogger endToEndEventLogger, LatencyCategory latencyCategory, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            latencyCategory = null;
        }
        this(healthLogger2, string, endToEndEventLogger, latencyCategory);
    }

    protected final boolean isOpen() {
        return this.openLog != null;
    }

    protected final void openLogHelper(@NotNull Map<String, String> tags, @NotNull Function2<? super SB, ? super Timer, Unit> timerSetter) {
        block0: {
            Intrinsics.checkNotNullParameter(tags, (String)"tags");
            Intrinsics.checkNotNullParameter(timerSetter, (String)"timerSetter");
            LOGGER.i("Starting event " + this.eventName + " with latencyCategory " + (Object)((Object)this.latencyCategory), new Pair[0]);
            this.openLog = this.logger.startTimer(tags, timerSetter);
            LatencyCategory latencyCategory = this.latencyCategory;
            if (latencyCategory == null) break block0;
            LatencyCategory it = latencyCategory;
            boolean bl = false;
            this.endToEndEventLogger.categoryStart(this.latencyCategory);
        }
    }

    public static /* synthetic */ void openLogHelper$default(StageEventLogHelper stageEventLogHelper, Map map2, Function2 function2, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: openLogHelper");
        }
        if ((n2 & 1) != 0) {
            map2 = MapsKt.emptyMap();
        }
        stageEventLogHelper.openLogHelper(map2, function2);
    }

    @CallSuper
    public void cleanUp() {
        LatencyCategory latencyCategory = this.latencyCategory;
        if (latencyCategory != null) {
            LatencyCategory category = latencyCategory;
            boolean bl = false;
            this.endToEndEventLogger.categoryEnd(category);
        }
        this.openLog = null;
    }

    protected final void closeLogHelper(@NotNull PaymentCollectionData data, @NotNull Function1<? super Map<String, String>, ? extends Pair<? extends Outcome, ? extends Map<String, String>>> outcomeAndTags) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(outcomeAndTags, (String)"outcomeAndTags");
            PendingTimer pendingTimer = this.openLog;
            if (pendingTimer == null) break block1;
            PendingTimer it = pendingTimer;
            boolean bl = false;
            LatencyCategory latencyCategory = this.latencyCategory;
            if (latencyCategory != null) {
                LatencyCategory category = latencyCategory;
                boolean bl2 = false;
                this.endToEndEventLogger.categoryEnd(category);
            }
            Pair pair = (Pair)outcomeAndTags.invoke(UtilsKt.generateCommonTags(data, this.latencyCategory));
            Outcome outcome = (Outcome)pair.component1();
            Map tags = (Map)pair.component2();
            LOGGER.i("Reporting " + this.eventName + " outcome " + outcome + " tags " + tags, new Pair[0]);
            HealthLogger.endTimer$default(this.logger, it, outcome, tags, null, 8, null);
            this.openLog = null;
        }
    }

    protected final void closeLogHelper(@NotNull ManualEntryData data, @NotNull Function1<? super Map<String, String>, ? extends Pair<? extends Outcome, ? extends Map<String, String>>> outcomeAndTags) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter(outcomeAndTags, (String)"outcomeAndTags");
            PendingTimer pendingTimer = this.openLog;
            if (pendingTimer == null) break block1;
            PendingTimer it = pendingTimer;
            boolean bl = false;
            LatencyCategory latencyCategory = this.latencyCategory;
            if (latencyCategory != null) {
                LatencyCategory category = latencyCategory;
                boolean bl2 = false;
                this.endToEndEventLogger.categoryEnd(category);
            }
            Pair pair = (Pair)outcomeAndTags.invoke(UtilsKt.generateCommonTags(data, this.latencyCategory));
            Outcome outcome = (Outcome)pair.component1();
            Map tags = (Map)pair.component2();
            LOGGER.i("Reporting " + this.eventName + " outcome " + outcome + " tags " + tags, new Pair[0]);
            HealthLogger.endTimer$default(this.logger, it, outcome, tags, null, 8, null);
            this.openLog = null;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/core/paymentcollection/metrics/StageEventLogHelper$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "getLOGGER", "()Lcom/stripe/jvmcore/logging/terminal/log/Log;", "paymentcollection_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Log getLOGGER() {
            return LOGGER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

