/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.metrics;

import com.stripe.core.paymentcollection.HardwareEvent;
import com.stripe.core.paymentcollection.HardwareListenerEvent;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionState;
import com.stripe.core.paymentcollection.metrics.AccountSelectionLogger;
import com.stripe.core.paymentcollection.metrics.ApplicationSelectionLogger;
import com.stripe.core.paymentcollection.metrics.DisplayCartLogger;
import com.stripe.core.paymentcollection.metrics.DisplayCartResult;
import com.stripe.core.paymentcollection.metrics.EndToEndEventLogger;
import com.stripe.core.paymentcollection.metrics.KernelProcessingEventLogger;
import com.stripe.core.paymentcollection.metrics.OnlineAuthLogger;
import com.stripe.core.paymentcollection.metrics.PendingPosCommand;
import com.stripe.core.paymentcollection.metrics.PinEntryFailureReason;
import com.stripe.core.paymentcollection.metrics.PinEntryLogger;
import com.stripe.core.paymentcollection.metrics.RemoveCardLogger;
import com.stripe.core.paymentcollection.metrics.Result;
import com.stripe.core.paymentcollection.metrics.UtilsKt;
import com.stripe.core.paymentcollection.metrics.WaitForCardPresentLogger;
import com.stripe.core.paymentcollection.metrics.WaitForPosCommandEventLogger;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.HealthLoggerBuilder;
import com.stripe.jvmcore.paymentcollection.OnlineAuthState;
import com.stripe.jvmcore.paymentcollection.OnlineAuthType;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.PaymentCollectionDomain;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.StageScope;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u0016\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)J\u0018\u0010*\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010+\u001a\u00020,J\"\u0010-\u001a\u00020!2\u0006\u0010.\u001a\u00020/2\u0006\u0010\"\u001a\u00020#2\n\b\u0002\u00100\u001a\u0004\u0018\u000101J\u000e\u00102\u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0010\u00103\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#J\u001a\u00104\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u00105\u001a\u0004\u0018\u000106J\u000e\u00107\u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u0018\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020:2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0018\u0010;\u001a\u00020!2\u0006\u00109\u001a\u00020<2\b\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010=\u001a\u00020!J\u0006\u0010>\u001a\u00020!J\u0006\u0010?\u001a\u00020!J\u000e\u0010@\u001a\u00020!2\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020!J\u0006\u0010D\u001a\u00020!J\u0006\u0010E\u001a\u00020!J\u000e\u0010F\u001a\u00020!2\u0006\u0010G\u001a\u000206R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0010j\u0002`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lcom/stripe/core/paymentcollection/metrics/StageEventLogger;", "", "healthLoggerBuilder", "Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;", "endToEndEventLogger", "Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;", "(Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;)V", "accountSelectionLogger", "Lcom/stripe/core/paymentcollection/metrics/AccountSelectionLogger;", "applicationSelectionLogger", "Lcom/stripe/core/paymentcollection/metrics/ApplicationSelectionLogger;", "displayCartLogger", "Lcom/stripe/core/paymentcollection/metrics/DisplayCartLogger;", "kernelProcessingLogger", "Lcom/stripe/core/paymentcollection/metrics/KernelProcessingEventLogger;", "logger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/StageScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/StageScope$Builder;", "Lcom/stripe/core/paymentcollection/metrics/StageLogger;", "onlineAuthLogger", "Lcom/stripe/core/paymentcollection/metrics/OnlineAuthLogger;", "pinEntryLogger", "Lcom/stripe/core/paymentcollection/metrics/PinEntryLogger;", "removeCardLogger", "Lcom/stripe/core/paymentcollection/metrics/RemoveCardLogger;", "waitForCardPresent", "Lcom/stripe/core/paymentcollection/metrics/WaitForCardPresentLogger;", "waitForPosCommand", "Lcom/stripe/core/paymentcollection/metrics/WaitForPosCommandEventLogger;", "closeAccountSelectionLog", "", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "nextState", "Lcom/stripe/core/paymentcollection/PaymentCollectionState;", "closeApplicationSelectionLog", "closeDisplayCartLog", "displayCartResult", "Lcom/stripe/core/paymentcollection/metrics/DisplayCartResult;", "closeOnlineAuthenticationLog", "authState", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthState;", "closePinEntryLog", "result", "Lcom/stripe/core/paymentcollection/metrics/Result;", "knownFailureReason", "Lcom/stripe/core/paymentcollection/metrics/PinEntryFailureReason;", "closeRemoveCardLog", "closeWaitForCardPresentLog", "closeWaitForPosCommandLog", "closingCommand", "Lcom/stripe/core/paymentcollection/metrics/PendingPosCommand;", "onCancel", "onHardwareEvent", "event", "Lcom/stripe/core/paymentcollection/HardwareEvent;", "onHardwareListenerEvent", "Lcom/stripe/core/paymentcollection/HardwareListenerEvent;", "openAccountSelectionLog", "openApplicationSelectionLog", "openDisplayCartLog", "openOnlineAuthenticationLog", "authType", "Lcom/stripe/jvmcore/paymentcollection/OnlineAuthType;", "openPinEntryLog", "openRemoveCardLog", "openWaitForCardPresentLog", "openWaitForPosCommandLog", "pendingCommand", "paymentcollection_release"})
public final class StageEventLogger {
    @NotNull
    private final HealthLogger<PaymentCollectionDomain, PaymentCollectionDomain.Builder, StageScope, StageScope.Builder> logger;
    @NotNull
    private final ApplicationSelectionLogger applicationSelectionLogger;
    @NotNull
    private final AccountSelectionLogger accountSelectionLogger;
    @NotNull
    private final DisplayCartLogger displayCartLogger;
    @NotNull
    private final OnlineAuthLogger onlineAuthLogger;
    @NotNull
    private final PinEntryLogger pinEntryLogger;
    @NotNull
    private final RemoveCardLogger removeCardLogger;
    @NotNull
    private final WaitForPosCommandEventLogger waitForPosCommand;
    @NotNull
    private final WaitForCardPresentLogger waitForCardPresent;
    @NotNull
    private final KernelProcessingEventLogger kernelProcessingLogger;

    @Inject
    public StageEventLogger(@NotNull HealthLoggerBuilder healthLoggerBuilder, @NotNull EndToEndEventLogger endToEndEventLogger) {
        Intrinsics.checkNotNullParameter((Object)healthLoggerBuilder, (String)"healthLoggerBuilder");
        Intrinsics.checkNotNullParameter((Object)endToEndEventLogger, (String)"endToEndEventLogger");
        this.logger = UtilsKt.buildsStageHealthLogger(healthLoggerBuilder);
        this.applicationSelectionLogger = new ApplicationSelectionLogger(this.logger, endToEndEventLogger);
        this.accountSelectionLogger = new AccountSelectionLogger(this.logger, endToEndEventLogger);
        this.displayCartLogger = new DisplayCartLogger(this.logger, endToEndEventLogger);
        this.onlineAuthLogger = new OnlineAuthLogger(this.logger, endToEndEventLogger);
        this.pinEntryLogger = new PinEntryLogger(this.logger, endToEndEventLogger);
        this.removeCardLogger = new RemoveCardLogger(this.logger, endToEndEventLogger);
        this.waitForPosCommand = new WaitForPosCommandEventLogger(this.logger, endToEndEventLogger);
        this.waitForCardPresent = new WaitForCardPresentLogger(this.logger, endToEndEventLogger);
        this.kernelProcessingLogger = new KernelProcessingEventLogger(this.logger, endToEndEventLogger);
    }

    public final void openApplicationSelectionLog() {
        this.applicationSelectionLogger.openLog();
    }

    public final void closeApplicationSelectionLog(@NotNull PaymentCollectionData data, @NotNull PaymentCollectionState nextState) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)nextState), (String)"nextState");
        this.applicationSelectionLogger.closeLog(data, nextState);
    }

    public final void openAccountSelectionLog() {
        this.accountSelectionLogger.openLog();
    }

    public final void closeAccountSelectionLog(@NotNull PaymentCollectionData data, @NotNull PaymentCollectionState nextState) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)nextState), (String)"nextState");
        this.accountSelectionLogger.closeLog(data, nextState);
    }

    public final void openPinEntryLog() {
        this.pinEntryLogger.openLog();
    }

    public final void closePinEntryLog(@NotNull Result result2, @NotNull PaymentCollectionData data, @Nullable PinEntryFailureReason knownFailureReason) {
        Intrinsics.checkNotNullParameter((Object)((Object)result2), (String)"result");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.pinEntryLogger.closeLog(result2, data, knownFailureReason);
    }

    public static /* synthetic */ void closePinEntryLog$default(StageEventLogger stageEventLogger, Result result2, PaymentCollectionData paymentCollectionData, PinEntryFailureReason pinEntryFailureReason, int n2, Object object) {
        if ((n2 & 4) != 0) {
            pinEntryFailureReason = null;
        }
        stageEventLogger.closePinEntryLog(result2, paymentCollectionData, pinEntryFailureReason);
    }

    public final void openOnlineAuthenticationLog(@NotNull OnlineAuthType authType) {
        Intrinsics.checkNotNullParameter((Object)((Object)authType), (String)"authType");
        this.onlineAuthLogger.openLog(authType);
    }

    public final void closeOnlineAuthenticationLog(@Nullable PaymentCollectionData data, @NotNull OnlineAuthState authState) {
        Intrinsics.checkNotNullParameter((Object)authState, (String)"authState");
        this.onlineAuthLogger.closeLog(data, authState);
    }

    public final void openDisplayCartLog() {
        this.displayCartLogger.openLog();
    }

    public final void closeDisplayCartLog(@NotNull PaymentCollectionData data, @NotNull DisplayCartResult displayCartResult) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)displayCartResult), (String)"displayCartResult");
        this.displayCartLogger.closeLog(data, displayCartResult);
    }

    public final void openWaitForPosCommandLog(@NotNull PendingPosCommand pendingCommand) {
        Intrinsics.checkNotNullParameter((Object)((Object)pendingCommand), (String)"pendingCommand");
        this.waitForPosCommand.openLog(pendingCommand);
    }

    public final void closeWaitForPosCommandLog(@Nullable PaymentCollectionData data, @Nullable PendingPosCommand closingCommand) {
        this.waitForPosCommand.closeLog(data, closingCommand);
    }

    public final void openRemoveCardLog() {
        this.removeCardLogger.openLog();
    }

    public final void closeRemoveCardLog(@NotNull PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.removeCardLogger.closeLog(data);
    }

    public final void openWaitForCardPresentLog() {
        this.waitForCardPresent.openLog();
    }

    public final void closeWaitForCardPresentLog(@Nullable PaymentCollectionData data) {
        this.waitForCardPresent.closeLog(data);
    }

    public final void onHardwareEvent(@NotNull HardwareEvent event, @Nullable PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.kernelProcessingLogger.onHardwareEvent(event, data);
    }

    public final void onHardwareListenerEvent(@NotNull HardwareListenerEvent event, @Nullable PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.kernelProcessingLogger.onHardwareListenerEvent(event, data);
    }

    public final void onCancel(@NotNull PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.closeDisplayCartLog(data, DisplayCartResult.MERCHANT_CANCELLED);
        this.closeWaitForPosCommandLog(data, null);
        this.closeOnlineAuthenticationLog(data, OnlineAuthState.Cancelled.INSTANCE);
        this.closeWaitForCardPresentLog(data);
    }
}

