/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.metrics;

import androidx.annotation.VisibleForTesting;
import com.stripe.core.hardware.paymentcollection.TippingSelectionType;
import com.stripe.core.hardware.tipping.TippingSelectionFailureReason;
import com.stripe.core.paymentcollection.CancelReason;
import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.TippingState;
import com.stripe.core.paymentcollection.metrics.EndToEndEventLogger;
import com.stripe.core.paymentcollection.metrics.LatencyCategory;
import com.stripe.core.paymentcollection.metrics.Result;
import com.stripe.core.paymentcollection.metrics.StageEventLogHelper;
import com.stripe.core.paymentcollection.metrics.TippingLogger;
import com.stripe.core.paymentcollection.metrics.UtilsKt;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.magstripe.MagStripePaymentCollectionAuthority;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.HealthLoggerBuilder;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.jvmcore.restclient.IntegrationType;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.tipping.DiscreteScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.tipping.StageScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.tipping.TippingDomain;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0004\b\u0001\u0018\u0000 (2\u00020\u0001:\u0002()B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J(\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ \u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010!J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010#\u001a\u00020\u00192\b\u0010 \u001a\u0004\u0018\u00010!J\u0018\u0010$\u001a\u00020\u00192\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u0019R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u00020\u000e8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R&\u0010\u0013\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/stripe/core/paymentcollection/metrics/TippingLogger;", "", "healthLoggerBuilder", "Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;", "endToEndEventLogger", "Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;", "(Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;)V", "tippingDiscreteLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/tipping/TippingDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/tipping/TippingDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/tipping/DiscreteScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/tipping/DiscreteScope$Builder;", "tippingSelectionLogger", "Lcom/stripe/core/paymentcollection/metrics/TippingLogger$TippingSelectionStageLogger;", "getTippingSelectionLogger$paymentcollection_release$annotations", "()V", "getTippingSelectionLogger$paymentcollection_release", "()Lcom/stripe/core/paymentcollection/metrics/TippingLogger$TippingSelectionStageLogger;", "tippingStageLogger", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/tipping/StageScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/tipping/StageScope$Builder;", "buildTippingDiscreteHealthLogger", "buildTippingStageHealthLogger", "closeTippingSelectionLog", "", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "logCurrencyMismatch", "tippingCurrencies", "", "currencyCode", "integrationType", "Lcom/stripe/jvmcore/restclient/IntegrationType;", "logReselectTipping", "logSkipTipping", "logTipEligible", "eligibleAmount", "", "openTippingSelectionLog", "Companion", "TippingSelectionStageLogger", "paymentcollection_release"})
@SourceDebugExtension(value={"SMAP\nTippingLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TippingLogger.kt\ncom/stripe/core/paymentcollection/metrics/TippingLogger\n+ 2 Tags.kt\ncom/stripe/core/paymentcollection/metrics/TagsKt\n+ 3 HealthLogger.kt\ncom/stripe/jvmcore/logging/HealthLoggerBuilder\n+ 4 HealthLogger.kt\ncom/stripe/jvmcore/logging/HealthLoggerBuilder$DomainedBuilder\n*L\n1#1,188:1\n412#2,11:189\n412#2,11:200\n412#2,11:211\n412#2,11:222\n436#3,4:233\n436#3,4:241\n457#4,4:237\n457#4,4:245\n*S KotlinDebug\n*F\n+ 1 TippingLogger.kt\ncom/stripe/core/paymentcollection/metrics/TippingLogger\n*L\n38#1:189,11\n50#1:200,11\n58#1:211,11\n66#1:222,11\n169#1:233,4\n180#1:241,4\n172#1:237,4\n183#1:245,4\n*E\n"})
public final class TippingLogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HealthLogger<TippingDomain, TippingDomain.Builder, StageScope, StageScope.Builder> tippingStageLogger;
    @NotNull
    private final TippingSelectionStageLogger tippingSelectionLogger;
    @NotNull
    private final HealthLogger<TippingDomain, TippingDomain.Builder, DiscreteScope, DiscreteScope.Builder> tippingDiscreteLogger;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(TippingLogger.class);

    @Inject
    public TippingLogger(@NotNull HealthLoggerBuilder healthLoggerBuilder, @NotNull EndToEndEventLogger endToEndEventLogger) {
        Intrinsics.checkNotNullParameter((Object)healthLoggerBuilder, (String)"healthLoggerBuilder");
        Intrinsics.checkNotNullParameter((Object)endToEndEventLogger, (String)"endToEndEventLogger");
        this.tippingStageLogger = this.buildTippingStageHealthLogger(healthLoggerBuilder);
        this.tippingSelectionLogger = new TippingSelectionStageLogger(this.tippingStageLogger, endToEndEventLogger);
        this.tippingDiscreteLogger = this.buildTippingDiscreteHealthLogger(healthLoggerBuilder);
    }

    @NotNull
    public final TippingSelectionStageLogger getTippingSelectionLogger$paymentcollection_release() {
        return this.tippingSelectionLogger;
    }

    @VisibleForTesting
    public static /* synthetic */ void getTippingSelectionLogger$paymentcollection_release$annotations() {
    }

    public final void openTippingSelectionLog() {
        this.tippingSelectionLogger.openLog();
    }

    public final void closeTippingSelectionLog(@NotNull PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.tippingSelectionLogger.closeLog(data);
    }

    /*
     * WARNING - void declaration
     */
    public final void logReselectTipping(@NotNull PaymentCollectionData data) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        LOGGER.i("logReselectTipping", new Pair[0]);
        Map $this$logReselectTipping_u24lambda_u240 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        Map map3 = $this$logReselectTipping_u24lambda_u240;
        Enum tag$iv = data.getIntegrationType();
        boolean $i$f$addEnumTag = false;
        if (tag$iv != null) {
            void $this$addEnumTag$iv;
            KClass kClass = Reflection.getOrCreateKotlinClass(IntegrationType.class);
            String tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : IntegrationType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, tag$iv.name());
        }
        Map tagMap = map2;
        HealthLogger.incrementCounter$default(this.tippingDiscreteLogger, null, tagMap, null, logReselectTipping.1.INSTANCE, 5, null);
    }

    public final void logCurrencyMismatch(@NotNull String tippingCurrencies, @NotNull String currencyCode, @Nullable IntegrationType integrationType) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)tippingCurrencies, (String)"tippingCurrencies");
        Intrinsics.checkNotNullParameter((Object)currencyCode, (String)"currencyCode");
        LOGGER.i("Tipping flow will not start because there are no tipping configs match. the transaction used for the currency. Tipping currencies: " + tippingCurrencies + ". Transaction currency: " + currencyCode, new Pair[0]);
        Map $this$logCurrencyMismatch_u24lambda_u241 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        Map $this$addEnumTag$iv = $this$logCurrencyMismatch_u24lambda_u241;
        boolean $i$f$addEnumTag = false;
        if ((Enum)integrationType != null) {
            KClass kClass = Reflection.getOrCreateKotlinClass(IntegrationType.class);
            String tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : IntegrationType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, ((Enum)integrationType).name());
        }
        Map tagMap = map2;
        HealthLogger.incrementCounter$default(this.tippingDiscreteLogger, null, tagMap, null, logCurrencyMismatch.1.INSTANCE, 5, null);
    }

    public final void logSkipTipping(@Nullable IntegrationType integrationType) {
        Map map2;
        LOGGER.i("Not starting the tipping flow because the skip tipping flag is set to true", new Pair[0]);
        Map $this$logSkipTipping_u24lambda_u242 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        Map $this$addEnumTag$iv = $this$logSkipTipping_u24lambda_u242;
        boolean $i$f$addEnumTag = false;
        if ((Enum)integrationType != null) {
            KClass kClass = Reflection.getOrCreateKotlinClass(IntegrationType.class);
            String tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : IntegrationType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, ((Enum)integrationType).name());
        }
        Map tagMap = map2;
        HealthLogger.incrementCounter$default(this.tippingDiscreteLogger, null, tagMap, null, logSkipTipping.1.INSTANCE, 5, null);
    }

    public final void logTipEligible(@Nullable IntegrationType integrationType, long eligibleAmount) {
        Map map2;
        LOGGER.i("logTipEligible", new Pair[0]);
        Map $this$logTipEligible_u24lambda_u243 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        Map $this$addEnumTag$iv = $this$logTipEligible_u24lambda_u243;
        boolean $i$f$addEnumTag = false;
        if ((Enum)integrationType != null) {
            KClass kClass = Reflection.getOrCreateKotlinClass(IntegrationType.class);
            String tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : IntegrationType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, ((Enum)integrationType).name());
        }
        $this$logTipEligible_u24lambda_u243.put("IsZeroValue", String.valueOf(eligibleAmount == 0L));
        Map tagMap = map2;
        HealthLogger.incrementCounter$default(this.tippingDiscreteLogger, null, tagMap, null, logTipEligible.1.INSTANCE, 5, null);
    }

    private final HealthLogger<TippingDomain, TippingDomain.Builder, StageScope, StageScope.Builder> buildTippingStageHealthLogger(HealthLoggerBuilder healthLoggerBuilder) {
        HealthLoggerBuilder.DomainedBuilder<TippingDomain, TippingDomain.Builder> this_$iv;
        HealthLoggerBuilder healthLoggerBuilder2 = healthLoggerBuilder;
        Function2 domainSetter$iv = buildTippingStageHealthLogger.1.INSTANCE;
        boolean $i$f$withDomain = false;
        this_$iv = (HealthLoggerBuilder)((Object)this_$iv).new HealthLoggerBuilder.DomainedBuilder<TippingDomain, TippingDomain.Builder>(TippingDomain.class, TippingDomain.Builder.class, domainSetter$iv);
        Function2 scopeSetter$iv = buildTippingStageHealthLogger.2.INSTANCE;
        boolean $i$f$withScope = false;
        return this_$iv.new HealthLoggerBuilder.DomainedBuilder.ScopedBuilder<StageScope, StageScope.Builder>(StageScope.class, StageScope.Builder.class, scopeSetter$iv).build();
    }

    private final HealthLogger<TippingDomain, TippingDomain.Builder, DiscreteScope, DiscreteScope.Builder> buildTippingDiscreteHealthLogger(HealthLoggerBuilder healthLoggerBuilder) {
        HealthLoggerBuilder.DomainedBuilder<TippingDomain, TippingDomain.Builder> this_$iv;
        HealthLoggerBuilder healthLoggerBuilder2 = healthLoggerBuilder;
        Function2 domainSetter$iv = buildTippingDiscreteHealthLogger.1.INSTANCE;
        boolean $i$f$withDomain = false;
        this_$iv = (HealthLoggerBuilder)((Object)this_$iv).new HealthLoggerBuilder.DomainedBuilder<TippingDomain, TippingDomain.Builder>(TippingDomain.class, TippingDomain.Builder.class, domainSetter$iv);
        Function2 scopeSetter$iv = buildTippingDiscreteHealthLogger.2.INSTANCE;
        boolean $i$f$withScope = false;
        return this_$iv.new HealthLoggerBuilder.DomainedBuilder.ScopedBuilder<DiscreteScope, DiscreteScope.Builder>(DiscreteScope.class, DiscreteScope.Builder.class, scopeSetter$iv).build();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/paymentcollection/metrics/TippingLogger$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "paymentcollection_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001B-\u0012\u001e\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u0011J!\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u0018\u001a\u00020\f\u00a8\u0006\u0019"}, d2={"Lcom/stripe/core/paymentcollection/metrics/TippingLogger$TippingSelectionStageLogger;", "Lcom/stripe/core/paymentcollection/metrics/StageEventLogHelper;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/tipping/TippingDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/tipping/TippingDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/tipping/StageScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/tipping/StageScope$Builder;", "logger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "endToEndEventLogger", "Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;", "(Lcom/stripe/jvmcore/logging/HealthLogger;Lcom/stripe/core/paymentcollection/metrics/EndToEndEventLogger;)V", "closeLog", "", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "generateTippingResult", "Lcom/stripe/core/paymentcollection/metrics/Result;", "generateTippingResult$paymentcollection_release", "generateTippingTags", "", "", "generateTippingTags$paymentcollection_release", "getFailureReason", "Lcom/stripe/core/hardware/tipping/TippingSelectionFailureReason;", "openLog", "paymentcollection_release"})
    @SourceDebugExtension(value={"SMAP\nTippingLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TippingLogger.kt\ncom/stripe/core/paymentcollection/metrics/TippingLogger$TippingSelectionStageLogger\n+ 2 Tags.kt\ncom/stripe/core/paymentcollection/metrics/TagsKt\n*L\n1#1,188:1\n412#2,11:189\n412#2,11:200\n*S KotlinDebug\n*F\n+ 1 TippingLogger.kt\ncom/stripe/core/paymentcollection/metrics/TippingLogger$TippingSelectionStageLogger\n*L\n123#1:189,11\n127#1:200,11\n*E\n"})
    public static final class TippingSelectionStageLogger
    extends StageEventLogHelper<TippingDomain, TippingDomain.Builder, StageScope, StageScope.Builder> {
        public TippingSelectionStageLogger(@NotNull HealthLogger<TippingDomain, TippingDomain.Builder, StageScope, StageScope.Builder> logger2, @NotNull EndToEndEventLogger endToEndEventLogger) {
            Intrinsics.checkNotNullParameter(logger2, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)endToEndEventLogger, (String)"endToEndEventLogger");
            super(logger2, "TippingSelection", endToEndEventLogger, LatencyCategory.USER_ACTION);
        }

        public final void openLog() {
            StageEventLogHelper.openLogHelper$default(this, null, openLog.1.INSTANCE, 1, null);
        }

        private final TippingSelectionFailureReason getFailureReason(PaymentCollectionData data) {
            return data.getCancelReason() == CancelReason.MERCHANT_CANCELLED ? TippingSelectionFailureReason.MERCHANT_CANCELLED : (data.getCancelReason() == CancelReason.HARDWARE_CANCELLED ? TippingSelectionFailureReason.HARDWARE_CANCELLED : (data.getTippingState() instanceof TippingState.Completed ? ((TippingState.Completed)data.getTippingState()).getResult().getTipSelectionFailure() : TippingSelectionFailureReason.TIP_SELECTION_TYPE_NOT_FOUND));
        }

        @VisibleForTesting
        @NotNull
        public final Map<String, String> generateTippingTags$paymentcollection_release(@NotNull PaymentCollectionData data) {
            TippingSelectionType tippingSelectionType;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Map tippingTags = new LinkedHashMap();
            TippingSelectionFailureReason failureReason = this.getFailureReason(data);
            TippingSelectionType tippingSelectionType2 = tippingSelectionType = data.getTippingState() instanceof TippingState.Completed ? ((TippingState.Completed)data.getTippingState()).getResult().getTippingType() : null;
            if (failureReason != null) {
                Map map2;
                Map $this$generateTippingTags_u24lambda_u240 = map2 = tippingTags;
                boolean bl = false;
                Map $this$addEnumTag$iv = $this$generateTippingTags_u24lambda_u240;
                boolean $i$f$addEnumTag = false;
                KClass kClass = Reflection.getOrCreateKotlinClass(TippingSelectionFailureReason.class);
                String tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : TippingSelectionFailureReason.class.getSimpleName());
                Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
                $this$addEnumTag$iv.put(tagName$iv, ((Enum)failureReason).name());
            } else {
                Map map3;
                Map $this$generateTippingTags_u24lambda_u241 = map3 = tippingTags;
                boolean bl = false;
                Map $this$addEnumTag$iv = $this$generateTippingTags_u24lambda_u241;
                boolean $i$f$addEnumTag = false;
                if ((Enum)tippingSelectionType != null) {
                    KClass kClass = Reflection.getOrCreateKotlinClass(TippingSelectionType.class);
                    String tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : TippingSelectionType.class.getSimpleName());
                    Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
                    $this$addEnumTag$iv.put(tagName$iv, ((Enum)tippingSelectionType).name());
                }
            }
            return tippingTags;
        }

        @VisibleForTesting
        @NotNull
        public final Result generateTippingResult$paymentcollection_release(@NotNull PaymentCollectionData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            TippingSelectionFailureReason failureReason = this.getFailureReason(data);
            return failureReason == null ? Result.SUCCESS : Result.FAILURE;
        }

        public final void closeLog(@NotNull PaymentCollectionData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.closeLogHelper(data, (Function1<Map<String, String>, Pair<Outcome, Map<String, String>>>)((Function1)new Function1<Map<String, String>, Pair<? extends Outcome, ? extends Map<String, String>>>(this, data){
                final /* synthetic */ TippingSelectionStageLogger this$0;
                final /* synthetic */ PaymentCollectionData $data;
                {
                    this.this$0 = $receiver;
                    this.$data = $data;
                    super(1);
                }

                @NotNull
                public final Pair<Outcome, Map<String, String>> invoke(@NotNull Map<String, String> tagMap) {
                    Map<String, String> map2;
                    Intrinsics.checkNotNullParameter(tagMap, (String)"tagMap");
                    Map<String, String> generatedTippingTags = this.this$0.generateTippingTags$paymentcollection_release(this.$data);
                    Result generatedResult = this.this$0.generateTippingResult$paymentcollection_release(this.$data);
                    Map<String, String> $this$invoke_u24lambda_u240 = map2 = tagMap;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.putAll(generatedTippingTags);
                    return new Pair((Object)UtilsKt.toOutcome(generatedResult), tagMap);
                }
            }));
        }
    }
}

