/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.paymentcollection.metrics;

import com.stripe.core.paymentcollection.PaymentCollectionData;
import com.stripe.core.paymentcollection.PaymentCollectionStatesKt;
import com.stripe.core.paymentcollection.manualentry.ManualEntryData;
import com.stripe.core.paymentcollection.metrics.LatencyCategory;
import com.stripe.core.paymentcollection.metrics.PaymentMethodType;
import com.stripe.core.paymentcollection.metrics.Result;
import com.stripe.core.paymentcollection.metrics.UtilsKt;
import com.stripe.jvmcore.hardware.emv.ApplicationId;
import com.stripe.jvmcore.hardware.emv.InterfaceType;
import com.stripe.jvmcore.hardware.emv.TlvMap;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.magstripe.MagStripePaymentCollectionAuthority;
import com.stripe.jvmcore.logging.HealthLogger;
import com.stripe.jvmcore.logging.HealthLoggerBuilder;
import com.stripe.jvmcore.loggingmodels.Outcome;
import com.stripe.jvmcore.restclient.IntegrationType;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.DiscreteScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.EndToEndScope;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.PaymentCollectionDomain;
import com.stripe.proto.terminal.clientlogger.pub.message.health.domains.paymentcollection.StageScope;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000|\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a,\u0010\u0000\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001j\u0002`\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a,\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0001j\u0002`\f2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a,\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u0001j\u0002`\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a8\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013`\u00142\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u001a8\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012j\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0013`\u00142\u0006\u0010\u0015\u001a\u00020\u00192\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u001a\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a\n\u0010\u001e\u001a\u00020\u001f*\u00020 *:\u0010!\"\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00012\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001*:\u0010\"\"\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u00012\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0001*<\b\u0000\u0010#\"\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0$2\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0$*:\u0010%\"\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u00012\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u0001\u00a8\u0006&"}, d2={"buildsDiscreteHealthLogger", "Lcom/stripe/jvmcore/logging/HealthLogger;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/PaymentCollectionDomain$Builder;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/DiscreteScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/DiscreteScope$Builder;", "Lcom/stripe/core/paymentcollection/metrics/DiscreteHealthLogger;", "healthLoggerBuilder", "Lcom/stripe/jvmcore/logging/HealthLoggerBuilder;", "buildsEndToEndHealthLogger", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/EndToEndScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/EndToEndScope$Builder;", "Lcom/stripe/core/paymentcollection/metrics/EndToEndHealthLogger;", "buildsStageHealthLogger", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/StageScope;", "Lcom/stripe/proto/terminal/clientlogger/pub/message/health/domains/paymentcollection/StageScope$Builder;", "Lcom/stripe/core/paymentcollection/metrics/StageLogger;", "generateCommonTags", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "data", "Lcom/stripe/core/paymentcollection/PaymentCollectionData;", "latencyCategory", "Lcom/stripe/core/paymentcollection/metrics/LatencyCategory;", "Lcom/stripe/core/paymentcollection/manualentry/ManualEntryData;", "getApplicationId", "Lcom/stripe/jvmcore/hardware/emv/ApplicationId;", "getPaymentMethodType", "Lcom/stripe/core/paymentcollection/metrics/PaymentMethodType;", "toOutcome", "Lcom/stripe/jvmcore/loggingmodels/Outcome;", "Lcom/stripe/core/paymentcollection/metrics/Result;", "DiscreteHealthLogger", "EndToEndHealthLogger", "PaymentCollectionStageEventLogger", "Lcom/stripe/core/paymentcollection/metrics/StageEventLogHelper;", "StageLogger", "paymentcollection_release"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/stripe/core/paymentcollection/metrics/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Tags.kt\ncom/stripe/core/paymentcollection/metrics/TagsKt\n+ 4 HealthLogger.kt\ncom/stripe/jvmcore/logging/HealthLoggerBuilder\n+ 5 HealthLogger.kt\ncom/stripe/jvmcore/logging/HealthLoggerBuilder$DomainedBuilder\n*L\n1#1,142:1\n1#2:143\n412#3,11:144\n412#3,11:155\n412#3,11:166\n412#3,11:177\n412#3,11:188\n412#3,11:199\n412#3,11:210\n412#3,11:221\n412#3,11:232\n412#3,11:243\n436#4,4:254\n436#4,4:262\n436#4,4:270\n457#5,4:258\n457#5,4:266\n457#5,4:274\n*S KotlinDebug\n*F\n+ 1 Utils.kt\ncom/stripe/core/paymentcollection/metrics/UtilsKt\n*L\n61#1:144,11\n62#1:155,11\n63#1:166,11\n64#1:177,11\n65#1:188,11\n75#1:199,11\n76#1:210,11\n77#1:221,11\n78#1:232,11\n79#1:243,11\n113#1:254,4\n124#1:262,4\n135#1:270,4\n116#1:258,4\n127#1:266,4\n138#1:274,4\n*E\n"})
public final class UtilsKt {
    @NotNull
    public static final Outcome toOutcome(@NotNull Result $this$toOutcome) {
        Outcome outcome;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toOutcome), (String)"<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toOutcome.ordinal()]) {
            case 1: {
                outcome = Outcome.Ok.INSTANCE;
                break;
            }
            case 2: {
                outcome = Outcome.GenericError.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return outcome;
    }

    @NotNull
    public static final PaymentMethodType getPaymentMethodType(@NotNull PaymentCollectionData data) {
        InterfaceType interfaceType;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data.getOnlineAuthorizationData();
        if (string != null) {
            String it = string;
            boolean bl = false;
            interfaceType = PaymentCollectionStatesKt.interfaceTypeFromTlv(it);
        } else {
            interfaceType = null;
        }
        InterfaceType interfaceType2 = interfaceType;
        TransactionType emvTransactionType = data.getEmvTransactionType();
        return data.getShouldStartManualEntry() ? PaymentMethodType.MANUAL_ENTRY : (data.getMagStripeReadResult() != null ? PaymentMethodType.MAGSTRIPE : (interfaceType2 == InterfaceType.CONTACTLESS ? PaymentMethodType.EMV_TAP : (interfaceType2 == InterfaceType.CONTACT && emvTransactionType == TransactionType.QUICK ? PaymentMethodType.EMV_INSERT_QUICK : (interfaceType2 == InterfaceType.CONTACT && emvTransactionType == TransactionType.TRADITIONAL ? PaymentMethodType.EMV_INSERT_FULL : PaymentMethodType.UNKNOWN))));
    }

    @Nullable
    public static final ApplicationId getApplicationId(@NotNull PaymentCollectionData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = data.getOnlineAuthorizationData();
        return object != null && (object = TlvMap.Companion.toTlvMap((String)object)) != null ? ((TlvMap)object).getApplicationId() : null;
    }

    @NotNull
    public static final HashMap<String, String> generateCommonTags(@NotNull PaymentCollectionData data, @Nullable LatencyCategory latencyCategory) {
        Map $this$addEnumTag$iv;
        String tagName$iv;
        KClass kClass;
        HashMap<String, String> hashMap;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        HashMap<String, String> $this$generateCommonTags_u24lambda_u241 = hashMap = new HashMap<String, String>();
        boolean bl = false;
        Map map2 = $this$generateCommonTags_u24lambda_u241;
        Enum tag$iv = UtilsKt.getPaymentMethodType(data);
        boolean $i$f$addEnumTag = false;
        if (tag$iv != null) {
            kClass = Reflection.getOrCreateKotlinClass(PaymentMethodType.class);
            tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : PaymentMethodType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, tag$iv.name());
        }
        $this$addEnumTag$iv = $this$generateCommonTags_u24lambda_u241;
        tag$iv = data.getTransactionType();
        $i$f$addEnumTag = false;
        if (tag$iv != null) {
            kClass = Reflection.getOrCreateKotlinClass(com.stripe.core.hardware.paymentcollection.TransactionType.class);
            tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : com.stripe.core.hardware.paymentcollection.TransactionType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, tag$iv.name());
        }
        $this$addEnumTag$iv = $this$generateCommonTags_u24lambda_u241;
        tag$iv = data.getEmvTransactionType();
        $i$f$addEnumTag = false;
        if (tag$iv != null) {
            kClass = Reflection.getOrCreateKotlinClass(TransactionType.class);
            tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : TransactionType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, tag$iv.name());
        }
        $this$addEnumTag$iv = $this$generateCommonTags_u24lambda_u241;
        tag$iv = data.getIntegrationType();
        $i$f$addEnumTag = false;
        if (tag$iv != null) {
            kClass = Reflection.getOrCreateKotlinClass(IntegrationType.class);
            tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : IntegrationType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, tag$iv.name());
        }
        $this$addEnumTag$iv = $this$generateCommonTags_u24lambda_u241;
        boolean $i$f$addEnumTag2 = false;
        if ((Enum)latencyCategory != null) {
            KClass kClass2 = Reflection.getOrCreateKotlinClass(LatencyCategory.class);
            String tagName$iv2 = Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : LatencyCategory.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv2, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv2, ((Enum)latencyCategory).name());
        }
        return hashMap;
    }

    public static /* synthetic */ HashMap generateCommonTags$default(PaymentCollectionData paymentCollectionData, LatencyCategory latencyCategory, int n2, Object object) {
        if ((n2 & 2) != 0) {
            latencyCategory = null;
        }
        return UtilsKt.generateCommonTags(paymentCollectionData, latencyCategory);
    }

    @NotNull
    public static final HashMap<String, String> generateCommonTags(@NotNull ManualEntryData data, @Nullable LatencyCategory latencyCategory) {
        Map $this$addEnumTag$iv;
        String tagName$iv;
        KClass kClass;
        HashMap<String, String> hashMap;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        HashMap<String, String> $this$generateCommonTags_u24lambda_u242 = hashMap = new HashMap<String, String>();
        boolean bl = false;
        Map map2 = $this$generateCommonTags_u24lambda_u242;
        Enum tag$iv = PaymentMethodType.MANUAL_ENTRY;
        boolean $i$f$addEnumTag = false;
        if (tag$iv != null) {
            kClass = Reflection.getOrCreateKotlinClass(PaymentMethodType.class);
            tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : PaymentMethodType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, tag$iv.name());
        }
        $this$addEnumTag$iv = $this$generateCommonTags_u24lambda_u242;
        tag$iv = data.getTransactionType();
        $i$f$addEnumTag = false;
        if (tag$iv != null) {
            kClass = Reflection.getOrCreateKotlinClass(com.stripe.core.hardware.paymentcollection.TransactionType.class);
            tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : com.stripe.core.hardware.paymentcollection.TransactionType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, tag$iv.name());
        }
        $this$addEnumTag$iv = $this$generateCommonTags_u24lambda_u242;
        tag$iv = data.getEmvTransactionType();
        $i$f$addEnumTag = false;
        if (tag$iv != null) {
            kClass = Reflection.getOrCreateKotlinClass(TransactionType.class);
            tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : TransactionType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, tag$iv.name());
        }
        $this$addEnumTag$iv = $this$generateCommonTags_u24lambda_u242;
        tag$iv = data.getIntegrationType();
        $i$f$addEnumTag = false;
        if (tag$iv != null) {
            kClass = Reflection.getOrCreateKotlinClass(IntegrationType.class);
            tagName$iv = Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : IntegrationType.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv, tag$iv.name());
        }
        $this$addEnumTag$iv = $this$generateCommonTags_u24lambda_u242;
        boolean $i$f$addEnumTag2 = false;
        if ((Enum)latencyCategory != null) {
            KClass kClass2 = Reflection.getOrCreateKotlinClass(LatencyCategory.class);
            String tagName$iv2 = Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(TransactionType.class)) ? "EmvTransactionType" : (Intrinsics.areEqual((Object)kClass2, (Object)Reflection.getOrCreateKotlinClass(MagStripePaymentCollectionAuthority.class)) ? "MagStripeAllowReason" : LatencyCategory.class.getSimpleName());
            Intrinsics.checkNotNullExpressionValue((Object)tagName$iv2, (String)"tagName");
            $this$addEnumTag$iv.put(tagName$iv2, ((Enum)latencyCategory).name());
        }
        return hashMap;
    }

    public static /* synthetic */ HashMap generateCommonTags$default(ManualEntryData manualEntryData, LatencyCategory latencyCategory, int n2, Object object) {
        if ((n2 & 2) != 0) {
            latencyCategory = null;
        }
        return UtilsKt.generateCommonTags(manualEntryData, latencyCategory);
    }

    @NotNull
    public static final HealthLogger<PaymentCollectionDomain, PaymentCollectionDomain.Builder, StageScope, StageScope.Builder> buildsStageHealthLogger(@NotNull HealthLoggerBuilder healthLoggerBuilder) {
        HealthLoggerBuilder.DomainedBuilder<PaymentCollectionDomain, PaymentCollectionDomain.Builder> this_$iv;
        Intrinsics.checkNotNullParameter((Object)healthLoggerBuilder, (String)"healthLoggerBuilder");
        HealthLoggerBuilder healthLoggerBuilder2 = healthLoggerBuilder;
        Function2 domainSetter$iv = buildsStageHealthLogger.1.INSTANCE;
        boolean $i$f$withDomain = false;
        this_$iv = (HealthLoggerBuilder)((Object)this_$iv).new HealthLoggerBuilder.DomainedBuilder<PaymentCollectionDomain, PaymentCollectionDomain.Builder>(PaymentCollectionDomain.class, PaymentCollectionDomain.Builder.class, domainSetter$iv);
        Function2 scopeSetter$iv = buildsStageHealthLogger.2.INSTANCE;
        boolean $i$f$withScope = false;
        return this_$iv.new HealthLoggerBuilder.DomainedBuilder.ScopedBuilder<StageScope, StageScope.Builder>(StageScope.class, StageScope.Builder.class, scopeSetter$iv).build();
    }

    @NotNull
    public static final HealthLogger<PaymentCollectionDomain, PaymentCollectionDomain.Builder, DiscreteScope, DiscreteScope.Builder> buildsDiscreteHealthLogger(@NotNull HealthLoggerBuilder healthLoggerBuilder) {
        HealthLoggerBuilder.DomainedBuilder<PaymentCollectionDomain, PaymentCollectionDomain.Builder> this_$iv;
        Intrinsics.checkNotNullParameter((Object)healthLoggerBuilder, (String)"healthLoggerBuilder");
        HealthLoggerBuilder healthLoggerBuilder2 = healthLoggerBuilder;
        Function2 domainSetter$iv = buildsDiscreteHealthLogger.1.INSTANCE;
        boolean $i$f$withDomain = false;
        this_$iv = (HealthLoggerBuilder)((Object)this_$iv).new HealthLoggerBuilder.DomainedBuilder<PaymentCollectionDomain, PaymentCollectionDomain.Builder>(PaymentCollectionDomain.class, PaymentCollectionDomain.Builder.class, domainSetter$iv);
        Function2 scopeSetter$iv = buildsDiscreteHealthLogger.2.INSTANCE;
        boolean $i$f$withScope = false;
        return this_$iv.new HealthLoggerBuilder.DomainedBuilder.ScopedBuilder<DiscreteScope, DiscreteScope.Builder>(DiscreteScope.class, DiscreteScope.Builder.class, scopeSetter$iv).build();
    }

    @NotNull
    public static final HealthLogger<PaymentCollectionDomain, PaymentCollectionDomain.Builder, EndToEndScope, EndToEndScope.Builder> buildsEndToEndHealthLogger(@NotNull HealthLoggerBuilder healthLoggerBuilder) {
        HealthLoggerBuilder.DomainedBuilder<PaymentCollectionDomain, PaymentCollectionDomain.Builder> this_$iv;
        Intrinsics.checkNotNullParameter((Object)healthLoggerBuilder, (String)"healthLoggerBuilder");
        HealthLoggerBuilder healthLoggerBuilder2 = healthLoggerBuilder;
        Function2 domainSetter$iv = buildsEndToEndHealthLogger.1.INSTANCE;
        boolean $i$f$withDomain = false;
        this_$iv = (HealthLoggerBuilder)((Object)this_$iv).new HealthLoggerBuilder.DomainedBuilder<PaymentCollectionDomain, PaymentCollectionDomain.Builder>(PaymentCollectionDomain.class, PaymentCollectionDomain.Builder.class, domainSetter$iv);
        Function2 scopeSetter$iv = buildsEndToEndHealthLogger.2.INSTANCE;
        boolean $i$f$withScope = false;
        return this_$iv.new HealthLoggerBuilder.DomainedBuilder.ScopedBuilder<EndToEndScope, EndToEndScope.Builder>(EndToEndScope.class, EndToEndScope.Builder.class, scopeSetter$iv).build();
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Result.values().length];
            try {
                nArray[Result.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Result.FAILURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

