/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.random;

import android.annotation.SuppressLint;
import androidx.annotation.RequiresApi;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0007J\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/core/random/RandomUtil;", "", "random", "Lkotlin/random/Random;", "(Lkotlin/random/Random;)V", "computeLocalTimeInRange", "Ljava/time/LocalTime;", "localTime", "durationInSeconds", "", "computeRandomLongInRange", "start", "duration", "random_release"})
public final class RandomUtil {
    @NotNull
    private final Random random;

    public RandomUtil(@NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.random = random;
    }

    public final long computeRandomLongInRange(long start2, long duration) {
        long randomDelayInSeconds = this.random.nextLong(duration);
        return start2 + randomDelayInSeconds;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    @RequiresApi(value=26)
    @NotNull
    public final LocalTime computeLocalTimeInRange(@NotNull LocalTime localTime, long durationInSeconds) {
        Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
        long randomDelayInSeconds = this.random.nextLong(durationInSeconds);
        LocalTime localTime2 = localTime.plusSeconds(randomDelayInSeconds);
        Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"localTime.plusSeconds(randomDelayInSeconds)");
        return localTime2;
    }
}

