/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.readerconnection;

import com.stripe.core.hardware.ConnectionType;
import com.stripe.core.hardware.Reader;
import com.stripe.core.readerconnection.ConnectionState;
import com.stripe.core.readerconnection.ConnectionSummary;
import com.stripe.core.stripeterminal.log.AndroidLog;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0007\b\u0007\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ$\u0010\u000e\u001a\u00020\t2\u0014\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\f0\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\tJ\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fR\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/stripe/core/readerconnection/ConnectionManager;", "", "()V", "<set-?>", "Lcom/stripe/core/readerconnection/ConnectionSummary;", "summary", "getSummary", "()Lcom/stripe/core/readerconnection/ConnectionSummary;", "endOperation", "", "startConnect", "reader", "Lcom/stripe/core/hardware/Reader;", "startDisconnect", "startDiscovery", "readerClasses", "", "Lkotlin/reflect/KClass;", "connectionType", "Lcom/stripe/core/hardware/ConnectionType;", "startReaderInfo", "startSession", "Companion", "readerconnection_release"})
public final class ConnectionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ConnectionSummary summary = new ConnectionSummary(null, ConnectionState.NONE, null, null, 13, null);
    @NotNull
    public static final String TAG = "ConnectionManager";

    @Inject
    public ConnectionManager() {
    }

    @NotNull
    public final ConnectionSummary getSummary() {
        return this.summary;
    }

    public final void startConnect(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        AndroidLog.INSTANCE.i(TAG, "startConnect");
        this.summary = new ConnectionSummary(null, ConnectionState.CONNECTING, reader, null, 9, null);
    }

    public final void startReaderInfo() {
        AndroidLog.INSTANCE.i(TAG, "startReaderInfo");
        this.summary = new ConnectionSummary(null, ConnectionState.FETCHING_INFO, null, null, 13, null);
    }

    public final void startDisconnect(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        AndroidLog.INSTANCE.i(TAG, "startDisconnect");
        this.summary = new ConnectionSummary(null, ConnectionState.DISCONNECTING, reader, null, 9, null);
    }

    public final void startDiscovery(@NotNull List<? extends KClass<? extends Reader>> readerClasses, @NotNull ConnectionType connectionType) {
        Intrinsics.checkNotNullParameter(readerClasses, (String)"readerClasses");
        Intrinsics.checkNotNullParameter((Object)((Object)connectionType), (String)"connectionType");
        AndroidLog.INSTANCE.i(TAG, "startDiscovery");
        ConnectionState connectionState = ConnectionState.DISCOVERING;
        this.summary = new ConnectionSummary(connectionType, connectionState, null, readerClasses, 4, null);
    }

    public final void endOperation() {
        AndroidLog.INSTANCE.i(TAG, "endOperation");
        this.summary = new ConnectionSummary(null, ConnectionState.NONE, null, null, 13, null);
    }

    public final void startSession(@NotNull Reader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        AndroidLog.INSTANCE.i(TAG, "startSession");
        this.summary = new ConnectionSummary(null, ConnectionState.STARTING_SESSION, reader, null, 9, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/readerconnection/ConnectionManager$Companion;", "", "()V", "TAG", "", "readerconnection_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

