/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.readerupdate;

import android.graphics.Bitmap;
import com.squareup.wire.Message;
import com.stripe.core.hardware.Reader;
import com.stripe.core.hardware.updates.ReaderUpdateException;
import com.stripe.core.readerupdate.RemoteUpdate;
import com.stripe.core.readerupdate.Update;
import com.stripe.core.readerupdate.UpdateClient;
import com.stripe.core.readerupdate.UpdatePackage;
import com.stripe.core.readerupdate.UpdateSummary;
import com.stripe.core.updater.Ingester;
import com.stripe.jvmcore.featureflag.FeatureFlagsRepository;
import com.stripe.jvmcore.logging.terminal.contracts.Logger;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.proto.model.common.ClientVersionSpecPb;
import com.stripe.proto.model.common.UrlPb;
import com.stripe.proto.model.config.BBPOSConfig;
import com.stripe.proto.model.config.MobileClientConfig;
import com.stripe.proto.terminal.terminal.pub.message.common.ImageRef;
import javax.inject.Provider;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u0012\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001j\u0002`\u0004:\u0001\u001eB%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J(\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0002J\u0019\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0014\u0010\u001d\u001a\u00020\u0002*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001f"}, d2={"Lcom/stripe/core/readerupdate/ArmadaIngesterImpl;", "Lcom/stripe/core/updater/Ingester;", "Lcom/stripe/core/readerupdate/UpdateSummary;", "Lcom/stripe/core/readerupdate/UpdatePackage;", "Lcom/stripe/core/readerupdate/ArmadaIngester;", "updateClient", "Lcom/stripe/core/readerupdate/UpdateClient;", "readerProvider", "Ljavax/inject/Provider;", "Lcom/stripe/core/hardware/Reader;", "featureFlagsRepository", "Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;", "(Lcom/stripe/core/readerupdate/UpdateClient;Ljavax/inject/Provider;Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;)V", "otaVersion", "", "Lcom/stripe/proto/model/common/ClientVersionSpecPb;", "getOtaVersion", "(Lcom/stripe/proto/model/common/ClientVersionSpecPb;)Ljava/lang/String;", "downloadSettings", "Lcom/stripe/core/readerupdate/Update$Settings;", "summary", "downloadUpdates", "ingest", "coordinates", "(Lcom/stripe/core/readerupdate/UpdateSummary;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toRemoteUpdate", "Lcom/stripe/core/readerupdate/RemoteUpdate;", "needsOtaUpdate", "", "updatePresignedUrls", "Companion", "readerupdate_release"})
@SourceDebugExtension(value={"SMAP\nArmadaIngester.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArmadaIngester.kt\ncom/stripe/core/readerupdate/ArmadaIngesterImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,116:1\n1#2:117\n*E\n"})
public final class ArmadaIngesterImpl
implements Ingester<UpdateSummary, UpdatePackage> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UpdateClient updateClient;
    @NotNull
    private final Provider<Reader> readerProvider;
    @NotNull
    private final FeatureFlagsRepository featureFlagsRepository;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(ArmadaIngesterImpl.class);

    public ArmadaIngesterImpl(@NotNull UpdateClient updateClient, @NotNull Provider<Reader> readerProvider, @NotNull FeatureFlagsRepository featureFlagsRepository) {
        Intrinsics.checkNotNullParameter((Object)updateClient, (String)"updateClient");
        Intrinsics.checkNotNullParameter(readerProvider, (String)"readerProvider");
        Intrinsics.checkNotNullParameter((Object)featureFlagsRepository, (String)"featureFlagsRepository");
        this.updateClient = updateClient;
        this.readerProvider = readerProvider;
        this.featureFlagsRepository = featureFlagsRepository;
    }

    @Override
    @Nullable
    public Object ingest(@NotNull UpdateSummary coordinates2, @NotNull Continuation<? super UpdatePackage> $completion) {
        UpdatePackage updatePackage;
        try {
            updatePackage = this.downloadUpdates(coordinates2, this.updateClient, this.readerProvider);
        }
        catch (ReaderUpdateException.UpdateFailedServerError e2) {
            UpdateSummary updatedSummary = this.updatePresignedUrls(coordinates2, this.updateClient);
            updatePackage = this.downloadUpdates(updatedSummary, this.updateClient, this.readerProvider);
        }
        return updatePackage;
    }

    private final UpdatePackage downloadUpdates(UpdateSummary summary, UpdateClient updateClient, Provider<Reader> readerProvider) {
        Update.Firmware firmware;
        RemoteUpdate remoteUpdate;
        Update.Config config;
        Update.Keys keys;
        Object it;
        LOGGER.d("downloadUpdates", new Pair[0]);
        Reader reader = (Reader)readerProvider.get();
        if (reader == null) {
            throw new ReaderUpdateException.NotConnectedToReader("Not connected to reader", null, 2, null);
        }
        Reader reader2 = reader;
        boolean needsOta = reader2.getNeedsOtaUpdate() || this.featureFlagsRepository.getFeatureFlags().enableBbposDownloading || this.featureFlagsRepository.getFeatureFlags().enableBbposVersioning;
        String string = summary.getKeyProfileName();
        if (string != null) {
            it = string;
            boolean bl = false;
            keys = new Update.Keys(new RemoteUpdate.Ota((String)it));
        } else {
            keys = null;
        }
        Update.Keys keys2 = keys;
        ClientVersionSpecPb clientVersionSpecPb = summary.getConfigSpec();
        if (clientVersionSpecPb != null && (it = this.toRemoteUpdate(clientVersionSpecPb, needsOta)) != null) {
            Object it2 = it;
            boolean bl = false;
            config = new Update.Config((RemoteUpdate)it2);
        } else {
            config = null;
        }
        Update.Config config2 = config;
        it = summary.getFirmwareSpec();
        if (it != null && (remoteUpdate = this.toRemoteUpdate((ClientVersionSpecPb)((Object)it), needsOta)) != null) {
            RemoteUpdate it3 = remoteUpdate;
            boolean bl = false;
            firmware = new Update.Firmware(it3);
        } else {
            firmware = null;
        }
        Update.Firmware firmware2 = firmware;
        Update.Settings settings = this.downloadSettings(summary, updateClient);
        return new UpdatePackage(keys2, config2, firmware2, settings);
    }

    private final Update.Settings downloadSettings(UpdateSummary summary, UpdateClient updateClient) {
        Bitmap bitmap;
        LOGGER.d("downloadSettings", new Pair[0]);
        MobileClientConfig mobileClientConfig = summary.getFullConfig();
        if (mobileClientConfig == null) {
            return null;
        }
        MobileClientConfig fullConfig = mobileClientConfig;
        if (summary.getSettingsVersion() == null && summary.getImageRef() == null) {
            return null;
        }
        ImageRef imageRef = summary.getImageRef();
        if (imageRef != null) {
            Bitmap bitmap2;
            ImageRef it = imageRef;
            boolean bl = false;
            try {
                bitmap2 = updateClient.downloadImage(it);
            }
            catch (Exception e2) {
                Logger.w$default(LOGGER, e2, null, new Pair[0], 2, null);
                bitmap2 = null;
            }
            bitmap = bitmap2;
        } else {
            bitmap = null;
        }
        Bitmap image2 = bitmap;
        return new Update.Settings(fullConfig, image2, summary.getSettingsVersion());
    }

    private final UpdateSummary updatePresignedUrls(UpdateSummary $this$updatePresignedUrls, UpdateClient updateClient) {
        LOGGER.w("Expired S3 link. Updating presigned URLs", new Pair[0]);
        Message message = $this$updatePresignedUrls.getConfigSpec();
        String configVersion = message != null && (message = message.version_info) != null ? message.client_version : null;
        Message message2 = $this$updatePresignedUrls.getFirmwareSpec();
        String firmwareVersion = message2 != null && (message2 = message2.version_info) != null ? message2.client_version : null;
        MobileClientConfig updatedConfig = updateClient.downloadMobilePosConfig(configVersion, firmwareVersion);
        BBPOSConfig bbposConfig = updatedConfig.bbpos_config;
        UpdateSummary.Builder builder = $this$updatePresignedUrls.toBuilder();
        if ($this$updatePresignedUrls.getConfigSpec() != null) {
            BBPOSConfig bBPOSConfig = bbposConfig;
            builder.setConfigSpec(bBPOSConfig != null ? bBPOSConfig.config_spec : null);
        }
        if ($this$updatePresignedUrls.getFirmwareSpec() != null) {
            BBPOSConfig bBPOSConfig = bbposConfig;
            builder.setFirmwareSpec(bBPOSConfig != null ? bBPOSConfig.firmware_spec : null);
        }
        return builder.build();
    }

    private final String getOtaVersion(ClientVersionSpecPb $this$otaVersion) {
        Object object = $this$otaVersion.version_info;
        if (object == null || (object = object.client_version) == null) {
            object = "";
        }
        return object;
    }

    private final RemoteUpdate toRemoteUpdate(ClientVersionSpecPb $this$toRemoteUpdate, boolean needsOtaUpdate) {
        RemoteUpdate remoteUpdate;
        if (needsOtaUpdate) {
            remoteUpdate = new RemoteUpdate.Ota(this.getOtaVersion($this$toRemoteUpdate));
        } else {
            UrlPb urlPb = $this$toRemoteUpdate.presigned_url;
            if (urlPb == null) {
                urlPb = new UrlPb(null, null, null, null, 15, null);
            }
            String hex = this.updateClient.downloadConfig(urlPb);
            remoteUpdate = new RemoteUpdate.Local(hex, this.getOtaVersion($this$toRemoteUpdate));
        }
        return remoteUpdate;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/readerupdate/ArmadaIngesterImpl$Companion;", "", "()V", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "readerupdate_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

