/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.readerupdate;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.annotation.VisibleForTesting;
import com.squareup.wire.Message;
import com.stripe.core.hardware.reactive.emv.MerchantNameData;
import com.stripe.core.hardware.updates.ReaderUpdateException;
import com.stripe.core.transaction.SettingsRepository;
import com.stripe.jvmcore.crpcclient.CrpcResponse;
import com.stripe.jvmcore.device.DeviceInfoRepository;
import com.stripe.jvmcore.featureflag.FeatureFlagsRepository;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.proto.api.armada.ArmadaApi;
import com.stripe.proto.api.armada.DownloadMobilePosConfigRequest;
import com.stripe.proto.api.armada.DownloadMobilePosConfigResponse;
import com.stripe.proto.model.common.ApplicationModel;
import com.stripe.proto.model.common.ClientVersionSpecPb;
import com.stripe.proto.model.common.DeviceInfo;
import com.stripe.proto.model.common.HardwareModel;
import com.stripe.proto.model.common.UrlPb;
import com.stripe.proto.model.config.BBPOSConfig;
import com.stripe.proto.model.config.MagstripeConfig;
import com.stripe.proto.model.config.MobileClientConfig;
import com.stripe.proto.model.config.ReaderFeatureFlags;
import com.stripe.proto.terminal.terminal.pub.message.common.ImageRef;
import com.stripe.proto.terminal.terminal.pub.message.config.OfflineConfigPb;
import com.stripe.proto.terminal.terminal.pub.message.config.TippingConfigPb;
import java.io.Closeable;
import java.io.InputStream;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kamranzafar.jtar.TarEntry;
import org.kamranzafar.jtar.TarInputStream;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 )2\u00020\u0001:\u0002)*B7\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u001a\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u0010J\u0015\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"H\u0001\u00a2\u0006\u0002\b#J \u0010$\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006+"}, d2={"Lcom/stripe/core/readerupdate/UpdateClient;", "", "armadaApi", "Lcom/stripe/proto/api/armada/ArmadaApi;", "okHttpClient", "Lokhttp3/OkHttpClient;", "deviceInfoRepository", "Lcom/stripe/jvmcore/device/DeviceInfoRepository;", "featureFlagRepository", "Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;", "settingsRepository", "Lcom/stripe/core/transaction/SettingsRepository;", "offlineConfigUpdateListener", "Lcom/stripe/core/readerupdate/UpdateClient$OfflineConfigUpdateListener;", "(Lcom/stripe/proto/api/armada/ArmadaApi;Lokhttp3/OkHttpClient;Lcom/stripe/jvmcore/device/DeviceInfoRepository;Lcom/stripe/jvmcore/featureflag/FeatureFlagsRepository;Lcom/stripe/core/transaction/SettingsRepository;Lcom/stripe/core/readerupdate/UpdateClient$OfflineConfigUpdateListener;)V", "appVersion", "", "getAppVersion", "(Lcom/stripe/jvmcore/device/DeviceInfoRepository;)Ljava/lang/String;", "downloadConfig", "url", "Lcom/stripe/proto/model/common/UrlPb;", "downloadImage", "Landroid/graphics/Bitmap;", "imageRef", "Lcom/stripe/proto/terminal/terminal/pub/message/common/ImageRef;", "downloadMobilePosConfig", "Lcom/stripe/proto/model/config/MobileClientConfig;", "data", "Lcom/stripe/core/hardware/reactive/emv/MerchantNameData;", "configVersion", "firmwareVersion", "processResponse", "response", "Lokhttp3/Response;", "processResponse$readerupdate_release", "retrieveMobilePosConfig", "bbposConfig", "Lcom/stripe/proto/api/armada/DownloadMobilePosConfigRequest$BBPOSConfig;", "validateConfig", "config", "Companion", "OfflineConfigUpdateListener", "readerupdate_release"})
@SourceDebugExtension(value={"SMAP\nUpdateClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateClient.kt\ncom/stripe/core/readerupdate/UpdateClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n1#2:259\n*E\n"})
public final class UpdateClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArmadaApi armadaApi;
    @NotNull
    private final OkHttpClient okHttpClient;
    @NotNull
    private final DeviceInfoRepository deviceInfoRepository;
    @NotNull
    private final FeatureFlagsRepository featureFlagRepository;
    @NotNull
    private final SettingsRepository settingsRepository;
    @NotNull
    private final OfflineConfigUpdateListener offlineConfigUpdateListener;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(UpdateClient.class);
    @NotNull
    private static final String FIRMWARE_CONFIG_KEY = "firmware-config-key";
    @NotNull
    private static final String TAR = "application/x-tar";

    @Inject
    public UpdateClient(@NotNull ArmadaApi armadaApi, @NotNull OkHttpClient okHttpClient, @NotNull DeviceInfoRepository deviceInfoRepository, @NotNull FeatureFlagsRepository featureFlagRepository, @NotNull SettingsRepository settingsRepository, @NotNull OfflineConfigUpdateListener offlineConfigUpdateListener) {
        Intrinsics.checkNotNullParameter((Object)armadaApi, (String)"armadaApi");
        Intrinsics.checkNotNullParameter((Object)okHttpClient, (String)"okHttpClient");
        Intrinsics.checkNotNullParameter((Object)deviceInfoRepository, (String)"deviceInfoRepository");
        Intrinsics.checkNotNullParameter((Object)featureFlagRepository, (String)"featureFlagRepository");
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        Intrinsics.checkNotNullParameter((Object)offlineConfigUpdateListener, (String)"offlineConfigUpdateListener");
        this.armadaApi = armadaApi;
        this.okHttpClient = okHttpClient;
        this.deviceInfoRepository = deviceInfoRepository;
        this.featureFlagRepository = featureFlagRepository;
        this.settingsRepository = settingsRepository;
        this.offlineConfigUpdateListener = offlineConfigUpdateListener;
    }

    @NotNull
    public final MobileClientConfig downloadMobilePosConfig(@Nullable MerchantNameData data) throws ReaderUpdateException {
        return UpdateClient.retrieveMobilePosConfig$default(this, data, null, 2, null);
    }

    @NotNull
    public final MobileClientConfig downloadMobilePosConfig(@Nullable String configVersion, @Nullable String firmwareVersion) throws ReaderUpdateException {
        String string;
        String string2;
        if (configVersion == null && firmwareVersion == null) {
            throw new ReaderUpdateException.UpdateFailedServerError("Failed to update, no version info", null, 2, null);
        }
        String string3 = configVersion;
        if (string3 == null) {
            string3 = string2 = "";
        }
        if ((string = firmwareVersion) == null) {
            string = "";
        }
        String string4 = string;
        return UpdateClient.retrieveMobilePosConfig$default(this, null, new DownloadMobilePosConfigRequest.BBPOSConfig(string4, string2, null, 4, null), 1, null);
    }

    @NotNull
    public final Bitmap downloadImage(@NotNull ImageRef imageRef) throws ReaderUpdateException {
        Intrinsics.checkNotNullParameter((Object)((Object)imageRef), (String)"imageRef");
        Request request = new Request.Builder().get().url(imageRef.image_url).build();
        return this.processResponse$readerupdate_release(this.okHttpClient.newCall(request).execute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    public final Bitmap processResponse$readerupdate_release(@NotNull Response response) throws ReaderUpdateException {
        block13: {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            if (response.isSuccessful()) {
                try {
                    ResponseBody responseBody = response.body();
                    if (responseBody == null) break block13;
                    Closeable closeable = (Closeable)responseBody;
                    Throwable throwable = null;
                    try {
                        Bitmap bitmap;
                        ResponseBody body = (ResponseBody)closeable;
                        boolean bl = false;
                        Closeable closeable2 = body.byteStream();
                        Throwable throwable2 = null;
                        try {
                            InputStream p0 = (InputStream)closeable2;
                            boolean bl2 = false;
                            Bitmap bitmap2 = BitmapFactory.decodeStream((InputStream)p0);
                            bitmap = bitmap2;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"body.byteStream().use(BitmapFactory::decodeStream)");
                        Bitmap bitmap3 = bitmap;
                        return bitmap3;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Exception e2) {
                    throw new ReaderUpdateException.UpdateFailed("Failure to decode image", null, 2, null);
                }
            }
        }
        throw new ReaderUpdateException.UpdateFailedServerError("Failure downloading image. Code: " + response.code() + ", Message: " + response.message(), null, 2, null);
    }

    @NotNull
    public final String downloadConfig(@NotNull UrlPb url) throws ReaderUpdateException {
        String string;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)((Object)url), (String)"url");
                Request request = new Request.Builder().get().url(Companion.toUrl(url)).build();
                Response response = this.okHttpClient.newCall(request).execute();
                if (!response.isSuccessful()) {
                    throw new ReaderUpdateException.UpdateFailedServerError("Failure downloading config. Code: " + response.code() + ", Message: " + response.message(), null, 2, null);
                }
                ResponseBody responseBody = response.body();
                if (responseBody == null) break block4;
                ResponseBody body = responseBody;
                boolean bl = false;
                string = Intrinsics.areEqual((Object)String.valueOf(body.contentType()), (Object)TAR) ? Companion.extractFirstHexFileFromTar(body.byteStream()) : body.string();
                if (string != null) break block5;
            }
            throw new ReaderUpdateException.UpdateFailed("Unexpected failure downloading config", null, 2, null);
        }
        return string;
    }

    private final MobileClientConfig retrieveMobilePosConfig(MerchantNameData data, DownloadMobilePosConfigRequest.BBPOSConfig bbposConfig) throws ReaderUpdateException {
        MobileClientConfig mobileClientConfig;
        DownloadMobilePosConfigRequest request;
        CrpcResponse<DownloadMobilePosConfigResponse> response;
        String string;
        String string2;
        String string3;
        String string4;
        DeviceInfoRepository $this$retrieveMobilePosConfig_u24lambda_u242 = this.deviceInfoRepository;
        boolean bl = false;
        HardwareModel hardwareModel = $this$retrieveMobilePosConfig_u24lambda_u242.getHardwareModel();
        if (hardwareModel.unknown_hardware != null) {
            throw new ReaderUpdateException.UnexpectedError("No connected reader", null, 2, null);
        }
        DeviceInfo.DeviceClass deviceClass = DeviceInfo.DeviceClass.READER;
        ApplicationModel applicationModel = new ApplicationModel(FIRMWARE_CONFIG_KEY, this.getAppVersion($this$retrieveMobilePosConfig_u24lambda_u242), null, 4, null);
        HardwareModel hardwareModel2 = new HardwareModel(null, null, null, hardwareModel.bbpos_hardware, null, null, null, null, 247, null);
        String string5 = $this$retrieveMobilePosConfig_u24lambda_u242.getSerialNumber();
        String string6 = $this$retrieveMobilePosConfig_u24lambda_u242.getPinKeyProfileId();
        if (string6 == null) {
            string6 = string4 = "";
        }
        if ((string3 = $this$retrieveMobilePosConfig_u24lambda_u242.getConfigVersion()) == null) {
            string3 = string2 = "";
        }
        if ((string = $this$retrieveMobilePosConfig_u24lambda_u242.getFirmwareVersion()) == null) {
            string = "";
        }
        String string7 = string;
        DeviceInfo deviceInfo = new DeviceInfo(deviceClass, string5, hardwareModel2, applicationModel, null, null, null, null, null, string7, string2, string4, null, null, null, null, 61936, null);
        MerchantNameData merchantNameData = data;
        String string8 = merchantNameData != null ? merchantNameData.getConfigHash() : null;
        if (string8 == null) {
            string8 = "";
        }
        if ((response = this.armadaApi.downloadMobilePosConfig(request = new DownloadMobilePosConfigRequest(deviceInfo, string8, bbposConfig, null, 8, null))) instanceof CrpcResponse.Success) {
            ReaderFeatureFlags newFeatureFlags;
            ReaderFeatureFlags readerFeatureFlags = ((DownloadMobilePosConfigResponse)((Object)((CrpcResponse.Success)response).getResponse())).reader_feature_flags;
            if (readerFeatureFlags == null) {
                readerFeatureFlags = newFeatureFlags = new ReaderFeatureFlags(false, false, false, false, 0L, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, 0L, false, false, false, false, false, false, 0L, 0L, false, 0L, null, -1, -1, 255, null);
            }
            if (this.featureFlagRepository.getFeatureFlags().enable_new_payment_collection_android_sdk != newFeatureFlags.enable_new_payment_collection_android_sdk) {
                LOGGER.d("Received feature flag change on new payment collection to " + newFeatureFlags.enable_new_payment_collection_android_sdk + '.', new Pair[0]);
            }
            this.featureFlagRepository.putFeatureFlags(newFeatureFlags);
            Message message = ((DownloadMobilePosConfigResponse)((Object)((CrpcResponse.Success)response).getResponse())).config;
            if (message == null || (message = message.tipping_config) == null) {
                message = new TippingConfigPb(null, null, 3, null);
            }
            Message tippingConfig = message;
            Message message2 = ((DownloadMobilePosConfigResponse)((Object)((CrpcResponse.Success)response).getResponse())).config;
            this.settingsRepository.setKeyProfileName(message2 != null && (message2 = message2.bbpos_config) != null ? message2.key_profile_name : null);
            this.settingsRepository.setTippingConfig((TippingConfigPb)tippingConfig);
            this.settingsRepository.setMagstripeConfig(new MagstripeConfig(false, null, 2, null));
            MobileClientConfig mobileClientConfig2 = ((DownloadMobilePosConfigResponse)((Object)((CrpcResponse.Success)response).getResponse())).config;
            this.offlineConfigUpdateListener.onOfflineConfigUpdate(this.deviceInfoRepository.getSerialNumber(), mobileClientConfig2 != null ? mobileClientConfig2.offline_config : null);
            mobileClientConfig = ((DownloadMobilePosConfigResponse)((Object)((CrpcResponse.Success)response).getResponse())).config;
            if (mobileClientConfig == null) {
                mobileClientConfig = new MobileClientConfig(null, null, null, null, null, null, null, null, null, 511, null);
            }
        } else {
            Pair[] pairArray;
            if (response instanceof CrpcResponse.RpcError) {
                pairArray = new Pair[]{TuplesKt.to((Object)"code", (Object)((CrpcResponse.RpcError)response).getCode().name()), TuplesKt.to((Object)"message", (Object)((CrpcResponse.RpcError)response).getMessage())};
                LOGGER.w("DownloadMobilePosConfig failed", pairArray);
                throw new ReaderUpdateException.UpdateFailedServerError("DownloadMobilePosConfig failed", null, 2, null);
            }
            if (response instanceof CrpcResponse.ApplicationError) {
                pairArray = new Pair[]{TuplesKt.to((Object)"code", (Object)((CrpcResponse.ApplicationError)response).getCode().name()), TuplesKt.to((Object)"message", (Object)((CrpcResponse.ApplicationError)response).getMessage())};
                LOGGER.w("DownloadMobilePosConfig failed", pairArray);
                throw new ReaderUpdateException.UpdateFailedServerError("DownloadMobilePosConfig failed", null, 2, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return this.validateConfig(mobileClientConfig);
    }

    static /* synthetic */ MobileClientConfig retrieveMobilePosConfig$default(UpdateClient updateClient, MerchantNameData merchantNameData, DownloadMobilePosConfigRequest.BBPOSConfig bBPOSConfig, int n2, Object object) throws ReaderUpdateException {
        if ((n2 & 1) != 0) {
            merchantNameData = null;
        }
        if ((n2 & 2) != 0) {
            bBPOSConfig = null;
        }
        return updateClient.retrieveMobilePosConfig(merchantNameData, bBPOSConfig);
    }

    private final MobileClientConfig validateConfig(MobileClientConfig config) {
        Unit unit;
        BBPOSConfig bBPOSConfig = config.bbpos_config;
        if (bBPOSConfig != null) {
            BBPOSConfig it = bBPOSConfig;
            boolean bl = false;
            if (it.config_spec == null || Intrinsics.areEqual((Object)((Object)it.config_spec), (Object)((Object)new ClientVersionSpecPb(null, null, null, null, null, null, null, null, 255, null)))) {
                LOGGER.w("MobileClientConfig missing configSpec", new Pair[0]);
            }
            if (it.firmware_spec == null || Intrinsics.areEqual((Object)((Object)it.firmware_spec), (Object)((Object)new ClientVersionSpecPb(null, null, null, null, null, null, null, null, 255, null)))) {
                LOGGER.w("MobileClientConfig missing firmwareSpec", new Pair[0]);
            }
            if (it.minimum_required_config_spec == null || Intrinsics.areEqual((Object)((Object)it.minimum_required_config_spec), (Object)((Object)new ClientVersionSpecPb(null, null, null, null, null, null, null, null, 255, null)))) {
                LOGGER.w("MobileClientConfig missing minimumRequiredConfigSpec", new Pair[0]);
            }
            if (it.minimum_required_firmware_spec == null || Intrinsics.areEqual((Object)((Object)it.minimum_required_firmware_spec), (Object)((Object)new ClientVersionSpecPb(null, null, null, null, null, null, null, null, 255, null)))) {
                LOGGER.w("MobileClientConfig missing minimumRequiredFirmwareSpec", new Pair[0]);
            }
            if (((CharSequence)it.key_profile_pek0).length() == 0 || ((CharSequence)it.key_profile_name).length() == 0) {
                LOGGER.w("MobileClientConfig missing valid key name or pek0", new Pair[0]);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            LOGGER.w("MobileClientConfig missing bbposConfig", new Pair[0]);
        }
        if (((CharSequence)config.client_config_version).length() == 0) {
            LOGGER.w("MobileClientConfig missing clientConfigVersion", new Pair[0]);
        }
        return config;
    }

    private final String getAppVersion(DeviceInfoRepository $this$appVersion) {
        CharSequence charSequence = $this$appVersion.getFirmwareVersion();
        return charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)$this$appVersion.getConfigVersion()) == null || charSequence.length() == 0 || (charSequence = (CharSequence)$this$appVersion.getPinKeysetId()) == null || charSequence.length() == 0 ? "" : $this$appVersion.getFirmwareVersion() + '-' + $this$appVersion.getConfigVersion() + '-' + $this$appVersion.getPinKeysetId();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nH\u0007J\n\u0010\u000b\u001a\u00020\u0004*\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/core/readerupdate/UpdateClient$Companion;", "", "()V", "FIRMWARE_CONFIG_KEY", "", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "TAR", "extractFirstHexFileFromTar", "inputStream", "Ljava/io/InputStream;", "toUrl", "Lcom/stripe/proto/model/common/UrlPb;", "readerupdate_release"})
    @SourceDebugExtension(value={"SMAP\nUpdateClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateClient.kt\ncom/stripe/core/readerupdate/UpdateClient$Companion\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,258:1\n179#2,2:259\n1#3:261\n*S KotlinDebug\n*F\n+ 1 UpdateClient.kt\ncom/stripe/core/readerupdate/UpdateClient$Companion\n*L\n252#1:259,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String toUrl(@NotNull UrlPb $this$toUrl) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$toUrl), (String)"<this>");
            return $this$toUrl.protocol + "://" + $this$toUrl.host + $this$toUrl.path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @VisibleForTesting
        @Nullable
        public final String extractFirstHexFileFromTar(@NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            var2_2 = (Closeable)new TarInputStream(inputStream);
            var3_3 = null;
            try {
                block8: {
                    tarInputStream = (TarInputStream)var2_2;
                    $i$a$-use-UpdateClient$Companion$extractFirstHexFileFromTar$1 = false;
                    var6_8 = SequencesKt.generateSequence((Function0)((Function0)new Function0<TarEntry>(tarInputStream){
                        final /* synthetic */ TarInputStream $tarInputStream;
                        {
                            this.$tarInputStream = $tarInputStream;
                            super(0);
                        }

                        @Nullable
                        public final TarEntry invoke() {
                            return this.$tarInputStream.getNextEntry();
                        }
                    }));
                    $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        it = (TarEntry)element$iv;
                        $i$a$-firstOrNull-UpdateClient$Companion$extractFirstHexFileFromTar$1$2 = false;
                        v0 = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"it.name");
                        if (!StringsKt.endsWith$default((String)v0, (String)".hex", (boolean)false, (int)2, null)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                var12_15 = v1;
                if (var12_15 == null) ** GOTO lbl-1000
                entry = var12_15;
                $i$a$-let-UpdateClient$Companion$extractFirstHexFileFromTar$1$3 = false;
                var6_8 = ByteString.Companion.read((InputStream)tarInputStream, (int)entry.getSize());
                if (var6_8 != null) {
                    v2 = var6_8.utf8();
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
                var4_4 = v2;
            }
            catch (Throwable var4_5) {
                var3_3 = var4_5;
                throw var4_5;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var2_2, (Throwable)var3_3);
            }
            return var4_4;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/stripe/core/readerupdate/UpdateClient$OfflineConfigUpdateListener;", "", "onOfflineConfigUpdate", "", "serialNumber", "", "offlineConfig", "Lcom/stripe/proto/terminal/terminal/pub/message/config/OfflineConfigPb;", "readerupdate_release"})
    public static interface OfflineConfigUpdateListener {
        public void onOfflineConfigUpdate(@NotNull String var1, @Nullable OfflineConfigPb var2);
    }
}

