/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.statemachine;

import androidx.annotation.VisibleForTesting;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0004J\r\u0010\r\u001a\u0004\u0018\u00018\u0001\u00a2\u0006\u0002\u0010\u000eJ\r\u0010\u000f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\bH\u0004J3\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\b\u0010\u0014\u001a\u0004\u0018\u00018\u00002\b\u0010\u0005\u001a\u0004\u0018\u00018\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014\u00a2\u0006\u0002\u0010\u0017J\u001c\u0010\u0018\u001a\u00020\u00122\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bH\u0002J!\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u00002\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00028\u0001H\u0007\u00a2\u0006\u0002\u0010\u001cR\u0012\u0010\u0005\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001c\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u0004\u0018\u00018\u0001X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0012\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R&\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/stripe/core/statemachine/StateMachine;", "S", "", "D", "()V", "data", "Ljava/lang/Object;", "handler", "Lcom/stripe/core/statemachine/StateMachine$StateHandler;", "previousData", "state", "stateHandlers", "", "getData", "()Ljava/lang/Object;", "getState", "getStateHandler", "onStateChanging", "", "to", "from", "reason", "", "(Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/Object;Ljava/lang/String;)V", "registerHandler", "transitionTo", "(Ljava/lang/Object;Ljava/lang/String;)V", "updateData", "(Ljava/lang/Object;)V", "updateDataWithoutCallback", "StateHandler", "statemachine_release"})
public abstract class StateMachine<S, D> {
    @NotNull
    private final Map<S, StateHandler<S, D>> stateHandlers = new LinkedHashMap();
    @Nullable
    private S state;
    @Nullable
    private StateHandler<S, D> handler;
    @Nullable
    private D data;
    @Nullable
    private D previousData;

    private final void registerHandler(StateHandler<S, D> handler2) {
        this.stateHandlers.put(handler2.getState(), handler2);
    }

    public final void updateData(@NotNull D to) {
        block0: {
            Intrinsics.checkNotNullParameter(to, (String)"to");
            this.previousData = this.data;
            this.data = to;
            StateHandler<S, D> stateHandler = this.handler;
            if (stateHandler == null) break block0;
            stateHandler.onUpdate(to, this.previousData);
        }
    }

    @VisibleForTesting(otherwise=2)
    public final void updateDataWithoutCallback(@NotNull D data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.data = data;
    }

    public void transitionTo(@NotNull S to, @Nullable String reason) {
        StateHandler<S, D> stateHandler;
        Intrinsics.checkNotNullParameter(to, (String)"to");
        if (Intrinsics.areEqual(this.state, to)) {
            return;
        }
        S previousState = this.state;
        StateHandler<S, D> stateHandler2 = this.handler;
        if (stateHandler2 != null) {
            stateHandler2.onExit(to);
        }
        if (!Intrinsics.areEqual(previousState, this.state)) {
            return;
        }
        StateHandler<S, D> toHandler = this.stateHandlers.get(to);
        this.handler = toHandler;
        this.state = to;
        StateHandler<S, D> stateHandler3 = toHandler;
        if (stateHandler3 == null) {
            throw new IllegalStateException("No handler registered for " + to);
        }
        StateHandler<S, D> $this$transitionTo_u24lambda_u240 = stateHandler = stateHandler3;
        boolean bl = false;
        this.onStateChanging(to, previousState, this.data, reason);
        $this$transitionTo_u24lambda_u240.onEnter(this.data, previousState);
    }

    public static /* synthetic */ void transitionTo$default(StateMachine stateMachine, Object object, String string, int n2, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transitionTo");
        }
        if ((n2 & 2) != 0) {
            string = null;
        }
        stateMachine.transitionTo(object, string);
    }

    @Nullable
    public final S getState() {
        return this.state;
    }

    @Nullable
    protected final StateHandler<S, D> getStateHandler() {
        return this.handler;
    }

    @Nullable
    public final D getData() {
        return this.data;
    }

    protected void onStateChanging(@NotNull S to, @Nullable S from, @Nullable D data, @Nullable String reason) {
        Intrinsics.checkNotNullParameter(to, (String)"to");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u0002*\b\b\u0003\u0010\u0003*\u00020\u00022\u00020\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u000f\u001a\u0004\u0018\u00018\u0003H\u0016\u00a2\u0006\u0002\u0010\u0007J!\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00018\u00032\b\u0010\u0013\u001a\u0004\u0018\u00018\u0002H\u0016\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00028\u0002H\u0016\u00a2\u0006\u0002\u0010\u0005J\u001f\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00028\u00032\b\u0010\u0019\u001a\u0004\u0018\u00018\u0003H\u0016\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u001a\u001a\u00020\u00112\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\nJ\u001f\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00028\u00022\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0013\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00028\u0003\u00a2\u0006\u0002\u0010\u0005R\u0013\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R&\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/stripe/core/statemachine/StateMachine$StateHandler;", "S", "", "D", "state", "(Ljava/lang/Object;)V", "getState", "()Ljava/lang/Object;", "Ljava/lang/Object;", "stateMachine", "Lcom/stripe/core/statemachine/StateMachine;", "getStateMachine", "()Lcom/stripe/core/statemachine/StateMachine;", "setStateMachine", "(Lcom/stripe/core/statemachine/StateMachine;)V", "getData", "onEnter", "", "current", "from", "(Ljava/lang/Object;Ljava/lang/Object;)V", "onExit", "to", "onUpdate", "new", "old", "register", "transitionTo", "reason", "", "(Ljava/lang/Object;Ljava/lang/String;)V", "updateDataWithoutCallback", "data", "statemachine_release"})
    public static class StateHandler<S, D> {
        @NotNull
        private final S state;
        public StateMachine<S, D> stateMachine;

        public StateHandler(@NotNull S state) {
            Intrinsics.checkNotNullParameter(state, (String)"state");
            this.state = state;
        }

        @NotNull
        public final S getState() {
            return this.state;
        }

        @NotNull
        public final StateMachine<S, D> getStateMachine() {
            StateMachine<S, D> stateMachine = this.stateMachine;
            if (stateMachine != null) {
                return stateMachine;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"stateMachine");
            return null;
        }

        public final void setStateMachine(@NotNull StateMachine<S, D> stateMachine) {
            Intrinsics.checkNotNullParameter(stateMachine, (String)"<set-?>");
            this.stateMachine = stateMachine;
        }

        public final void register(@NotNull StateMachine<S, D> stateMachine) {
            Intrinsics.checkNotNullParameter(stateMachine, (String)"stateMachine");
            this.setStateMachine(stateMachine);
            ((StateMachine)stateMachine).registerHandler(this);
        }

        public final void updateDataWithoutCallback(@NotNull D data) {
            Intrinsics.checkNotNullParameter(data, (String)"data");
            this.getStateMachine().updateDataWithoutCallback(data);
        }

        public final void transitionTo(@NotNull S to, @Nullable String reason) {
            Intrinsics.checkNotNullParameter(to, (String)"to");
            this.getStateMachine().transitionTo(to, reason);
        }

        public static /* synthetic */ void transitionTo$default(StateHandler stateHandler, Object object, String string, int n2, Object object2) {
            if (object2 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transitionTo");
            }
            if ((n2 & 2) != 0) {
                string = null;
            }
            stateHandler.transitionTo(object, string);
        }

        public void onEnter(@Nullable D current, @Nullable S from) {
        }

        public void onExit(@NotNull S to) {
            Intrinsics.checkNotNullParameter(to, (String)"to");
        }

        public void onUpdate(@NotNull D d2, @Nullable D old) {
            Intrinsics.checkNotNullParameter(d2, (String)"new");
        }

        @Nullable
        public D getData() {
            return this.getStateMachine().getData();
        }
    }
}

