/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.storage;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Base64;
import com.stripe.core.storage.AndroidKeyValueStore;
import com.stripe.jvmcore.dagger.ForApplication;
import com.stripe.jvmcore.dagger.IO;
import com.stripe.jvmcore.storage.KeyValueStore;
import com.stripe.jvmcore.storage.SharedPrefsChangeListener;
import com.stripe.jvmcore.storage.StoreChangeListener;
import io.reactivex.rxjava3.core.Scheduler;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\t*\u0001\b\u0018\u0000 52\u00020\u0001:\u00015B\u001b\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001fH\u0016J\u001c\u0010 \u001a\u00020\u001d2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020#0\"H\u0016J\b\u0010$\u001a\u00020\u001dH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\fH\u0016J\u0018\u0010(\u001a\u00020&2\u0006\u0010'\u001a\u00020\f2\u0006\u0010)\u001a\u00020&H\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010'\u001a\u00020\f2\u0006\u0010)\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020\f2\u0006\u0010)\u001a\u00020-H\u0016J\u001c\u0010.\u001a\u0004\u0018\u00010\f2\u0006\u0010'\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010\fH\u0016J\u0018\u0010/\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\f2\u0006\u00100\u001a\u00020&H\u0016J\u0018\u00101\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\f2\u0006\u00100\u001a\u00020+H\u0016J\u0018\u00102\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\f2\u0006\u00100\u001a\u00020-H\u0016J\u0018\u00103\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\f2\u0006\u00100\u001a\u00020\fH\u0016J\u0010\u00104\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR&\u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/stripe/core/storage/AndroidKeyValueStore;", "Lcom/stripe/jvmcore/storage/KeyValueStore;", "applicationContext", "Landroid/content/Context;", "ioScheduler", "Lio/reactivex/rxjava3/core/Scheduler;", "(Landroid/content/Context;Lio/reactivex/rxjava3/core/Scheduler;)V", "listener", "com/stripe/core/storage/AndroidKeyValueStore$listener$1", "Lcom/stripe/core/storage/AndroidKeyValueStore$listener$1;", "listenerMap", "", "", "", "Lcom/stripe/jvmcore/storage/SharedPrefsChangeListener;", "getListenerMap", "()Ljava/util/Map;", "sharedPreferences", "Landroid/content/SharedPreferences;", "getSharedPreferences", "()Landroid/content/SharedPreferences;", "sharedPreferencesFuture", "Ljava/util/concurrent/Future;", "base64Decode", "", "encodedMessage", "base64Encode", "byteArray", "batchRemoveFields", "", "keys", "", "batchSetFields", "map", "", "", "clear", "contains", "", "key", "getBoolean", "default", "getInt", "", "getLong", "", "getString", "putBoolean", "value", "putInt", "putLong", "putString", "remove", "Companion", "storage_release"})
@SourceDebugExtension(value={"SMAP\nAndroidKeyValueStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidKeyValueStore.kt\ncom/stripe/core/storage/AndroidKeyValueStore\n+ 2 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n39#2,12:131\n39#2,12:143\n39#2,12:155\n39#2,12:167\n39#2,12:179\n39#2,6:191\n45#2,6:199\n39#2,6:205\n45#2,6:213\n39#2,12:219\n1855#3,2:197\n1855#3,2:211\n*S KotlinDebug\n*F\n+ 1 AndroidKeyValueStore.kt\ncom/stripe/core/storage/AndroidKeyValueStore\n*L\n56#1:131,12\n64#1:143,12\n72#1:155,12\n80#1:167,12\n88#1:179,12\n92#1:191,6\n92#1:199,6\n97#1:205,6\n97#1:213,6\n115#1:219,12\n93#1:197,2\n98#1:211,2\n*E\n"})
public final class AndroidKeyValueStore
implements KeyValueStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final Future<SharedPreferences> sharedPreferencesFuture;
    @NotNull
    private final Map<String, Set<SharedPrefsChangeListener>> listenerMap;
    @NotNull
    private final listener.1 listener;
    @NotNull
    public static final String ADMIN_SHARED_PREFS = "admin_prefs";

    @Inject
    public AndroidKeyValueStore(@ForApplication @NotNull Context applicationContext, @IO @NotNull Scheduler ioScheduler) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)ioScheduler, (String)"ioScheduler");
        this.applicationContext = applicationContext;
        this.listenerMap = new LinkedHashMap();
        this.listener = new SharedPreferences.OnSharedPreferenceChangeListener(this){
            @NotNull
            private final StoreChangeListener changeListener;
            final /* synthetic */ AndroidKeyValueStore this$0;
            {
                this.this$0 = $receiver;
                this.changeListener = new StoreChangeListener($receiver.getListenerMap());
            }

            @NotNull
            public final StoreChangeListener getChangeListener() {
                return this.changeListener;
            }

            public void onSharedPreferenceChanged(@Nullable SharedPreferences sharedPreferences, @Nullable String key) {
                this.changeListener.onValueChanged(this.this$0, key);
            }
        };
        this.sharedPreferencesFuture = new FutureTask<SharedPreferences>(() -> AndroidKeyValueStore._init_$lambda$0(this));
        ioScheduler.scheduleDirect((Runnable)((Object)this.sharedPreferencesFuture));
    }

    @NotNull
    public final SharedPreferences getSharedPreferences() {
        SharedPreferences sharedPreferences = this.sharedPreferencesFuture.get();
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"sharedPreferencesFuture.get()");
        return sharedPreferences;
    }

    @Override
    @NotNull
    public Map<String, Set<SharedPrefsChangeListener>> getListenerMap() {
        return this.listenerMap;
    }

    @Override
    public void putString(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$putString_u24lambda_u241 = editor$iv;
        boolean bl = false;
        $this$putString_u24lambda_u241.putString(key, value);
        editor$iv.apply();
    }

    @Override
    @Nullable
    public String getString(@NotNull String key, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getSharedPreferences().getString(key, string);
    }

    @Override
    public void putBoolean(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$putBoolean_u24lambda_u242 = editor$iv;
        boolean bl = false;
        $this$putBoolean_u24lambda_u242.putBoolean(key, value);
        editor$iv.apply();
    }

    @Override
    public boolean getBoolean(@NotNull String key, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getSharedPreferences().getBoolean(key, bl);
    }

    @Override
    public void putLong(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$putLong_u24lambda_u243 = editor$iv;
        boolean bl = false;
        $this$putLong_u24lambda_u243.putLong(key, value);
        editor$iv.apply();
    }

    @Override
    public long getLong(@NotNull String key, long l2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getSharedPreferences().getLong(key, l2);
    }

    @Override
    public void putInt(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$putInt_u24lambda_u244 = editor$iv;
        boolean bl = false;
        $this$putInt_u24lambda_u244.putInt(key, value);
        editor$iv.apply();
    }

    @Override
    public int getInt(@NotNull String key, int n2) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getSharedPreferences().getInt(key, n2);
    }

    @Override
    public void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$remove_u24lambda_u245 = editor$iv;
        boolean bl = false;
        $this$remove_u24lambda_u245.remove(key);
        editor$iv.apply();
    }

    @Override
    public void batchRemoveFields(@NotNull List<String> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$batchRemoveFields_u24lambda_u247 = editor$iv;
        boolean bl = false;
        Iterable $this$forEach$iv = keys;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            $this$batchRemoveFields_u24lambda_u247.remove(it);
        }
        editor$iv.apply();
    }

    @Override
    public void batchSetFields(@NotNull Map<String, ? extends Object> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$batchSetFields_u24lambda_u249 = editor$iv;
        boolean bl = false;
        Iterable $this$forEach$iv = map2.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Object v2 = value;
            if (v2 instanceof String) {
                $this$batchSetFields_u24lambda_u249.putString(key, (String)value);
                continue;
            }
            if (v2 instanceof Integer) {
                $this$batchSetFields_u24lambda_u249.putInt(key, ((Number)value).intValue());
                continue;
            }
            if (v2 instanceof Boolean) {
                $this$batchSetFields_u24lambda_u249.putBoolean(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (v2 instanceof Long) {
                $this$batchSetFields_u24lambda_u249.putLong(key, ((Number)value).longValue());
                continue;
            }
            throw new Exception("Unsupported data type for " + value + '.');
        }
        editor$iv.apply();
    }

    @Override
    public boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getSharedPreferences().contains(key);
    }

    @Override
    public void clear() {
        SharedPreferences $this$edit_u24default$iv = this.getSharedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor$iv = $this$edit_u24default$iv.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor$iv, (String)"editor");
        SharedPreferences.Editor $this$clear_u24lambda_u2410 = editor$iv;
        boolean bl = false;
        $this$clear_u24lambda_u2410.clear();
        editor$iv.apply();
    }

    @Override
    @NotNull
    public String base64Encode(@NotNull byte[] byteArray) {
        Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
        String string = Base64.encodeToString((byte[])byteArray, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(byteArray, Base64.DEFAULT)");
        return string;
    }

    @Override
    @NotNull
    public byte[] base64Decode(@NotNull String encodedMessage) {
        Intrinsics.checkNotNullParameter((Object)encodedMessage, (String)"encodedMessage");
        byte[] byArray = Base64.decode((String)encodedMessage, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(encodedMessage, Base64.DEFAULT)");
        return byArray;
    }

    private static final SharedPreferences _init_$lambda$0(AndroidKeyValueStore this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SharedPreferences sharedPrefs = this$0.applicationContext.getSharedPreferences(ADMIN_SHARED_PREFS, 0);
        sharedPrefs.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this$0.listener);
        return sharedPrefs;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/core/storage/AndroidKeyValueStore$Companion;", "", "()V", "ADMIN_SHARED_PREFS", "", "storage_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

