/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.stripeterminal.storage;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.stripe.core.stripeterminal.storage.EventDao;
import com.stripe.core.stripeterminal.storage.EventEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class EventDao_Impl
implements EventDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<EventEntity> __insertionAdapterOfEventEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public EventDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEventEntity = new EntityInsertionAdapter<EventEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `events` (`event`,`scope`,`domain`,`startTimeMs`,`uid`) VALUES (?,?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, EventEntity value) {
                if (value.getEvent() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEvent());
                }
                if (value.getScope() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getScope());
                }
                if (value.getDomain() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getDomain());
                }
                stmt.bindLong(4, value.getStartTimeMs());
                stmt.bindLong(5, value.getUid());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE from events";
                return "DELETE from events";
            }
        };
    }

    @Override
    public void insert(EventEntity event) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEventEntity.insert((Object)event);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertAll(List<EventEntity> event) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEventEntity.insert(event);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EventEntity> getAll() {
        String _sql = "SELECT * from events";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * from events", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfEvent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"event");
            int _cursorIndexOfScope = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"scope");
            int _cursorIndexOfDomain = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"domain");
            int _cursorIndexOfStartTimeMs = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"startTimeMs");
            int _cursorIndexOfUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uid");
            ArrayList<EventEntity> _result = new ArrayList<EventEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpEvent = _cursor.isNull(_cursorIndexOfEvent) ? null : _cursor.getString(_cursorIndexOfEvent);
                String _tmpScope = _cursor.isNull(_cursorIndexOfScope) ? null : _cursor.getString(_cursorIndexOfScope);
                String _tmpDomain = _cursor.isNull(_cursorIndexOfDomain) ? null : _cursor.getString(_cursorIndexOfDomain);
                long _tmpStartTimeMs = _cursor.getLong(_cursorIndexOfStartTimeMs);
                long _tmpUid = _cursor.getLong(_cursorIndexOfUid);
                EventEntity _item = new EventEntity(_tmpEvent, _tmpScope, _tmpDomain, _tmpStartTimeMs, _tmpUid);
                _result.add(_item);
            }
            ArrayList<EventEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

