/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.stripeterminal.storage;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.stripe.core.stripeterminal.storage.LogLevelConverters;
import com.stripe.core.stripeterminal.storage.LogPointDao;
import com.stripe.core.stripeterminal.storage.LogPointEntity;
import com.stripe.jvmcore.loggingmodels.LogLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class LogPointDao_Impl
implements LogPointDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<LogPointEntity> __insertionAdapterOfLogPointEntity;
    private final LogLevelConverters __logLevelConverters = new LogLevelConverters();
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public LogPointDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfLogPointEntity = new EntityInsertionAdapter<LogPointEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `logpoints` (`message`,`exception`,`loglevel`,`timeOffsetMs`,`traceId`,`uid`) VALUES (?,?,?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, LogPointEntity value) {
                if (value.getMessage() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessage());
                }
                if (value.getException() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getException());
                }
                int _tmp = LogPointDao_Impl.this.__logLevelConverters.fromLogLevel(value.getLogLevel());
                stmt.bindLong(3, (long)_tmp);
                stmt.bindLong(4, (long)value.getOffsetMs());
                if (value.getTraceId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getTraceId());
                }
                stmt.bindLong(6, value.getUid());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM logpoints";
                return "DELETE FROM logpoints";
            }
        };
    }

    @Override
    public void insert(LogPointEntity logPoint) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfLogPointEntity.insert((Object)logPoint);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertAll(List<LogPointEntity> logPointEntityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfLogPointEntity.insert(logPointEntityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogPointEntity> getAll() {
        String _sql = "SELECT * FROM logpoints";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM logpoints", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
            int _cursorIndexOfException = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"exception");
            int _cursorIndexOfLogLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"loglevel");
            int _cursorIndexOfOffsetMs = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeOffsetMs");
            int _cursorIndexOfTraceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"traceId");
            int _cursorIndexOfUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uid");
            ArrayList<LogPointEntity> _result = new ArrayList<LogPointEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpMessage = _cursor.isNull(_cursorIndexOfMessage) ? null : _cursor.getString(_cursorIndexOfMessage);
                String _tmpException = _cursor.isNull(_cursorIndexOfException) ? null : _cursor.getString(_cursorIndexOfException);
                int _tmp = _cursor.getInt(_cursorIndexOfLogLevel);
                LogLevel _tmpLogLevel = this.__logLevelConverters.toLogLevel(_tmp);
                int _tmpOffsetMs = _cursor.getInt(_cursorIndexOfOffsetMs);
                String _tmpTraceId = _cursor.isNull(_cursorIndexOfTraceId) ? null : _cursor.getString(_cursorIndexOfTraceId);
                long _tmpUid = _cursor.getLong(_cursorIndexOfUid);
                LogPointEntity _item = new LogPointEntity(_tmpMessage, _tmpException, _tmpLogLevel, _tmpOffsetMs, _tmpTraceId, _tmpUid);
                _result.add(_item);
            }
            ArrayList<LogPointEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<LogPointEntity> getLogPointsForTrace(String traceId) {
        String _sql = "SELECT * FROM logpoints WHERE traceId = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM logpoints WHERE traceId = ?", (int)1);
        int _argIndex = 1;
        if (traceId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, traceId);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
            int _cursorIndexOfException = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"exception");
            int _cursorIndexOfLogLevel = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"loglevel");
            int _cursorIndexOfOffsetMs = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timeOffsetMs");
            int _cursorIndexOfTraceId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"traceId");
            int _cursorIndexOfUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uid");
            ArrayList<LogPointEntity> _result = new ArrayList<LogPointEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpMessage = _cursor.isNull(_cursorIndexOfMessage) ? null : _cursor.getString(_cursorIndexOfMessage);
                String _tmpException = _cursor.isNull(_cursorIndexOfException) ? null : _cursor.getString(_cursorIndexOfException);
                int _tmp = _cursor.getInt(_cursorIndexOfLogLevel);
                LogLevel _tmpLogLevel = this.__logLevelConverters.toLogLevel(_tmp);
                int _tmpOffsetMs = _cursor.getInt(_cursorIndexOfOffsetMs);
                String _tmpTraceId = _cursor.isNull(_cursorIndexOfTraceId) ? null : _cursor.getString(_cursorIndexOfTraceId);
                long _tmpUid = _cursor.getLong(_cursorIndexOfUid);
                LogPointEntity _item = new LogPointEntity(_tmpMessage, _tmpException, _tmpLogLevel, _tmpOffsetMs, _tmpTraceId, _tmpUid);
                _result.add(_item);
            }
            ArrayList<LogPointEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

