/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.stripeterminal.storage;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.stripe.core.stripeterminal.storage.EventDao;
import com.stripe.core.stripeterminal.storage.EventDao_Impl;
import com.stripe.core.stripeterminal.storage.LogPointDao;
import com.stripe.core.stripeterminal.storage.LogPointDao_Impl;
import com.stripe.core.stripeterminal.storage.StripeTerminalDatabase;
import com.stripe.core.stripeterminal.storage.TraceDao;
import com.stripe.core.stripeterminal.storage.TraceDao_Impl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StripeTerminalDatabase_Impl
extends StripeTerminalDatabase {
    private volatile EventDao _eventDao;
    private volatile LogPointDao _logPointDao;
    private volatile TraceDao _traceDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(4){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `events` (`event` TEXT NOT NULL, `scope` TEXT NOT NULL, `domain` TEXT NOT NULL, `startTimeMs` INTEGER NOT NULL, `uid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `logpoints` (`message` TEXT, `exception` TEXT, `loglevel` INTEGER NOT NULL, `timeOffsetMs` INTEGER NOT NULL, `traceId` TEXT NOT NULL, `uid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `traces` (`startTimeMs` INTEGER NOT NULL, `id` TEXT NOT NULL, `request` TEXT, `response` TEXT, `service` TEXT NOT NULL, `method` TEXT NOT NULL, `exception` TEXT, `totalTimeMs` INTEGER, `sessionId` TEXT, `serialNumber` TEXT, `tags` TEXT, `uid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '9bf83398a5dde48d79a5c4f594b4bf80')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `events`");
                _db.execSQL("DROP TABLE IF EXISTS `logpoints`");
                _db.execSQL("DROP TABLE IF EXISTS `traces`");
                if (StripeTerminalDatabase_Impl.this.mCallbacks != null) {
                    int _size = StripeTerminalDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)StripeTerminalDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            public void onCreate(SupportSQLiteDatabase _db) {
                if (StripeTerminalDatabase_Impl.this.mCallbacks != null) {
                    int _size = StripeTerminalDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)StripeTerminalDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                StripeTerminalDatabase_Impl.this.mDatabase = _db;
                StripeTerminalDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (StripeTerminalDatabase_Impl.this.mCallbacks != null) {
                    int _size = StripeTerminalDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)StripeTerminalDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            public RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsEvents = new HashMap<String, TableInfo.Column>(5);
                _columnsEvents.put("event", new TableInfo.Column("event", "TEXT", true, 0, null, 1));
                _columnsEvents.put("scope", new TableInfo.Column("scope", "TEXT", true, 0, null, 1));
                _columnsEvents.put("domain", new TableInfo.Column("domain", "TEXT", true, 0, null, 1));
                _columnsEvents.put("startTimeMs", new TableInfo.Column("startTimeMs", "INTEGER", true, 0, null, 1));
                _columnsEvents.put("uid", new TableInfo.Column("uid", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysEvents = new HashSet(0);
                HashSet _indicesEvents = new HashSet(0);
                TableInfo _infoEvents = new TableInfo("events", _columnsEvents, _foreignKeysEvents, _indicesEvents);
                TableInfo _existingEvents = TableInfo.read((SupportSQLiteDatabase)_db, (String)"events");
                if (!_infoEvents.equals((Object)_existingEvents)) {
                    return new RoomOpenHelper.ValidationResult(false, "events(com.stripe.core.stripeterminal.storage.EventEntity).\n Expected:\n" + _infoEvents + "\n Found:\n" + _existingEvents);
                }
                HashMap<String, TableInfo.Column> _columnsLogpoints = new HashMap<String, TableInfo.Column>(6);
                _columnsLogpoints.put("message", new TableInfo.Column("message", "TEXT", false, 0, null, 1));
                _columnsLogpoints.put("exception", new TableInfo.Column("exception", "TEXT", false, 0, null, 1));
                _columnsLogpoints.put("loglevel", new TableInfo.Column("loglevel", "INTEGER", true, 0, null, 1));
                _columnsLogpoints.put("timeOffsetMs", new TableInfo.Column("timeOffsetMs", "INTEGER", true, 0, null, 1));
                _columnsLogpoints.put("traceId", new TableInfo.Column("traceId", "TEXT", true, 0, null, 1));
                _columnsLogpoints.put("uid", new TableInfo.Column("uid", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysLogpoints = new HashSet(0);
                HashSet _indicesLogpoints = new HashSet(0);
                TableInfo _infoLogpoints = new TableInfo("logpoints", _columnsLogpoints, _foreignKeysLogpoints, _indicesLogpoints);
                TableInfo _existingLogpoints = TableInfo.read((SupportSQLiteDatabase)_db, (String)"logpoints");
                if (!_infoLogpoints.equals((Object)_existingLogpoints)) {
                    return new RoomOpenHelper.ValidationResult(false, "logpoints(com.stripe.core.stripeterminal.storage.LogPointEntity).\n Expected:\n" + _infoLogpoints + "\n Found:\n" + _existingLogpoints);
                }
                HashMap<String, TableInfo.Column> _columnsTraces = new HashMap<String, TableInfo.Column>(12);
                _columnsTraces.put("startTimeMs", new TableInfo.Column("startTimeMs", "INTEGER", true, 0, null, 1));
                _columnsTraces.put("id", new TableInfo.Column("id", "TEXT", true, 0, null, 1));
                _columnsTraces.put("request", new TableInfo.Column("request", "TEXT", false, 0, null, 1));
                _columnsTraces.put("response", new TableInfo.Column("response", "TEXT", false, 0, null, 1));
                _columnsTraces.put("service", new TableInfo.Column("service", "TEXT", true, 0, null, 1));
                _columnsTraces.put("method", new TableInfo.Column("method", "TEXT", true, 0, null, 1));
                _columnsTraces.put("exception", new TableInfo.Column("exception", "TEXT", false, 0, null, 1));
                _columnsTraces.put("totalTimeMs", new TableInfo.Column("totalTimeMs", "INTEGER", false, 0, null, 1));
                _columnsTraces.put("sessionId", new TableInfo.Column("sessionId", "TEXT", false, 0, null, 1));
                _columnsTraces.put("serialNumber", new TableInfo.Column("serialNumber", "TEXT", false, 0, null, 1));
                _columnsTraces.put("tags", new TableInfo.Column("tags", "TEXT", false, 0, null, 1));
                _columnsTraces.put("uid", new TableInfo.Column("uid", "INTEGER", true, 1, null, 1));
                HashSet _foreignKeysTraces = new HashSet(0);
                HashSet _indicesTraces = new HashSet(0);
                TableInfo _infoTraces = new TableInfo("traces", _columnsTraces, _foreignKeysTraces, _indicesTraces);
                TableInfo _existingTraces = TableInfo.read((SupportSQLiteDatabase)_db, (String)"traces");
                if (!_infoTraces.equals((Object)_existingTraces)) {
                    return new RoomOpenHelper.ValidationResult(false, "traces(com.stripe.core.stripeterminal.storage.TraceEntity).\n Expected:\n" + _infoTraces + "\n Found:\n" + _existingTraces);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "9bf83398a5dde48d79a5c4f594b4bf80", "f37b1ae7a9517128cb8956719a3d7429");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"events", "logpoints", "traces"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `events`");
            _db.execSQL("DELETE FROM `logpoints`");
            _db.execSQL("DELETE FROM `traces`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(EventDao.class, EventDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(LogPointDao.class, LogPointDao_Impl.getRequiredConverters());
        _typeConvertersMap.put(TraceDao.class, TraceDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecsMap) {
        return Arrays.asList(new Migration[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventDao eventDao() {
        if (this._eventDao != null) {
            return this._eventDao;
        }
        StripeTerminalDatabase_Impl stripeTerminalDatabase_Impl = this;
        synchronized (stripeTerminalDatabase_Impl) {
            if (this._eventDao == null) {
                this._eventDao = new EventDao_Impl(this);
            }
            return this._eventDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LogPointDao logPointDao() {
        if (this._logPointDao != null) {
            return this._logPointDao;
        }
        StripeTerminalDatabase_Impl stripeTerminalDatabase_Impl = this;
        synchronized (stripeTerminalDatabase_Impl) {
            if (this._logPointDao == null) {
                this._logPointDao = new LogPointDao_Impl(this);
            }
            return this._logPointDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TraceDao traceDao() {
        if (this._traceDao != null) {
            return this._traceDao;
        }
        StripeTerminalDatabase_Impl stripeTerminalDatabase_Impl = this;
        synchronized (stripeTerminalDatabase_Impl) {
            if (this._traceDao == null) {
                this._traceDao = new TraceDao_Impl(this);
            }
            return this._traceDao;
        }
    }
}

