/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.stripeterminal.storage;

import android.database.Cursor;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.stripe.core.stripeterminal.storage.MapConverters;
import com.stripe.core.stripeterminal.storage.TraceDao;
import com.stripe.core.stripeterminal.storage.TraceEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class TraceDao_Impl
implements TraceDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<TraceEntity> __insertionAdapterOfTraceEntity;
    private final MapConverters __mapConverters = new MapConverters();
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;

    public TraceDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfTraceEntity = new EntityInsertionAdapter<TraceEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `traces` (`startTimeMs`,`id`,`request`,`response`,`service`,`method`,`exception`,`totalTimeMs`,`sessionId`,`serialNumber`,`tags`,`uid`) VALUES (?,?,?,?,?,?,?,?,?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, TraceEntity value) {
                stmt.bindLong(1, value.getStartTimeMs());
                if (value.getId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getId());
                }
                if (value.getRequest() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getRequest());
                }
                if (value.getResponse() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getResponse());
                }
                if (value.getService() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getService());
                }
                if (value.getMethod() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getMethod());
                }
                if (value.getException() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getException());
                }
                if (value.getTotalTimeMs() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, value.getTotalTimeMs().longValue());
                }
                if (value.getSessionId() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getSessionId());
                }
                if (value.getSerialNumber() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getSerialNumber());
                }
                String _tmp = TraceDao_Impl.this.__mapConverters.fromStringStringMap(value.getTags());
                if (_tmp == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp);
                }
                stmt.bindLong(12, value.getUid());
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM traces";
                return "DELETE FROM traces";
            }
        };
    }

    @Override
    public void insert(TraceEntity traceEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfTraceEntity.insert((Object)traceEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertAll(List<TraceEntity> traceEntityList) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfTraceEntity.insert(traceEntityList);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TraceEntity> getAll() {
        String _sql = "SELECT * FROM traces";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM traces", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfStartTimeMs = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"startTimeMs");
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfRequest = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"request");
            int _cursorIndexOfResponse = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"response");
            int _cursorIndexOfService = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"service");
            int _cursorIndexOfMethod = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"method");
            int _cursorIndexOfException = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"exception");
            int _cursorIndexOfTotalTimeMs = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"totalTimeMs");
            int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
            int _cursorIndexOfSerialNumber = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"serialNumber");
            int _cursorIndexOfTags = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"tags");
            int _cursorIndexOfUid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"uid");
            ArrayList<TraceEntity> _result = new ArrayList<TraceEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                long _tmpStartTimeMs = _cursor.getLong(_cursorIndexOfStartTimeMs);
                String _tmpId = _cursor.isNull(_cursorIndexOfId) ? null : _cursor.getString(_cursorIndexOfId);
                String _tmpRequest = _cursor.isNull(_cursorIndexOfRequest) ? null : _cursor.getString(_cursorIndexOfRequest);
                String _tmpResponse = _cursor.isNull(_cursorIndexOfResponse) ? null : _cursor.getString(_cursorIndexOfResponse);
                String _tmpService = _cursor.isNull(_cursorIndexOfService) ? null : _cursor.getString(_cursorIndexOfService);
                String _tmpMethod = _cursor.isNull(_cursorIndexOfMethod) ? null : _cursor.getString(_cursorIndexOfMethod);
                String _tmpException = _cursor.isNull(_cursorIndexOfException) ? null : _cursor.getString(_cursorIndexOfException);
                Long _tmpTotalTimeMs = _cursor.isNull(_cursorIndexOfTotalTimeMs) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfTotalTimeMs));
                String _tmpSessionId = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                String _tmpSerialNumber = _cursor.isNull(_cursorIndexOfSerialNumber) ? null : _cursor.getString(_cursorIndexOfSerialNumber);
                String _tmp = _cursor.isNull(_cursorIndexOfTags) ? null : _cursor.getString(_cursorIndexOfTags);
                Map<String, String> _tmpTags = this.__mapConverters.toStringStringMap(_tmp);
                long _tmpUid = _cursor.getLong(_cursorIndexOfUid);
                TraceEntity _item = new TraceEntity(_tmpStartTimeMs, _tmpId, _tmpRequest, _tmpResponse, _tmpService, _tmpMethod, _tmpException, _tmpTotalTimeMs, _tmpSessionId, _tmpSerialNumber, _tmpTags, _tmpUid);
                _result.add(_item);
            }
            ArrayList<TraceEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

