/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.time;

import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0002\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"withBeginningOfDay", "Ljava/time/ZonedDateTime;", "withEndOf", "unit", "Ljava/time/temporal/ChronoUnit;", "withEndOfDay", "withStartOf", "time"})
public final class TimeExtensionsKt {
    @NotNull
    public static final ZonedDateTime withBeginningOfDay(@NotNull ZonedDateTime $this$withBeginningOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$withBeginningOfDay, (String)"<this>");
        ZonedDateTime zonedDateTime = $this$withBeginningOfDay.truncatedTo(ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"truncatedTo(ChronoUnit.DAYS)");
        return zonedDateTime;
    }

    @NotNull
    public static final ZonedDateTime withEndOfDay(@NotNull ZonedDateTime $this$withEndOfDay) {
        Intrinsics.checkNotNullParameter((Object)$this$withEndOfDay, (String)"<this>");
        ZonedDateTime zonedDateTime = ZonedDateTime.of($this$withEndOfDay.toLocalDate(), LocalTime.MAX, $this$withEndOfDay.getZone());
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"of(toLocalDate(), LocalTime.MAX, zone)");
        return zonedDateTime;
    }

    @NotNull
    public static final ZonedDateTime withStartOf(@NotNull ZonedDateTime $this$withStartOf, @NotNull ChronoUnit unit) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkNotNullParameter((Object)$this$withStartOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        switch (WhenMappings.$EnumSwitchMapping$0[unit.ordinal()]) {
            case 1: {
                zonedDateTime = $this$withStartOf;
                break;
            }
            case 2: {
                zonedDateTime = $this$withStartOf.minusDays((long)$this$withStartOf.getDayOfWeek().getValue() % 7L);
                break;
            }
            case 3: {
                zonedDateTime = $this$withStartOf.withDayOfMonth(1);
                break;
            }
            case 4: {
                zonedDateTime = $this$withStartOf.withDayOfYear(1);
                break;
            }
            default: {
                throw new UnsupportedOperationException(unit + " is not supported");
            }
        }
        ZonedDateTime day = zonedDateTime;
        Intrinsics.checkNotNullExpressionValue((Object)day, (String)"day");
        return TimeExtensionsKt.withBeginningOfDay(day);
    }

    @NotNull
    public static final ZonedDateTime withEndOf(@NotNull ZonedDateTime $this$withEndOf, @NotNull ChronoUnit unit) {
        ZonedDateTime zonedDateTime;
        Intrinsics.checkNotNullParameter((Object)$this$withEndOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        switch (WhenMappings.$EnumSwitchMapping$0[unit.ordinal()]) {
            case 1: {
                zonedDateTime = $this$withEndOf;
                break;
            }
            case 2: {
                zonedDateTime = $this$withEndOf.plusDays(6L - (long)($this$withEndOf.getDayOfWeek().getValue() % 7));
                break;
            }
            case 3: {
                zonedDateTime = $this$withEndOf.plusMonths(1L).minusDays($this$withEndOf.getDayOfMonth());
                break;
            }
            case 4: {
                zonedDateTime = $this$withEndOf.plusYears(1L).minusDays($this$withEndOf.getDayOfYear());
                break;
            }
            default: {
                throw new UnsupportedOperationException(unit + " is not supported");
            }
        }
        ZonedDateTime day = zonedDateTime;
        Intrinsics.checkNotNullExpressionValue((Object)day, (String)"day");
        return TimeExtensionsKt.withEndOfDay(day);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ChronoUnit.values().length];
            try {
                nArray[ChronoUnit.DAYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChronoUnit.WEEKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChronoUnit.MONTHS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ChronoUnit.YEARS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

