/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.transaction;

import com.neovisionaries.i18n.CurrencyCode;
import com.stripe.core.hardware.tipping.LegacyTipSelectionResult;
import com.stripe.core.transaction.Settings;
import com.stripe.core.transaction.Transaction;
import com.stripe.jvmcore.cart.Cart;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.currency.AmountKt;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.Confirmation;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.restclient.IntegrationType;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.jvmcore.transaction.payment.Payment;
import com.stripe.stripeterminal.external.models.DeviceType;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 C2\u00020\u0001:\u0001CB\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0019\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010+\u001a\u0004\u0018\u00010,\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0012\u0010/\u001a\u0004\u0018\u00010(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00100R\u0012\u00101\u001a\u0004\u0018\u00010(X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00100R\u0016\u00102\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00103\u001a\u0004\u0018\u0001048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0013\u00107\u001a\u0004\u0018\u000108\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0013\u0010;\u001a\u0004\u0018\u00010<\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0013\u0010?\u001a\u0004\u0018\u00010@\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010B\u00a8\u0006D"}, d2={"Lcom/stripe/core/transaction/Summary;", "", "state", "Lcom/stripe/core/transaction/Transaction;", "payment", "Lcom/stripe/jvmcore/transaction/payment/Payment;", "(Lcom/stripe/core/transaction/Transaction;Lcom/stripe/jvmcore/transaction/payment/Payment;)V", "activeReadersEnabled", "Ljava/util/EnumSet;", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$ReaderType;", "getActiveReadersEnabled", "()Ljava/util/EnumSet;", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "getAmount", "()Lcom/stripe/jvmcore/currency/Amount;", "cart", "Lcom/stripe/jvmcore/cart/Cart;", "getCart", "()Lcom/stripe/jvmcore/cart/Cart;", "chargeAttempt", "Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "getChargeAttempt", "()Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "confirmation", "Lcom/stripe/jvmcore/hardware/emv/Confirmation;", "getConfirmation", "()Lcom/stripe/jvmcore/hardware/emv/Confirmation;", "deviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "domesticDebitAids", "", "", "domesticDebitPriority", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$DomesticDebitPriority;", "error", "Lcom/stripe/core/transaction/Transaction$Error;", "getError", "()Lcom/stripe/core/transaction/Transaction$Error;", "hasPayment", "", "getHasPayment", "()Z", "integrationType", "Lcom/stripe/jvmcore/restclient/IntegrationType;", "getIntegrationType", "()Lcom/stripe/jvmcore/restclient/IntegrationType;", "isDeferredAuthorizationCountry", "Ljava/lang/Boolean;", "isOffline", "platformReaderConfiguration", "readerConfiguration", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration;", "getReaderConfiguration", "()Lcom/stripe/jvmcore/hardware/ReaderConfiguration;", "settings", "Lcom/stripe/core/transaction/Settings;", "getSettings", "()Lcom/stripe/core/transaction/Settings;", "tipSelectionResult", "Lcom/stripe/core/hardware/tipping/LegacyTipSelectionResult;", "getTipSelectionResult", "()Lcom/stripe/core/hardware/tipping/LegacyTipSelectionResult;", "type", "Lcom/stripe/core/transaction/Transaction$Type;", "getType", "()Lcom/stripe/core/transaction/Transaction$Type;", "Companion", "transaction_release"})
@SourceDebugExtension(value={"SMAP\nSummary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Summary.kt\ncom/stripe/core/transaction/Summary\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
public final class Summary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Transaction.Type type;
    @Nullable
    private final Settings settings;
    @Nullable
    private final Amount amount;
    @Nullable
    private final Transaction.Error error;
    @Nullable
    private final ChargeAttempt chargeAttempt;
    @Nullable
    private final IntegrationType integrationType;
    @Nullable
    private final LegacyTipSelectionResult tipSelectionResult;
    @Nullable
    private final Boolean isOffline;
    @Nullable
    private final Boolean isDeferredAuthorizationCountry;
    @Nullable
    private final DeviceType deviceType;
    @Nullable
    private final ReaderConfiguration.DomesticDebitPriority domesticDebitPriority;
    @NotNull
    private final List<String> domesticDebitAids;
    @Nullable
    private final Cart cart;
    private final boolean hasPayment;
    @Nullable
    private final Confirmation confirmation;
    @Nullable
    private final EnumSet<ReaderConfiguration.ReaderType> platformReaderConfiguration;
    @NotNull
    private static final Amount SETUP_INTENT_AMOUNT = new Amount(0L, CurrencyCode.USD);

    public Summary(@Nullable Transaction state, @Nullable Payment payment) {
        Transaction transaction = state;
        this.type = transaction != null ? transaction.getType() : null;
        Transaction transaction2 = state;
        this.settings = transaction2 != null ? transaction2.getSettings() : null;
        Transaction transaction3 = state;
        this.amount = transaction3 != null ? transaction3.getAmount() : null;
        Transaction transaction4 = state;
        this.error = transaction4 != null ? transaction4.getError() : null;
        Transaction transaction5 = state;
        this.chargeAttempt = transaction5 != null ? transaction5.getChargeAttempt() : null;
        Transaction transaction6 = state;
        this.integrationType = transaction6 != null ? transaction6.getIntegrationType() : null;
        Transaction transaction7 = state;
        this.tipSelectionResult = transaction7 != null ? transaction7.getTipSelectionResult() : null;
        Transaction transaction8 = state;
        this.isOffline = transaction8 != null ? Boolean.valueOf(transaction8.isOffline()) : null;
        Transaction transaction9 = state;
        this.isDeferredAuthorizationCountry = transaction9 != null ? Boolean.valueOf(transaction9.isDeferredAuthorizationCountry()) : null;
        Transaction transaction10 = state;
        this.deviceType = transaction10 != null ? transaction10.getDeviceType() : null;
        Transaction transaction11 = state;
        this.domesticDebitPriority = transaction11 != null ? transaction11.getDomesticDebitPriority() : null;
        Object object = state;
        if (object == null || (object = ((Transaction)object).getDomesticDebitAids()) == null) {
            object = CollectionsKt.emptyList();
        }
        this.domesticDebitAids = object;
        Transaction transaction12 = state;
        this.cart = transaction12 != null ? transaction12.getCart() : null;
        this.hasPayment = payment != null;
        Object object2 = payment;
        if (object2 == null || (object2 = ((Payment)object2).getConfirmation()) == null) {
            Transaction transaction13 = state;
            object2 = transaction13 != null ? transaction13.getConfirmation() : null;
        }
        this.confirmation = object2;
        Transaction transaction14 = state;
        this.platformReaderConfiguration = transaction14 != null ? transaction14.getActiveReaderConfiguration() : null;
    }

    @Nullable
    public final Transaction.Type getType() {
        return this.type;
    }

    @Nullable
    public final Settings getSettings() {
        return this.settings;
    }

    @Nullable
    public final Amount getAmount() {
        return this.amount;
    }

    @Nullable
    public final Transaction.Error getError() {
        return this.error;
    }

    @Nullable
    public final ChargeAttempt getChargeAttempt() {
        return this.chargeAttempt;
    }

    @Nullable
    public final IntegrationType getIntegrationType() {
        return this.integrationType;
    }

    @Nullable
    public final LegacyTipSelectionResult getTipSelectionResult() {
        return this.tipSelectionResult;
    }

    @Nullable
    public final Cart getCart() {
        return this.cart;
    }

    public final boolean getHasPayment() {
        return this.hasPayment;
    }

    @Nullable
    public final Confirmation getConfirmation() {
        return this.confirmation;
    }

    @Nullable
    public final EnumSet<ReaderConfiguration.ReaderType> getActiveReadersEnabled() {
        EnumSet<ReaderConfiguration.ReaderType> enumSet = this.platformReaderConfiguration;
        if (enumSet == null) {
            ReaderConfiguration readerConfiguration = this.getReaderConfiguration();
            enumSet = readerConfiguration != null ? readerConfiguration.getReadersEnabled() : null;
        }
        return enumSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final ReaderConfiguration getReaderConfiguration() {
        ReaderConfiguration.QuickChipOption quickChipOption;
        Amount amount;
        if (this.type == null) return null;
        if (this.confirmation != null) return null;
        if (this.hasPayment) return null;
        if (this.type == Transaction.Type.DISPLAY_CART) {
            Settings settings = this.settings;
            if ((settings != null ? settings.getEmvTransactionType() : null) == TransactionType.TRADITIONAL) return null;
        }
        EnumSet<Enum> interfaces = this.chargeAttempt instanceof ChargeAttempt.ExtendedAttempt && SetsKt.setOf((Object)((Object)ChargeAttempt.ExtendedAttempt.Requirement.OFFLINE_PIN_REQUIRED)).contains((Object)((ChargeAttempt.ExtendedAttempt)this.chargeAttempt).getRequirement()) ? EnumSet.of((Enum)ReaderConfiguration.ReaderType.ICC, (Enum)ReaderConfiguration.ReaderType.MAGSTRIPE) : (this.type == Transaction.Type.REUSABLE_CARD ? EnumSet.of((Enum)ReaderConfiguration.ReaderType.MAGSTRIPE, (Enum)ReaderConfiguration.ReaderType.ICC) : (this.type == Transaction.Type.INTERAC_REFUND ? EnumSet.of((Enum)ReaderConfiguration.ReaderType.ICC, (Enum)ReaderConfiguration.ReaderType.NFC) : EnumSet.of((Enum)ReaderConfiguration.ReaderType.MAGSTRIPE, (Enum)ReaderConfiguration.ReaderType.ICC, (Enum)ReaderConfiguration.ReaderType.NFC)));
        boolean bl = false;
        EnumSet<Enum> it = interfaces;
        boolean bl2 = false;
        EnumSet<Enum> trimmedInterfaces = EnumSet.copyOf(it);
        if (Intrinsics.areEqual((Object)this.isOffline, (Object)true)) {
            trimmedInterfaces.remove((Object)ReaderConfiguration.ReaderType.MAGSTRIPE);
        }
        EnumSet<Enum> readersEnabled = trimmedInterfaces;
        Settings settings = this.settings;
        if ((settings != null ? settings.getEmvTransactionType() : null) == TransactionType.TRADITIONAL && this.amount != null) {
            amount = this.amount;
        } else {
            Settings settings2 = this.settings;
            amount = (settings2 != null ? settings2.getEmvTransactionType() : null) == TransactionType.QUICK && this.amount != null && this.amount.getValue() != 0L ? this.amount : (this.type == Transaction.Type.SETUP_INTENT ? SETUP_INTENT_AMOUNT : AmountKt.getQUICK_EMV_AMOUNT());
        }
        Amount amount2 = amount;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: {
                quickChipOption = ReaderConfiguration.QuickChipOption.USE_QUICKCHIP;
                break;
            }
            case 2: 
            case 3: {
                if (Intrinsics.areEqual((Object)this.isDeferredAuthorizationCountry, (Object)true) && Intrinsics.areEqual((Object)this.isOffline, (Object)true)) {
                    quickChipOption = ReaderConfiguration.QuickChipOption.USE_QUICKCHIP;
                    break;
                }
                quickChipOption = ReaderConfiguration.QuickChipOption.USE_CONFIG;
                break;
            }
            default: {
                quickChipOption = ReaderConfiguration.QuickChipOption.USE_CONFIG;
            }
        }
        ReaderConfiguration.QuickChipOption quickChipMode = quickChipOption;
        ReaderConfiguration.TransactionType transactionType = this.type == Transaction.Type.INTERAC_REFUND ? ReaderConfiguration.TransactionType.REFUND : ReaderConfiguration.TransactionType.GOODS;
        Object terminalCapabilitiesOverride = null;
        Object contactlessOnlinePinOption = null;
        if (Intrinsics.areEqual((Object)this.isOffline, (Object)true)) {
            Pair<String, ReaderConfiguration.ContactlessOnlinePinOption> pair = this.deviceType;
            if (pair != null && (pair = Companion.disableOnlinePinSettings((DeviceType)pair)) != null) {
                Pair<String, ReaderConfiguration.ContactlessOnlinePinOption> it2 = pair;
                boolean bl3 = false;
                terminalCapabilitiesOverride = it2.getFirst();
                contactlessOnlinePinOption = it2.getSecond();
            }
        }
        Intrinsics.checkNotNullExpressionValue(readersEnabled, (String)"readersEnabled");
        Settings settings3 = this.settings;
        Intrinsics.checkNotNull((Object)settings3);
        ReaderConfiguration readerConfiguration = new ReaderConfiguration(readersEnabled, amount2, transactionType, settings3.getEmvTransactionType(), quickChipMode, (String)terminalCapabilitiesOverride, Companion.domesticDebitPriorityOverride(this.domesticDebitPriority, this.domesticDebitAids, this.isOffline), (ReaderConfiguration.ContactlessOnlinePinOption)((Object)contactlessOnlinePinOption));
        return readerConfiguration;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0006\u0012\u0004\u0018\u00010\n0\b*\u00020\u000bJ+\u0010\f\u001a\u0004\u0018\u00010\r*\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0002\u0010\u0012R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/stripe/core/transaction/Summary$Companion;", "", "()V", "SETUP_INTENT_AMOUNT", "Lcom/stripe/jvmcore/currency/Amount;", "getSETUP_INTENT_AMOUNT", "()Lcom/stripe/jvmcore/currency/Amount;", "disableOnlinePinSettings", "Lkotlin/Pair;", "", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$ContactlessOnlinePinOption;", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "domesticDebitPriorityOverride", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$DomesticDebitPriority;", "domesticDebitAids", "", "isOffline", "", "(Lcom/stripe/jvmcore/hardware/ReaderConfiguration$DomesticDebitPriority;Ljava/util/List;Ljava/lang/Boolean;)Lcom/stripe/jvmcore/hardware/ReaderConfiguration$DomesticDebitPriority;", "transaction_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Amount getSETUP_INTENT_AMOUNT() {
            return SETUP_INTENT_AMOUNT;
        }

        @Nullable
        public final ReaderConfiguration.DomesticDebitPriority domesticDebitPriorityOverride(@Nullable ReaderConfiguration.DomesticDebitPriority $this$domesticDebitPriorityOverride, @NotNull List<String> domesticDebitAids, @Nullable Boolean isOffline) {
            Intrinsics.checkNotNullParameter(domesticDebitAids, (String)"domesticDebitAids");
            return domesticDebitAids.isEmpty() ? null : (Intrinsics.areEqual((Object)isOffline, (Object)true) ? ReaderConfiguration.DomesticDebitPriority.OFF : $this$domesticDebitPriorityOverride);
        }

        @NotNull
        public final Pair<String, ReaderConfiguration.ContactlessOnlinePinOption> disableOnlinePinSettings(@NotNull DeviceType $this$disableOnlinePinSettings) {
            Pair pair;
            Intrinsics.checkNotNullParameter((Object)$this$disableOnlinePinSettings, (String)"<this>");
            switch (WhenMappings.$EnumSwitchMapping$0[$this$disableOnlinePinSettings.ordinal()]) {
                case 1: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                case 2: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                case 3: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                case 4: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                case 5: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                case 6: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                case 7: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                case 8: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                case 9: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                case 10: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                case 11: {
                    pair = TuplesKt.to((Object)"20B8C8", (Object)((Object)ReaderConfiguration.ContactlessOnlinePinOption.DISABLED));
                    break;
                }
                case 12: {
                    pair = TuplesKt.to((Object)"60B8C8", (Object)((Object)ReaderConfiguration.ContactlessOnlinePinOption.DISABLED));
                    break;
                }
                case 13: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                case 14: {
                    pair = TuplesKt.to(null, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return pair;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[DeviceType.values().length];
                try {
                    nArray[DeviceType.CHIPPER_1X.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.CHIPPER_2X.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.COTS_DEVICE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.ETNA.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.STRIPE_M2.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.STRIPE_S700.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.STRIPE_S700_DEVKIT.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.UNKNOWN.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.VERIFONE_P400.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.WISECUBE.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.WISEPAD_3.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.WISEPAD_3S.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.WISEPOS_E.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[DeviceType.WISEPOS_E_DEVKIT.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Transaction.Type.values().length];
            try {
                nArray[Transaction.Type.SETUP_INTENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Transaction.Type.PAYMENT_METHOD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Transaction.Type.TIPPING_SELECTION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

