/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.transaction;

import com.stripe.core.hardware.emv.AuthRequest;
import com.stripe.core.hardware.tipping.LegacyTipSelected;
import com.stripe.core.hardware.tipping.LegacyTipSelectionFailure;
import com.stripe.core.hardware.tipping.LegacyTipSelectionResult;
import com.stripe.core.hardware.tipping.TippingSelectionFailureReason;
import com.stripe.core.transaction.ReaderTrace;
import com.stripe.core.transaction.Settings;
import com.stripe.core.transaction.Summary;
import com.stripe.core.transaction.Transaction;
import com.stripe.core.transaction.TransactionRepository;
import com.stripe.core.transaction.payment.MagstripeManager;
import com.stripe.core.transaction.payment.PaymentManager;
import com.stripe.core.transaction.payment.QuickEmvManager;
import com.stripe.core.transaction.payment.TraditionalEmvManager;
import com.stripe.jvmcore.cart.Cart;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.device.MainlandDeviceType;
import com.stripe.jvmcore.device.PlatformDeviceInfo;
import com.stripe.jvmcore.hardware.ReaderConfiguration;
import com.stripe.jvmcore.hardware.emv.CardStatus;
import com.stripe.jvmcore.hardware.emv.Confirmation;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.hardware.emv.TransactionType;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadFailure;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadResult;
import com.stripe.jvmcore.hardware.magstripe.MagStripeReadSuccess;
import com.stripe.jvmcore.logging.terminal.log.Log;
import com.stripe.jvmcore.loggingmodels.ApplicationTraceResult;
import com.stripe.jvmcore.restclient.AuthenticatedRestClient;
import com.stripe.jvmcore.restclient.IntegrationType;
import com.stripe.jvmcore.transaction.ChargeAttempt;
import com.stripe.jvmcore.transaction.CollectiblePayment;
import com.stripe.jvmcore.transaction.payment.MagstripePayment;
import com.stripe.jvmcore.transaction.payment.Payment;
import com.stripe.stripeterminal.external.models.DeviceType;
import java.util.EnumSet;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 R2\u00020\u0001:\u0001RB\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\u0018\u001a\u00020\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020+J\u0014\u0010,\u001a\u00020\u00142\f\u0010-\u001a\b\u0012\u0004\u0012\u00020/0.J\u000e\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020 J\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020\u0014J\u000e\u00105\u001a\u00020\u00142\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020\u00142\u0006\u00106\u001a\u000207J\u000e\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020;J\u0016\u0010<\u001a\u00020\u00142\u0006\u0010=\u001a\u00020>2\u0006\u00106\u001a\u000207J\u0016\u0010?\u001a\u00020\u00142\u0006\u0010@\u001a\u00020A2\u0006\u00106\u001a\u000207J6\u0010B\u001a\u00020\u00142\u0006\u0010@\u001a\u00020A2\u0006\u00106\u001a\u0002072\b\b\u0002\u0010C\u001a\u0002032\b\b\u0002\u0010D\u001a\u0002032\n\b\u0002\u0010E\u001a\u0004\u0018\u00010FJ\u000e\u0010G\u001a\u00020\u00142\u0006\u00106\u001a\u000207J\u000e\u0010H\u001a\u00020\u00142\u0006\u00106\u001a\u000207J4\u0010I\u001a\u00020\u00142\u0006\u0010@\u001a\u00020A2\u0006\u00106\u001a\u0002072\u0006\u0010C\u001a\u0002032\b\b\u0002\u0010D\u001a\u0002032\n\b\u0002\u0010E\u001a\u0004\u0018\u00010FJ\u0006\u0010J\u001a\u00020KJ\u000e\u0010L\u001a\u00020\u00142\u0006\u0010M\u001a\u00020NJ\u000e\u0010O\u001a\u00020\u00142\u0006\u0010P\u001a\u00020QR\u0018\u0010\t\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006S"}, d2={"Lcom/stripe/core/transaction/TransactionManager;", "", "restClient", "Lcom/stripe/jvmcore/restclient/AuthenticatedRestClient;", "platformDeviceInfo", "Lcom/stripe/jvmcore/device/PlatformDeviceInfo;", "transactionRepository", "Lcom/stripe/core/transaction/TransactionRepository;", "(Lcom/stripe/jvmcore/restclient/AuthenticatedRestClient;Lcom/stripe/jvmcore/device/PlatformDeviceInfo;Lcom/stripe/core/transaction/TransactionRepository;)V", "paymentManager", "Lcom/stripe/core/transaction/payment/PaymentManager;", "Lcom/stripe/jvmcore/transaction/payment/Payment;", "<set-?>", "Lcom/stripe/core/transaction/Transaction;", "state", "getState", "()Lcom/stripe/core/transaction/Transaction;", "getTransactionRepository", "()Lcom/stripe/core/transaction/TransactionRepository;", "cancelPayment", "", "clearConfirmationRequest", "collectiblePayment", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "endTransaction", "getDeviceType", "Lcom/stripe/stripeterminal/external/models/DeviceType;", "handleAuthRequest", "authRequest", "Lcom/stripe/core/hardware/emv/AuthRequest;", "handleAuthResponse", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "tlvBlob", "", "handleCardStatus", "cardStatus", "Lcom/stripe/jvmcore/hardware/emv/CardStatus;", "handleConfirmationRequest", "confirmation", "Lcom/stripe/jvmcore/hardware/emv/Confirmation;", "handleMagstripeRead", "readResult", "Lcom/stripe/jvmcore/hardware/magstripe/MagStripeReadResult;", "handleReaderConfigurationUpdate", "readerConfiguration", "Ljava/util/EnumSet;", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$ReaderType;", "handleTransactionResult", "transactionResult", "isPaymentCollectible", "", "reset", "resumePaymentMethod", "settings", "Lcom/stripe/core/transaction/Settings;", "resumeSetupIntent", "setIntegrationType", "integrationType", "Lcom/stripe/jvmcore/restclient/IntegrationType;", "startDisplayCart", "cart", "Lcom/stripe/jvmcore/cart/Cart;", "startInteracRefund", "amount", "Lcom/stripe/jvmcore/currency/Amount;", "startPaymentMethod", "isOffline", "isDeferredAuthorizationCountry", "domesticDebitPriority", "Lcom/stripe/jvmcore/hardware/ReaderConfiguration$DomesticDebitPriority;", "startReusableCard", "startSetupIntentPaymentMethod", "startTippingSelection", "summary", "Lcom/stripe/core/transaction/Summary;", "updateChargeAttempt", "chargeAttempt", "Lcom/stripe/jvmcore/transaction/ChargeAttempt;", "updateWithTipResult", "tipSelectionResult", "Lcom/stripe/core/hardware/tipping/LegacyTipSelectionResult;", "Companion", "transaction_release"})
@SourceDebugExtension(value={"SMAP\nTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionManager.kt\ncom/stripe/core/transaction/TransactionManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,510:1\n1282#2,2:511\n*S KotlinDebug\n*F\n+ 1 TransactionManager.kt\ncom/stripe/core/transaction/TransactionManager\n*L\n502#1:511,2\n*E\n"})
public final class TransactionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AuthenticatedRestClient restClient;
    @NotNull
    private final PlatformDeviceInfo platformDeviceInfo;
    @NotNull
    private final TransactionRepository transactionRepository;
    @Nullable
    private Transaction state;
    @Nullable
    private PaymentManager<? extends Payment> paymentManager;
    @NotNull
    private static final Log LOGGER = Log.Companion.getLogger(TransactionManager.class);
    @NotNull
    private static final String IDENTIFIER = "transaction_manager_operation";

    @Inject
    public TransactionManager(@NotNull AuthenticatedRestClient restClient, @NotNull PlatformDeviceInfo platformDeviceInfo, @NotNull TransactionRepository transactionRepository) {
        Intrinsics.checkNotNullParameter((Object)restClient, (String)"restClient");
        Intrinsics.checkNotNullParameter((Object)platformDeviceInfo, (String)"platformDeviceInfo");
        Intrinsics.checkNotNullParameter((Object)transactionRepository, (String)"transactionRepository");
        this.restClient = restClient;
        this.platformDeviceInfo = platformDeviceInfo;
        this.transactionRepository = transactionRepository;
    }

    @NotNull
    public final TransactionRepository getTransactionRepository() {
        return this.transactionRepository;
    }

    @Nullable
    public final Transaction getState() {
        return this.state;
    }

    /*
     * Unable to fully structure code
     */
    public final void updateWithTipResult(@NotNull LegacyTipSelectionResult tipSelectionResult) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)tipSelectionResult, (String)"tipSelectionResult");
                if (!(tipSelectionResult instanceof LegacyTipSelected)) break block4;
                v0 = this.state;
                v1 = v0 != null && (v0 = v0.getAmount()) != null ? Long.valueOf(v0.getValue()) : (preTipAmount = null);
                if (preTipAmount == null) {
                    var3_4 = this.state;
                    this.state = var3_4 != null && (var4_7 = var3_4.toBuilder()) != null && (var5_11 = var4_7.tipSelectionResult(new LegacyTipSelectionFailure(TippingSelectionFailureReason.TRANSACTION_STATE_MACHINE_NO_AMOUNT))) != null ? var5_11.build() : null;
                    return;
                }
                v2 = this.state;
                v3 = v2 != null && (v2 = v2.getAmount()) != null ? v2.getCurrency() : (currencyCode = null);
                if (currencyCode == null) {
                    var4_8 = this.state;
                    this.state = var4_8 != null && (var5_12 = var4_8.toBuilder()) != null && (var6_14 = var5_12.tipSelectionResult(new LegacyTipSelectionFailure(TippingSelectionFailureReason.TRANSACTION_STATE_MACHINE_NO_CURRENCY_CODE))) != null ? var6_14.build() : null;
                    return;
                }
                tipAmount = ((LegacyTipSelected)tipSelectionResult).getTipsAmount();
                postTipAmount = preTipAmount + tipAmount;
                totalAmount = new Amount(postTipAmount, currencyCode);
                var9_17 = this.state;
                this.state = var9_17 != null && (var10_18 = var9_17.toBuilder()) != null && (var11_19 = var10_18.amount(totalAmount)) != null && (var12_20 = var11_19.tipSelectionResult(tipSelectionResult)) != null ? var12_20.build() : null;
                break block5;
            }
            var2_3 = this.state;
            if (var2_3 == null || (var3_6 = var2_3.toBuilder()) == null) ** GOTO lbl-1000
            v4 = this.state;
            var4_10 = var3_6.amount(v4 != null ? v4.getAmount() : null);
            if (var4_10 != null && (var5_13 = var4_10.tipSelectionResult(tipSelectionResult)) != null) {
                v5 = var5_13.build();
            } else lbl-1000:
            // 2 sources

            {
                v5 = null;
            }
            this.state = v5;
        }
    }

    public final void reset() {
        this.state = null;
        this.paymentManager = null;
    }

    public final void startInteracRefund(@NotNull Amount amount, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        LOGGER.i("startInteracRefund", new Pair[0]);
        this.state = new Transaction.Builder(Transaction.Type.INTERAC_REFUND, settings, null, null, null, null, null, 0, null, null, null, null, false, false, null, null, null, 131068, null).setDeviceType(this.getDeviceType()).amount(amount).build();
        this.paymentManager = null;
        LOGGER.startOperation(ReaderTrace.Companion.startInteracRefund(), IDENTIFIER);
    }

    public final void startReusableCard(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        LOGGER.i("startReusableCard", new Pair[0]);
        this.state = new Transaction.Builder(Transaction.Type.REUSABLE_CARD, settings, null, null, null, null, null, 0, null, null, null, null, false, false, null, null, null, 131068, null).setDeviceType(this.getDeviceType()).build();
        this.paymentManager = null;
        LOGGER.startOperation(ReaderTrace.Companion.startReusableCard(), IDENTIFIER);
    }

    public final void startSetupIntentPaymentMethod(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        LOGGER.i("startSetupIntentPaymentMethod", new Pair[0]);
        this.state = new Transaction.Builder(Transaction.Type.SETUP_INTENT, settings, null, null, null, null, null, 0, null, null, null, null, false, false, null, null, null, 131068, null).setDeviceType(this.getDeviceType()).build();
        this.paymentManager = null;
        LOGGER.startOperation(ReaderTrace.Companion.startSetupIntentPaymentMethod(), IDENTIFIER);
    }

    public final void startPaymentMethod(@NotNull Amount amount, @NotNull Settings settings, boolean isOffline, boolean isDeferredAuthorizationCountry, @Nullable ReaderConfiguration.DomesticDebitPriority domesticDebitPriority) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        LOGGER.i("startPaymentMethod", new Pair[0]);
        Transaction transaction = this.state;
        if ((transaction != null ? transaction.getType() : null) == Transaction.Type.DISPLAY_CART) {
            Transaction.Builder builder;
            Transaction.Builder builder2;
            Transaction.Builder builder3;
            Transaction.Builder builder4;
            Transaction.Builder builder5;
            Transaction.Builder builder6;
            Transaction.Builder builder7;
            Transaction.Builder builder8;
            Transaction.Builder builder9;
            Transaction transaction2 = this.state;
            this.state = transaction2 != null && (builder9 = transaction2.toBuilder()) != null && (builder8 = builder9.cart(null)) != null && (builder7 = builder8.type(Transaction.Type.PAYMENT_METHOD)) != null && (builder6 = builder7.amount(amount)) != null && (builder5 = builder6.setOffline(isOffline)) != null && (builder4 = builder5.setIsDeferredAuthorizationCountry(isDeferredAuthorizationCountry)) != null && (builder3 = builder4.setDeviceType(this.getDeviceType())) != null && (builder2 = builder3.setDomesticDebitPriority(domesticDebitPriority)) != null && (builder = builder2.setDomesticDebitAids(this.transactionRepository.getDomesticDebitAids())) != null ? builder.build() : null;
        } else {
            this.state = new Transaction.Builder(Transaction.Type.PAYMENT_METHOD, settings, null, null, null, null, null, 0, null, null, null, null, false, false, null, null, null, 131068, null).amount(amount).setOffline(isOffline).setIsDeferredAuthorizationCountry(isDeferredAuthorizationCountry).setDeviceType(this.getDeviceType()).setDomesticDebitPriority(domesticDebitPriority).setDomesticDebitAids(this.transactionRepository.getDomesticDebitAids()).build();
            this.paymentManager = null;
            LOGGER.startOperation(ReaderTrace.Companion.startPaymentMethod(), IDENTIFIER);
        }
    }

    public static /* synthetic */ void startPaymentMethod$default(TransactionManager transactionManager, Amount amount, Settings settings, boolean bl, boolean bl2, ReaderConfiguration.DomesticDebitPriority domesticDebitPriority, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            domesticDebitPriority = null;
        }
        transactionManager.startPaymentMethod(amount, settings, bl, bl2, domesticDebitPriority);
    }

    public final void startTippingSelection(@NotNull Amount amount, @NotNull Settings settings, boolean isOffline, boolean isDeferredAuthorizationCountry, @Nullable ReaderConfiguration.DomesticDebitPriority domesticDebitPriority) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.state = new Transaction.Builder(Transaction.Type.TIPPING_SELECTION, settings, null, null, null, null, null, 0, null, null, null, null, false, false, null, null, null, 131068, null).amount(amount).setOffline(isOffline).setIsDeferredAuthorizationCountry(isDeferredAuthorizationCountry).setDeviceType(this.getDeviceType()).setDomesticDebitPriority(domesticDebitPriority).setDomesticDebitAids(this.transactionRepository.getDomesticDebitAids()).build();
        this.paymentManager = null;
        LOGGER.startOperation(ReaderTrace.Companion.startTipSelection(), IDENTIFIER);
    }

    public static /* synthetic */ void startTippingSelection$default(TransactionManager transactionManager, Amount amount, Settings settings, boolean bl, boolean bl2, ReaderConfiguration.DomesticDebitPriority domesticDebitPriority, int n2, Object object) {
        if ((n2 & 8) != 0) {
            bl2 = false;
        }
        if ((n2 & 0x10) != 0) {
            domesticDebitPriority = null;
        }
        transactionManager.startTippingSelection(amount, settings, bl, bl2, domesticDebitPriority);
    }

    public final void setIntegrationType(@NotNull IntegrationType integrationType) {
        Transaction.Builder builder;
        Transaction.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)((Object)integrationType), (String)"integrationType");
        LOGGER.i("setIntegrationType " + (Object)((Object)integrationType), new Pair[0]);
        Transaction transaction = this.state;
        this.state = transaction != null && (builder2 = transaction.toBuilder()) != null && (builder = builder2.integrationType(integrationType)) != null ? builder.build() : null;
    }

    public final void startDisplayCart(@NotNull Cart cart, @NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)cart, (String)"cart");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        LOGGER.i("startDisplayCart", new Pair[0]);
        Transaction transaction = this.state;
        if ((transaction != null ? transaction.getType() : null) == Transaction.Type.DISPLAY_CART) {
            Transaction.Builder builder;
            Transaction.Builder builder2;
            Transaction transaction2 = this.state;
            this.state = transaction2 != null && (builder2 = transaction2.toBuilder()) != null && (builder = builder2.cart(cart)) != null ? builder.build() : null;
        } else {
            this.state = new Transaction.Builder(Transaction.Type.DISPLAY_CART, settings, null, null, null, null, null, 0, null, null, null, null, false, false, null, null, null, 131068, null).cart(cart).build();
            this.paymentManager = null;
            LOGGER.startOperation(ReaderTrace.Companion.startDisplayCart(), IDENTIFIER);
        }
    }

    public final void resumePaymentMethod(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        LOGGER.i("resumePaymentMethod", new Pair[0]);
        Transaction transaction = this.state;
        Amount amount = transaction != null ? transaction.getAmount() : null;
        Transaction transaction2 = this.state;
        this.state = new Transaction.Builder(Transaction.Type.PAYMENT_METHOD, settings, null, null, null, null, null, 0, null, null, null, null, false, false, null, null, null, 131068, null).amount(amount).chargeAttempt(transaction2 != null ? transaction2.getChargeAttempt() : null).setDeviceType(this.getDeviceType()).build();
        this.paymentManager = null;
    }

    public final void resumeSetupIntent(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        LOGGER.i("resumeSetupIntent", new Pair[0]);
        this.state = new Transaction.Builder(Transaction.Type.SETUP_INTENT, settings, null, null, null, null, null, 0, null, null, null, null, false, false, null, null, null, 131068, null).build();
        this.paymentManager = null;
    }

    public final void endTransaction() {
        LOGGER.i("endTransaction", new Pair[0]);
        this.state = null;
        this.paymentManager = null;
        LOGGER.endOperation(ApplicationTraceResult.Companion.success(), IDENTIFIER);
    }

    @Nullable
    public final CollectiblePayment collectiblePayment() {
        PaymentManager<? extends Payment> paymentManager = this.paymentManager;
        return paymentManager != null ? paymentManager.collectiblePayment() : null;
    }

    @NotNull
    public final Deferred<TransactionResult> handleAuthResponse(@NotNull String tlvBlob) throws IllegalStateException, NotImplementedError {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        PaymentManager<? extends Payment> paymentManager = this.paymentManager;
        if (paymentManager == null || (paymentManager = paymentManager.handleAuthResponse(tlvBlob)) == null) {
            throw new IllegalStateException("No payment manager".toString());
        }
        return paymentManager;
    }

    public final void updateChargeAttempt(@NotNull ChargeAttempt chargeAttempt) {
        Intrinsics.checkNotNullParameter((Object)chargeAttempt, (String)"chargeAttempt");
        Object object = this.state;
        this.state = object != null && (object = ((Transaction)object).toBuilder()) != null && (object = ((Transaction.Builder)object).chargeAttempt(chargeAttempt)) != null ? ((Transaction.Builder)object).build() : null;
    }

    public final void cancelPayment() {
        Transaction.Builder builder;
        Transaction.Builder builder2;
        Transaction.Builder builder3;
        LOGGER.i("cancelPayment", new Pair[0]);
        this.paymentManager = null;
        Transaction transaction = this.state;
        this.state = transaction != null && (builder3 = transaction.toBuilder()) != null && (builder2 = builder3.incrementNumOfCanceledPayments()) != null && (builder = builder2.confirmation(null)) != null ? builder.build() : null;
    }

    @NotNull
    public final Summary summary() {
        PaymentManager<? extends Payment> paymentManager = this.paymentManager;
        return new Summary(this.state, paymentManager != null ? paymentManager.getPayment() : null);
    }

    public final void handleMagstripeRead(@NotNull MagStripeReadResult readResult) {
        Intrinsics.checkNotNullParameter((Object)readResult, (String)"readResult");
        LOGGER.i("handleMagstripeRead " + readResult, new Pair[0]);
        MagStripeReadResult magStripeReadResult = readResult;
        if (magStripeReadResult instanceof MagStripeReadSuccess) {
            Transaction transaction = this.state;
            if (transaction != null) {
                Transaction it = transaction;
                boolean bl = false;
                this.state = ((MagStripeReadSuccess)readResult).getIccCapable() && it.getFallbackReason() == MagstripePayment.FallbackReason.NONE ? it.toBuilder().error(Transaction.Error.CHIP_CARD_SWIPE).build() : it.toBuilder().error(null).build();
                this.paymentManager = new MagstripeManager((MagStripeReadSuccess)readResult, ((MagStripeReadSuccess)readResult).getIccCapable() ? it.getFallbackReason() : MagstripePayment.FallbackReason.NONE);
            }
        } else if (magStripeReadResult instanceof MagStripeReadFailure) {
            switch (WhenMappings.$EnumSwitchMapping$0[((MagStripeReadFailure)readResult).getFailureType().ordinal()]) {
                case 1: {
                    Transaction.Builder builder;
                    Transaction.Builder builder2;
                    Transaction transaction = this.state;
                    this.state = transaction != null && (builder2 = transaction.toBuilder()) != null && (builder = builder2.error(Transaction.Error.BAD_SWIPE)) != null ? builder.build() : null;
                    break;
                }
                case 2: {
                    Transaction.Builder builder;
                    Transaction.Builder builder3;
                    Transaction transaction = this.state;
                    this.state = transaction != null && (builder3 = transaction.toBuilder()) != null && (builder = builder3.error(Transaction.Error.HARDWARE_ERROR)) != null ? builder.build() : null;
                }
            }
        }
    }

    public final void handleConfirmationRequest(@NotNull Confirmation confirmation) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)confirmation, (String)"confirmation");
            LOGGER.i("handleConfirmationRequest", new Pair[0]);
            Transaction transaction = this.state;
            if (transaction == null) break block0;
            Transaction it = transaction;
            boolean bl = false;
            this.state = it.toBuilder().confirmation(confirmation).build();
        }
    }

    public final void clearConfirmationRequest() {
        Transaction.Builder builder;
        Transaction.Builder builder2;
        LOGGER.i("clearConfirmationRequest", new Pair[0]);
        Transaction transaction = this.state;
        this.state = transaction != null && (builder2 = transaction.toBuilder()) != null && (builder = builder2.confirmation(null)) != null ? builder.build() : null;
    }

    public final boolean isPaymentCollectible() {
        PaymentManager<? extends Payment> paymentManager = this.paymentManager;
        return paymentManager != null ? paymentManager.isPaymentCollectible() : false;
    }

    public final void handleReaderConfigurationUpdate(@NotNull EnumSet<ReaderConfiguration.ReaderType> readerConfiguration) {
        Intrinsics.checkNotNullParameter(readerConfiguration, (String)"readerConfiguration");
        Object object = this.state;
        this.state = object != null && (object = ((Transaction)object).toBuilder()) != null && (object = ((Transaction.Builder)object).activeReaderConfiguration(readerConfiguration)) != null ? ((Transaction.Builder)object).build() : null;
    }

    public final void handleAuthRequest(@NotNull AuthRequest authRequest) {
        block6: {
            PaymentManager paymentManager;
            Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
            LOGGER.i("handleAuthRequest", new Pair[0]);
            Transaction transaction = this.state;
            if (transaction == null) break block6;
            Transaction it = transaction;
            boolean bl = false;
            Transaction transaction2 = this.state;
            if ((transaction2 != null ? transaction2.getType() : null) == Transaction.Type.INTERAC_REFUND) {
                paymentManager = new TraditionalEmvManager(authRequest);
            } else {
                switch (WhenMappings.$EnumSwitchMapping$1[authRequest.getTransactionType().ordinal()]) {
                    case 1: {
                        paymentManager = new QuickEmvManager(authRequest);
                        break;
                    }
                    case 2: {
                        paymentManager = new TraditionalEmvManager(authRequest);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            this.paymentManager = paymentManager;
            this.state = it.toBuilder().error(null).build();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void handleCardStatus(@NotNull CardStatus cardStatus) {
        Transaction.Builder builder;
        Transaction.Builder builder2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)cardStatus), (String)"cardStatus");
        LOGGER.i("handleCardStatus " + (Object)((Object)cardStatus), new Pair[0]);
        PaymentManager<? extends Payment> paymentManager = this.paymentManager;
        if (paymentManager != null) {
            PaymentManager<? extends Payment> it = paymentManager;
            boolean bl = false;
            if (it instanceof QuickEmvManager) {
                Transaction.Builder builder3;
                Transaction.Builder builder4;
                object = this.state;
                this.state = object != null && (builder4 = ((Transaction)object).toBuilder()) != null && (builder3 = builder4.error(null)) != null ? builder3.build() : null;
            }
        }
        if (cardStatus == CardStatus.CARD_PROCESSING) {
            Transaction.Builder builder5;
            Transaction transaction = this.state;
            this.state = transaction != null && (builder5 = transaction.toBuilder()) != null && (builder2 = builder5.error(null)) != null ? builder2.build() : null;
            return;
        }
        if (cardStatus == CardStatus.NO_CARD) {
            Transaction transaction = this.state;
            if ((transaction != null ? transaction.getError() : null) != Transaction.Error.INSERT_OR_SWIPE_REQUIRED) {
                Transaction.Builder builder6;
                Transaction.Builder builder7;
                Transaction transaction2 = this.state;
                this.state = transaction2 != null && (builder7 = transaction2.toBuilder()) != null && (builder2 = builder7.chargeAttempt(null)) != null && (builder6 = builder2.confirmation(null)) != null && (object = builder6.error(null)) != null ? ((Transaction.Builder)object).build() : null;
                return;
            }
        }
        if (cardStatus == CardStatus.NO_CARD) {
            Transaction.Builder builder8;
            Transaction.Builder builder9;
            Transaction transaction = this.state;
            this.state = transaction != null && (builder9 = transaction.toBuilder()) != null && (builder2 = builder9.chargeAttempt(null)) != null && (builder8 = builder2.confirmation(null)) != null ? builder8.build() : null;
            return;
        }
        if (cardStatus != CardStatus.CARD_NOT_WORKING) {
            if (cardStatus != CardStatus.CARD_IDLE) return;
            return;
        }
        Transaction transaction = this.state;
        this.state = transaction != null && (builder = transaction.toBuilder()) != null && (builder2 = builder.fallbackReason(MagstripePayment.FallbackReason.CHIP_ERROR)) != null ? builder2.build() : null;
    }

    public final void handleTransactionResult(@NotNull TransactionResult transactionResult2) {
        Intrinsics.checkNotNullParameter((Object)transactionResult2, (String)"transactionResult");
        LOGGER.i("handleTransactionResult " + (Object)((Object)transactionResult2.getResult()), new Pair[0]);
        switch (WhenMappings.$EnumSwitchMapping$2[transactionResult2.getResult().ordinal()]) {
            case 1: {
                Transaction.Builder builder;
                Transaction.Builder builder2;
                Transaction transaction = this.state;
                this.state = transaction != null && (builder2 = transaction.toBuilder()) != null && (builder = builder2.error(Transaction.Error.HARDWARE_ERROR)) != null ? builder.build() : null;
                break;
            }
            case 2: {
                Transaction.Builder builder;
                Transaction.Builder builder3;
                Transaction transaction = this.state;
                this.state = transaction != null && (builder3 = transaction.toBuilder()) != null && (builder = builder3.error(Transaction.Error.DECLINED)) != null ? builder.build() : null;
                break;
            }
            case 3: {
                Transaction.Builder builder;
                Transaction.Builder builder4;
                Transaction transaction = this.state;
                this.state = transaction != null && (builder4 = transaction.toBuilder()) != null && (builder = builder4.error(Transaction.Error.TERMINATED)) != null ? builder.build() : null;
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                Transaction.Builder builder;
                Transaction.Builder builder5;
                Transaction transaction = this.state;
                this.state = transaction != null && (builder5 = transaction.toBuilder()) != null && (builder = builder5.error(Transaction.Error.CONTACTLESS_LIMIT_EXCEEDED)) != null ? builder.build() : null;
                break;
            }
            case 6: {
                Transaction.Builder builder;
                Transaction.Builder builder6;
                Transaction.Builder builder7;
                Transaction transaction = this.state;
                this.state = transaction != null && (builder7 = transaction.toBuilder()) != null && (builder6 = builder7.fallbackReason(MagstripePayment.FallbackReason.EMPTY_CANDIDATE_LIST)) != null && (builder = builder6.error(Transaction.Error.NO_MUTUALLY_SUPPORTED_APPS)) != null ? builder.build() : null;
                break;
            }
            case 7: {
                Transaction.Builder builder;
                Transaction.Builder builder8;
                Transaction transaction = this.state;
                this.state = transaction != null && (builder8 = transaction.toBuilder()) != null && (builder = builder8.error(Transaction.Error.CARD_BLOCKED)) != null ? builder.build() : null;
                break;
            }
            case 8: {
                Transaction.Builder builder;
                Transaction.Builder builder9;
                Transaction transaction = this.state;
                this.state = transaction != null && (builder9 = transaction.toBuilder()) != null && (builder = builder9.error(Transaction.Error.CHECK_MOBILE_DEVICE)) != null ? builder.build() : null;
                break;
            }
            case 9: {
                Transaction.Builder builder;
                Transaction.Builder builder10;
                Transaction transaction = this.state;
                this.state = transaction != null && (builder10 = transaction.toBuilder()) != null && (builder = builder10.error(Transaction.Error.HARDWARE_ERROR)) != null ? builder.build() : null;
                break;
            }
            case 10: {
                Transaction.Builder builder;
                Transaction.Builder builder11;
                Transaction transaction = this.state;
                this.state = transaction != null && (builder11 = transaction.toBuilder()) != null && (builder = builder11.error(Transaction.Error.INSERT_OR_SWIPE_REQUIRED)) != null ? builder.build() : null;
                break;
            }
            case 11: {
                Transaction.Builder builder;
                Transaction.Builder builder12;
                Transaction transaction = this.state;
                this.state = transaction != null && (builder12 = transaction.toBuilder()) != null && (builder = builder12.error(Transaction.Error.MULTIPLE_CARDS_DETECTED)) != null ? builder.build() : null;
            }
        }
    }

    private final DeviceType getDeviceType() {
        DeviceType deviceType;
        block2: {
            DeviceType[] $this$firstOrNull$iv = DeviceType.values();
            boolean $i$f$firstOrNull = false;
            int n2 = $this$firstOrNull$iv.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                DeviceType element$iv;
                DeviceType it = element$iv = $this$firstOrNull$iv[i2];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)new MainlandDeviceType(it.getDeviceName()), (Object)this.platformDeviceInfo.getMainlandDeviceType())) continue;
                deviceType = element$iv;
                break block2;
            }
            deviceType = null;
        }
        if (deviceType == null) {
            TransactionManager it = this;
            boolean bl = false;
            LOGGER.w("Failed to retrieve device type.", new Pair[0]);
            return DeviceType.UNKNOWN;
        }
        return deviceType;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/core/transaction/TransactionManager$Companion;", "", "()V", "IDENTIFIER", "", "LOGGER", "Lcom/stripe/jvmcore/logging/terminal/log/Log;", "transaction_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[MagStripeReadFailure.FailureType.values().length];
            try {
                nArray[MagStripeReadFailure.FailureType.BAD_SWIPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MagStripeReadFailure.FailureType.MSR_FAILURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TransactionType.values().length];
            try {
                nArray[TransactionType.QUICK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionType.TRADITIONAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[TransactionResult.Result.values().length];
            try {
                nArray[TransactionResult.Result.APPROVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.DECLINED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.TERMINATED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CANCELED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CONTACTLESS_LIMIT_EXCEEDED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.EMPTY_CANDIDATE_LIST.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CARD_BLOCKED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CHECK_MOBILE_DEVICE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.DEVICE_FAILURE.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.INSERT_OR_SWIPE_REQUIRED.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.MULTIPLE_CARDS_DETECTED.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.ICC_CARD_REMOVED.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.MOBILE_WALLET_TOO_MANY_TAPS.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TransactionResult.Result.CARD_STILL_INSERTED.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

