/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.transaction;

import com.stripe.core.hardware.paymentcollection.ContactCardSlotState;
import com.stripe.core.transaction.CancelableOperationContext;
import com.stripe.core.transaction.CancelableOperationType;
import com.stripe.core.transaction.ConfirmRefundParams;
import com.stripe.core.transaction.Settings;
import com.stripe.core.transaction.SettingsRepository;
import com.stripe.core.transaction.TransactionRepositoryKt;
import com.stripe.core.transaction.TransactionStateSummary;
import com.stripe.jvmcore.currency.Amount;
import com.stripe.jvmcore.restclient.CoreTransactionRepository;
import com.stripe.jvmcore.restclient.IntegrationType;
import com.stripe.jvmcore.restclient.TransactionOpType;
import com.stripe.jvmcore.transaction.CollectiblePayment;
import com.stripe.jvmcore.transaction.PaymentCollectionDeviceCapability;
import com.stripe.jvmcore.transaction.PaymentCollectionDeviceCapabilityKt;
import com.stripe.proto.model.common.DeviceInfo;
import com.stripe.proto.model.common.VersionInfoPb;
import com.stripe.stripeterminal.external.callable.Cancelable;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 |2\u00020\u0001:\u0002|}B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010h\u001a\u00020iJ\u0006\u0010j\u001a\u00020iJ\u0006\u0010k\u001a\u00020iJ\b\u0010l\u001a\u0004\u0018\u00010mJ\u000e\u0010n\u001a\u00020\t2\u0006\u0010o\u001a\u00020pJ\u0006\u0010q\u001a\u00020iJ\u0006\u0010r\u001a\u00020iJ\u0016\u0010s\u001a\u00020i2\u0006\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00020wJ\u0018\u0010x\u001a\u00020i2\u0006\u0010o\u001a\u00020p2\u0006\u0010y\u001a\u00020\tH\u0016J\u000e\u0010z\u001a\u00020i2\u0006\u0010{\u001a\u00020\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010*\u0004\b\u000b\u0010\fR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR(\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u0015\u001a\u0004\u0018\u00010 8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R(\u0010&\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u000e\"\u0004\b(\u0010\u0010R+\u0010*\u001a\u00020)2\u0006\u0010\b\u001a\u00020)8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/*\u0004\b+\u0010\fR7\u00101\u001a\b\u0012\u0004\u0012\u00020\t002\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t008F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b3\u00104\"\u0004\b5\u00106*\u0004\b2\u0010\fR(\u00108\u001a\u0004\u0018\u0001072\b\u0010\u0015\u001a\u0004\u0018\u0001078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b=\u0010\u0014R\u0011\u0010>\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u0014R/\u0010?\u001a\u0004\u0018\u00010\t2\b\u0010\b\u001a\u0004\u0018\u00010\t8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bA\u0010\u000e\"\u0004\bB\u0010\u0010*\u0004\b@\u0010\fR(\u0010C\u001a\u0004\u0018\u00010\t2\b\u0010\u0015\u001a\u0004\u0018\u00010\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bD\u0010\u000e\"\u0004\bE\u0010\u0010R(\u0010G\u001a\u0004\u0018\u00010F2\b\u0010\u0015\u001a\u0004\u0018\u00010F8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bH\u0010I\"\u0004\bJ\u0010KR/\u0010M\u001a\u0004\u0018\u00010L2\b\u0010\b\u001a\u0004\u0018\u00010L8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bO\u0010P\"\u0004\bQ\u0010R*\u0004\bN\u0010\fR/\u0010T\u001a\u0004\u0018\u00010S2\b\u0010\b\u001a\u0004\u0018\u00010S8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bV\u0010W\"\u0004\bX\u0010Y*\u0004\bU\u0010\fR/\u0010Z\u001a\u0004\u0018\u00010S2\b\u0010\b\u001a\u0004\u0018\u00010S8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\\\u0010W\"\u0004\b]\u0010Y*\u0004\b[\u0010\fR\u0014\u0010^\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b_\u0010\u0014R\u0011\u0010`\u001a\u00020a8F\u00a2\u0006\u0006\u001a\u0004\bb\u0010cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00070e\u00a2\u0006\b\n\u0000\u001a\u0004\bf\u0010g\u00a8\u0006~"}, d2={"Lcom/stripe/core/transaction/TransactionRepository;", "Lcom/stripe/jvmcore/restclient/CoreTransactionRepository;", "settingsRepository", "Lcom/stripe/core/transaction/SettingsRepository;", "(Lcom/stripe/core/transaction/SettingsRepository;)V", "_transactionStateSummaryFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/core/transaction/TransactionStateSummary;", "<set-?>", "", "accountId", "getAccountId$delegate", "(Lcom/stripe/core/transaction/TransactionRepository;)Ljava/lang/Object;", "getAccountId", "()Ljava/lang/String;", "setAccountId", "(Ljava/lang/String;)V", "allowExtendedTransactions", "", "getAllowExtendedTransactions", "()Z", "value", "Lcom/stripe/jvmcore/currency/Amount;", "amountTip", "getAmountTip", "()Lcom/stripe/jvmcore/currency/Amount;", "setAmountTip", "(Lcom/stripe/jvmcore/currency/Amount;)V", "cardStatusFlow", "Lcom/stripe/core/hardware/paymentcollection/ContactCardSlotState;", "getCardStatusFlow", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "collectiblePayment", "getCollectiblePayment", "()Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "setCollectiblePayment", "(Lcom/stripe/jvmcore/transaction/CollectiblePayment;)V", "connectionToken", "getConnectionToken", "setConnectionToken", "Lcom/stripe/jvmcore/transaction/PaymentCollectionDeviceCapability;", "devicePaymentCapability", "getDevicePaymentCapability$delegate", "getDevicePaymentCapability", "()Lcom/stripe/jvmcore/transaction/PaymentCollectionDeviceCapability;", "setDevicePaymentCapability", "(Lcom/stripe/jvmcore/transaction/PaymentCollectionDeviceCapability;)V", "", "domesticDebitAids", "getDomesticDebitAids$delegate", "getDomesticDebitAids", "()Ljava/util/List;", "setDomesticDebitAids", "(Ljava/util/List;)V", "Lcom/stripe/jvmcore/restclient/IntegrationType;", "integrationType", "getIntegrationType", "()Lcom/stripe/jvmcore/restclient/IntegrationType;", "setIntegrationType", "(Lcom/stripe/jvmcore/restclient/IntegrationType;)V", "isInTransaction", "isInValidTransaction", "localNetworkSessionToken", "getLocalNetworkSessionToken$delegate", "getLocalNetworkSessionToken", "setLocalNetworkSessionToken", "paymentIntentId", "getPaymentIntentId", "setPaymentIntentId", "Lcom/stripe/core/transaction/ConfirmRefundParams;", "refundParams", "getRefundParams", "()Lcom/stripe/core/transaction/ConfirmRefundParams;", "setRefundParams", "(Lcom/stripe/core/transaction/ConfirmRefundParams;)V", "Lcom/stripe/proto/model/common/DeviceInfo;", "remotePosDeviceInfo", "getRemotePosDeviceInfo$delegate", "getRemotePosDeviceInfo", "()Lcom/stripe/proto/model/common/DeviceInfo;", "setRemotePosDeviceInfo", "(Lcom/stripe/proto/model/common/DeviceInfo;)V", "Lcom/stripe/proto/model/common/VersionInfoPb;", "remotePosSdkVersionInfo", "getRemotePosSdkVersionInfo$delegate", "getRemotePosSdkVersionInfo", "()Lcom/stripe/proto/model/common/VersionInfoPb;", "setRemotePosSdkVersionInfo", "(Lcom/stripe/proto/model/common/VersionInfoPb;)V", "remotePosSecondarySdkVersionInfo", "getRemotePosSecondarySdkVersionInfo$delegate", "getRemotePosSecondarySdkVersionInfo", "setRemotePosSecondarySdkVersionInfo", "remotePosSupportsExtendedTransactions", "getRemotePosSupportsExtendedTransactions", "settings", "Lcom/stripe/core/transaction/Settings;", "getSettings", "()Lcom/stripe/core/transaction/Settings;", "transactionStateSummaryFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getTransactionStateSummaryFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "clearRemotePosInfo", "", "clearTipAmount", "clearTransactionContext", "getCancelableOperationContext", "Lcom/stripe/core/transaction/CancelableOperationContext;", "getRequestId", "opType", "Lcom/stripe/jvmcore/restclient/TransactionOpType;", "resetContext", "resetTransactionState", "setCancelableOperationContext", "cancelableOperation", "Lcom/stripe/stripeterminal/external/callable/Cancelable;", "cancelableOperationType", "Lcom/stripe/core/transaction/CancelableOperationType;", "setRequestId", "requestId", "updateState", "state", "Companion", "TransactionContext", "transaction_release"})
public final class TransactionRepository
implements CoreTransactionRepository {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsRepository settingsRepository;
    @NotNull
    private final MutableStateFlow<TransactionStateSummary> _transactionStateSummaryFlow;
    @NotNull
    private final StateFlow<TransactionStateSummary> transactionStateSummaryFlow;
    @NotNull
    private final MutableStateFlow<ContactCardSlotState> cardStatusFlow;
    @NotNull
    private static TransactionContext currentTransactionContext = new TransactionContext(null, null, null, null, null, null, null, 127, null);
    @Nullable
    private static String _localNetworkSessionToken;
    @NotNull
    private static final MutableStateFlow<ContactCardSlotState> _cardStatusFlow;
    @Nullable
    private static String _connectionToken;
    @Nullable
    private static VersionInfoPb _remotePosSdkVersionInfo;
    @Nullable
    private static VersionInfoPb _remotePosSecondarySdkVersionInfo;
    @Nullable
    private static DeviceInfo _remotePosDeviceInfo;
    @NotNull
    private static PaymentCollectionDeviceCapability _devicePaymentCapability;
    @Nullable
    private static String _accountId;
    @NotNull
    private static List<String> _domesticDebitAids;

    @Inject
    public TransactionRepository(@NotNull SettingsRepository settingsRepository) {
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        this.settingsRepository = settingsRepository;
        this._transactionStateSummaryFlow = StateFlowKt.MutableStateFlow((Object)TransactionStateSummary.Empty.INSTANCE);
        this.transactionStateSummaryFlow = FlowKt.asStateFlow(this._transactionStateSummaryFlow);
        this.cardStatusFlow = _cardStatusFlow;
    }

    @NotNull
    public final Settings getSettings() {
        return this.settingsRepository.getSettings();
    }

    @NotNull
    public final StateFlow<TransactionStateSummary> getTransactionStateSummaryFlow() {
        return this.transactionStateSummaryFlow;
    }

    @NotNull
    public final MutableStateFlow<ContactCardSlotState> getCardStatusFlow() {
        return this.cardStatusFlow;
    }

    public final void updateState(@NotNull TransactionStateSummary state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this._transactionStateSummaryFlow.setValue((Object)state);
    }

    public final void resetContext() {
        this.clearTransactionContext();
        this.resetTransactionState();
    }

    public final void clearTipAmount() {
        currentTransactionContext.setAmountTip(null);
    }

    public final void clearTransactionContext() {
        currentTransactionContext = new TransactionContext(null, null, null, null, null, null, null, 127, null);
    }

    public final void clearRemotePosInfo() {
        this.setRemotePosSdkVersionInfo(null);
        this.setRemotePosSecondarySdkVersionInfo(null);
        this.setRemotePosDeviceInfo(null);
    }

    public final void resetTransactionState() {
        this.updateState(TransactionStateSummary.Empty.INSTANCE);
    }

    @Nullable
    public final String getConnectionToken() {
        String value = _connectionToken;
        _connectionToken = null;
        return value;
    }

    public final void setConnectionToken(@Nullable String value) {
        _connectionToken = value;
    }

    @Override
    @Nullable
    public IntegrationType getIntegrationType() {
        return currentTransactionContext.getIntegrationType();
    }

    @Override
    public void setIntegrationType(@Nullable IntegrationType value) {
        currentTransactionContext.setIntegrationType(value);
    }

    public final boolean isInTransaction() {
        return !Intrinsics.areEqual((Object)this.transactionStateSummaryFlow.getValue(), (Object)TransactionStateSummary.Empty.INSTANCE);
    }

    public final boolean isInValidTransaction() {
        return this.isInTransaction() && !Intrinsics.areEqual((Object)this.transactionStateSummaryFlow.getValue(), (Object)TransactionStateSummary.UnrecoverableError.INSTANCE) && !Intrinsics.areEqual((Object)this.transactionStateSummaryFlow.getValue(), (Object)TransactionStateSummary.Cancelled.INSTANCE);
    }

    public final boolean getAllowExtendedTransactions() {
        return (this.getRemotePosSdkVersionInfo() == null || this.getRemotePosSupportsExtendedTransactions()) && this.getDevicePaymentCapability().getSupportExtendedTransaction();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean getRemotePosSupportsExtendedTransactions() {
        if (this.getIntegrationType() == IntegrationType.SERVER_DRIVEN) return true;
        VersionInfoPb versionInfoPb = this.getRemotePosSdkVersionInfo();
        Intrinsics.checkNotNull((Object)((Object)versionInfoPb));
        if (!TransactionRepositoryKt.allowExtendedTransactions(versionInfoPb)) return false;
        return true;
    }

    @Nullable
    public final VersionInfoPb getRemotePosSdkVersionInfo() {
        return _remotePosSdkVersionInfo;
    }

    public final void setRemotePosSdkVersionInfo(@Nullable VersionInfoPb versionInfoPb) {
        _remotePosSdkVersionInfo = versionInfoPb;
    }

    private static Object getRemotePosSdkVersionInfo$delegate(TransactionRepository transactionRepository) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)Companion, Companion.class, "_remotePosSdkVersionInfo", "get_remotePosSdkVersionInfo()Lcom/stripe/proto/model/common/VersionInfoPb;", 0)));
    }

    @Nullable
    public final VersionInfoPb getRemotePosSecondarySdkVersionInfo() {
        return _remotePosSecondarySdkVersionInfo;
    }

    public final void setRemotePosSecondarySdkVersionInfo(@Nullable VersionInfoPb versionInfoPb) {
        _remotePosSecondarySdkVersionInfo = versionInfoPb;
    }

    private static Object getRemotePosSecondarySdkVersionInfo$delegate(TransactionRepository transactionRepository) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)Companion, Companion.class, "_remotePosSecondarySdkVersionInfo", "get_remotePosSecondarySdkVersionInfo()Lcom/stripe/proto/model/common/VersionInfoPb;", 0)));
    }

    @Nullable
    public final DeviceInfo getRemotePosDeviceInfo() {
        return _remotePosDeviceInfo;
    }

    public final void setRemotePosDeviceInfo(@Nullable DeviceInfo deviceInfo) {
        _remotePosDeviceInfo = deviceInfo;
    }

    private static Object getRemotePosDeviceInfo$delegate(TransactionRepository transactionRepository) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)Companion, Companion.class, "_remotePosDeviceInfo", "get_remotePosDeviceInfo()Lcom/stripe/proto/model/common/DeviceInfo;", 0)));
    }

    @NotNull
    public final PaymentCollectionDeviceCapability getDevicePaymentCapability() {
        return _devicePaymentCapability;
    }

    public final void setDevicePaymentCapability(@NotNull PaymentCollectionDeviceCapability paymentCollectionDeviceCapability) {
        Intrinsics.checkNotNullParameter((Object)paymentCollectionDeviceCapability, (String)"<set-?>");
        _devicePaymentCapability = paymentCollectionDeviceCapability;
    }

    private static Object getDevicePaymentCapability$delegate(TransactionRepository transactionRepository) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)Companion, Companion.class, "_devicePaymentCapability", "get_devicePaymentCapability()Lcom/stripe/jvmcore/transaction/PaymentCollectionDeviceCapability;", 0)));
    }

    @Nullable
    public final String getLocalNetworkSessionToken() {
        return _localNetworkSessionToken;
    }

    public final void setLocalNetworkSessionToken(@Nullable String string) {
        _localNetworkSessionToken = string;
    }

    private static Object getLocalNetworkSessionToken$delegate(TransactionRepository transactionRepository) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)Companion, Companion.class, "_localNetworkSessionToken", "get_localNetworkSessionToken()Ljava/lang/String;", 0)));
    }

    @Nullable
    public final String getAccountId() {
        return _accountId;
    }

    public final void setAccountId(@Nullable String string) {
        _accountId = string;
    }

    private static Object getAccountId$delegate(TransactionRepository transactionRepository) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)Companion, Companion.class, "_accountId", "get_accountId()Ljava/lang/String;", 0)));
    }

    @Nullable
    public final CollectiblePayment getCollectiblePayment() {
        return currentTransactionContext.getCollectiblePayment();
    }

    public final void setCollectiblePayment(@Nullable CollectiblePayment value) {
        currentTransactionContext.setCollectiblePayment(value);
    }

    @NotNull
    public final List<String> getDomesticDebitAids() {
        return _domesticDebitAids;
    }

    public final void setDomesticDebitAids(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        _domesticDebitAids = list;
    }

    private static Object getDomesticDebitAids$delegate(TransactionRepository transactionRepository) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)Companion, Companion.class, "_domesticDebitAids", "get_domesticDebitAids()Ljava/util/List;", 0)));
    }

    public final void setCancelableOperationContext(@NotNull Cancelable cancelableOperation, @NotNull CancelableOperationType cancelableOperationType) {
        Intrinsics.checkNotNullParameter((Object)cancelableOperation, (String)"cancelableOperation");
        Intrinsics.checkNotNullParameter((Object)cancelableOperationType, (String)"cancelableOperationType");
        currentTransactionContext.setCancelableOperationContext(new CancelableOperationContext(cancelableOperation, cancelableOperationType));
    }

    @Nullable
    public final CancelableOperationContext getCancelableOperationContext() {
        return currentTransactionContext.getCancelableOperationContext();
    }

    @Override
    public void setRequestId(@NotNull TransactionOpType opType, @NotNull String requestId) {
        Intrinsics.checkNotNullParameter((Object)((Object)opType), (String)"opType");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        ((Map)currentTransactionContext.getRequestIds()).put(opType, requestId);
    }

    @NotNull
    public final String getRequestId(@NotNull TransactionOpType opType) {
        Intrinsics.checkNotNullParameter((Object)((Object)opType), (String)"opType");
        String string = currentTransactionContext.getRequestIds().get((Object)opType);
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Nullable
    public final Amount getAmountTip() {
        return currentTransactionContext.getAmountTip();
    }

    public final void setAmountTip(@Nullable Amount value) {
        currentTransactionContext.setAmountTip(value);
    }

    @Nullable
    public final String getPaymentIntentId() {
        return currentTransactionContext.getPaymentIntentId();
    }

    public final void setPaymentIntentId(@Nullable String value) {
        currentTransactionContext.setPaymentIntentId(value);
    }

    @Nullable
    public final ConfirmRefundParams getRefundParams() {
        return currentTransactionContext.getRefundParams();
    }

    public final void setRefundParams(@Nullable ConfirmRefundParams value) {
        currentTransactionContext.setRefundParams(value);
    }

    static {
        _cardStatusFlow = StateFlowKt.MutableStateFlow((Object)((Object)ContactCardSlotState.EMPTY));
        _devicePaymentCapability = PaymentCollectionDeviceCapabilityKt.getDEFAULT_PAYMENT_COLLECTION_CAPABILITY();
        _domesticDebitAids = CollectionsKt.emptyList();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/stripe/core/transaction/TransactionRepository$Companion;", "", "()V", "_accountId", "", "_cardStatusFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/core/hardware/paymentcollection/ContactCardSlotState;", "_connectionToken", "_devicePaymentCapability", "Lcom/stripe/jvmcore/transaction/PaymentCollectionDeviceCapability;", "_domesticDebitAids", "", "_localNetworkSessionToken", "_remotePosDeviceInfo", "Lcom/stripe/proto/model/common/DeviceInfo;", "_remotePosSdkVersionInfo", "Lcom/stripe/proto/model/common/VersionInfoPb;", "_remotePosSecondarySdkVersionInfo", "currentTransactionContext", "Lcom/stripe/core/transaction/TransactionRepository$TransactionContext;", "transaction_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001Bc\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\u000b\u0010-\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010.\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010/\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\rH\u00c6\u0003J\u000b\u00101\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u00102\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003Jg\u00103\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00c6\u0001J\u0013\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00107\u001a\u000208H\u00d6\u0001J\t\u00109\u001a\u00020\u0005H\u00d6\u0001R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006:"}, d2={"Lcom/stripe/core/transaction/TransactionRepository$TransactionContext;", "", "requestIds", "Ljava/util/EnumMap;", "Lcom/stripe/jvmcore/restclient/TransactionOpType;", "", "integrationType", "Lcom/stripe/jvmcore/restclient/IntegrationType;", "collectiblePayment", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "cancelableOperationContext", "Lcom/stripe/core/transaction/CancelableOperationContext;", "amountTip", "Lcom/stripe/jvmcore/currency/Amount;", "paymentIntentId", "refundParams", "Lcom/stripe/core/transaction/ConfirmRefundParams;", "(Ljava/util/EnumMap;Lcom/stripe/jvmcore/restclient/IntegrationType;Lcom/stripe/jvmcore/transaction/CollectiblePayment;Lcom/stripe/core/transaction/CancelableOperationContext;Lcom/stripe/jvmcore/currency/Amount;Ljava/lang/String;Lcom/stripe/core/transaction/ConfirmRefundParams;)V", "getAmountTip", "()Lcom/stripe/jvmcore/currency/Amount;", "setAmountTip", "(Lcom/stripe/jvmcore/currency/Amount;)V", "getCancelableOperationContext", "()Lcom/stripe/core/transaction/CancelableOperationContext;", "setCancelableOperationContext", "(Lcom/stripe/core/transaction/CancelableOperationContext;)V", "getCollectiblePayment", "()Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "setCollectiblePayment", "(Lcom/stripe/jvmcore/transaction/CollectiblePayment;)V", "getIntegrationType", "()Lcom/stripe/jvmcore/restclient/IntegrationType;", "setIntegrationType", "(Lcom/stripe/jvmcore/restclient/IntegrationType;)V", "getPaymentIntentId", "()Ljava/lang/String;", "setPaymentIntentId", "(Ljava/lang/String;)V", "getRefundParams", "()Lcom/stripe/core/transaction/ConfirmRefundParams;", "setRefundParams", "(Lcom/stripe/core/transaction/ConfirmRefundParams;)V", "getRequestIds", "()Ljava/util/EnumMap;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "", "toString", "transaction_release"})
    private static final class TransactionContext {
        @NotNull
        private final EnumMap<TransactionOpType, String> requestIds;
        @Nullable
        private IntegrationType integrationType;
        @Nullable
        private CollectiblePayment collectiblePayment;
        @Nullable
        private CancelableOperationContext cancelableOperationContext;
        @Nullable
        private Amount amountTip;
        @Nullable
        private String paymentIntentId;
        @Nullable
        private ConfirmRefundParams refundParams;

        public TransactionContext(@NotNull EnumMap<TransactionOpType, String> requestIds, @Nullable IntegrationType integrationType, @Nullable CollectiblePayment collectiblePayment, @Nullable CancelableOperationContext cancelableOperationContext, @Nullable Amount amountTip, @Nullable String paymentIntentId, @Nullable ConfirmRefundParams refundParams) {
            Intrinsics.checkNotNullParameter(requestIds, (String)"requestIds");
            this.requestIds = requestIds;
            this.integrationType = integrationType;
            this.collectiblePayment = collectiblePayment;
            this.cancelableOperationContext = cancelableOperationContext;
            this.amountTip = amountTip;
            this.paymentIntentId = paymentIntentId;
            this.refundParams = refundParams;
        }

        public /* synthetic */ TransactionContext(EnumMap enumMap, IntegrationType integrationType, CollectiblePayment collectiblePayment, CancelableOperationContext cancelableOperationContext, Amount amount, String string, ConfirmRefundParams confirmRefundParams, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                enumMap = new EnumMap<TransactionOpType, String>(TransactionOpType.class);
            }
            if ((n2 & 2) != 0) {
                integrationType = null;
            }
            if ((n2 & 4) != 0) {
                collectiblePayment = null;
            }
            if ((n2 & 8) != 0) {
                cancelableOperationContext = null;
            }
            if ((n2 & 0x10) != 0) {
                amount = null;
            }
            if ((n2 & 0x20) != 0) {
                string = null;
            }
            if ((n2 & 0x40) != 0) {
                confirmRefundParams = null;
            }
            this(enumMap, integrationType, collectiblePayment, cancelableOperationContext, amount, string, confirmRefundParams);
        }

        @NotNull
        public final EnumMap<TransactionOpType, String> getRequestIds() {
            return this.requestIds;
        }

        @Nullable
        public final IntegrationType getIntegrationType() {
            return this.integrationType;
        }

        public final void setIntegrationType(@Nullable IntegrationType integrationType) {
            this.integrationType = integrationType;
        }

        @Nullable
        public final CollectiblePayment getCollectiblePayment() {
            return this.collectiblePayment;
        }

        public final void setCollectiblePayment(@Nullable CollectiblePayment collectiblePayment) {
            this.collectiblePayment = collectiblePayment;
        }

        @Nullable
        public final CancelableOperationContext getCancelableOperationContext() {
            return this.cancelableOperationContext;
        }

        public final void setCancelableOperationContext(@Nullable CancelableOperationContext cancelableOperationContext) {
            this.cancelableOperationContext = cancelableOperationContext;
        }

        @Nullable
        public final Amount getAmountTip() {
            return this.amountTip;
        }

        public final void setAmountTip(@Nullable Amount amount) {
            this.amountTip = amount;
        }

        @Nullable
        public final String getPaymentIntentId() {
            return this.paymentIntentId;
        }

        public final void setPaymentIntentId(@Nullable String string) {
            this.paymentIntentId = string;
        }

        @Nullable
        public final ConfirmRefundParams getRefundParams() {
            return this.refundParams;
        }

        public final void setRefundParams(@Nullable ConfirmRefundParams confirmRefundParams) {
            this.refundParams = confirmRefundParams;
        }

        @NotNull
        public final EnumMap<TransactionOpType, String> component1() {
            return this.requestIds;
        }

        @Nullable
        public final IntegrationType component2() {
            return this.integrationType;
        }

        @Nullable
        public final CollectiblePayment component3() {
            return this.collectiblePayment;
        }

        @Nullable
        public final CancelableOperationContext component4() {
            return this.cancelableOperationContext;
        }

        @Nullable
        public final Amount component5() {
            return this.amountTip;
        }

        @Nullable
        public final String component6() {
            return this.paymentIntentId;
        }

        @Nullable
        public final ConfirmRefundParams component7() {
            return this.refundParams;
        }

        @NotNull
        public final TransactionContext copy(@NotNull EnumMap<TransactionOpType, String> requestIds, @Nullable IntegrationType integrationType, @Nullable CollectiblePayment collectiblePayment, @Nullable CancelableOperationContext cancelableOperationContext, @Nullable Amount amountTip, @Nullable String paymentIntentId, @Nullable ConfirmRefundParams refundParams) {
            Intrinsics.checkNotNullParameter(requestIds, (String)"requestIds");
            return new TransactionContext(requestIds, integrationType, collectiblePayment, cancelableOperationContext, amountTip, paymentIntentId, refundParams);
        }

        public static /* synthetic */ TransactionContext copy$default(TransactionContext transactionContext, EnumMap enumMap, IntegrationType integrationType, CollectiblePayment collectiblePayment, CancelableOperationContext cancelableOperationContext, Amount amount, String string, ConfirmRefundParams confirmRefundParams, int n2, Object object) {
            if ((n2 & 1) != 0) {
                enumMap = transactionContext.requestIds;
            }
            if ((n2 & 2) != 0) {
                integrationType = transactionContext.integrationType;
            }
            if ((n2 & 4) != 0) {
                collectiblePayment = transactionContext.collectiblePayment;
            }
            if ((n2 & 8) != 0) {
                cancelableOperationContext = transactionContext.cancelableOperationContext;
            }
            if ((n2 & 0x10) != 0) {
                amount = transactionContext.amountTip;
            }
            if ((n2 & 0x20) != 0) {
                string = transactionContext.paymentIntentId;
            }
            if ((n2 & 0x40) != 0) {
                confirmRefundParams = transactionContext.refundParams;
            }
            return transactionContext.copy(enumMap, integrationType, collectiblePayment, cancelableOperationContext, amount, string, confirmRefundParams);
        }

        @NotNull
        public String toString() {
            return "TransactionContext(requestIds=" + this.requestIds + ", integrationType=" + (Object)((Object)this.integrationType) + ", collectiblePayment=" + this.collectiblePayment + ", cancelableOperationContext=" + this.cancelableOperationContext + ", amountTip=" + this.amountTip + ", paymentIntentId=" + this.paymentIntentId + ", refundParams=" + this.refundParams + ')';
        }

        public int hashCode() {
            int result2 = this.requestIds.hashCode();
            result2 = result2 * 31 + (this.integrationType == null ? 0 : this.integrationType.hashCode());
            result2 = result2 * 31 + (this.collectiblePayment == null ? 0 : this.collectiblePayment.hashCode());
            result2 = result2 * 31 + (this.cancelableOperationContext == null ? 0 : this.cancelableOperationContext.hashCode());
            result2 = result2 * 31 + (this.amountTip == null ? 0 : this.amountTip.hashCode());
            result2 = result2 * 31 + (this.paymentIntentId == null ? 0 : this.paymentIntentId.hashCode());
            result2 = result2 * 31 + (this.refundParams == null ? 0 : this.refundParams.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TransactionContext)) {
                return false;
            }
            TransactionContext transactionContext = (TransactionContext)other;
            if (!Intrinsics.areEqual(this.requestIds, transactionContext.requestIds)) {
                return false;
            }
            if (this.integrationType != transactionContext.integrationType) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.collectiblePayment, (Object)transactionContext.collectiblePayment)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cancelableOperationContext, (Object)transactionContext.cancelableOperationContext)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.amountTip, (Object)transactionContext.amountTip)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.paymentIntentId, (Object)transactionContext.paymentIntentId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.refundParams, (Object)transactionContext.refundParams);
        }

        public TransactionContext() {
            this(null, null, null, null, null, null, null, 127, null);
        }
    }
}

