/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.transaction.payment;

import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.transaction.CollectiblePayment;
import com.stripe.jvmcore.transaction.payment.EmvPayment;
import com.stripe.jvmcore.transaction.payment.Payment;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0016R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/stripe/core/transaction/payment/PaymentManager;", "P", "Lcom/stripe/jvmcore/transaction/payment/Payment;", "", "payment", "(Lcom/stripe/jvmcore/transaction/payment/Payment;)V", "getPayment", "()Lcom/stripe/jvmcore/transaction/payment/Payment;", "Lcom/stripe/jvmcore/transaction/payment/Payment;", "collectiblePayment", "Lcom/stripe/jvmcore/transaction/CollectiblePayment;", "handleAuthResponse", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "tlvBlob", "", "isPaymentCollectible", "", "supportsSca", "transaction_release"})
public abstract class PaymentManager<P extends Payment> {
    @NotNull
    private final P payment;

    public PaymentManager(@NotNull P payment) {
        Intrinsics.checkNotNullParameter(payment, (String)"payment");
        this.payment = payment;
    }

    @NotNull
    public final P getPayment() {
        return this.payment;
    }

    public final boolean isPaymentCollectible() {
        return ((Payment)this.payment).isCollectible();
    }

    @NotNull
    public final CollectiblePayment collectiblePayment() {
        P p2 = this.payment;
        EmvPayment emvPayment = p2 instanceof EmvPayment ? (EmvPayment)p2 : null;
        return new CollectiblePayment(this.isPaymentCollectible() ? (Payment)this.payment : null, emvPayment != null ? emvPayment.getInterfaceType() : null, this.supportsSca());
    }

    @NotNull
    public Deferred<TransactionResult> handleAuthResponse(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        throw new NotImplementedError(null, 1, null);
    }

    public boolean supportsSca() {
        return false;
    }
}

