/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.transaction.payment;

import com.stripe.core.hardware.emv.AuthRequest;
import com.stripe.core.hardware.emv.CombinedKernelInterface;
import com.stripe.core.transaction.payment.PaymentManager;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.transaction.payment.EmvPayment;
import com.stripe.jvmcore.transaction.payment.Payment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/stripe/core/transaction/payment/QuickEmvManager;", "Lcom/stripe/core/transaction/payment/PaymentManager;", "Lcom/stripe/jvmcore/transaction/payment/EmvPayment;", "authRequest", "Lcom/stripe/core/hardware/emv/AuthRequest;", "(Lcom/stripe/core/hardware/emv/AuthRequest;)V", "callbackInterface", "Lcom/stripe/core/hardware/emv/CombinedKernelInterface;", "handleAuthResponse", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "tlvBlob", "", "transaction_release"})
public final class QuickEmvManager
extends PaymentManager<EmvPayment> {
    @NotNull
    private final CombinedKernelInterface callbackInterface;

    public QuickEmvManager(@NotNull AuthRequest authRequest) {
        Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
        super((Payment)new EmvPayment(authRequest.getTlvBlob(), authRequest.getInterfaceType(), authRequest.getTransactionType(), authRequest.getSourceType(), false, 16, null));
        this.callbackInterface = authRequest.getCallbackInterface();
    }

    @Override
    @NotNull
    public Deferred<TransactionResult> handleAuthResponse(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        return this.callbackInterface.handleAuthResponse(tlvBlob);
    }
}

