/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.core.transaction.payment;

import com.squareup.wire.Message;
import com.stripe.core.hardware.emv.AuthRequest;
import com.stripe.core.hardware.emv.CombinedKernelInterface;
import com.stripe.core.transaction.payment.PaymentManager;
import com.stripe.jvmcore.hardware.emv.TransactionResult;
import com.stripe.jvmcore.transaction.payment.EmvPayment;
import com.stripe.jvmcore.transaction.payment.Payment;
import com.stripe.proto.model.rest.Charge;
import com.stripe.proto.model.rest.Charges;
import com.stripe.proto.model.rest.PaymentMethodDetails;
import com.stripe.proto.model.rest.SetupIntent;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/core/transaction/payment/TraditionalEmvManager;", "Lcom/stripe/core/transaction/payment/PaymentManager;", "Lcom/stripe/jvmcore/transaction/payment/EmvPayment;", "authRequest", "Lcom/stripe/core/hardware/emv/AuthRequest;", "(Lcom/stripe/core/hardware/emv/AuthRequest;)V", "callbackInterface", "Lcom/stripe/core/hardware/emv/CombinedKernelInterface;", "handleAuthResponse", "Lkotlinx/coroutines/Deferred;", "Lcom/stripe/jvmcore/hardware/emv/TransactionResult;", "tlvBlob", "", "supportsSca", "", "Companion", "transaction_release"})
public final class TraditionalEmvManager
extends PaymentManager<EmvPayment> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CombinedKernelInterface callbackInterface;

    public TraditionalEmvManager(@NotNull AuthRequest authRequest) {
        Intrinsics.checkNotNullParameter((Object)authRequest, (String)"authRequest");
        super((Payment)new EmvPayment(authRequest.getTlvBlob(), authRequest.getInterfaceType(), authRequest.getTransactionType(), authRequest.getSourceType(), false, 16, null));
        this.callbackInterface = authRequest.getCallbackInterface();
    }

    @Override
    @NotNull
    public Deferred<TransactionResult> handleAuthResponse(@NotNull String tlvBlob) {
        Intrinsics.checkNotNullParameter((Object)tlvBlob, (String)"tlvBlob");
        return this.callbackInterface.handleAuthResponse(tlvBlob);
    }

    @Override
    public boolean supportsSca() {
        return true;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0004J\u0014\u0010\u0003\u001a\u00020\u0004*\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0004J\u0014\u0010\u0003\u001a\u00020\u0004*\u0004\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lcom/stripe/core/transaction/payment/TraditionalEmvManager$Companion;", "", "()V", "authData", "", "Lcom/stripe/proto/model/rest/Charges;", "defaultValue", "Lcom/stripe/proto/model/rest/PaymentMethodDetails;", "Lcom/stripe/proto/model/rest/SetupIntent$SetupAttempt$PaymentMethodDetails;", "transaction_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String authData(@Nullable Charges $this$authData, @NotNull String defaultValue) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            Object object2 = $this$authData;
            boolean bl = object2 != null && (object2 = object2.data_) != null ? !((Collection)object2).isEmpty() : false;
            if (bl) {
                object = ((Charge)((Object)CollectionsKt.last($this$authData.data_))).payment_method_details;
                if (object == null || (object = this.authData((PaymentMethodDetails)((Object)object), defaultValue)) == null) {
                    object = defaultValue;
                }
            } else {
                object = defaultValue;
            }
            return object;
        }

        @NotNull
        public final String authData(@Nullable PaymentMethodDetails $this$authData, @NotNull String defaultValue) {
            Message message;
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            Object object = $this$authData;
            if ((object == null || (object = object.card_present) == null || (object = object.emv_auth_data) == null) && ((message = $this$authData) != null && (message = message.interac_present) != null ? message.emv_auth_data : (object = null)) == null) {
                object = defaultValue;
            }
            return object;
        }

        @NotNull
        public final String authData(@Nullable SetupIntent.SetupAttempt.PaymentMethodDetails $this$authData, @NotNull String defaultValue) {
            Message message;
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            Object object = $this$authData;
            if ((object == null || (object = object.card_present) == null || (object = object.emv_auth_data) == null) && ((message = $this$authData) != null && (message = message.interac_present) != null ? message.emv_auth_data : (object = null)) == null) {
                object = defaultValue;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

