/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.cots.common;

import android.content.Context;
import android.content.Intent;
import com.stripe.core.aidlrpc.AidlRpcException;
import com.stripe.cots.aidlservice.CotsContactlessResult;
import com.stripe.cots.aidlservice.CotsReader;
import com.stripe.cots.common.CotsClientInterface;
import com.stripe.cots.common.CotsError;
import com.stripe.cots.common.CotsErrorKt;
import com.stripe.cots.common.compatibility.PreFlightChecks;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006JC\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0011\u0010\u0014\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J#\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0011\u0010\u001f\u001a\u00020\u0015H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0013\u0010 \u001a\u0004\u0018\u00010\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\b\u0010!\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lcom/stripe/cots/common/SimulatedCotsClient;", "Lcom/stripe/cots/common/CotsClientInterface;", "context", "Landroid/content/Context;", "preFlightChecks", "Lcom/stripe/cots/common/compatibility/PreFlightChecks;", "(Landroid/content/Context;Lcom/stripe/cots/common/compatibility/PreFlightChecks;)V", "isConnected", "", "reader", "Lcom/stripe/cots/aidlservice/CotsReader;", "activate", "sessionToken", "", "rpcSessionToken", "clientType", "clientVersion", "deviceUuid", "countryCode", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "cancelCollectPayment", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkDeviceCompatibility", "Lcom/stripe/cots/common/CotsError;", "collectPayment", "Lcom/stripe/cots/aidlservice/CotsContactlessResult;", "amount", "", "currency", "(JLjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "disconnect", "discover", "initializeKeys", "Companion", "common_release"})
public final class SimulatedCotsClient
implements CotsClientInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final PreFlightChecks preFlightChecks;
    @Nullable
    private CotsReader reader;
    private boolean isConnected;
    @NotNull
    private static final MutableStateFlow<CotsContactlessResult> result = StateFlowKt.MutableStateFlow(null);

    public SimulatedCotsClient(@NotNull Context context, @NotNull PreFlightChecks preFlightChecks) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)preFlightChecks, (String)"preFlightChecks");
        this.context = context;
        this.preFlightChecks = preFlightChecks;
    }

    @Override
    @Nullable
    public Object discover(@NotNull Continuation<? super CotsReader> $completion) throws AidlRpcException {
        CotsError compatibility = this.checkDeviceCompatibility();
        if (compatibility != CotsError.NONE) {
            return new CotsReader("", CotsErrorKt.toProto(compatibility), null, false, null, 28, null);
        }
        CotsReader cotsReader2 = this.reader;
        if (cotsReader2 == null) {
            SimulatedCotsClient $this$discover_u24lambda_u240 = this;
            boolean bl = false;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            $this$discover_u24lambda_u240.reader = new CotsReader(string, CotsReader.CotsError.NONE, null, true, null, 20, null);
            return $this$discover_u24lambda_u240.reader;
        }
        return cotsReader2;
    }

    @Override
    @Nullable
    public Object activate(@NotNull String sessionToken, @NotNull String rpcSessionToken, @NotNull String clientType, @NotNull String clientVersion, @NotNull String deviceUuid, @NotNull String countryCode, @NotNull Continuation<? super CotsReader> $completion) throws IllegalStateException, AidlRpcException {
        this.isConnected = true;
        return this.reader;
    }

    @Override
    @Nullable
    public Object disconnect(@NotNull Continuation<? super Unit> $completion) throws AidlRpcException {
        this.isConnected = false;
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object collectPayment(long amount, @NotNull String currency, @NotNull Continuation<? super CotsContactlessResult> $completion) throws IllegalStateException, AidlRpcException {
        void $this$collectPayment_u24lambda_u241;
        Intent intent;
        if (!this.isConnected) {
            throw new IllegalStateException("Can't collectPayment from CotsReader. CotsService not connected.");
        }
        result.setValue(null);
        Intent intent2 = intent = new Intent();
        Context context = this.context;
        boolean bl = false;
        $this$collectPayment_u24lambda_u241.setClassName(this.context.getPackageName(), "com.stripe.cots.simulator.SimulatedContactlessPaymentActivity");
        $this$collectPayment_u24lambda_u241.setFlags(0x10000000);
        context.startActivity(intent);
        return FlowKt.first((Flow)((Flow)result), (Function2)((Function2)new Function2<CotsContactlessResult, Continuation<? super Boolean>, Object>(null){
            int label;
            /* synthetic */ Object L$0;

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CotsContactlessResult it = (CotsContactlessResult)((Object)this.L$0);
                        return Boxing.boxBoolean((it != null ? 1 : 0) != 0);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CotsContactlessResult, Continuation<? super Boolean>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@Nullable CotsContactlessResult p1, @Nullable Continuation<? super Boolean> p2) {
                return (this.create((Object)((Object)p1), p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @Override
    @Nullable
    public Object cancelCollectPayment(@NotNull Continuation<? super Unit> $completion) {
        result.setValue((Object)new CotsContactlessResult(CotsContactlessResult.ContactlessOutcome.CANCELED, null, null, null, null, 30, null));
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public CotsError checkDeviceCompatibility() {
        return this.preFlightChecks.getDeviceCompatibility();
    }

    @Override
    public void initializeKeys() {
        this.preFlightChecks.initialize();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/cots/common/SimulatedCotsClient$Companion;", "", "()V", "result", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/cots/aidlservice/CotsContactlessResult;", "getResult", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "common_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MutableStateFlow<CotsContactlessResult> getResult() {
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

