/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.cots.common.compatibility;

import android.content.Context;
import android.nfc.NfcAdapter;
import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyInfo;
import com.scottyab.rootbeer.RootBeer;
import com.stripe.core.device.BuildValues;
import com.stripe.cots.common.CotsError;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B/\b\u0011\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/stripe/cots/common/compatibility/PreFlightChecks;", "", "context", "Landroid/content/Context;", "keyFactory", "Ljava/security/KeyFactory;", "key", "Ljava/security/Key;", "rootBeer", "Lcom/scottyab/rootbeer/RootBeer;", "buildValues", "Lcom/stripe/core/device/BuildValues;", "(Landroid/content/Context;Ljava/security/KeyFactory;Ljava/security/Key;Lcom/scottyab/rootbeer/RootBeer;Lcom/stripe/core/device/BuildValues;)V", "(Landroid/content/Context;Lcom/scottyab/rootbeer/RootBeer;Lcom/stripe/core/device/BuildValues;)V", "getDeviceCompatibility", "Lcom/stripe/cots/common/CotsError;", "initialize", "", "isHardwareBackedKeystore", "", "common_release"})
public final class PreFlightChecks {
    @NotNull
    private final Context context;
    @NotNull
    private final RootBeer rootBeer;
    @NotNull
    private final BuildValues buildValues;
    private Key key;
    private KeyFactory keyFactory;

    public PreFlightChecks(@NotNull Context context, @NotNull RootBeer rootBeer, @NotNull BuildValues buildValues) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)rootBeer, (String)"rootBeer");
        Intrinsics.checkNotNullParameter((Object)buildValues, (String)"buildValues");
        this.context = context;
        this.rootBeer = rootBeer;
        this.buildValues = buildValues;
    }

    @VisibleForTesting
    public PreFlightChecks(@NotNull Context context, @NotNull KeyFactory keyFactory, @NotNull Key key, @NotNull RootBeer rootBeer, @NotNull BuildValues buildValues) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)keyFactory, (String)"keyFactory");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)rootBeer, (String)"rootBeer");
        Intrinsics.checkNotNullParameter((Object)buildValues, (String)"buildValues");
        this(context, rootBeer, buildValues);
        this.key = key;
        this.keyFactory = keyFactory;
    }

    public final void initialize() {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        Intrinsics.checkNotNullExpressionValue((Object)keyFactory, (String)"getInstance(\"RSA\")");
        this.keyFactory = keyFactory;
        String[] stringArray = new String[]{"SHA-256", "SHA-1"};
        KeyGenParameterSpec.Builder builder = new KeyGenParameterSpec.Builder("preflight", 2).setDigests(stringArray);
        stringArray = new String[]{"ECB"};
        KeyGenParameterSpec.Builder builder2 = builder.setBlockModes(stringArray);
        stringArray = new String[]{"OAEPPadding"};
        KeyGenParameterSpec.Builder builder3 = builder2.setEncryptionPaddings(stringArray);
        stringArray = new String[]{"PSS"};
        KeyGenParameterSpec keyGenParameterSpec = builder3.setSignaturePaddings(stringArray).setKeySize(2048).build();
        Intrinsics.checkNotNullExpressionValue((Object)keyGenParameterSpec, (String)"Builder(\"preflight\", Key\u2026048)\n            .build()");
        KeyGenParameterSpec spec = keyGenParameterSpec;
        keyGenerator.initialize((AlgorithmParameterSpec)spec);
        PrivateKey privateKey = keyGenerator.genKeyPair().getPrivate();
        Intrinsics.checkNotNullExpressionValue((Object)privateKey, (String)"keyGenerator.genKeyPair().private");
        this.key = privateKey;
    }

    @NotNull
    public final CotsError getDeviceCompatibility() {
        if (!this.buildValues.isAtLeast(29)) {
            return CotsError.DISCOVERY_UNSUPPORTED_ANDROID_VERSION;
        }
        if (NfcAdapter.getDefaultAdapter((Context)this.context) == null) {
            return CotsError.DISCOVERY_MISSING_NFC_READER;
        }
        if (!this.isHardwareBackedKeystore()) {
            return CotsError.DISCOVERY_UNTRUSTED_HARDWARE;
        }
        if (this.rootBeer.isRooted()) {
            return CotsError.ATTESTATION_DEVICE_TAMPERED;
        }
        return CotsError.NONE;
    }

    private final boolean isHardwareBackedKeystore() {
        boolean bl;
        if (this.buildValues.isAtLeast(31)) {
            Key key;
            Object[] objectArray = new Integer[]{2, 1};
            List list = CollectionsKt.listOf((Object[])objectArray);
            KeyFactory keyFactory = this.keyFactory;
            if (keyFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"keyFactory");
                keyFactory = null;
            }
            if ((key = this.key) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"key");
                key = null;
            }
            bl = list.contains(keyFactory.getKeySpec(key, KeyInfo.class).getSecurityLevel());
        } else if (Build.VERSION.SDK_INT >= 23) {
            Key key;
            KeyFactory keyFactory = this.keyFactory;
            if (keyFactory == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"keyFactory");
                keyFactory = null;
            }
            if ((key = this.key) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"key");
                key = null;
            }
            bl = keyFactory.getKeySpec(key, KeyInfo.class).isInsideSecureHardware();
        } else {
            bl = false;
        }
        return bl;
    }
}

