/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.batchdispatcher.collectors;

import com.squareup.tape2.QueueFile;
import com.stripe.jvmcore.batchdispatcher.Collector;
import com.stripe.jvmcore.batchdispatcher.collectors.QueueFileCollectorKt;
import com.stripe.jvmcore.logwriter.LogWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 8*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u000389:B-\b\u0016\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB5\b\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0011\u0010 \u001a\u00020!H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u0015\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J7\u0010#\u001a\u00020!2\"\u0010&\u001a\u001e\b\u0001\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000)0(\u0012\u0006\u0012\u0004\u0018\u00010*0'H\u0016\u00f8\u0001\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010+J\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000-H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tH\u0002J\u0011\u0010/\u001a\u00020!H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\b\u00100\u001a\u000201H\u0002J\u001f\u00102\u001a\u00020!2\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00000-H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\b\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u00020!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u0004\u0018\u00010\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006;"}, d2={"Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector;", "T", "Lcom/stripe/jvmcore/batchdispatcher/Collector;", "Lkotlinx/coroutines/CoroutineScope;", "serializer", "Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector$Serializer;", "configuration", "Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector$Configuration;", "file", "Ljava/io/File;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "(Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector$Serializer;Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector$Configuration;Ljava/io/File;Lcom/stripe/jvmcore/logwriter/LogWriter;)V", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector$Serializer;Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector$Configuration;Ljava/io/File;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/stripe/jvmcore/logwriter/LogWriter;)V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "queueFile", "Lcom/squareup/tape2/QueueFile;", "usedBytesMethod", "Ljava/lang/reflect/Method;", "getUsedBytesMethod", "()Ljava/lang/reflect/Method;", "usedBytesMethod$delegate", "Lkotlin/Lazy;", "canAdd", "", "bytes", "", "close", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "collect", "record", "(Ljava/lang/Object;)V", "recordSupplier", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "Lkotlin/Result;", "", "(Lkotlin/jvm/functions/Function1;)V", "peek", "", "prepareQueueFile", "pruneIfNeeded", "queueFilename", "", "remove", "batch", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "usedBytes", "", "validateConfiguration", "Companion", "Configuration", "Serializer", "batchdispatcher"})
public final class QueueFileCollector<T>
implements Collector<T>,
CoroutineScope {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Serializer<T> serializer;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final CoroutineDispatcher dispatcher;
    @NotNull
    private final LogWriter logWriter;
    private QueueFile queueFile;
    @NotNull
    private final Lazy usedBytesMethod$delegate;
    @NotNull
    private final CoroutineContext coroutineContext;

    public QueueFileCollector(@NotNull Serializer<T> serializer2, @NotNull Configuration configuration, @NotNull File file, @NotNull CoroutineDispatcher dispatcher, @NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        this.serializer = serializer2;
        this.configuration = configuration;
        this.dispatcher = dispatcher;
        this.logWriter = logWriter;
        this.usedBytesMethod$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Method>(this){
            final /* synthetic */ QueueFileCollector<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Method invoke() {
                Object object;
                Object object2;
                Object object3 = this.this$0;
                try {
                    Method method;
                    QueueFileCollector<T> $this$invoke_u24lambda_u241 = object3;
                    boolean bl = false;
                    Method $this$invoke_u24lambda_u241_u24lambda_u240 = method = QueueFile.class.getDeclaredMethod("usedBytes", new Class[0]);
                    boolean bl2 = false;
                    $this$invoke_u24lambda_u241_u24lambda_u240.setAccessible(true);
                    object2 = Result.constructor-impl((Object)method);
                }
                catch (Throwable bl) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object3 = object2;
                object2 = this.this$0;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
                if (throwable == null) {
                    object = object3;
                } else {
                    Throwable e2 = throwable;
                    boolean bl = false;
                    LogWriter logWriter = QueueFileCollector.access$getLogWriter$p(object2);
                    String string = QueueFileCollectorKt.access$getTAG$p();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                    logWriter.e(string, "Failed to lookup private QueueFile#usedBytes() API.", e2);
                    object = null;
                }
                return (Method)object;
            }
        }));
        this.coroutineContext = SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)this.dispatcher);
        this.validateConfiguration();
        BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, file, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ QueueFileCollector<T> this$0;
            final /* synthetic */ File $file;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2;
                        Object object3;
                        CoroutineScope $this$launch;
                        ResultKt.throwOnFailure((Object)object);
                        Object object4 = $this$launch = (CoroutineScope)this.L$0;
                        QueueFileCollector queueFileCollector = this.this$0;
                        File file = this.$file;
                        QueueFileCollector queueFileCollector2 = this.this$0;
                        try {
                            boolean bl = false;
                            object3 = Result.constructor-impl((Object)queueFileCollector.prepareQueueFile(file));
                        }
                        catch (Throwable throwable) {
                            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                        }
                        object4 = object3;
                        queueFileCollector = this.this$0;
                        file = this.$file;
                        object3 = Result.exceptionOrNull-impl((Object)object4);
                        if (object3 == null) {
                            object2 = object4;
                        } else {
                            Object object5;
                            Object object6 = object4;
                            try {
                                Object e2 = object3;
                                boolean bl = false;
                                LogWriter logWriter = queueFileCollector.logWriter;
                                String string = QueueFileCollectorKt.access$getTAG$p();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                                logWriter.e(string, file.getName() + " failed to restore, deleting:", (Throwable)e2);
                                file.delete();
                                object5 = Result.constructor-impl((Object)queueFileCollector.prepareQueueFile(file));
                            }
                            catch (Throwable throwable) {
                                object5 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            object2 = object5;
                        }
                        object4 = object2;
                        ResultKt.throwOnFailure((Object)object4);
                        queueFileCollector2.queueFile = (QueueFile)object4;
                        LogWriter logWriter = this.this$0.logWriter;
                        String string = QueueFileCollectorKt.access$getTAG$p();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                        StringBuilder stringBuilder = new StringBuilder().append(this.$file.getName()).append(" ready to use with ");
                        QueueFile queueFile = this.this$0.queueFile;
                        if (queueFile == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
                            queueFile = null;
                        }
                        logWriter.v(string, stringBuilder.append(queueFile.size()).append(" entries and ").append(this.this$0.usedBytes()).append(" bytes.").toString());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public QueueFileCollector(@NotNull Serializer<T> serializer2, @NotNull Configuration configuration, @NotNull File file, @NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        this(serializer2, configuration, file, QueueFileCollector.Companion.createDefaultTapeDispatcher(), logWriter);
    }

    private final Method getUsedBytesMethod() {
        Lazy lazy = this.usedBytesMethod$delegate;
        return (Method)lazy.getValue();
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    private final void validateConfiguration() {
        if (!(this.configuration.getMaxBatchBytes() > 0L)) {
            boolean $i$a$-require-QueueFileCollector$validateConfiguration$52 = false;
            String $i$a$-require-QueueFileCollector$validateConfiguration$52 = "maxBatchBytes must be non-zero and positive: " + this.configuration.getMaxBatchBytes();
            throw new IllegalArgumentException($i$a$-require-QueueFileCollector$validateConfiguration$52.toString());
        }
        if (!(this.configuration.getMaxEntryBytes() > 0L)) {
            boolean $i$a$-require-QueueFileCollector$validateConfiguration$62 = false;
            String $i$a$-require-QueueFileCollector$validateConfiguration$62 = "maxEntryBytes must be non-zero and positive: " + this.configuration.getMaxEntryBytes();
            throw new IllegalArgumentException($i$a$-require-QueueFileCollector$validateConfiguration$62.toString());
        }
        if (!(this.configuration.getMaxFileBytes() > 0L)) {
            boolean $i$a$-require-QueueFileCollector$validateConfiguration$72 = false;
            String $i$a$-require-QueueFileCollector$validateConfiguration$72 = "maxFileBytes must be non-zero and positive: " + this.configuration.getMaxFileBytes();
            throw new IllegalArgumentException($i$a$-require-QueueFileCollector$validateConfiguration$72.toString());
        }
        if (!(this.configuration.getPruneFileBytes() > 0L)) {
            boolean bl = false;
            String string = "pruneFileBytes must be non-zero and positive: " + this.configuration.getPruneFileBytes();
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final QueueFile prepareQueueFile(File file) {
        QueueFile queueFile = new QueueFile.Builder(file).zero(true).forceLegacy(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)queueFile, (String)"Builder(file)\n          \u2026lse)\n            .build()");
        return queueFile;
    }

    @Override
    public void collect(T record) {
        this.collect((Function1)new Function1<Continuation<? super Result<? extends T>>, Object>(record, null){
            int label;
            final /* synthetic */ T $record;
            {
                this.$record = $record;
                super(1, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        return Result.box-impl((Object)Result.constructor-impl(this.$record));
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@Nullable Continuation<? super Result<? extends T>> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        });
    }

    @Override
    public void collect(@NotNull Function1<? super Continuation<? super Result<? extends T>>, ? extends Object> recordSupplier) {
        Intrinsics.checkNotNullParameter(recordSupplier, (String)"recordSupplier");
        BuildersKt.launch$default((CoroutineScope)this, (CoroutineContext)((CoroutineContext)this.dispatcher), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(recordSupplier, this, null){
            int label;
            final /* synthetic */ Function1<Continuation<? super Result<? extends T>>, Object> $recordSupplier;
            final /* synthetic */ QueueFileCollector<T> this$0;
            {
                this.$recordSupplier = $recordSupplier;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.$recordSupplier.invoke((Object)this);
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        var3_3 = ((Result)v0).unbox-impl();
                        var4_4 = this.this$0;
                        v1 = Result.exceptionOrNull-impl((Object)var3_3);
                        if (v1 != null) {
                            e = v1;
                            $i$a$-getOrElse-QueueFileCollector$collect$2$record$1 = false;
                            v2 = QueueFileCollector.access$getLogWriter$p(var4_4);
                            v3 = QueueFileCollectorKt.access$getTAG$p();
                            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"TAG");
                            v2.w(v3, QueueFileCollector.access$queueFilename((QueueFileCollector)var4_4) + " dropping entry because the supplier returned a failure:", e);
                            return Unit.INSTANCE;
                        }
                        record = var3_3;
                        var4_4 = QueueFileCollector.access$getSerializer$p(this.this$0).toBytes(record);
                        var5_6 = this.this$0;
                        p0 = var4_4;
                        $i$a$-takeIf-QueueFileCollector$collect$2$1 = false;
                        v4 = var3_3 = QueueFileCollector.access$canAdd(var5_6, (byte[])p0) != false ? var4_4 : null;
                        if (var3_3 != null) {
                            var4_4 = var3_3;
                            v5 = QueueFileCollector.access$getQueueFile$p(this.this$0);
                            if (v5 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
                                v5 = null;
                            }
                            var5_6 = v5;
                            p0 = var4_4;
                            $i$a$-let-QueueFileCollector$collect$2$2 = false;
                            var5_6.add((byte[])p0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final boolean canAdd(byte[] bytes) {
        boolean bl;
        if ((long)bytes.length > this.configuration.getMaxEntryBytes()) {
            String string = QueueFileCollectorKt.access$getTAG$p();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            this.logWriter.w(string, this.queueFilename() + " dropping entry of " + bytes.length + " bytes beyond max entry size of " + this.configuration.getMaxEntryBytes() + " bytes.");
            bl = false;
        } else if ((long)bytes.length + this.usedBytes() > this.configuration.getMaxFileBytes()) {
            String string = QueueFileCollectorKt.access$getTAG$p();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
            this.logWriter.w(string, this.queueFilename() + " dropping entry of " + bytes.length + " bytes beyond max file size of " + this.configuration.getMaxFileBytes() + " bytes.");
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    @Nullable
    public Object peek(@NotNull Continuation<? super List<? extends T>> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)new Function2<CoroutineScope, Continuation<? super List<? extends T>>, Object>(this, null){
            int label;
            final /* synthetic */ QueueFileCollector<T> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        List batch = new ArrayList<E>();
                        Ref.LongRef bytes = new Ref.LongRef();
                        try {
                            void $this$forEach$iv;
                            QueueFile queueFile = QueueFileCollector.access$getQueueFile$p(this.this$0);
                            if (queueFile == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
                                queueFile = null;
                            }
                            Iterable iterable = (Iterable)queueFile;
                            QueueFileCollector<T> queueFileCollector = this.this$0;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                byte[] record = (byte[])element$iv;
                                boolean bl = false;
                                bytes.element += (long)record.length;
                                if (bytes.element > QueueFileCollector.access$getConfiguration$p(queueFileCollector).getMaxBatchBytes()) {
                                    QueueFile queueFile2;
                                    if (batch.isEmpty()) {
                                        LogWriter logWriter = QueueFileCollector.access$getLogWriter$p(queueFileCollector);
                                        String string = QueueFileCollectorKt.access$getTAG$p();
                                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                                        logWriter.w(string, QueueFileCollector.access$queueFilename(queueFileCollector) + " adding an entry to prevent starvation.");
                                        Serializer serializer2 = QueueFileCollector.access$getSerializer$p(queueFileCollector);
                                        Intrinsics.checkNotNullExpressionValue((Object)record, (String)"record");
                                        batch.add(serializer2.fromBytes(record));
                                    }
                                    if ((queueFile2 = QueueFileCollector.access$getQueueFile$p(queueFileCollector)) == null) {
                                        Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
                                        queueFile2 = null;
                                    }
                                    int prune = queueFile2.size() - batch.size();
                                    LogWriter logWriter = QueueFileCollector.access$getLogWriter$p(queueFileCollector);
                                    String string = QueueFileCollectorKt.access$getTAG$p();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                                    logWriter.w(string, QueueFileCollector.access$queueFilename(queueFileCollector) + " pruned " + prune + " batch entries due to over sized batch.");
                                    continue;
                                }
                                Serializer serializer3 = QueueFileCollector.access$getSerializer$p(queueFileCollector);
                                Intrinsics.checkNotNullExpressionValue((Object)record, (String)"record");
                                batch.add(serializer3.fromBytes(record));
                            }
                        }
                        catch (IOException e2) {
                            LogWriter logWriter = QueueFileCollector.access$getLogWriter$p(this.this$0);
                            String string = QueueFileCollectorKt.access$getTAG$p();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                            logWriter.e(string, QueueFileCollector.access$queueFilename(this.this$0) + " failed to read, file appears to be corrupt, dropping.", e2);
                            QueueFile queueFile = QueueFileCollector.access$getQueueFile$p(this.this$0);
                            if (queueFile == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
                                queueFile = null;
                            }
                            queueFile.clear();
                            return CollectionsKt.emptyList();
                        }
                        if (!((Collection)batch).isEmpty()) {
                            LogWriter logWriter = QueueFileCollector.access$getLogWriter$p(this.this$0);
                            String string = QueueFileCollectorKt.access$getTAG$p();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                            logWriter.v(string, QueueFileCollector.access$queueFilename(this.this$0) + " batch of size " + batch.size() + " generated.");
                        }
                        return batch;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<? extends T>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    @Override
    @Nullable
    public Object remove(@NotNull List<? extends T> batch, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(batch, this, null){
            int label;
            final /* synthetic */ List<T> $batch;
            final /* synthetic */ QueueFileCollector<T> this$0;
            {
                this.$batch = $batch;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        QueueFile queueFile;
                        int n2;
                        int toRemove;
                        ResultKt.throwOnFailure((Object)object);
                        int n3 = this.$batch.size();
                        QueueFile queueFile2 = QueueFileCollector.access$getQueueFile$p(this.this$0);
                        if (queueFile2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
                            queueFile2 = null;
                        }
                        if ((toRemove = Math.min(n3, n2 = queueFile2.size())) != this.$batch.size()) {
                            LogWriter logWriter = QueueFileCollector.access$getLogWriter$p(this.this$0);
                            String string = QueueFileCollectorKt.access$getTAG$p();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                            logWriter.e(string, QueueFileCollector.access$queueFilename(this.this$0) + " trying to remove " + this.$batch.size() + " entries which is too many, removing " + toRemove + " instead.");
                        }
                        if ((queueFile = QueueFileCollector.access$getQueueFile$p(this.this$0)) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
                            queueFile = null;
                        }
                        queueFile.remove(toRemove);
                        LogWriter logWriter = QueueFileCollector.access$getLogWriter$p(this.this$0);
                        String string = QueueFileCollectorKt.access$getTAG$p();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                        logWriter.v(string, QueueFileCollector.access$queueFilename(this.this$0) + " removed " + toRemove + " entries.");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object pruneIfNeeded(@NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ QueueFileCollector<T> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        int removedEntries = 0;
                        while (true) {
                            QueueFile queueFile;
                            if ((queueFile = QueueFileCollector.access$getQueueFile$p(this.this$0)) == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
                                queueFile = null;
                            }
                            if (queueFile.isEmpty() || QueueFileCollector.access$usedBytes(this.this$0) <= QueueFileCollector.access$getConfiguration$p(this.this$0).getPruneFileBytes()) break;
                            QueueFile queueFile2 = QueueFileCollector.access$getQueueFile$p(this.this$0);
                            if (queueFile2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
                                queueFile2 = null;
                            }
                            queueFile2.remove();
                            ++removedEntries;
                        }
                        if (removedEntries > 0) {
                            LogWriter logWriter = QueueFileCollector.access$getLogWriter$p(this.this$0);
                            String string = QueueFileCollectorKt.access$getTAG$p();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                            logWriter.w(string, QueueFileCollector.access$queueFilename(this.this$0) + " pruned " + removedEntries + " file entries due to over sized file.");
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object close(@NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)this.dispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ QueueFileCollector<T> this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        QueueFile queueFile = QueueFileCollector.access$getQueueFile$p(this.this$0);
                        if (queueFile == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
                            queueFile = null;
                        }
                        queueFile.close();
                        LogWriter logWriter = QueueFileCollector.access$getLogWriter$p(this.this$0);
                        String string = QueueFileCollectorKt.access$getTAG$p();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                        logWriter.v(string, QueueFileCollector.access$queueFilename(this.this$0) + " closed.");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final long usedBytes() {
        long l2;
        Method method = this.getUsedBytesMethod();
        if (method != null) {
            Method it = method;
            boolean bl = false;
            QueueFile queueFile = this.queueFile;
            if (queueFile == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
                queueFile = null;
            }
            Object object = it.invoke((Object)queueFile, new Object[0]);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            l2 = (Long)object;
        } else {
            l2 = 0L;
        }
        return l2;
    }

    private final String queueFilename() {
        QueueFile queueFile = this.queueFile;
        if (queueFile == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"queueFile");
            queueFile = null;
        }
        String string = queueFile.file().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"queueFile.file().name");
        return string;
    }

    public static final /* synthetic */ Serializer access$getSerializer$p(QueueFileCollector $this) {
        return $this.serializer;
    }

    public static final /* synthetic */ String access$queueFilename(QueueFileCollector $this) {
        return $this.queueFilename();
    }

    public static final /* synthetic */ boolean access$canAdd(QueueFileCollector $this, byte[] bytes) {
        return $this.canAdd(bytes);
    }

    public static final /* synthetic */ Configuration access$getConfiguration$p(QueueFileCollector $this) {
        return $this.configuration;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0005"}, d2={"Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector$Companion;", "", "()V", "createDefaultTapeDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "batchdispatcher"})
    private static final class Companion {
        private Companion() {
        }

        private final CoroutineDispatcher createDefaultTapeDispatcher() {
            ExecutorService executorService = Executors.newSingleThreadExecutor(Companion::createDefaultTapeDispatcher$lambda$1);
            Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor \u2026          }\n            }");
            return (CoroutineDispatcher)ExecutorsKt.from((ExecutorService)executorService);
        }

        private static final Thread createDefaultTapeDispatcher$lambda$1(Runnable it) {
            Thread thread;
            Thread $this$createDefaultTapeDispatcher_u24lambda_u241_u24lambda_u240 = thread = Executors.defaultThreadFactory().newThread(it);
            boolean bl = false;
            $this$createDefaultTapeDispatcher_u24lambda_u241_u24lambda_u240.setDaemon(true);
            $this$createDefaultTapeDispatcher_u24lambda_u241_u24lambda_u240.setName("stripe-terminal-tape-dispatcher");
            return thread;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0016\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B5\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003\u00a2\u0006\u0002\u0010\u0013J>\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0018J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\n\u00a8\u0006!"}, d2={"Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector$Configuration;", "", "overrideMaxBatchBytes", "", "overrideMaxEntryBytes", "overrideMaxFileBytes", "overridePruneFileBytes", "(Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;)V", "maxBatchBytes", "getMaxBatchBytes", "()J", "maxEntryBytes", "getMaxEntryBytes", "maxFileBytes", "getMaxFileBytes", "Ljava/lang/Long;", "pruneFileBytes", "getPruneFileBytes", "component1", "()Ljava/lang/Long;", "component2", "component3", "component4", "copy", "(Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;Ljava/lang/Long;)Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector$Configuration;", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "batchdispatcher"})
    public static final class Configuration {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final Long overrideMaxBatchBytes;
        @Nullable
        private final Long overrideMaxEntryBytes;
        @Nullable
        private final Long overrideMaxFileBytes;
        @Nullable
        private final Long overridePruneFileBytes;
        private final long maxBatchBytes;
        private final long maxEntryBytes;
        private final long maxFileBytes;
        private final long pruneFileBytes;
        private static final long DEFAULT_MAX_BATCH_BYTES = 0x300000L;
        public static final long DEFAULT_MAX_ENTRY_BYTES = 0x100000L;
        private static final long DEFAULT_MAX_FILE_BYTES = 0x2000000L;
        private static final long DEFAULT_PRUNE_FILE_BYTES = 0x1E00000L;

        public Configuration(@Nullable Long overrideMaxBatchBytes, @Nullable Long overrideMaxEntryBytes, @Nullable Long overrideMaxFileBytes, @Nullable Long overridePruneFileBytes) {
            this.overrideMaxBatchBytes = overrideMaxBatchBytes;
            this.overrideMaxEntryBytes = overrideMaxEntryBytes;
            this.overrideMaxFileBytes = overrideMaxFileBytes;
            this.overridePruneFileBytes = overridePruneFileBytes;
            Long l2 = this.overrideMaxBatchBytes;
            this.maxBatchBytes = l2 != null ? l2 : 0x300000L;
            Long l3 = this.overrideMaxEntryBytes;
            this.maxEntryBytes = l3 != null ? l3 : 0x100000L;
            Long l4 = this.overrideMaxFileBytes;
            this.maxFileBytes = l4 != null ? l4 : 0x2000000L;
            Long l5 = this.overridePruneFileBytes;
            this.pruneFileBytes = l5 != null ? l5 : 0x1E00000L;
        }

        public /* synthetic */ Configuration(Long l2, Long l3, Long l4, Long l5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                l2 = null;
            }
            if ((n2 & 2) != 0) {
                l3 = null;
            }
            if ((n2 & 4) != 0) {
                l4 = null;
            }
            if ((n2 & 8) != 0) {
                l5 = null;
            }
            this(l2, l3, l4, l5);
        }

        public final long getMaxBatchBytes() {
            return this.maxBatchBytes;
        }

        public final long getMaxEntryBytes() {
            return this.maxEntryBytes;
        }

        public final long getMaxFileBytes() {
            return this.maxFileBytes;
        }

        public final long getPruneFileBytes() {
            return this.pruneFileBytes;
        }

        private final Long component1() {
            return this.overrideMaxBatchBytes;
        }

        private final Long component2() {
            return this.overrideMaxEntryBytes;
        }

        private final Long component3() {
            return this.overrideMaxFileBytes;
        }

        private final Long component4() {
            return this.overridePruneFileBytes;
        }

        @NotNull
        public final Configuration copy(@Nullable Long overrideMaxBatchBytes, @Nullable Long overrideMaxEntryBytes, @Nullable Long overrideMaxFileBytes, @Nullable Long overridePruneFileBytes) {
            return new Configuration(overrideMaxBatchBytes, overrideMaxEntryBytes, overrideMaxFileBytes, overridePruneFileBytes);
        }

        public static /* synthetic */ Configuration copy$default(Configuration configuration, Long l2, Long l3, Long l4, Long l5, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l2 = configuration.overrideMaxBatchBytes;
            }
            if ((n2 & 2) != 0) {
                l3 = configuration.overrideMaxEntryBytes;
            }
            if ((n2 & 4) != 0) {
                l4 = configuration.overrideMaxFileBytes;
            }
            if ((n2 & 8) != 0) {
                l5 = configuration.overridePruneFileBytes;
            }
            return configuration.copy(l2, l3, l4, l5);
        }

        @NotNull
        public String toString() {
            return "Configuration(overrideMaxBatchBytes=" + this.overrideMaxBatchBytes + ", overrideMaxEntryBytes=" + this.overrideMaxEntryBytes + ", overrideMaxFileBytes=" + this.overrideMaxFileBytes + ", overridePruneFileBytes=" + this.overridePruneFileBytes + ')';
        }

        public int hashCode() {
            int result2 = this.overrideMaxBatchBytes == null ? 0 : ((Object)this.overrideMaxBatchBytes).hashCode();
            result2 = result2 * 31 + (this.overrideMaxEntryBytes == null ? 0 : ((Object)this.overrideMaxEntryBytes).hashCode());
            result2 = result2 * 31 + (this.overrideMaxFileBytes == null ? 0 : ((Object)this.overrideMaxFileBytes).hashCode());
            result2 = result2 * 31 + (this.overridePruneFileBytes == null ? 0 : ((Object)this.overridePruneFileBytes).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Configuration)) {
                return false;
            }
            Configuration configuration = (Configuration)other;
            if (!Intrinsics.areEqual((Object)this.overrideMaxBatchBytes, (Object)configuration.overrideMaxBatchBytes)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.overrideMaxEntryBytes, (Object)configuration.overrideMaxEntryBytes)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.overrideMaxFileBytes, (Object)configuration.overrideMaxFileBytes)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.overridePruneFileBytes, (Object)configuration.overridePruneFileBytes);
        }

        public Configuration() {
            this(null, null, null, null, 15, null);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector$Configuration$Companion;", "", "()V", "DEFAULT_MAX_BATCH_BYTES", "", "DEFAULT_MAX_ENTRY_BYTES", "DEFAULT_MAX_FILE_BYTES", "DEFAULT_PRUNE_FILE_BYTES", "batchdispatcher"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\bf\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002J\u0015\u0010\u0003\u001a\u00028\u00012\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/stripe/jvmcore/batchdispatcher/collectors/QueueFileCollector$Serializer;", "T", "", "fromBytes", "bytes", "", "([B)Ljava/lang/Object;", "toBytes", "record", "(Ljava/lang/Object;)[B", "batchdispatcher"})
    public static interface Serializer<T> {
        @NotNull
        public byte[] toBytes(T var1);

        public T fromBytes(@NotNull byte[] var1);
    }
}

