/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.crpcclient;

import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.stripe.jvmcore.crpcclient.CrpcResponse;
import com.stripe.jvmcore.crpcclient.CustomCrpcInterceptor;
import com.stripe.jvmcore.crpcclient.MappersKt;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.jvmcore.traffictype.TrafficType;
import com.stripe.proto.model.common.DeviceInfo;
import com.stripe.proto.model.common.VersionInfoPb;
import com.stripe.proto.net.rpc.base.RpcEC;
import com.stripe.proto.net.rpc.base.RpcRequest;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0003./0B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000bJm\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0019\"\u0012\b\u0000\u0010\u001a*\f\u0012\u0004\u0012\u0002H\u001a\u0012\u0002\b\u00030\u001b\"\u0012\b\u0001\u0010\u001c*\f\u0012\u0004\u0012\u0002H\u001c\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u0002H\u001c2\f\u0010!\u001a\b\u0012\u0004\u0012\u0002H\u001c0\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u001a0\"\u00a2\u0006\u0002\u0010$Ja\u0010%\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0019\"\u0012\b\u0000\u0010\u001a*\f\u0012\u0004\u0012\u0002H\u001a\u0012\u0002\b\u00030\u001b\"\u0012\b\u0001\u0010\u001c*\f\u0012\u0004\u0012\u0002H\u001c\u0012\u0002\b\u00030\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u0002H\u001c2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H\u001a0\"H\u0002\u00a2\u0006\u0002\u0010,J\u0006\u0010-\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u00061"}, d2={"Lcom/stripe/jvmcore/crpcclient/CrpcClient;", "", "builder", "Lcom/stripe/jvmcore/crpcclient/CrpcClient$Builder;", "(Lcom/stripe/jvmcore/crpcclient/CrpcClient$Builder;)V", "baseUrlProvider", "Lcom/stripe/jvmcore/crpcclient/CrpcClient$BaseUrlProvider;", "client", "Lokhttp3/OkHttpClient;", "customCrpcInterceptors", "", "Lcom/stripe/jvmcore/crpcclient/CustomCrpcInterceptor;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "requestContextProvider", "Lcom/stripe/jvmcore/crpcclient/CrpcClient$CrpcRequestContextProvider;", "<set-?>", "", "requestId", "getRequestId", "()J", "addCustomCrpcInterceptor", "", "interceptor", "blockingPost", "Lcom/stripe/jvmcore/crpcclient/CrpcResponse;", "M", "Lcom/squareup/wire/Message;", "RE", "service", "", "method", "message", "requestProtoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "responseProtoAdapter", "(Ljava/lang/String;Ljava/lang/String;Lcom/squareup/wire/Message;Lcom/squareup/wire/ProtoAdapter;Lcom/squareup/wire/ProtoAdapter;)Lcom/stripe/jvmcore/crpcclient/CrpcResponse;", "execute", "httpRequest", "Lokhttp3/Request;", "crpcRequest", "Lcom/stripe/proto/net/rpc/base/RpcRequest;", "apiRequest", "protoAdapter", "(Lokhttp3/Request;Lcom/stripe/proto/net/rpc/base/RpcRequest;Lcom/squareup/wire/Message;Lcom/squareup/wire/ProtoAdapter;)Lcom/stripe/jvmcore/crpcclient/CrpcResponse;", "toBuilder", "BaseUrlProvider", "Builder", "CrpcRequestContextProvider", "crpcclient"})
@SourceDebugExtension(value={"SMAP\nCrpcClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrpcClient.kt\ncom/stripe/jvmcore/crpcclient/CrpcClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1855#2,2:191\n1855#2,2:193\n*S KotlinDebug\n*F\n+ 1 CrpcClient.kt\ncom/stripe/jvmcore/crpcclient/CrpcClient\n*L\n37#1:191,2\n63#1:193,2\n*E\n"})
public final class CrpcClient {
    @NotNull
    private final OkHttpClient client;
    @NotNull
    private final BaseUrlProvider baseUrlProvider;
    @NotNull
    private final CrpcRequestContextProvider requestContextProvider;
    @NotNull
    private final Set<CustomCrpcInterceptor> customCrpcInterceptors;
    @NotNull
    private final LogWriter logWriter;
    private long requestId;

    public CrpcClient(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.client = builder.getClientBuilder$crpcclient().build();
        this.baseUrlProvider = builder.getBaseUrlProvider$crpcclient();
        this.requestContextProvider = builder.getRequestContextProvider$crpcclient();
        this.customCrpcInterceptors = builder.getCustomApplicationInterceptors$crpcclient();
        this.logWriter = builder.getLogWriter$crpcclient();
    }

    public final long getRequestId() {
        return this.requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <M extends Message<M, ?>, RE extends Message<RE, ?>> CrpcResponse<M> execute(Request httpRequest, RpcRequest crpcRequest, RE apiRequest, ProtoAdapter<M> protoAdapter) {
        Object $i$f$forEach2;
        Iterable $this$forEach$iv = this.customCrpcInterceptors;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            CustomCrpcInterceptor it = (CustomCrpcInterceptor)element$iv;
            boolean bl = false;
            it.preCallAction(httpRequest, crpcRequest, apiRequest);
        }
        try {
            CrpcResponse<M> crpcResponse;
            $i$f$forEach2 = (Closeable)this.client.newCall(httpRequest).execute();
            Object object = null;
            try {
                Response it = (Response)$i$f$forEach2;
                boolean bl = false;
                crpcResponse = MappersKt.toCrpcResponse(it, crpcRequest.id, protoAdapter, this.logWriter);
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CloseableKt.closeFinally((Closeable)$i$f$forEach2, object);
                    throw throwable2;
                }
            }
            CloseableKt.closeFinally((Closeable)$i$f$forEach2, (Throwable)object);
            $i$f$forEach2 = crpcResponse;
        }
        catch (IOException e2) {
            String string = e2.getMessage();
            if (string == null) {
                string = "";
            }
            $i$f$forEach2 = new CrpcResponse.RpcError(RpcEC.SERVER_UNREACHABLE, string, null, e2, 4, null);
        }
        catch (Throwable t2) {
            String string = t2.getMessage();
            if (string == null) {
                string = "";
            }
            $i$f$forEach2 = new CrpcResponse.RpcError(RpcEC.RPC_ERROR, string, null, t2, 4, null);
        }
        Object response = $i$f$forEach2;
        Iterable $this$forEach$iv2 = this.customCrpcInterceptors;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv2) {
            CustomCrpcInterceptor it = (CustomCrpcInterceptor)element$iv;
            boolean bl = false;
            it.postCallAction(httpRequest, crpcRequest, apiRequest, response);
        }
        return response;
    }

    @NotNull
    public final <M extends Message<M, ?>, RE extends Message<RE, ?>> CrpcResponse<M> blockingPost(@NotNull String service, @NotNull String method, @NotNull RE message, @NotNull ProtoAdapter<RE> requestProtoAdapter, @NotNull ProtoAdapter<M> responseProtoAdapter) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        Intrinsics.checkNotNullParameter(requestProtoAdapter, (String)"requestProtoAdapter");
        Intrinsics.checkNotNullParameter(responseProtoAdapter, (String)"responseProtoAdapter");
        long l2 = this.requestId;
        this.requestId = l2 + 1L;
        long l3 = l2;
        ByteString byteString = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])requestProtoAdapter.encode(message), (int)0, (int)0, (int)3, null);
        String string = this.requestContextProvider.getSessionToken();
        String string2 = this.requestContextProvider.getLocalIp();
        DeviceInfo deviceInfo = this.requestContextProvider.getDeviceInfo();
        VersionInfoPb versionInfoPb = this.requestContextProvider.getVersionInfo();
        RpcRequest crpcRequest = new RpcRequest(l3, service, method, byteString, 0L, null, string2, string, null, versionInfoPb, deviceInfo, 0L, null, 6448, null);
        HttpUrl url = HttpUrl.Companion.get(this.baseUrlProvider.getBaseUrl()).newBuilder().addPathSegment("rpcservice").addPathSegment(service).build();
        Request httpRequest = new Request.Builder().url(url).post(RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (byte[])RpcRequest.ADAPTER.encode((Object)crpcRequest), null, (int)0, (int)0, (int)7, null)).tag(TrafficType.class, (Object)new TrafficType.Crpc(service, method)).build();
        return this.execute(httpRequest, crpcRequest, message, responseProtoAdapter);
    }

    public final void addCustomCrpcInterceptor(@NotNull CustomCrpcInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        this.customCrpcInterceptors.add(interceptor);
    }

    @NotNull
    public final Builder toBuilder() {
        return new Builder(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/stripe/jvmcore/crpcclient/CrpcClient$BaseUrlProvider;", "", "getBaseUrl", "", "crpcclient"})
    public static interface BaseUrlProvider {
        @NotNull
        public String getBaseUrl();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u0019J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\"\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%J\u000e\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020*J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006,"}, d2={"Lcom/stripe/jvmcore/crpcclient/CrpcClient$Builder;", "", "client", "Lcom/stripe/jvmcore/crpcclient/CrpcClient;", "(Lcom/stripe/jvmcore/crpcclient/CrpcClient;)V", "Lokhttp3/OkHttpClient;", "baseUrlProvider", "Lcom/stripe/jvmcore/crpcclient/CrpcClient$BaseUrlProvider;", "requestContextProvider", "Lcom/stripe/jvmcore/crpcclient/CrpcClient$CrpcRequestContextProvider;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "(Lokhttp3/OkHttpClient;Lcom/stripe/jvmcore/crpcclient/CrpcClient$BaseUrlProvider;Lcom/stripe/jvmcore/crpcclient/CrpcClient$CrpcRequestContextProvider;Lcom/stripe/jvmcore/logwriter/LogWriter;)V", "getBaseUrlProvider$crpcclient", "()Lcom/stripe/jvmcore/crpcclient/CrpcClient$BaseUrlProvider;", "setBaseUrlProvider$crpcclient", "(Lcom/stripe/jvmcore/crpcclient/CrpcClient$BaseUrlProvider;)V", "getClient$crpcclient", "()Lokhttp3/OkHttpClient;", "clientBuilder", "Lokhttp3/OkHttpClient$Builder;", "getClientBuilder$crpcclient", "()Lokhttp3/OkHttpClient$Builder;", "customApplicationInterceptors", "", "Lcom/stripe/jvmcore/crpcclient/CustomCrpcInterceptor;", "getCustomApplicationInterceptors$crpcclient", "()Ljava/util/Set;", "getLogWriter$crpcclient", "()Lcom/stripe/jvmcore/logwriter/LogWriter;", "getRequestContextProvider$crpcclient", "()Lcom/stripe/jvmcore/crpcclient/CrpcClient$CrpcRequestContextProvider;", "addCustomCrpcInterceptor", "interceptor", "build", "callTimeout", "seconds", "", "connectTimeout", "readTimeout", "retryOnConnectionFailure", "retry", "", "writeTimeout", "crpcclient"})
    public static final class Builder {
        @NotNull
        private final OkHttpClient client;
        @NotNull
        private BaseUrlProvider baseUrlProvider;
        @NotNull
        private final CrpcRequestContextProvider requestContextProvider;
        @NotNull
        private final LogWriter logWriter;
        @NotNull
        private final OkHttpClient.Builder clientBuilder;
        @NotNull
        private final Set<CustomCrpcInterceptor> customApplicationInterceptors;

        public Builder(@NotNull OkHttpClient client, @NotNull BaseUrlProvider baseUrlProvider, @NotNull CrpcRequestContextProvider requestContextProvider, @NotNull LogWriter logWriter) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)baseUrlProvider, (String)"baseUrlProvider");
            Intrinsics.checkNotNullParameter((Object)requestContextProvider, (String)"requestContextProvider");
            Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
            this.client = client;
            this.baseUrlProvider = baseUrlProvider;
            this.requestContextProvider = requestContextProvider;
            this.logWriter = logWriter;
            this.clientBuilder = this.client.newBuilder();
            this.customApplicationInterceptors = new LinkedHashSet();
        }

        @NotNull
        public final OkHttpClient getClient$crpcclient() {
            return this.client;
        }

        @NotNull
        public final BaseUrlProvider getBaseUrlProvider$crpcclient() {
            return this.baseUrlProvider;
        }

        public final void setBaseUrlProvider$crpcclient(@NotNull BaseUrlProvider baseUrlProvider) {
            Intrinsics.checkNotNullParameter((Object)baseUrlProvider, (String)"<set-?>");
            this.baseUrlProvider = baseUrlProvider;
        }

        @NotNull
        public final CrpcRequestContextProvider getRequestContextProvider$crpcclient() {
            return this.requestContextProvider;
        }

        @NotNull
        public final LogWriter getLogWriter$crpcclient() {
            return this.logWriter;
        }

        @NotNull
        public final OkHttpClient.Builder getClientBuilder$crpcclient() {
            return this.clientBuilder;
        }

        @NotNull
        public final Set<CustomCrpcInterceptor> getCustomApplicationInterceptors$crpcclient() {
            return this.customApplicationInterceptors;
        }

        public Builder(@NotNull CrpcClient client) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            this(client.client, client.baseUrlProvider, client.requestContextProvider, client.logWriter);
            CollectionsKt.addAll((Collection)this.customApplicationInterceptors, (Iterable)client.customCrpcInterceptors);
        }

        @NotNull
        public final Builder callTimeout(long seconds) {
            Builder builder;
            Builder $this$callTimeout_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$callTimeout_u24lambda_u240.clientBuilder.callTimeout(seconds, TimeUnit.SECONDS);
            return builder;
        }

        @NotNull
        public final Builder connectTimeout(long seconds) {
            Builder builder;
            Builder $this$connectTimeout_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$connectTimeout_u24lambda_u241.clientBuilder.callTimeout(seconds, TimeUnit.SECONDS);
            return builder;
        }

        @NotNull
        public final Builder readTimeout(long seconds) {
            Builder builder;
            Builder $this$readTimeout_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$readTimeout_u24lambda_u242.clientBuilder.readTimeout(seconds, TimeUnit.SECONDS);
            return builder;
        }

        @NotNull
        public final Builder writeTimeout(long seconds) {
            Builder builder;
            Builder $this$writeTimeout_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$writeTimeout_u24lambda_u243.clientBuilder.writeTimeout(seconds, TimeUnit.SECONDS);
            return builder;
        }

        @NotNull
        public final Builder retryOnConnectionFailure(boolean retry) {
            Builder builder;
            Builder $this$retryOnConnectionFailure_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$retryOnConnectionFailure_u24lambda_u244.clientBuilder.retryOnConnectionFailure(retry);
            return builder;
        }

        @NotNull
        public final Builder addCustomCrpcInterceptor(@NotNull CustomCrpcInterceptor interceptor) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
            Builder $this$addCustomCrpcInterceptor_u24lambda_u245 = builder = this;
            boolean bl = false;
            ((Collection)$this$addCustomCrpcInterceptor_u24lambda_u245.customApplicationInterceptors).add(interceptor);
            return builder;
        }

        @NotNull
        public final Builder baseUrlProvider(@NotNull BaseUrlProvider baseUrlProvider) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)baseUrlProvider, (String)"baseUrlProvider");
            Builder $this$baseUrlProvider_u24lambda_u246 = builder = this;
            boolean bl = false;
            $this$baseUrlProvider_u24lambda_u246.baseUrlProvider = baseUrlProvider;
            return builder;
        }

        @NotNull
        public final CrpcClient build() {
            return new CrpcClient(this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&J\b\u0010\u0007\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/stripe/jvmcore/crpcclient/CrpcClient$CrpcRequestContextProvider;", "", "getDeviceInfo", "Lcom/stripe/proto/model/common/DeviceInfo;", "getLocalIp", "", "getSessionToken", "getVersionInfo", "Lcom/stripe/proto/model/common/VersionInfoPb;", "crpcclient"})
    public static interface CrpcRequestContextProvider {
        @NotNull
        public String getLocalIp();

        @NotNull
        public DeviceInfo getDeviceInfo();

        @NotNull
        public VersionInfoPb getVersionInfo();

        @NotNull
        public String getSessionToken();
    }
}

