/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.jvmcore.crpcclient;

import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.stripe.jvmcore.crpcclient.CrpcResponse;
import com.stripe.jvmcore.logwriter.LogWriter;
import com.stripe.proto.net.rpc.base.ApplicationEC;
import com.stripe.proto.net.rpc.base.RpcEC;
import com.stripe.proto.net.rpc.base.RpcResponse;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aB\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0012\b\u0000\u0010\t*\f\u0012\u0004\u0012\u0002H\t\u0012\u0002\b\u00030\n*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001aC\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\t0\b\"\u0012\b\u0000\u0010\t*\f\u0012\u0004\u0012\u0002H\t\u0012\u0002\b\u00030\n*\u00020\u00112\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\t0\r2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"TAG", "", "durationMillis", "", "Lokhttp3/Response;", "getDurationMillis", "(Lokhttp3/Response;)J", "toCrpcResponse", "Lcom/stripe/jvmcore/crpcclient/CrpcResponse;", "M", "Lcom/squareup/wire/Message;", "requestId", "protoAdapter", "Lcom/squareup/wire/ProtoAdapter;", "logWriter", "Lcom/stripe/jvmcore/logwriter/LogWriter;", "toResponseType", "Lcom/stripe/proto/net/rpc/base/RpcResponse;", "(Lcom/stripe/proto/net/rpc/base/RpcResponse;Lcom/squareup/wire/ProtoAdapter;Ljava/lang/Long;)Lcom/stripe/jvmcore/crpcclient/CrpcResponse;", "crpcclient"})
public final class MappersKt {
    @NotNull
    private static final String TAG = "CrpcResponse";

    private static final long getDurationMillis(Response $this$durationMillis) {
        return $this$durationMillis.receivedResponseAtMillis() - $this$durationMillis.sentRequestAtMillis();
    }

    @NotNull
    public static final <M extends Message<M, ?>> CrpcResponse<M> toCrpcResponse(@NotNull Response $this$toCrpcResponse, long requestId, @NotNull ProtoAdapter<M> protoAdapter, @NotNull LogWriter logWriter) {
        Intrinsics.checkNotNullParameter((Object)$this$toCrpcResponse, (String)"<this>");
        Intrinsics.checkNotNullParameter(protoAdapter, (String)"protoAdapter");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        long durationMillis = MappersKt.getDurationMillis($this$toCrpcResponse);
        try {
            ResponseBody responseBody = $this$toCrpcResponse.body();
            if (responseBody == null) {
                return new CrpcResponse.RpcError(RpcEC.SERVER_UNREACHABLE, "", durationMillis, null, 8, null);
            }
            ResponseBody body = responseBody;
            RpcResponse rpcResponse = (RpcResponse)((Object)RpcResponse.ADAPTER.decode(body.bytes()));
            if (requestId != rpcResponse.request_id) {
                String message = "Request ID from cRPC request does not match response ID";
                logWriter.e(TAG, message);
                return new CrpcResponse.RpcError(RpcEC.BAD_RESPONSE, message, durationMillis, null, 8, null);
            }
            CrpcResponse<M> rpcResponseType = MappersKt.toResponseType(rpcResponse, protoAdapter, durationMillis);
            if (rpcResponseType instanceof CrpcResponse.ApplicationError) {
                logWriter.e(TAG, "Application error in cRPC response  " + (Object)((Object)((CrpcResponse.ApplicationError)rpcResponseType).getCode()));
            }
            if (rpcResponseType instanceof CrpcResponse.RpcError) {
                logWriter.e(TAG, "RPC error in cRPC response  " + (Object)((Object)((CrpcResponse.RpcError)rpcResponseType).getCode()));
            }
            return rpcResponseType;
        }
        catch (IOException e2) {
            return new CrpcResponse.RpcError(RpcEC.BAD_RESPONSE, "Unable to parse response", durationMillis, e2);
        }
    }

    @NotNull
    public static final <M extends Message<M, ?>> CrpcResponse<M> toResponseType(@NotNull RpcResponse $this$toResponseType, @NotNull ProtoAdapter<M> protoAdapter, @Nullable Long durationMillis) {
        CrpcResponse crpcResponse;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toResponseType), (String)"<this>");
        Intrinsics.checkNotNullParameter(protoAdapter, (String)"protoAdapter");
        Enum[] enumArray = new ApplicationEC[]{ApplicationEC.OK, ApplicationEC.APPLICATION_EC_INVALID};
        if (!CollectionsKt.listOf((Object[])enumArray).contains((Object)$this$toResponseType.app_error_code)) {
            crpcResponse = new CrpcResponse.ApplicationError($this$toResponseType.app_error_code, $this$toResponseType.error, durationMillis);
        } else {
            enumArray = new RpcEC[]{RpcEC.RPC_OK, RpcEC.RPC_EC_INVALID};
            crpcResponse = !CollectionsKt.listOf((Object[])enumArray).contains((Object)$this$toResponseType.rpc_error_code) ? (CrpcResponse)new CrpcResponse.RpcError($this$toResponseType.rpc_error_code, $this$toResponseType.error, durationMillis, null, 8, null) : (CrpcResponse)new CrpcResponse.Success<Message>((Message)protoAdapter.decode($this$toResponseType.content.toByteArray()), durationMillis);
        }
        return crpcResponse;
    }

    public static /* synthetic */ CrpcResponse toResponseType$default(RpcResponse rpcResponse, ProtoAdapter protoAdapter, Long l2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            l2 = null;
        }
        return MappersKt.toResponseType(rpcResponse, protoAdapter, l2);
    }
}

